<?php
	class Vista {
		var $tpl;
		var $menu;

		function Vista() {

			$this->tpl = new Smarty;
			$this->tpl->template_dir = _SMARTY_TPL."templates/";
			$this->tpl->compile_dir = _SMARTY_TPL."templates_c/";
			$this->tpl->left_delimiter = "<!--{";
			$this->tpl->right_delimiter = "}-->";

			$tp_modelo = new TP_Modelo();

			if(isset($_SESSION['id_usuario'])){
				$datos_usuario = $tp_modelo->getUsuario($_SESSION['id_usuario']);
				$this->tpl->assign("user",$datos_usuario);
			}
			$this->textos();
		}

		/**
		 * genera la paginacion de los registros seleccionados
		 * @param string $action action al cual se redirigira la siguiente paginacion
		 * @param array $paginacion arreglo para construir el paginado
		 */
		function setPaginado($action,$paginacion) {
			$this->tpl->assign("paginar",$paginacion["paginar"]);
			if($paginacion["first"]!="")
				$this->tpl->assign("first","javascript:setSiguientePagina('$action','".$paginacion["first"]."')");
			if($paginacion["previous"]!="")
				$this->tpl->assign("previous","javascript:setSiguientePagina('$action','".$paginacion["previous"]."')");
			if($paginacion["next"]!="")
				$this->tpl->assign("next","javascript:setSiguientePagina('$action','".$paginacion["next"]."')");
			if($paginacion["last"]!="")
				$this->tpl->assign("last","javascript:setSiguientePagina('$action','".$paginacion["last"]."')");

			$total_paginas = ($paginacion['last']!='') ? "{$paginacion['current']}/{$paginacion['last']}" : "{$paginacion['current']}/{$paginacion['current']}";
			$this->tpl->assign('total_paginas',$total_paginas);

			$max_num = 5;
			if ($paginacion["first"]!="") {
				$numeros_atras = '';
				$x = $paginacion['current'];
				$cnt = 0;
				do {
					$x--;
					$cnt++;
					$numeros_atras = "<a href='javascript:setSiguientePagina(\"$action\",\"$x\")'>$x</a>, ".$numeros_atras;
					if ($cnt==$max_num) $numeros_atras = '... '.$numeros_atras;
				} while($x>1 && $cnt<$max_num);
			}

			if ($paginacion["last"]!="") {
				$numeros_adelante = '';
				$x = $paginacion['current'];
				$cnt = 0;
				do {
					$x++;
					$cnt++;
					$numeros_adelante .= ", <a href='javascript:setSiguientePagina(\"$action\",\"$x\")'>$x</a>";
					if ($cnt==$max_num) $numeros_adelante .= ' ...';
				} while($x<$paginacion['last'] && $cnt<$max_num);
			}

			$this->tpl->assign('paginas_numeros',$numeros_atras."<b>{$paginacion['current']}</b>".$numeros_adelante);
		}

		/**
		 * setea los textos a utilizar en la pagina
		 */
		function textos() {
			$this->tpl->assign("campos_obligatorios_texto","Campos obligatorios");
			$this->tpl->assign("per_natural_texto","Persona Natural");
			$this->tpl->assign("per_juridica_texto","Persona Jurídica");
			$this->tpl->assign("nombre_texto","Nombre");
			$this->tpl->assign("ap_paterno_texto","Apellido Paterno");
			$this->tpl->assign("ap_materno_texto","Apellido Materno");
			$this->tpl->assign("razon_social_texto","Razón Social");
			$this->tpl->assign("correo_texto","Correo Electrónico");
			$this->tpl->assign("re_correo_texto","Reingrese su correo electrónico");
			$this->tpl->assign("direccion_texto","Dirección Postal");
			$this->tpl->assign("telefono_texto","Teléfono");
			$this->tpl->assign("region_texto","Región");
			$this->tpl->assign("comuna_texto","Comuna");
			$this->tpl->assign("localidad_texto","Localidad");
			$this->tpl->assign("direccion_input_texto","Dirección");
			$this->tpl->assign("region_selector_texto","Seleccione una región");
			$this->tpl->assign("comuna_selector_texto","Seleccione una comuna");
			$this->tpl->assign("apo_info_texto","Marque la casilla de más abajo para habilitar las opciones del apoderado");
			$this->tpl->assign("apo_check_texto","Datos del apoderado (sólo si corresponde)");

			$this->tpl->assign("nombre_ph","Ej. Juan");
			$this->tpl->assign("apellidos_ph","Ej. Valenzuela");
			$this->tpl->assign("razon_social_ph","Ej. Applicatta Ltda");
			$this->tpl->assign("correo_ph","Ej. usuario@correo.com");
			$this->tpl->assign("telefono_ph","Ej. 322345678");
			$this->tpl->assign("localidad_ph","Ej. Villa Dulce");
			$this->tpl->assign("direccion_ph","Ej. Avenida Calle #123 Depto. #987");
			$this->tpl->assign("mensaje_ph","Identifique claramente la información que se requiere. Debe mencionar las características esenciales de la información que solicita, tales como su materia, fecha de emisión o período de vigencia del documento, origen o destino, soporte, etc.");
			$this->tpl->assign("observaciones_ph","Incorpore observaciones o circunstancias relevantes para efectos de facilitar el acceso y la entrega de la información.");
			$this->tpl->assign("otro_ph","Ej. Otro formato");

			$this->tpl->assign("unidad_texto","Unidad");
			$this->tpl->assign("unidad_selector_texto","Seleccione unidad");
			$this->tpl->assign("mensaje_texto","Mensaje");
			$this->tpl->assign("observaciones_texto","Observaciones");
			$this->tpl->assign("via_texto","Deseo recibir la información vía");
			$this->tpl->assign("formato_texto","Deseo que la información me sea entregada en formato");
			$this->tpl->assign("otro_formato_texto","Otro formato");
			$this->tpl->assign("check_correo_texto","Deseo recibir notificaciones vía correo electrónico");
			$this->tpl->assign("adjunto_texto","Añadir adjunto");
			$this->tpl->assign("enviar_solicitud_texto","Enviar solicitud");

			$this->tpl->assign("id_ph","Ej. 35");
			$this->tpl->assign("radio_id_texto","Usando su identificador de usuario");
			$this->tpl->assign("radio_correo_texto","Usando su correo electrónico");
			$this->tpl->assign("cab_rc","Recuperar contraseña");
			$this->tpl->assign("consultar_solicitud_ph","Ej. 12345abcd");
			$this->tpl->assign("consultar_solicitud_cabecera","Consultar solicitud");
			$this->tpl->assign("consultar_solicitud_small","ingrese código de la solicitud");

			$this->tpl->assign("resp_correccion_texto","Respuesta");
			$this->tpl->assign("resp_correccion_ph","Ej. Mediante este mensaje rectifico la solicitud según la subsanación solicitada...");
			$this->tpl->assign("mis_datos_cabecera_texto","Modificar mis datos");
			$this->tpl->assign("mis_datos_cabecera_small","podrá modificar sus datos personales");

			$this->tpl->assign("solicitante_cabecera_texto","Enviar solicitud");
			$this->tpl->assign("solicitante_cabecera_small","ingrese datos del solicitante");

			$this->tpl->assign("solicitud_cabecera_texto","Enviar solicitud");
			$this->tpl->assign("solicitud_cabecera_small","ingrese datos de la solicitud");

			$this->tpl->assign("pf_cabecera_texto","Preguntas frecuentes");
			$this->tpl->assign("pf_cabecera_small","que podrían resolver sus dudas");

			$this->tpl->assign("regciu_cabecera_texto","Regístrese");
			$this->tpl->assign("regciu_cabecera_small","como ciudadano en el sistema");

			$this->tpl->assign("adjuntos_cab_tabla","Documentos relacionados");
			$this->tpl->assign("adjuntos_sin_resultados_texto","No existen documentos relacionados");

			$this->tpl->assign("datos_ciudadano_dc","Datos ciudadano");
			$this->tpl->assign("datos_solicitante_dc","Datos solicitante");
			$this->tpl->assign("datos_apoderado_dc","Datos del apoderado");
			$this->tpl->assign("datos_solicitud_dc","Datos solicitud");
			$this->tpl->assign("id_ciudadano_texto_tabla","ID ciudadano");
			$this->tpl->assign("tipo_persona_texto_tabla","Tipo persona");
			$this->tpl->assign("tiene_apoderado_texto_tabla","¿Tiene apoderado?");
			$this->tpl->assign("numero_solicitud_texto_tabla","Número Solicitud");
			$this->tpl->assign("fecha_ingreso_texto_tabla","Fecha Ingreso");
			$this->tpl->assign("tipo_texto_tabla","Tipo");
			$this->tpl->assign("dirigido_texto_tabla","Dirigido a");
			$this->tpl->assign("estado_texto_tabla","Estado");
			$this->tpl->assign("tipo_respuesta_texto_tabla","Tipo respuesta");
			$this->tpl->assign("correo_respuesta_texto_tabla","Correo electrónico respuesta");
			$this->tpl->assign("direccion_respuesta_texto_tabla","Dirección postal respuesta");
			$this->tpl->assign("nota_ciudadano_texto_tabla","Nota al ciudadano");
			$this->tpl->assign("fecha_limite_texto_tabla","Fecha límite respuesta");
			$this->tpl->assign("asunto_texto_tabla","Asunto");
			$this->tpl->assign("mensaje_texto_tabla","Mensaje");
			$this->tpl->assign("id_texto_tabla","ID");
			$this->tpl->assign("accion_texto_tabla","Acción");
			$this->tpl->assign("cargo_texto_tabla","Cargo");
			$this->tpl->assign("representante_legal_texto_tabla","Representate legal");
			$this->tpl->assign("respuesta_texto","Texto rectificación");

			$this->tpl->assign("mis_solicitudes_texto_h2","Mis solicitudes");
			$this->tpl->assign("mis_solicitudes_texto_small","listado de solicitudes enviadas");

			$this->tpl->assign("responder_correccion_texto_h2","Rectificar subsanación");
			$this->tpl->assign("responder_correccion_texto_small","solicitada por el encargado");

			$this->tpl->assign("responder_barra_texto","Haga clic en esta barra para revisar el estado de la solicitud");

			$this->tpl->assign("formulario_descargable_texto","Formulario Descargable");
			$this->tpl->assign("completar_registro_texto","Completar registro");
			$this->tpl->assign("completar_registro_texto_p","Recuerde completar su registro, revisando el email enviado a su cuenta de correo electrónico.");

			$this->tpl->assign("identificacion_texto","Identificación");
			$this->tpl->assign("recuperar_contrasena_texto","Recuperar contraseña");

			$this->tpl->assign("id_o_email_texto_ph","Ej. 9 o usuario@correo.cl");
			$this->tpl->assign("contrasena_texto_ph","********");
			$this->tpl->assign("id_texto_title","Recuerde que en este campo debe ingresar el identificador numérico proporcionado a su correo electrónico al momento de registrarse, o ingresar el correo electrónico con el cual efectuó el registro");
			$this->tpl->assign("recuperar_texto_title","Recuperar contraseña");
			$this->tpl->assign("registro_completo_texto","Su registro ha sido completado con éxito. <br><br> A continuación puede rellenar los campos del formulario para comenzar a realizar una nueva solicitud de información o hacer clic en el ícono  <i class='glyphicon glyphicon-th'></i>  para navegar otras opciones");
			$this->tpl->assign("registro_completo_titulo","Registro completado");

			$this->tpl->assign("inicio_texto","Ir al inicio");
			$this->tpl->assign("ir_a_solicitud_texto","haga clic para ir a realizar una nueva solicitud");
			$this->tpl->assign("visualizar_solicitud_vacio_texto","No ha realizado ninguna solicitud recientemente que le permita visualizar el resumen correspondiente. Si desea realizar una solicitud de información haga clic");
			$this->tpl->assign("visualizar_solicitud_vacio_volver_texto","o para volver al inicio haga clic");

			$this->tpl->assign("descripcion_subsanacion_texto_tabla","Descripción subsanación:");
			$this->tpl->assign("causal_texto_tabla","Razón o causal de cierre:");
		}

	}
?>
