<?php
class Index_Vista extends Vista {

	var $barra_modelo;
	var $articulos_modelo;

	function Index_Vista() {
	
		parent::Vista();

		$this->articulos_modelo = new Articulos_Modelo();
		$this->barra_modelo = new BarraNavegacion();

		$this->url = _BASE_WEB;
		
		$this->tpl->assign('title',_NOMBRE_INSTITUCION);
		$this->tpl->assign('url',"{$this->url}");
		$this->barra_modelo->setInsertarLink("Inicio","Inicio","","index.php?action=solicitud_informacion");

		$this->tpl->assign("titulo_cabecera_tp",_TITULO_HEADER_TP);
		$this->tpl->assign("seccion_tp",_SECCION_TP);
		$this->tpl->assign("articulo_cabecera_tp",$this->articulos_modelo->get_article_per_id(_ARTICULO_HEADER_TP));
		$this->tpl->assign("articulo_portada",$this->articulos_modelo->get_article_per_id(_ARTICULO_PORT_TP));
        $this->tpl->assign("articulo_contingencia",$this->articulos_modelo->get_article_per_id(_ARTICULO_CONTINGENCIA));
		
		$this->tpl->assign("cliente_footer", _CLIENTE_FOOTER);
		$this->tpl->assign("direccion_footer", _DIRECCION_FOOTER);
		$this->tpl->assign("fono_footer", _FONO_FOOTER);
		$this->tpl->assign("web_footer", _WEB_FOOTER);
		$this->tpl->assign("contacto_dificultades", _CORREO_PROBLEMAS);

		$this->tpl->assign("base_tpl","plantilla_base.tpl.htm");
	}

	function recuperarContrasenia() {
		$xajax = new xajax("controles/xajax/tp.xjx.php");
		$xajax->register(XAJAX_FUNCTION,"setRecuperarTP");
		$this->tpl->assign("xajax_include",$xajax->getJavascript('bibliotecas/xajax/'));
		$this->tpl->assign('action','oirs_recuperar');
		$this->barra_modelo->setInsertarLink("Recuperar contraseña","Recuperar contraseña","","");
		$this->tpl->assign("barra",$this->barra_modelo->getBarraNavegacion());
		$this->tpl->assign("inicio","index.php?action=login_solicitud_informacion");
		$this->tpl->display("recuperar_contrasena.tpl.htm");
	}

	function listadoSolicitudes($datos_usuario,$solicitudes_usuario) {
		$xajax = new xajax("controles/xajax/oirs.xjx.php");
		$xajax->register(XAJAX_FUNCTION,"setRevisarFormulario");
		$this->tpl->assign("xajax_include",$xajax->getJavascript('bibliotecas/xajax/'));
		$this->barra_modelo->setInsertarLink("Mis solicitudes","Mis solicitudes","","");
		$this->tpl->assign("barra",$this->barra_modelo->getBarraNavegacion());
		$this->tpl->assign('action','solicitudes');
		$this->tpl->assign('tp_usuario',$solicitudes_usuario['tp']);
		$this->setPaginado("solicitudes",$solicitudes_usuario['paginacion']);
		$this->tpl->assign("datos_usuario",$datos_usuario);
		$this->tpl->display("solicitudes.tpl.htm");
	}

	function solicitudDetalle($datos_usuario,$oirs,$adjuntos,$conteo_adjuntos) {
		$this->tpl->assign("tp",$oirs);
		$this->tpl->assign("adjuntos",$adjuntos);
		$this->tpl->assign("conteo_adjuntos",$conteo_adjuntos);
		$this->tpl->assign("datos_usuario",$datos_usuario);
		$this->barra_modelo->setInsertarLink("Mis solicitudes","Mis solicitudes","","{$this->url}index.php?action=solicitudes");
		$this->barra_modelo->setInsertarLink("Detalle solicitud","Detalle solicitud","","");
		$this->tpl->assign("barra",$this->barra_modelo->getBarraNavegacion());
		$this->tpl->display("solicitud_detalle.tpl.htm");
	}

	function consultarSolicitudResultado($datos,$adjuntos) {
		$this->barra_modelo->setInsertarLink("Consultar solicitud","Consultar solicitud","","index.php?action=consultar_solicitud");
		$this->barra_modelo->setInsertarLink("Detalle Solicitud","Detalle Solicitud","","");
		$this->tpl->assign("barra",$this->barra_modelo->getBarraNavegacion());
		$this->tpl->assign("adjuntos",$adjuntos["adjuntos"]);
		$this->tpl->assign("conteo_adjuntos",$adjuntos["conteo"]);
	    $this->tpl->assign("tp",$datos);
		$this->tpl->display("consultar_solicitud_resultado.tpl.htm");
	}

	function consultarSolicitud() {
		$xajax = new xajax("controles/xajax/cod_solicitud.xjx.php");
		$xajax->register(XAJAX_FUNCTION,"setRevisarFormulario");
		$this->tpl->assign("xajax_include",$xajax->getJavascript('bibliotecas/xajax/'));
		$this->barra_modelo->setInsertarLink("Consultar solicitud","Consultar solicitud","","");
		$this->tpl->assign("barra",$this->barra_modelo->getBarraNavegacion());
		$this->tpl->assign("action","consultar_solicitud");
		$this->tpl->display("consultar_solicitud.tpl.htm");
	}

	function ciudadanoAgregar($regiones) {
		$xajax = new xajax("controles/xajax/ciudadano.xjx.php");
		$xajax->register(XAJAX_FUNCTION,"setRevisarFormulario");
		$xajax->register(XAJAX_FUNCTION,"setRellenarComuna");
		$this->tpl->assign("xajax_include",$xajax->getJavascript('bibliotecas/xajax/'));
		$this->tpl->assign('action','ciudadano_agregar');
		$this->tpl->assign('btn','Registrarse');
		$this->tpl->assign("regiones",$regiones);
		
		$this->barra_modelo->setInsertarLink("Deseo registrarme","Deseo registrarme","","");
		$this->tpl->assign("barra",$this->barra_modelo->getBarraNavegacion());
		$this->tpl->display("ciudadano_agregar.tpl.htm");
	}

	function ciudadanoModificar($datos_usuario,$regiones) {
		$xajax = new xajax("controles/xajax/ciudadano.xjx.php");
		$xajax->register(XAJAX_FUNCTION,"setRevisarFormulario");
		$xajax->register(XAJAX_FUNCTION,"setRellenarComuna");
		$xajax->register(XAJAX_FUNCTION,"setRellenarComunaApoderado");
		$this->tpl->assign("xajax_include",$xajax->getJavascript('bibliotecas/xajax/'));

		$this->barra_modelo->setInsertarLink("Modificar mis datos","Modificar mis datos","","");
		$this->tpl->assign("barra",$this->barra_modelo->getBarraNavegacion());
		$this->tpl->assign("datos_usuario",$datos_usuario);

		if($datos_usuario['rut_dv'] != ""){
			$this->tpl->assign("rut","{$datos_usuario['rut_ciudadano']}-{$datos_usuario['rut_dv']}");
		}

		$this->tpl->assign('action','ciudadano_modificar');
		$this->tpl->assign("regiones",$regiones);

        $this->tpl->assign("region_selec",$datos_usuario["region"]);
        $this->tpl->assign("comuna_selec",$datos_usuario["comuna"]);
        $this->tpl->assign("btn","Modificar");
		$this->tpl->display("usuario_modificar.tpl.htm");
	}

	function responderCorreccion($datos_usuario,$oirs) {
		$xajax = new xajax("controles/xajax/solicitud.xjx.php");
		$xajax->register(XAJAX_FUNCTION,"responderCorreccion");
		$this->tpl->assign("xajax_include",$xajax->getJavascript('bibliotecas/xajax/'));
		$this->barra_modelo->setInsertarLink("Mis solicitudes","Mis solicitudes","","index.php?action=solicitudes");
		$this->barra_modelo->setInsertarLink("Responder subsanación","Responder subsanación","","");
		$this->tpl->assign("barra",$this->barra_modelo->getBarraNavegacion());
		$this->tpl->assign("datos_usuario",$datos_usuario);
		$this->tpl->assign("oirs",$oirs);
		$this->tpl->assign("id_usuario",$_SESSION['id_usuario']);
		$this->tpl->assign("subsanar_no_registro",$_SESSION['subsanar_no_registro']);
		$this->tpl->assign('action','correccion_responder');
		$this->tpl->assign("btn","Rectificar");
		$this->tpl->display("responder_correccion.tpl.htm");
	}

	function setPreguntas($_preguntas_lista) {
		$this->barra_modelo->setInsertarLink("Preguntas","Preguntas","","");
		$this->tpl->assign("barra",$this->barra_modelo->getBarraNavegacion());
		$this->tpl->assign("preguntas_lista",$_preguntas_lista);
		$this->setPaginado("preguntas",$_preguntas_lista['paginacion']);
		$this->tpl->display("preguntas_frecuentes.tpl.htm");
	}

	function solicitudAgregar($data,$forma_respuesta,$formato_entrega,$idformarespuesta,$idformatoentrega, $regiones) {
		$xajax = new xajax("controles/xajax/solicitud.xjx.php");
		$xajax->register(XAJAX_FUNCTION,"setSolicitud");
		$xajax->register(XAJAX_FUNCTION,"setRellenarComuna");
		$xajax->register(XAJAX_FUNCTION,"rellenarFormatos");
		$this->tpl->assign("xajax_include",$xajax->getJavascript('bibliotecas/xajax/'));
        
        //originales
        $id_forma_respuesta = array(0,1,2,3);
        $this->tpl->assign("idformarespuesta",$id_forma_respuesta);

        $forma_respuesta = array('Seleccione v&iacute;a de recepci&oacute;n(*)','Correo electr&oacute;nico','Correo postal','Retirar en oficina de partes');
        $this->tpl->assign("formarespuesta",$forma_respuesta);

        $id_formato_entrega = array(0,1,2,3,4,5,6);
        $this->tpl->assign("idformatoentrega",$id_formato_entrega);

        $formato_entrega = array('Seleccione un formato de entrega(*)','CD-ROM','Papel','Word','Excel','Otros','PDF');
        $this->tpl->assign("formatoentrega",$formato_entrega);
        

		$this->barra_modelo->setInsertarLink("Enviar solicitud","Enviar solicitud","","{$this->url}index.php?action=solicitante_agregar_formulario&tipo_solicitud=".$_REQUEST["tipo_solicitud"]."");
		$this->barra_modelo->setInsertarLink("Datos del solicitante","Datos del solicitante","","{$this->url}index.php?action=solicitante_agregar_formulario&tipo_solicitud=".$_REQUEST["tipo_solicitud"]."");
		$this->barra_modelo->setInsertarLink("Datos de la solicitud","Datos de la solicitud","","");
		$this->tpl->assign("barra",$this->barra_modelo->getBarraNavegacion());

		$this->tpl->assign("tipos_oirs",$data["tipos_oirs"]);
		$this->tpl->assign("deps_ciu",$data["deps_ciu"]);
		$this->tpl->assign("datos_solicitante",$data["datos_solicitante"]);
		$this->tpl->assign("datos_usuario",$data["datos_usuario"]);
		$this->tpl->assign("id_usuario",$data["datos_usuario"]["id_ciudadano"]);
		$this->tpl->assign('action','solicitud_agregar');
		$this->tpl->assign("regiones",$regiones);
		$this->tpl->assign("formarespuesta",$forma_respuesta);
		$this->tpl->assign("formatoentrega",$formato_entrega);
		$this->tpl->assign("idformarespuesta",$idformarespuesta);
		$this->tpl->assign("idformatoentrega",$idformatoentrega);
		$this->tpl->assign("id_solicitante",$_REQUEST['id_solicitante']);
		$this->tpl->display("solicitud_agregar.tpl.htm");
	}

	function oirsVisualizarSolicitud($datos_solicitud,$espasiva) {
	    $this->tpl->assign("datos_oirs",$datos_solicitud);
	    $this->tpl->assign("organismo",$datos_solicitud["organismo"]);
	    $this->tpl->assign("region",$datos_solicitud["region_nombre"]);
	    $this->tpl->assign("comuna",$datos_solicitud["comuna_nombre"]);
	    $this->tpl->assign("region_solicitante",$datos_solicitud["region_nombre_solicitante"]);
	    $this->tpl->assign("comuna_solicitante",$datos_solicitud["comuna_nombre_solicitante"]);
	    $this->tpl->assign("razon_social",$datos_solicitud[0]["razon_social_solicitante"]);
			$this->tpl->assign("solicitud_manual",$_REQUEST["sm"]);
			$this->tpl->assign("id_oirs",$datos_solicitud['id_oirs']);
			$this->tpl->assign("url_admin",_URL_CONTACTO_ADMIN);
		$this->tpl->display("solicitud_visualizar.tpl.htm");
	}

	function rectificacionEnviada($datos_solicitud,$espasiva) {
	    $this->tpl->assign("datos_oirs",$datos_solicitud);
	    $this->tpl->assign("organismo",$datos_solicitud["organismo"]);
			$this->tpl->assign("id_oirs",$datos_solicitud['id_oirs']);
			$this->tpl->display("rectificacion_enviada.tpl.htm");
	}

	function solicitanteAgregar($datos_usuario,$tipos_oirs,$regiones) {
		$xajax = new xajax("controles/xajax/solicitante.xjx.php");
		$xajax->register(XAJAX_FUNCTION,"setRevisarFormulario");
		$xajax->register(XAJAX_FUNCTION,"setRellenarComuna");
		$xajax->register(XAJAX_FUNCTION,"setRellenarComunaApoderado");
		$this->tpl->assign("xajax_include",$xajax->getJavascript('bibliotecas/xajax/'));
		$this->barra_modelo->setInsertarLink("Enviar solicitud","Enviar solicitud","","");
		$this->barra_modelo->setInsertarLink("Datos del solicitante","Datos del solicitante","","");
		$this->tpl->assign("barra",$this->barra_modelo->getBarraNavegacion());
		$this->tpl->assign("tipos_oirs",$tipos_oirs);
		$this->tpl->assign('action','solicitante_agregar');
		$this->tpl->assign("regiones",$regiones);
        $this->tpl->assign("tipo_solicitud",$_REQUEST["tipo_solicitud"]);
        $this->tpl->assign("registrado",$_REQUEST["registrado"]);
		$this->tpl->assign("datos_usuario",$datos_usuario);
		$this->tpl->display("solicitante_agregar.tpl.htm");
	}

	function solicitanteAgregarNoRegistro($datos_usuario,$regiones,$numero_solicitud,$fecha_solicitud) {
		$xajax = new xajax("controles/xajax/solicitante_no_registro.xjx.php");
		$xajax->register(XAJAX_FUNCTION,"setRevisarFormulario");
		$xajax->register(XAJAX_FUNCTION,"setRellenarComuna");
		$xajax->register(XAJAX_FUNCTION,"setRellenarComunaApoderado");
		$this->tpl->assign("xajax_include",$xajax->getJavascript('bibliotecas/xajax/'));
		$this->barra_modelo->setInsertarLink("No deseo registrarme","No deseo registrarme","","");
		$this->tpl->assign("barra",$this->barra_modelo->getBarraNavegacion());
		$this->tpl->assign('action','solicitante_agregar_no_registro');
		$this->tpl->assign('value_btn','Registrar');
		$this->tpl->assign("regiones",$regiones);
        $this->tpl->assign("datos_usuario",$datos_usuario);
		$this->tpl->assign('numero_solicitud',$numero_solicitud);
		$this->tpl->assign('fecha_solicitud',$fecha_solicitud);

		$this->tpl->display("solicitante_agregar_no_registro.tpl.htm");
	}

	function solicitudAgregarNoRegistro($datos_solicitante,$forma_respuesta,$formato_entrega,$regiones,$deps_ciu,$id_usuario,$solicitud_manual,$fecha_solicitud) 
	{


		$xajax = new xajax("controles/xajax/solicitud_no_registro.xjx.php");
		$xajax->register(XAJAX_FUNCTION,"setSolicitud");
		$xajax->register(XAJAX_FUNCTION,"setRellenarComuna");
		$xajax->register(XAJAX_FUNCTION,"rellenarFormatos");
        
        $id_forma_respuesta = array(0,1,2,3);
        $this->tpl->assign("idformarespuesta",$id_forma_respuesta);

        $forma_respuesta = array('Seleccione v&iacute;a de recepci&oacute;n(*)','Correo electr&oacute;nico','Correo postal','Retirar en oficina de partes');
        $this->tpl->assign("formarespuesta",$forma_respuesta);

        $id_formato_entrega = array(0,1,2,3,4,5,6);
        $this->tpl->assign("idformatoentrega",$id_formato_entrega);

        $formato_entrega = array('Seleccione un formato de entrega(*)','CD-ROM','Papel','Word','Excel','Otros','PDF');
        $this->tpl->assign("formatoentrega",$formato_entrega);
        
	
		$this->tpl->assign("xajax_include",$xajax->getJavascript('bibliotecas/xajax/'));
		$this->barra_modelo->setInsertarLink("No deseo registrarme","No deseo registrarme","","");
		$this->tpl->assign("barra",$this->barra_modelo->getBarraNavegacion());
		$this->tpl->assign("deps_ciu",$deps_ciu);
		 
		 

		$this->tpl->assign("datos_solicitante",$datos_solicitante);
		$this->tpl->assign('action','solicitud_agregar_no_registro');
		$this->tpl->assign("regiones",$regiones);
		
		$this->tpl->assign("idformarespuesta",array_keys($forma_respuesta));
		
		$this->tpl->assign("formarespuesta",array_values($forma_respuesta));
		
		$this->tpl->assign("idformatoentrega",array_keys($formato_entrega));
		$this->tpl->assign("formatoentrega",array_values($formato_entrega));
		$this->tpl->assign("id_solicitante",$_REQUEST['id_solicitante']);
		$this->tpl->assign("id_usuario",$id_usuario);
		$this->tpl->assign("solicitud_manual",$solicitud_manual);
		$this->tpl->assign("fecha_solicitud",$fecha_solicitud);
		$this->tpl->display("solicitud_agregar_no_registro.tpl.htm");

	}

	function formularioDescargable($formulario_descargable){
		$this->barra_modelo->setInsertarLink("Formulario Descargable","Formulario Descargable","","");
		$this->tpl->assign("barra",$this->barra_modelo->getBarraNavegacion());
		$this->tpl->assign("formulario_descargable",$formulario_descargable);
		$this->tpl->display("formulario_descargable.tpl.htm");
	}

	function solicitudInformacion($imagenes){
		$xajax = new xajax("controles/xajax/login.xjx.php");
		$xajax->register(XAJAX_FUNCTION,"setCheckPass");
		$this->tpl->assign("xajax_include",$xajax->getJavascript('bibliotecas/xajax/'));
		$this->barra_modelo->setInsertarLink("Solicitud en línea","Solicitud en línea","","{$this->url}index.php?action=solicitud_informacion");
		$this->tpl->assign("barra",$this->barra_modelo->getBarraNavegacion());
		$this->tpl->assign('action',strpos($_SERVER['HTTP_REFERER'],'ciudadano_agregar_formulario') > 0 ? true : false);
		$this->tpl->assign("accion","solicitud_informacion");
		$this->tpl->assign("registro",!empty($_REQUEST["registro"]) ? $_REQUEST["registro"] : '');
		$this->tpl->assign("imagenes",$imagenes["imagenes"]);
		$this->tpl->display("solicitud_informacion.tpl.htm");
	}
}
?>
