<?php
// Portable UTF-8
use voku\helper\UTF8;
class TP_Modelo extends Modelo {

	var $tb_oirs;
	var $tb_estados_oirs;
	var $tb_tipo_oirs;
	var $tb_organo;
	var $tb_historial;
	var $tb_persona;
	var $tb_ciudadano_persona;
	var $tb_ciudadano;
	var $tb_usuarios;
	var $tb_funcionario;
	var $tb_trans_adjunto;
	var $tb_feriados;
	var $tb_trans_regiones;
	var $tb_trans_comunas;
	var $tb_trans_solicitante;
	var $tb_trans_configuration;

	function TP_Modelo() {
		parent::Modelo();
		$this->tb_oirs = 'trans_oirs';
		$this->tb_estados_oirs = 'trans_estados_oirs';
		$this->tb_tipo_oirs = 'trans_tipo_oirs';
		$this->tb_organo = 'trans_organo_administrativo';
		$this->tb_historial = 'trans_historial';
		$this->tb_persona = 'trans_persona_juridica';
		$this->tb_ciudadano_persona = 'trans_ciudadano_persona_juridica';
		$this->tb_ciudadano = 'trans_ciudadano';
		$this->tb_usuarios = 'trans_usuarios';
		$this->tb_funcionario = 'trans_funcionario';
		$this->tb_trans_adjunto = 'trans_adjunto';
		$this->tb_feriados = 'trans_feriados';
		$this->tb_trans_regiones = 'trans_regiones';
		$this->tb_trans_comunas = 'trans_comunas';
		$this->tb_trans_solicitante = "trans_solicitante";
		$this->tb_trans_configuration = "trans_configuration";

	}

	function Start() {
		$this->setTransaccion('start');
	}

	function End() {
		$this->setTransaccion('end');
	}

	function FailTrans() {
		$this->setTransaccion('fail');
	}

	function setInsertID() {
		return $this->getInsertID();
	}

	function setAgregarOIRS($cmps) {
		$sql = "select * from {$this->tb_oirs} where id_oirs = -1";
		return $this->setGuardar($sql,$cmps);
	}
	function setModificarOIRS($cmps) {
		$sql = "select * from {$this->tb_oirs} where id_oirs = {$cmps['id_oirs']}";
		return $this->setModificar($sql,$cmps);
	}

	function setAgregarHistorial($cmps) {
		$sql = "select * from {$this->tb_historial} where id_historial = -1";
		return $this->setGuardar($sql,$cmps);
	}

	function setAgregarUsuario($cmps) {
		$sql = "select * from {$this->tb_usuarios} where id_usuario = -1";
		return $this->setGuardar($sql,$cmps);
	}

	function setAgregarCiudadano($cmps) {
		$sql = "select * from {$this->tb_ciudadano} where id_ciudadano = -1";
		return $this->setGuardar($sql,$cmps);
	}

	function setAgregarSolicitante($cmps) {
		$sql = "select * from {$this->tb_trans_solicitante} where id_solicitante = -1";
		return $this->setGuardar($sql,$cmps);
	}

	function setAgregarCiudadano_persona($cmps) {
		$sql = "select * from {$this->tb_ciudadano_persona}";
		return $this->setGuardar($sql,$cmps);
	}

	function setAgregarPersona_juridica($cmps) {
		$sql = "select * from {$this->tb_persona}";
		return $this->setGuardar($sql,$cmps);
	}

	function setModificarUsuario($cmps) {
		$sql = "select * from {$this->tb_usuarios} where id_usuario = {$cmps['id_usuario']}";
		return $this->setModificar($sql,$cmps);
	}

	function setModificarCiudadano($cmps) {
		$sql = "select * from {$this->tb_ciudadano} where id_ciudadano = {$cmps['id_ciudadano']}";
		return $this->setModificar($sql,$cmps);
	}

	function getOIRS($id_oirs,$captcha) {
		$sql = "select o.*, e.estado, t.tipo from {$this->tb_oirs} o inner join {$this->tb_estados_oirs} e on o.estado_oirs=e.id_estado inner join {$this->tb_tipo_oirs} t on o.tipo_oirs=t.id_tipo where o.id_oirs=$id_oirs and o.captcha='$captcha'";
		$rs = $this->getConsulta($sql);

		return $rs->fields;
	}

	function getOIRSxId($id_oirs) {
		$sql = "select o.*, e.estado, t.tipo,
		sol.id_solicitante,
		sol.razon_social as razon_social_solicitante,
		sol.nombre as nombre_solicitante,
		sol.apellido_paterno_ciudadano as apellido_paterno_solicitante,
		sol.apellido_materno_ciudadano as apellido_materno_solicitante,
		sol.email_o_postal,
		sol.email as email_solicitante,
		sol.direccion as direccion_solicitante,
		sol.region as region_solicitante,
		sol.comuna as comuna_solicitante,
		sol.localidad as localidad_solicitante,
		sol.tipo as tipo_solicitante,
		sol.apoderado as apoderado_solicitante,
		sol.nombre_apoderado,
		sol.ap_paterno_apoderado,
		sol.ap_materno_apoderado from {$this->tb_oirs} o
		inner join {$this->tb_estados_oirs} e on o.id_estado=e.id_estado
		inner join {$this->tb_tipo_oirs} t on o.id_tipo=t.id_tipo
		inner join {$this->tb_trans_solicitante} sol on o.id_solicitante = sol.id_solicitante
		where o.id_oirs=$id_oirs";

		$rs = $this->getConsulta($sql);
		$dato = array();
		$dato["id_oirs"] 				= $rs->fields["id_oirs"];
		$dato["id_ciudadano"] 			= $rs->fields["id_ciudadano"];
		$dato["cod_solicitud"] 			= $rs->fields["cod_solicitud"];
		$dato["id_tipo"] 				= $rs->fields["id_tipo"];
		$dato["id_estado"] 				= $rs->fields["id_estado"];
		$dato["asunto"] 				= $rs->fields["asunto"];
		$dato["tipo_solicitante"] 		= utf8_encode($rs->fields["tipo_solicitante"]);
		$dato["fecha"] 					= $rs->fields["fecha"];
		$dato["fecha_modificar"] 		= $rs->fields["fecha_modificar"];
		$dato["mensaje"] 				= utf8_encode($rs->fields["mensaje"]);
		$dato["observaciones"] 			= utf8_encode($rs->fields["observaciones"]);
		$dato["fecha_maxima_respuesta"] = utf8_encode($rs->fields["fecha_maxima_respuesta"]);
		$dato["fecha_extendido"] 		= utf8_encode($rs->fields["fecha_extendido"]);
		$dato["nombre"] 				= utf8_encode($rs->fields["nombre"]);
		$dato["direccion"] 				= utf8_encode($rs->fields["direccion"]);
		$dato["tramitado"] 				= utf8_encode($rs->fields["tramitado"]);
		$dato["id_organo"] 				= utf8_encode($rs->fields["id_organo"]);
		$dato["id_organo_ciu"] 			= utf8_encode($rs->fields["id_organo_ciu"]);
		$dato["tipo_respuesta"] 		= utf8_encode($rs->fields["tipo_respuesta"]);
		$dato["formato_entrega"] 		= utf8_encode($rs->fields["formato_entrega"]);
		$dato["otro_formato"] 			= utf8_encode($rs->fields["otro_formato"]);
		$dato["envio_email"] 			= utf8_encode($rs->fields["envio_email"]);
		$dato["email_oirs"] 			= utf8_encode($rs->fields["email_oirs"]);
		$dato["direccion_oirs"] 		= $rs->fields["direccion_oirs"];
		$dato["region_oirs"] 			= $rs->fields["region_oirs"];
		$dato["comuna_oirs"] 			= $rs->fields["comuna_oirs"];
		$dato["localidad_oirs"] 		= $rs->fields["localidad_oirs"];
		$dato["otro_formato"] 		= utf8_encode($rs->fields["otro_formato"]);
	//Datos apoderado y solicitante
		$dato["id_solicitante"] = $rs->fields["id_solicitante"];
		$dato["razon_social_solicitante"] = $rs->fields["razon_social_solicitante"];
		$dato["nombre_solicitante"] = $rs->fields["nombre_solicitante"];
		$dato["apellido_paterno_solicitante"] = $rs->fields["apellido_paterno_solicitante"];
		$dato["apellido_materno_solicitante"] = $rs->fields["apellido_materno_solicitante"];
		$dato["email_o_postal"] = $rs->fields["email_o_postal"];
		$dato["email_solicitante"] = $rs->fields["email_solicitante"];
		$dato["direccion_solicitante"] = $rs->fields["direccion_solicitante"];
		$dato["region_solicitante"] = $rs->fields["region_solicitante"];
		$dato["comuna_solicitante"] = $rs->fields["comuna_solicitante"];
		$dato["localidad_solicitante"] = $rs->fields["localidad_solicitante"];
		$dato["tipo_solicitante"] = $rs->fields["tipo_solicitante"];
		$dato["apoderado_solicitante"] = $rs->fields["apoderado_solicitante"];
		$dato["nombre_apoderado"] = $rs->fields["nombre_apoderado"];
		$dato["ap_paterno_apoderado"] = $rs->fields["ap_paterno_apoderado"];
		$dato["ap_materno_apoderado"] = $rs->fields["ap_materno_apoderado"];
		$dato["extendido"] = $rs->fields["extendido"];

		if(($dato['id_estado'] == 'EC' || $dato['id_estado'] == 'CO')  and $rs->fields['fecha_maxima_respuesta'] > $rs->fields['fecha_extendido']){
			$dato['fechafinal'] = $rs->fields['fecha_maxima_respuesta'];
		}elseif(($dato['id_estado'] == 'EC' || $dato['id_estado'] == 'CO') and $rs->fields['fecha_maxima_respuesta'] < $rs->fields['fecha_extendido']){
			$dato['fechafinal'] = $rs->fields['fecha_extendido'];
		}else{
			$dato['fechafinal'] = 'N/A';
		}
	//Otros datos
		$dato["organismo"] = utf8_encode($this->getOrganoxid($rs->fields["id_organo_ciu"]));
		$dato["region_nombre"] = utf8_encode($this->getRegionxid($rs->fields["region"]));
		$dato["comuna_nombre"] = $this->getComunaxid($rs->fields["comuna"]);
		$dato["region_nombre_solicitante"] = utf8_encode($this->getRegionxid($rs->fields["region_solicitante"]));
		$dato["comuna_nombre_solicitante"] = $this->getComunaxid($rs->fields["comuna_solicitante"]);

		$dato['historial'] = $this->getUltimo_historial($rs->fields['id_oirs']);
		$dato['ultima_subsanacion'] = $this->getUltimaSubsanacion($rs->fields['id_oirs']);
		$dato['usuario_no_registrado'] = $this->getUsuario($rs->fields['id_ciudadano']["no_registrado"] == 1) ? TRUE : FALSE;
		$dato['cod_solicitud'] = $rs->fields['cod_solicitud'];

		return $dato;
	}

	function getTiposOIRS() {
		$sql = "select * from {$this->tb_tipo_oirs} order by tipo asc";
		$rs = $this->getConsulta($sql);
		$estados = array();
		while (!$rs->EOF) {
			$estados[$rs->fields['id_tipo']] = $rs->fields['tipo'];
			$rs->MoveNext();
		}
		return $estados;
	}

	function getTiposSolicitudes() {
		$sql = "select * from {$this->tb_tipo_oirs} where solicitud_informacion = 0 order by id_tipo asc";
		$rs = $this->getConsulta($sql);
		$estados = array();
		while (!$rs->EOF) {
			$estado = array();
			$estado["id_tipo"] = $rs->fields['id_tipo'];
			$estado["tipo"] = $rs->fields['tipo'];
			$estado["solicitud_informacion"] = $rs->fields['solicitud_informacion'];
			$estado["descripcion"] = $rs->fields['descripcion'];
			$estados[] = $estado;
			$rs->MoveNext();
		}
		return $estados;
	}

	function getTiposSolicitudesPasiva() {
		$sql = "select * from {$this->tb_tipo_oirs} where solicitud_informacion = 1 order by id_tipo asc";
		$rs = $this->getConsulta($sql);
		$estados = array();
		while (!$rs->EOF) {
			$estado = array();
			$estado["id_tipo"] = $rs->fields['id_tipo'];
			$estado["tipo"] = $rs->fields['tipo'];
			$estado["solicitud_informacion"] = $rs->fields['solicitud_informacion'];
			$estado["descripcion"] = $rs->fields['descripcion'];
			$estados[] = $estado;
			$rs->MoveNext();
		}
		return $estados;
	}

	function getImagenTipo($id_tipo) {
		$sql = "select imagen from {$this->tb_tipo_oirs} where id_tipo = $id_tipo";
		$rs = $this->getConsulta($sql);
		$estados = array();
		while (!$rs->EOF) {
			$estado = array();
			$estado["imagen"] = $rs->fields['imagen'];
			$estados[] = $estado;
			$rs->MoveNext();
		}
		return $estados;
	}

	function getTiposOIRSxId($id) {
		$sql = "select * from {$this->tb_tipo_oirs} where id_tipo = '$id' order by tipo asc";
		$rs = $this->getConsulta($sql);
		$estados = array();
		while (!$rs->EOF) {
			$estados["id_tipo"] = $rs->fields['id_tipo'];
			$estados["plazo"] = $rs->fields['plazo'];
			$estados["tipo"] = $rs->fields['tipo'];
			$estados["solicitud_informacion"] = $rs->fields['solicitud_informacion'];
			$rs->MoveNext();
		}
		return $estados;
	}

	function getOrganos() {
		$sql = "select * from {$this->tb_organo} order by nombre asc";
		$rs = $this->getConsulta($sql);
		$organos = array();
		while (!$rs->EOF) {
			$organos[$rs->fields['id_organo']] = $rs->fields['nombre'];
			$rs->MoveNext();
		}
		return $organos;

	}

	function getOrganoxid($id_organo) {
		$sql = "select * from {$this->tb_organo} where id_organo = '$id_organo'order by nombre asc";
		$rs = $this->getConsulta($sql);
		return $rs->fields["nombre"];
	}

	function getFuncionario($id_organo) {
		$sql = "select f.*,o.id_organo from {$this->tb_organo} o, $this->tb_funcionario f
		where o.id_organo='$id_organo' and o.id_funcionario=f.id_funcionario";
		$rs_usuario = $this->getConsulta($sql);

		$usuario["id_organo"] = $rs_usuario->fields["id_organo"];
		$usuario["email"] = $rs_usuario->fields["email"];
		$usuario["nombre"] = $rs_usuario->fields["nombre"];
		$usuario["id_funcionario"] = $rs_usuario->fields["id_funcionario"];

		return $usuario;
	}

	function getEmail($email) {
		$sql = "select * from $this->tb_ciudadano c where c.email='$email'";
		$rs_mail = $this->getConsulta($sql);

		$mail['existe'] = (!$rs_mail->EOF) ? true : false;
		$mail["email"] = $rs_mail->fields["email"];
		$mail["no_registrado"] = $rs_mail->fields["no_registrado"];

		return $mail;
	}

	function getEmailxId($id) {
		$sql = "select * from $this->tb_ciudadano c where c.id_ciudadano='$id'";
		$rs_mail = $this->getConsulta($sql);

		$mail['existe'] = (!$rs_mail->EOF) ? true : false;
		$mail["email"] = $rs_mail->fields["email"];

		return $mail;
	}


	function getEmailxIdSolicitante($id_solicitante) {
		$sql = "select * from $this->tb_trans_solicitante s where s.id_solicitante='$id_solicitante'";
		$rs_mail = $this->getConsulta($sql);

		$mail['existe'] = (!$rs_mail->EOF) ? true : false;
		$mail["email"] = $rs_mail->fields["email"];

		return $mail;
	}

	function getIdCiudadano($id) {
		$sql = "select * from $this->tb_ciudadano where id_ciudadano='$id'";

		$rs_id = $this->getConsulta($sql);

		$id['existe'] = (!$rs_id->EOF) ? true : false;
		$id["id_ciudadano"] = $rs_id->fields["id_ciudadano"];

		return $id;
	}


	function getUsuarioxid($id_ciudadano,$enviarpass=false) {
		$sql = "select * from $this->tb_usuarios u, $this->tb_ciudadano c
		where u.id_usuario='$id_ciudadano' and c.id_ciudadano=u.id_usuario";
		$rs_usuario = $this->getConsulta($sql);

		$usuario['existe'] = (!$rs_usuario->EOF) ? true : false;
		$usuario["id_ciudadano"] = $rs_usuario->fields["id_ciudadano"];
		$usuario["rut_ciudadano"] = $rs_usuario->fields["rut_ciudadano"];
		$usuario["rut_dv"] = $rs_usuario->fields["rut_dv"];
		$usuario["contrasena"] = $rs_usuario->fields["contrasena"];
		$usuario["tipo"] = $rs_usuario->fields["tipo"];
		$usuario["nombre"] = $rs_usuario->fields["nombre"];
		$usuario["email"] = $rs_usuario->fields["email"];
		$usuario["apellidos"] = $rs_usuario->fields["apellidos"];
		if($usuario && $enviarpass) {
			$contacto_modelo = new Contacto_Pasiva_Modelo();
			$contacto_modelo->recuperarContrasena(array('email'=>$rs_usuario->fields["email"],
															 'id_ciudadano'=>$rs_usuario->fields["id_ciudadano"],
															 'contrasena'=>$rs_usuario->fields["contrasena"]));
											 }
			return $usuario;
	}


		function getUsuarioxemail($email, $enviarpass=false) {
		$sql = "select * from $this->tb_usuarios u, $this->tb_ciudadano c
		where c.email='$email' and c.id_ciudadano=u.id_usuario";
		$rs_usuario = $this->getConsulta($sql);

		$usuario['existe'] = (!$rs_usuario->EOF) ? true : false;
		$usuario["id_ciudadano"] = $rs_usuario->fields["id_ciudadano"];
		$usuario["rut_ciudadano"] = $rs_usuario->fields["rut_ciudadano"];
		$usuario["rut_dv"] = $rs_usuario->fields["rut_dv"];
		$usuario["contrasena"] = $rs_usuario->fields["contrasena"];
		$usuario["tipo"] = $rs_usuario->fields["tipo"];
		$usuario["nombre"] = $rs_usuario->fields["nombre"];
		$usuario["email"] = $rs_usuario->fields["email"];
		$usuario["apellidos"] = $rs_usuario->fields["apellidos"];
		$usuario["no_registrado"] = $rs_usuario->fields["no_registrado"];
		if($usuario && $enviarpass) {
			$contacto_modelo = new Contacto_Modelo();
		   $contacto_modelo->recuperarContrasena(array('email'=>$rs_usuario->fields["email"],
															 'id_ciudadano'=>$rs_usuario->fields["id_ciudadano"],
															 'contrasena'=>$rs_usuario->fields["contrasena"]));
											 }

		return $usuario;
	}

	function getLogin($id_ciudadano,$contrasena) {

		$sql = "select * from $this->tb_usuarios u, $this->tb_ciudadano c
		where (u.id_usuario='".mysql_real_escape_string($id_ciudadano)."' or c.email = '".mysql_real_escape_string($id_ciudadano)."') and u.contrasena='".mysql_real_escape_string($contrasena)."' and c.id_ciudadano=u.id_usuario";

		$rs_usuario = $this->getConsulta($sql);

		$usuario['existe'] = (!$rs_usuario->EOF) ? true : false;
		$usuario["id_usuario"] = $rs_usuario->fields["id_usuario"];
		$usuario["contrasena"] = $rs_usuario->fields["contrasena"];
		$usuario["tipo"] = $rs_usuario->fields["tipo"];
		$usuario["nombre"] = $rs_usuario->fields["nombre"];
		$usuario["apellidos"] = $rs_usuario->fields["apellidos"];

		return $usuario;
	}

	function setLogout() {
		unset($_SESSION['id_usuario']);
	}

	function getUsuario($id_ciudadano) {
		$sql = "select c.*,u.contrasena, u.email_activado from $this->tb_ciudadano c,$this->tb_usuarios u where c.id_ciudadano='$id_ciudadano'
		and c.id_ciudadano=u.id_usuario ";
		$rs_usuario = $this->getConsulta($sql);

		$usuario["id_ciudadano"] = $rs_usuario->fields["id_ciudadano"];
		$usuario["rut_ciudadano"] = $rs_usuario->fields["rut_ciudadano"];
		$usuario["rut_dv"] = $rs_usuario->fields["rut_dv"];
		$usuario["email"] = $rs_usuario->fields["email"];
		$usuario["email_apoderado"] = $rs_usuario->fields["email_apoderado"];
		$usuario["envio_email"] = $rs_usuario->fields["envio_email"];
		$usuario["telefono"] = $rs_usuario->fields["telefono"];
		$usuario["nombre"] = ucwords($rs_usuario->fields["nombre"]);

		//$usuario["apellidos"] = ucwords($rs_usuario->fields["apellidos"]);
		$usuario["apellido_paterno_ciudadano"] = ucwords($rs_usuario->fields["apellido_paterno_ciudadano"]);
		$usuario["apellido_materno_ciudadano"] = ucwords($rs_usuario->fields["apellido_materno_ciudadano"]);
		$usuario["direccion"] = $rs_usuario->fields["direccion"];
		$usuario["localidad"] = $rs_usuario->fields["localidad"];
		$usuario["region"] = $rs_usuario->fields["region"];
		$usuario["comuna"] = $rs_usuario->fields["comuna"];
		$usuario["nombre_apoderado"] = ucwords($rs_usuario->fields["nombre_apoderado"]);
		$usuario["ap_materno_apoderado"] = ucwords($rs_usuario->fields["ap_materno_apoderado"]);
		$usuario["ap_paterno_apoderado"] = ucwords($rs_usuario->fields["ap_paterno_apoderado"]);
		$usuario["direccion_apoderado"] = $rs_usuario->fields["direccion_apoderado"];
		$usuario["localidad_apoderado"] = $rs_usuario->fields["localidad_apoderado"];
		$usuario["region_apoderado"] = $rs_usuario->fields["region_apoderado"];
		$usuario["comuna_apoderado"] = $rs_usuario->fields["comuna_apoderado"];
		$usuario["contrasena"] = $rs_usuario->fields["contrasena"];
		$usuario["razon_social"] = $rs_usuario->fields["razon_social"];
		$usuario["apoderado"] = $rs_usuario->fields["apoderado"];
		$usuario["tipo"] = $rs_usuario->fields["tipo"];
		$usuario["email_activado"] = $rs_usuario->fields["email_activado"];
		$usuario["no_registrado"] = $rs_usuario->fields["no_registrado"];
		return $usuario;
	}

	function getSolicitante($id_solicitante){

		$sql = "SELECT sol.id_solicitante,
		sol.razon_social as razon_social_solicitante,
		sol.nombre as nombre_solicitante,
		sol.apellido_paterno_ciudadano as apellido_paterno_solicitante,
		sol.apellido_materno_ciudadano as apellido_materno_solicitante,
		sol.email_o_postal,
		sol.email as email_solicitante,
		sol.direccion as direccion_solicitante,
		sol.region as region_solicitante,
		sol.comuna as comuna_solicitante,
		sol.localidad as localidad_solicitante,
		sol.tipo as tipo_solicitante,
		sol.apoderado as apoderado_solicitante,
		sol.nombre_apoderado,
		sol.ap_paterno_apoderado,
		sol.ap_materno_apoderado,
		sol.numero_papel,
		sol.fecha_solicitud FROM {$this->tb_trans_solicitante} sol WHERE id_solicitante=".$id_solicitante."";
		$rs = $this->getConsulta($sql);

		$solicitante["id_solicitante"] = $rs->fields["id_solicitante"];
		$solicitante["razon_social_solicitante"] = $rs->fields["razon_social_solicitante"];
		$solicitante["nombre_solicitante"] = $rs->fields["nombre_solicitante"];
		$solicitante["apellido_paterno_solicitante"] = $rs->fields["apellido_paterno_solicitante"];
		$solicitante["apellido_materno_solicitante"] = $rs->fields["apellido_materno_solicitante"];
		$solicitante["email_o_postal"] = $rs->fields["email_o_postal"];
		$solicitante["email_solicitante"] = $rs->fields["email_solicitante"];
		$solicitante["direccion_solicitante"] = $rs->fields["direccion_solicitante"];
		$solicitante["region_solicitante"] = $rs->fields["region_solicitante"];
		$solicitante["comuna_solicitante"] = $rs->fields["comuna_solicitante"];
		$solicitante["localidad_solicitante"] = $rs->fields["localidad_solicitante"];
		$solicitante["tipo_solicitante"] = $rs->fields["tipo_solicitante"];
		$solicitante["apoderado_solicitante"] = $rs->fields["apoderado_solicitante"];
		$solicitante["email_o_postal_apoderado"] = $rs->fields["email_o_postal_apoderado"];
		$solicitante["nombre_apoderado"] = $rs->fields["nombre_apoderado"];
		$solicitante["ap_paterno_apoderado"] = $rs->fields["ap_paterno_apoderado"];
		$solicitante["ap_materno_apoderado"] = $rs->fields["ap_materno_apoderado"];
		$solicitante["numero_papel"] = $rs->fields["numero_papel"];
		$solicitante["fecha_solicitud"] = $rs->fields["fecha_solicitud"];

		return $solicitante;
	}

	function listadoSolicitudesUsuario($_pagina_actual,$id_ciudadano) {

		  $sql = "select * from $this->tb_oirs o,$this->tb_ciudadano c,$this->tb_tipo_oirs t,$this->tb_estados_oirs e
		  where o.id_ciudadano = '$id_ciudadano' and o.id_ciudadano=c.id_ciudadano
		  and o.id_tipo=t.id_tipo and o.id_estado=e.id_estado and o.id_tipo = 5 order by o.fecha desc";

		  $this->max_reg = 6;
		  $rs = $this->getConsulta($sql,true,$_pagina_actual);
		  $consultas = array();

		  while (!$rs->EOF) {
			  $consulta = array();
			  $consulta['id_oirs'] = $rs->fields['id_oirs'];
			  $consulta['fecha'] = $rs->fields['fecha'];
			  $consulta['asunto'] = $rs->fields['asunto'];
			  $consulta['id_tipo_oirs'] = utf8_encode($rs->fields['id_tipo_oirs']);
			  $consulta['tipo'] = utf8_encode($rs->fields['tipo']);
			  $consulta['solicitud_informacion'] = $rs->fields['solicitud_informacion'];
	      $consulta['estado'] = utf8_encode($rs->fields['estado']);
	      $consulta['id_estado'] = $rs->fields['id_estado']	;
			  $consulta['historial'] = $this->getUltimo_historial($rs->fields['id_oirs']);

				if($consulta['historial']['id_estado'] == 'EP') {
					$consulta['fechafinal'] = $rs->fields['fecha_maxima_respuesta'];
				}elseif($consulta['historial']['id_estado'] == 'RE'){
					$consulta['fechafinal'] = $this->fechaValida($oirs['fecha'],_DIAS_RESP);
				}elseif($consulta['historial']['id_estado'] == 'ET'){
					$consulta['fechafinal'] = $rs->fields['fecha_extendido'];
				}elseif($consulta['historial']['id_estado'] == 'EC'){
					$consulta['fechafinal'] = $rs->fields['fecha_modificar'];
				}elseif(($consulta['historial']['id_estado'] == 'DE' || $consulta['historial']['id_estado'] == 'CO') and $rs->fields['fecha_maxima_respuesta'] > $rs->fields['fecha_extendido']) {
					$consulta['fechafinal'] = $rs->fields['fecha_maxima_respuesta'];
				}else {
					$consulta['fechafinal'] = $rs->fields['fecha_extendido']!=null?$rs->fields['fecha_extendido']:"N/D";
				}

				//Días restantes
				if($consulta['id_estado'] == 'EP') {
					$consulta['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$consulta['fechafinal']);
				}elseif ($consulta['id_estado'] == 'RE') {
					$consulta['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$consulta['fechafinal']);
				}elseif ($consulta['id_estado'] == 'ET') {
					$consulta['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$consulta['fechafinal']);
				}
				elseif ($consulta['id_estado'] == 'CO') {
					$consulta['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$consulta['fechafinal']);
				}
				elseif ($consulta['id_estado'] == 'EC') {
					$consulta['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$consulta['fechafinal']);
				}
				elseif ($consulta['id_estado'] == 'DE') {
					$consulta['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$consulta['fechafinal']);
				}

			  $consultas[] = $consulta;
			  $rs->MoveNext();
		  }

		  $datos['tp'] = $consultas;
		  $datos['paginacion'] = $this->getPaginado($rs->atfirstpage(),$rs->absolutepage(),
			  $rs->atlastpage(),$rs->lastpageno());

		  $datos['paginacion']['paginar'] = ($rs->atfirstpage() &&
			  ($rs->lastpageno() == $rs->absolutepage())) ? "false" : "true";

		  return $datos;
	  }

	function getUltimo_historial($id_oirs) {
		$sql = "select h.* from $this->tb_historial h
		where h.id_oirs='$id_oirs'
		order by h.id_historial desc";
		$rs = $this->getConsulta($sql);

		$historial["id_historial"] = $rs->fields["id_historial"];
		$historial["estado"] = $rs->fields["estado"];
		$historial["id_estado"] = $rs->fields["id_estado"];
		$historial["plazo_dias"] = $rs->fields["plazo_dias"];
		$historial["plazo_dias_adicionales"] = $rs->fields["plazo_dias_adicionales"];
		$historial["nota_al_ciudadano"] = $rs->fields["nota_al_ciudadano"];
		$historial["fecha"] = $rs->fields["fecha"];
		$historial["respuesta_del_ciudadano"] = $rs->fields["respuesta_del_ciudadano"];
		return $historial;
	}

	function getUltimaSubsanacion($id_oirs) {
		$sql = "select h.nota_al_ciudadano from $this->tb_historial h
		where h.id_oirs='$id_oirs' and id_estado = 'EC'
		order by h.id_historial desc";
		$rs = $this->getConsulta($sql);

		$historial["nota_al_ciudadano"] = $rs->fields["nota_al_ciudadano"];

		return $historial;
	}

	function getSolicitanteExiste($id_oirs){

		$sql = "SELECT id_solicitante,id_tipo FROM $this->tb_oirs WHERE id_oirs = '$id_oirs'";
		$rs = $this->getConsulta($sql);
		$solicitud_informacion = $this->getTiposOIRSxId($rs->fields["id_tipo"]);
		$datos["id_solicitante"] = $rs->fields["id_solicitante"];
		$datos["existe"] = (!$rs_usuario->EOF) ? true : false;
		$datos["solicitud_informacion"] = $solicitud_informacion["solicitud_informacion"];
		return $datos;
	}


	/*function getDetalle_oirs($id_oirs) {

		$existe_solicitante = $this->getSolicitanteExiste($id_oirs);

		$sql = "select o.*,c.*,t.tipo as tipo_solicitud, t.solicitud_informacion,e.*,
		sol.id_solicitante,
		sol.razon_social as razon_social_solicitante,
		sol.nombre as nombre_solicitante,
		sol.apellido_paterno_ciudadano as apellido_paterno_solicitante,
		sol.apellido_materno_ciudadano as apellido_materno_solicitante,
		sol.email_o_postal,
		sol.email as email_solicitante,
		sol.direccion as direccion_solicitante,
		sol.region as region_solicitante,
		sol.comuna as comuna_solicitante,
		sol.localidad as localidad_solicitante,
		sol.tipo as tipo_solicitante,
		sol.apoderado as apoderado_solicitante,
		sol.nombre_apoderado,
		sol.ap_paterno_apoderado,
		sol.ap_materno_apoderado
		from $this->tb_oirs o,$this->tb_ciudadano c,$this->tb_tipo_oirs t,$this->tb_estados_oirs e, $this->tb_historial, $this->tb_trans_solicitante sol
		where o.id_oirs='$id_oirs'
		and o.id_ciudadano=c.id_ciudadano
		and o.id_tipo=t.id_tipo
		and o.id_estado=e.id_estado";
		if($existe_solicitante["existe"]==1 && $existe_solicitante["id_solicitante"]!=0 && $existe_solicitante["solicitud_informacion"]==1){
		$sql.= " and o.id_solicitante = sol.id_solicitante";
		}
		$rs = $this->getConsulta($sql);

		//Datos ciudadano
		$oirs["id_ciudadano"] = $rs->fields["id_ciudadano"];
		$oirs["nombre"] = ucwords($rs->fields["nombre"]);
		$oirs["apellido_paterno_ciudadano"] = ucwords($rs->fields["apellido_paterno_ciudadano"]);
		$oirs["apellido_materno_ciudadano"] = ucwords($rs->fields["apellido_materno_ciudadano"]);
		$oirs["email"] = $rs->fields["email"];
		$oirs["direccion"] = $rs->fields["direccion"];

		//Datos OIRS - Solicitud
		$oirs["id_oirs"] = $rs->fields["id_oirs"];
		$oirs["asunto"] = $rs->fields["asunto"];
		$oirs["mensaje"] = $rs->fields["mensaje"];
		$oirs["email_oirs"] = $rs->fields["email_oirs"];
		$oirs["direccion_oirs"] = $rs->fields["direccion_oirs"];
		$oirs["localidad_oirs"] = $rs->fields["localidad_oirs"];
		$oirs["region_oirs"] = $this->getRegionxid($rs->fields["region_oirs"]);
		$oirs["comuna_oirs"] = $this->getComunaxid($rs->fields["comuna_oirs"]);

		$oirs["fecha"] = $rs->fields["fecha"];
		$oirs["tipo"] = $rs->fields["tipo_solicitud"];
		$oirs["tipo_persona"] = $rs->fields["tipo"];
		$oirs["solicitud_informacion"] = $rs->fields["solicitud_informacion"];
		$oirs["estado"] = $rs->fields["estado"];
		$oirs["tipo_respuesta"] = $rs->fields["tipo_respuesta"];
		if($rs->fields["estado"] != 'DE'){
			$oirs['historial'] = $this->getUltimo_historial($rs->fields['id_oirs']);
		}

		$oirs['fecha_maxima_respuesta'] = $rs->fields['fecha_maxima_respuesta'];
		$oirs['fecha_extendido'] = $rs->fields['fecha_extendido'];
		$oirs['fecha_modificar'] = $rs->fields['fecha_modificar'];

		if($oirs['historial']['id_estado'] == 'EP') {
			$oirs['fechafinal'] = $rs->fields['fecha_maxima_respuesta'];
		}elseif($oirs['historial']['id_estado'] == 'RE'){
			$oirs['fechafinal'] = $this->fechaValida($oirs['fecha'],_DIAS_RESP);
		}elseif($oirs['historial']['id_estado'] == 'ET'){
			$oirs['fechafinal'] = $rs->fields['fecha_extendido'];
		}elseif($oirs['historial']['id_estado'] == 'CO'){
			$oirs['fechafinal'] = $rs->fields['fecha_modificar'];
		}elseif($oirs['historial']['id_estado'] == 'DE' and $rs->fields['fecha_maxima_respuesta'] > $rs->fields['fecha_extendido']) {
			$oirs['fechafinal'] = $rs->fields['fecha_maxima_respuesta'];
		}else {
			$oirs['fechafinal'] = $rs->fields['fecha_extendido']!=null?$rs->fields['fecha_extendido']:"N/D";
		}

		$oirs["organo_dirigido"] = $this->getDepsCiuNombre($rs->fields["id_organo_ciu"]);

		//Datos solicitante y apoderado

		$oirs["id_solicitante"] = $rs->fields["id_solicitante"];
		$oirs["razon_social_solicitante"] = $rs->fields["razon_social_solicitante"];
		$oirs["nombre_solicitante"] = $rs->fields["nombre_solicitante"];
		$oirs["apellido_paterno_solicitante"] = $rs->fields["apellido_paterno_solicitante"];
		$oirs["apellido_materno_solicitante"] = $rs->fields["apellido_materno_solicitante"];
		$oirs["email_o_postal"] = $rs->fields["email_o_postal"];
		$oirs["email_solicitante"] = $rs->fields["email_solicitante"];
		$oirs["direccion_solicitante"] = $rs->fields["direccion_solicitante"];
		$oirs["region_solicitante"] = $rs->fields["region_solicitante"];
		$oirs["comuna_solicitante"] = $rs->fields["comuna_solicitante"];
		$oirs["localidad_solicitante"] = $rs->fields["localidad_solicitante"];
		$oirs["tipo_solicitante"] = $rs->fields["tipo_solicitante"];
		$oirs["apoderado_solicitante"] = $rs->fields["apoderado_solicitante"];
		$oirs["email_o_postal_apoderado"] = $rs->fields["email_o_postal_apoderado"];
		$oirs["nombre_apoderado"] = $rs->fields["nombre_apoderado"];
		$oirs["ap_paterno_apoderado"] = $rs->fields["ap_paterno_apoderado"];
		$oirs["ap_materno_apoderado"] = $rs->fields["ap_materno_apoderado"];


		return $oirs;
	}*/


	function getDetalle_oirs($id_oirs) {

		$existe_solicitante = $this->getSolicitanteExiste($id_oirs);

		$sql = "select o.*,c.*,t.tipo as tipo_solicitud, t.solicitud_informacion,e.*
		from $this->tb_oirs o
		inner join $this->tb_ciudadano c on o.id_ciudadano=c.id_ciudadano
		inner join $this->tb_tipo_oirs t on o.id_tipo=t.id_tipo
		inner join $this->tb_estados_oirs e on o.id_estado=e.id_estado
		";

		$sql .= "where o.id_oirs={$id_oirs}";

		$rs = $this->getConsulta($sql);

		//Datos ciudadano
		$oirs["id_ciudadano"] = $rs->fields["id_ciudadano"];
		$oirs["nombre"] = ucwords($rs->fields["nombre"]);
		$oirs["apellido_paterno_ciudadano"] = ucwords($rs->fields["apellido_paterno_ciudadano"]);
		$oirs["apellido_materno_ciudadano"] = ucwords($rs->fields["apellido_materno_ciudadano"]);
		$oirs["email"] = $rs->fields["email"];
		$oirs["direccion"] = $rs->fields["direccion"];

		//Datos OIRS - Solicitud
		$oirs["id_oirs"] = $rs->fields["id_oirs"];
		$oirs["asunto"] = $rs->fields["asunto"];
		$oirs["mensaje"] = $rs->fields["mensaje"];
		$oirs["observaciones"] = $rs->fields["observaciones"];
		$oirs["email_oirs"] = $rs->fields["email_oirs"];
		$oirs["direccion_oirs"] = utf8_encode($rs->fields["direccion_oirs"]);
		$oirs["localidad_oirs"] = utf8_encode($rs->fields["localidad_oirs"]);
		$oirs["region_oirs"] = utf8_encode($this->getRegionxid($rs->fields["region_oirs"]));
		$oirs["comuna_oirs"] = utf8_encode($this->getComunaxid($rs->fields["comuna_oirs"]));

		$oirs["fecha"] = $rs->fields["fecha"];
		$oirs["tipo"] = utf8_encode($rs->fields["tipo_solicitud"]);
		$oirs["tipo_persona"] = utf8_encode($rs->fields["tipo"]);
		$oirs["solicitud_informacion"] = utf8_encode($rs->fields["solicitud_informacion"]);
		$oirs["estado"] = utf8_encode($rs->fields["estado"]);
		
		$oirs["tipo_respuesta"] = $rs->fields["tipo_respuesta"];
		if($rs->fields["estado"] != 'DE'){
			$oirs['historial'] = $this->getUltimo_historial($rs->fields['id_oirs']);
		}

		$oirs['fecha_maxima_respuesta'] = $rs->fields['fecha_maxima_respuesta'];
		$oirs['fecha_extendido'] = $rs->fields['fecha_extendido'];
		$oirs['fecha_modificar'] = $rs->fields['fecha_modificar'];

		if($oirs['historial']['id_estado'] == 'EP') {
			$oirs['fechafinal'] = $rs->fields['fecha_maxima_respuesta'];
		}elseif($oirs['historial']['id_estado'] == 'RE'){
			$oirs['fechafinal'] = $this->fechaValida($oirs['fecha'],_DIAS_RESP);
		}elseif($oirs['historial']['id_estado'] == 'ET'){
			$oirs['fechafinal'] = $rs->fields['fecha_extendido'];
		}elseif($oirs['historial']['id_estado'] == 'EC'){
			$oirs['fechafinal'] = $rs->fields['fecha_modificar'];
		}elseif(($oirs['historial']['id_estado'] == 'DE' || $oirs['historial']['id_estado'] == 'CO') and $rs->fields['fecha_maxima_respuesta'] > $rs->fields['fecha_extendido']) {
			$oirs['fechafinal'] = $rs->fields['fecha_maxima_respuesta'];
		}else {
			$oirs['fechafinal'] = $rs->fields['fecha_extendido']!=null?$rs->fields['fecha_extendido']:"N/D";
		}

		//Días restantes
		if($oirs['id_estado'] == 'EP') {
			$oirs['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$oirs['fechafinal']);
		}elseif ($oirs['id_estado'] == 'RE') {
			$oirs['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$oirs['fechafinal']);
		}elseif ($oirs['id_estado'] == 'ET') {
			$oirs['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$oirs['fechafinal']);
		}
		elseif ($oirs['id_estado'] == 'CO') {
			$oirs['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$oirs['fechafinal']);
		}
		elseif ($oirs['id_estado'] == 'EC') {
			$oirs['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$oirs['fechafinal']);
		}
		elseif ($oirs['id_estado'] == 'DE') {
			$oirs['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$oirs['fechafinal']);
		}

		$oirs["organo_dirigido"] = utf8_encode($this->getDepsCiuNombre($rs->fields["id_organo_ciu"]));

		//Datos solicitante y apoderado

		$oirs["id_solicitante"] = $rs->fields["id_solicitante"];
		$oirs["razon_social_solicitante"] = $rs->fields["razon_social_solicitante"];
		$oirs["nombre_solicitante"] = $rs->fields["nombre_solicitante"];
		$oirs["apellido_paterno_solicitante"] = $rs->fields["apellido_paterno_solicitante"];
		$oirs["apellido_materno_solicitante"] = $rs->fields["apellido_materno_solicitante"];
		$oirs["email_o_postal"] = $rs->fields["email_o_postal"];
		$oirs["email_solicitante"] = $rs->fields["email_solicitante"];
		$oirs["direccion_solicitante"] = $rs->fields["direccion_solicitante"];
		$oirs["region_solicitante"] = $rs->fields["region_solicitante"];
		$oirs["comuna_solicitante"] = $rs->fields["comuna_solicitante"];
		$oirs["localidad_solicitante"] = $rs->fields["localidad_solicitante"];
		$oirs["tipo_solicitante"] = $rs->fields["tipo_solicitante"];
		$oirs["apoderado_solicitante"] = $rs->fields["apoderado_solicitante"];
		$oirs["email_o_postal_apoderado"] = $rs->fields["email_o_postal_apoderado"];
		$oirs["nombre_apoderado"] = $rs->fields["nombre_apoderado"];
		$oirs["ap_paterno_apoderado"] = $rs->fields["ap_paterno_apoderado"];
		$oirs["ap_materno_apoderado"] = $rs->fields["ap_materno_apoderado"];
		
		array_walk_recursive($oirs, function (&$value) {
			            //Elimina el caracter BOM si lo tiene.
			            $value = UTF8::remove_bom($value);
			            //Convierte a iso-8859-1 si detecta utf-8, si no no realiza cambios.
			            if (UTF8::str_detect_encoding($value) == 'UTF-8'){
			                $value = UTF8::utf8_encode($value);
			            } else {
			                $value = UTF8::utf8_decode($value);
			            }
			        });

		return $oirs;
	}

	function getSolicitanteExisteCode($code){

		$sql = "SELECT id_solicitante,id_tipo FROM $this->tb_oirs WHERE cod_solicitud = '$code'";
		$rs = $this->getConsulta($sql);
		$datos["id_solicitante"] = $rs->fields["id_solicitante"];
		$datos["id_tipo"] = $rs->fields["id_tipo"];
		$datos["existe"] = (!$rs_usuario->EOF) ? true : false;
		$solicitud_informacion = $this->getTiposOIRSxId( $rs->fields["id_tipo"]);
		$datos["solicitud_informacion"] = $solicitud_informacion["solicitud_informacion"];
		return $datos;
	}

	function getDetalleOirsCode($code) {

		$existe_solicitante = $this->getSolicitanteExisteCode($code);

		$sql = "select o.*,c.*,t.tipo as tipo_solicitud, t.solicitud_informacion,e.*,
		sol.id_solicitante,
		sol.razon_social as razon_social_solicitante,
		sol.nombre as nombre_solicitante,
		sol.apellido_paterno_ciudadano as apellido_paterno_solicitante,
		sol.apellido_materno_ciudadano as apellido_materno_solicitante,
		sol.email_o_postal,
		sol.email as email_solicitante,
		sol.direccion as direccion_solicitante,
		sol.region as region_solicitante,
		sol.comuna as comuna_solicitante,
		sol.localidad as localidad_solicitante,
		sol.tipo as tipo_solicitante,
		sol.apoderado as apoderado_solicitante,
		sol.nombre_apoderado,
		sol.ap_paterno_apoderado,
		sol.ap_materno_apoderado
		from $this->tb_oirs o,$this->tb_ciudadano c,$this->tb_tipo_oirs t,$this->tb_estados_oirs e, $this->tb_historial, $this->tb_trans_solicitante sol
		where (o.cod_solicitud='$code' OR o.subsanar_no_registro='$code')
		and o.id_ciudadano=c.id_ciudadano
		and o.id_tipo=t.id_tipo
		and o.id_estado=e.id_estado";
		if($existe_solicitante["existe"]==1 && $existe_solicitante["id_solicitante"]!=0 && $existe_solicitante["solicitud_informacion"]==1){
		$sql.= " and o.id_solicitante = sol.id_solicitante";
		}
		$rs = $this->getConsulta($sql);

		if ($rs->EOF){
			$oirs["existe"]=false;
		} else {
			$oirs["existe"]=true;
		}

		//Datos ciudadano
		$oirs["id_ciudadano"] = $rs->fields["id_ciudadano"];
		$oirs["nombre"] = ucwords($rs->fields["nombre"]);
		$oirs["apellido_paterno_ciudadano"] = ucwords($rs->fields["apellido_paterno_ciudadano"]);
		$oirs["apellido_materno_ciudadano"] = ucwords($rs->fields["apellido_materno_ciudadano"]);
		$oirs["email"] = $rs->fields["email"];
		$oirs["direccion"] = $rs->fields["direccion"];
		$oirs["no_registrado"] = $rs->fields["no_registrado"] == 1 ? TRUE : FALSE;

		//Datos OIRS - Solicitud
		$oirs["id_oirs"] = $rs->fields["id_oirs"];
		$oirs["subsanar_no_registro"] = $rs->fields["subsanar_no_registro"];
		$oirs["asunto"] = $rs->fields["asunto"];
		$oirs["mensaje"] = $rs->fields["mensaje"];
		$oirs["cod_solicitud"] = $rs->fields["cod_solicitud"];
		$oirs["observaciones"] = $rs->fields["observaciones"];
		$oirs["direccion_oirs"] = $rs->fields["direccion_oirs"];
		$oirs["localidad_oirs"] = $rs->fields["localidad_oirs"];
		$oirs["region_oirs"] = $this->getRegionxid($rs->fields["region_oirs"]);
		$oirs["comuna_oirs"] = $this->getComunaxid($rs->fields["comuna_oirs"]);
		$oirs["email_oirs"] = $rs->fields["email_oirs"];

		$oirs["fecha"] = $rs->fields["fecha"];
		$oirs["tipo"] = utf8_encode($rs->fields["tipo_solicitud"]);
		$oirs["tipo_persona"] = utf8_encode($rs->fields["tipo"]);
		$oirs["solicitud_informacion"] = utf8_encode($rs->fields["solicitud_informacion"]);
		$oirs["estado"] = utf8_encode($rs->fields["estado"]);
		$oirs["id_estado"] = $rs->fields["id_estado"];
		$oirs["tipo_respuesta"] = $rs->fields["tipo_respuesta"];
		if($rs->fields["estado"] != 'DE'){
			$oirs['historial'] = $this->getUltimo_historial($rs->fields['id_oirs']);
		}

		$oirs['fecha_maxima_respuesta'] = $rs->fields['fecha_maxima_respuesta'];
		$oirs['fecha_extendido'] = $rs->fields['fecha_extendido'];
		$oirs['fecha_modificar'] = $rs->fields['fecha_modificar'];

		if($oirs['historial']['id_estado'] == 'EP') {
			$oirs['fechafinal'] = $rs->fields['fecha_maxima_respuesta'];
		}elseif($oirs['historial']['id_estado'] == 'RE'){
			$oirs['fechafinal'] = $this->fechaValida($oirs['fecha'],_DIAS_RESP);
		}elseif($oirs['historial']['id_estado'] == 'ET'){
			$oirs['fechafinal'] = $rs->fields['fecha_extendido'];
		}elseif($oirs['historial']['id_estado'] == 'CO'){
			$oirs['fechafinal'] = $rs->fields['fecha_modificar'];
		}elseif($oirs['historial']['id_estado'] == 'DE' and $rs->fields['fecha_maxima_respuesta'] > $rs->fields['fecha_extendido']) {
			$oirs['fechafinal'] = $rs->fields['fecha_maxima_respuesta'];
		}else {
			$oirs['fechafinal'] = $rs->fields['fecha_extendido']!=null?$rs->fields['fecha_extendido']:"N/D";
		}

		$oirs["organo_dirigido"] = $this->getDepsCiuNombre($rs->fields["id_organo_ciu"]);

		//Datos solicitante y apoderado

		$oirs["id_solicitante"] = $rs->fields["id_solicitante"];
		$oirs["razon_social_solicitante"] = $rs->fields["razon_social_solicitante"];
		$oirs["nombre_solicitante"] = $rs->fields["nombre_solicitante"];
		$oirs["apellido_paterno_solicitante"] = $rs->fields["apellido_paterno_solicitante"];
		$oirs["apellido_materno_solicitante"] = $rs->fields["apellido_materno_solicitante"];
		$oirs["email_o_postal"] = $rs->fields["email_o_postal"];
		$oirs["email_solicitante"] = $rs->fields["email_solicitante"];
		$oirs["direccion_solicitante"] = $rs->fields["direccion_solicitante"];
		$oirs["region_solicitante"] = $rs->fields["region_solicitante"];
		$oirs["comuna_solicitante"] = $rs->fields["comuna_solicitante"];
		$oirs["localidad_solicitante"] = $rs->fields["localidad_solicitante"];
		$oirs["tipo_solicitante"] = $rs->fields["tipo_solicitante"];
		$oirs["apoderado_solicitante"] = $rs->fields["apoderado_solicitante"];
		$oirs["email_o_postal_apoderado"] = $rs->fields["email_o_postal_apoderado"];
		$oirs["nombre_apoderado"] = $rs->fields["nombre_apoderado"];
		$oirs["ap_paterno_apoderado"] = $rs->fields["ap_paterno_apoderado"];
		$oirs["ap_materno_apoderado"] = $rs->fields["ap_materno_apoderado"];


		return $oirs;
	}


	// function getDetalleOirsCode($code) {

	// 	$sql = "select o.*,c.*,t.tipo as tipo_solicitud, t.solicitud_informacion,e.*
	// 	from $this->tb_oirs o,$this->tb_ciudadano c,$this->tb_tipo_oirs t,$this->tb_estados_oirs e, $this->tb_historial
	// 	where o.cod_solicitud='$code' and o.id_ciudadano=c.id_ciudadano and o.id_tipo=t.id_tipo and o.id_estado=e.id_estado";
	// 	$rs = $this->getConsulta($sql);

	// 	$oirs["id_ciudadano"] = $rs->fields["id_ciudadano"];
	// 	$oirs["rut_ciudadano"] = $rs->fields["rut_ciudadano"];
	// 	$oirs["rut_dv"] = $rs->fields["rut_dv"];
	// 	$oirs["razon_social"] = ucwords($rs->fields["razon_social"]);
	// 	$oirs["nombre"] = ucwords($rs->fields["nombre"]);
	// 	$oirs["apellido_paterno_ciudadano"] = ucwords($rs->fields["apellido_paterno_ciudadano"]);
	// 	$oirs["apellido_materno_ciudadano"] = ucwords($rs->fields["apellido_materno_ciudadano"]);
	// 	$oirs["email_o_postal"] = $rs->fields["email_o_postal"];
	// 	$oirs["email"] = $rs->fields["email"];
	// 	$oirs["direccion"] = $rs->fields["direccion"];
	// 	$oirs["id_oirs"] = $rs->fields["id_oirs"];
	// 	$oirs["asunto"] = $rs->fields["asunto"];
	// 	$oirs["mensaje"] = $rs->fields["mensaje"];
	// 	/* nuevos datos oirs */
	// 	$oirs["email_oirs"] = $rs->fields["email_oirs"];
	// 	$oirs["direccion_oirs"] = $rs->fields["direccion_oirs"];
	// 	$oirs["localidad_oirs"] = $rs->fields["localidad_oirs"];
	// 	$oirs["region_oirs"] = $this->getRegionxid($rs->fields["region_oirs"]);
	// 	$oirs["comuna_oirs"] = $this->getComunaxid($rs->fields["comuna_oirs"]);
	// 	/**********************/
	// 	$oirs["fecha"] = $rs->fields["fecha"];
	// 	$oirs["tipo"] = $rs->fields["tipo_solicitud"];
	// 	$oirs["tipo_persona"] = $rs->fields["tipo"];
	// 	$oirs["solicitud_informacion"] = $rs->fields["solicitud_informacion"];
	// 	$oirs["estado"] = $rs->fields["estado"];
	// 	$oirs["tipo_respuesta"] = $rs->fields["tipo_respuesta"];
	// 	if($rs->fields["estado"] != 'DE'){
	// 		$oirs['historial'] = $this->getUltimo_historial($rs->fields['id_oirs']);
	// 		//print_r($oirs['historial']);
	// 		//die();
	// 	}
	// 	//$oirs["persona_juridica"] = $this->getPersona_juridica($rs->fields['rut_persona_juridica']);
	// 	$oirs['fecha_maxima_respuesta'] = $rs->fields['fecha_maxima_respuesta'];
	// 	$oirs['fecha_extendido'] = $rs->fields['fecha_extendido'];
	// 	$oirs['fecha_modificar'] = $rs->fields['fecha_modificar'];

	// 	if($oirs['historial']['id_estado'] == 'EP') {
	// 		$oirs['fechafinal'] = $rs->fields['fecha_maxima_respuesta'];
	// 	}elseif($oirs['historial']['id_estado'] == 'RE'){
	// 		$oirs['fechafinal'] = $this->fechaValida($oirs['fecha'],_DIAS_RESP);
	// 	}elseif($oirs['historial']['id_estado'] == 'ET'){
	// 		$oirs['fechafinal'] = $rs->fields['fecha_extendido'];
	// 	}elseif($oirs['historial']['id_estado'] == 'CO'){
	// 		$oirs['fechafinal'] = $rs->fields['fecha_modificar'];
	// 	}elseif($oirs['historial']['id_estado'] == 'DE' and $rs->fields['fecha_maxima_respuesta'] > $rs->fields['fecha_extendido']) {
	// 		$oirs['fechafinal'] = $rs->fields['fecha_maxima_respuesta'];
	// 	}else {
	// 		$oirs['fechafinal'] = $rs->fields['fecha_extendido']!=null?$rs->fields['fecha_extendido']:"N/D";
	// 	}

	// 	$oirs["organo_dirigido"] = $this->getDepsCiuNombre($rs->fields["id_organo_ciu"]);
	// 	/*
	// 	Datos apoderado
	// 	*/
	// 	$oirs["apoderado"] = $rs->fields["apoderado"];
	// 	$oirs["email_o_postal_apoderado"] = $rs->fields["email_o_postal_apoderado"];
	// 	$oirs["nombre_apoderado"] = $rs->fields["nombre_apoderado"];
	// 	$oirs["ap_paterno_apoderado"] = $rs->fields["ap_paterno_apoderado"];
	// 	$oirs["ap_materno_apoderado"] = $rs->fields["ap_materno_apoderado"];
	// 	$oirs["email_apoderado"] = $rs->fields["email_apoderado"];
	// 	$oirs["direccion_apoderado"] = $rs->fields["direccion_apoderado"];
	// 	$oirs["localidad"] = $rs->fields["localidad"];
	// 	$oirs["region_apoderado"] = $this->getRegionxid($rs->fields["region_apoderado"]);
	// 	$oirs["comuna_apoderado"] = $this->getComunaxid($rs->fields["comuna_apoderado"]);


	// 	return $oirs;
	// }

	function getPersona_juridica($rut_persona_juridica) {
		$sql = "select p.*,cp.* from $this->tb_persona p,$this->tb_ciudadano_persona cp,$this->tb_ciudadano c
		where p.rut_persona_juridica='$rut_persona_juridica' and p.rut_persona_juridica=cp.rut_persona_juridica
		and cp.id_ciudadano=c.id_ciudadano";
		$rs = $this->getConsulta($sql);

		$persona["nombre_persona"] = ucwords($rs->fields["nombre"]);
		$persona["cargo"] = $rs->fields["cargo"];
		$persona["representante_legal"] = $rs->fields["representante_legal"];
		$persona["direccion"] = $rs->fields["direccion"];
		return $persona;
	}

	function getOirsxestado($id_ciudadano,$id_estado){

		$sql = "select * from $this->tb_oirs o,$this->tb_ciudadano c,$this->tb_estados_oirs e
			where o.id_ciudadano='$id_ciudadano' and o.id_estado='$id_estado' and o.id_estado=e.id_estado
			and o.id_ciudadano=c.id_ciudadano order by o.id_oirs";
		$rs = $this->getConsulta($sql);
		$consultas = array();

		while (!$rs->EOF) {
			$consulta = array();
			$consulta['id_oirs'] = $rs->fields['id_oirs'];
			$consulta['fecha'] = $rs->fields['fecha'];
			$consulta['id_estado'] = $rs->fields['id_estado'];
			$consultas[] = $consulta;
			$rs->MoveNext();
		}

		return $consultas;

	}

	function getAdjuntos($id_oirs) {
		//$rs = $this->getConsulta("select * from {$this->tb_trans_adjunto} where id_oirs = {$id_oirs} and publico = 1");
        $rs = $this->getConsulta("SELECT adj.* , DATE_FORMAT(date( his.fecha ),'%d/%m/%Y') AS fecha FROM {$this->tb_trans_adjunto} adj
                                    JOIN $this->tb_historial his
                                    ON adj.id_historial = his.id_historial
                                    WHERE adj.id_oirs = {$id_oirs} AND adj.publico=1
                                    ORDER BY his.fecha DESC");
                                    
		$adjuntos = array();
		while (!$rs->EOF) {
			array_push($adjuntos,$rs->fields);
			$rs->MoveNext();
		}
		return $adjuntos;
	}

	function getAdjunto($id_adjunto,$id_oirs) {
		$rs = $this->getConsulta("select * from {$this->tb_trans_adjunto} where id_adjunto={$id_adjunto} and id_oirs={$id_oirs}");
		return $rs->fields;
	}

	function getDepsOIRSCiu() {
		$sql = "select o.id_organo, o.nombre from {$this->tb_organo} o
				inner join trans_funcionario f on o.id_funcionario = f.id_funcionario
				where o.id_organo <> 1 order by o.id_organo asc";
		$rs = $this->getConsulta($sql);
		$estados = array();
		while (!$rs->EOF) {
			$estados[$rs->fields['id_organo']] = utf8_encode($rs->fields['nombre']);
			$rs->MoveNext();
		}
		return $estados;
		
	}

	function getDepsCiuNombre($id_dep){
			$sql = "SELECT * FROM {$this->tb_organo} WHERE id_organo = '".$id_dep."'";
			$rs = $this->getConsulta($sql);
			return utf8_encode($rs->fields["nombre"]);
		}

		function codigoActivacion(){
			$code = sha1(mt_rand().time().mt_rand().$_SERVER['REMOTE_ADDR']);
			return $code;
		}

		function getUsuarioOirsCiu($_code) {
			$usuario = array();

			#usuario
			$sql = "select * from {$this->tb_usuarios} where codigo_activacion='$_code'";
			//print_r($sql);
			//die();

			$rs_usuario = $this->getConsulta($sql);

			$usuario["id_usuario"] = $rs_usuario->fields["id_usuario"];
			$usuario["tipo"] = $rs_usuario->fields["tipo"];
			$usuario["codigo_activacion"] = $rs_usuario->fields["codigo_activacion"];
			$usuario["activo"] = $rs_usuario->fields["activo"];

			if ($rs_usuario->EOF){
				$usuario["existe"]=false;
			} else {
				$usuario["existe"]=true;
			}
			return $usuario;
		}

		function activarUsuario($_code){

				$this->setTransaccion('start');
				$sql = "UPDATE {$this->tb_usuarios} SET email_activado=1 WHERE codigo_activacion='$_code'";
				//print_r($sql);
			//die();
				$this->db->Execute($sql);
				return $this->setTransaccion('end');

			}

		function getUsuarioOirsCiuID($_id_usuario) {
			#usuario
			$sql = "select tu.email_activado,tc.no_registrado from {$this->tb_usuarios} tu
			left join {$this->tb_ciudadano} tc
			on tu.id_usuario = tc.id_ciudadano
			where tc.id_ciudadano='$_id_usuario'";
			//print_r($sql);
			//die();
			$rs_usuario = $this->getConsulta($sql);
			return $rs_usuario->fields;
		}

		function getUsuarioOirsCiuEmail($_email) {

			$sql = "select tu.email_activado from {$this->tb_usuarios} tu
			left join {$this->tb_ciudadano} tc
			on tu.id_usuario = tc.id_ciudadano
			where tc.email='$_email'";

			$rs_usuario = $this->getConsulta($sql);
			return $rs_usuario->fields["email_activado"];
		}

		function getDatosCiudadano($_email) {
			#usuario
			$usuarios = array();
			$sql = "select * from {$this->tb_usuarios} tu
			left join {$this->tb_ciudadano} tc
			on tu.id_usuario = tc.id_ciudadano
			where tc.email='$_email'";
			$rs_usuario = $this->getConsulta($sql);
			$usuarios = $rs_usuario->fields;
			return $usuarios;
		}

		function getDatosCiudadanoRegistrado($_email) {
			#usuario
			$usuarios = array();
			$sql = "select * from {$this->tb_usuarios} tu
			left join {$this->tb_ciudadano} tc
			on tu.id_usuario = tc.id_ciudadano
			where tc.email='$_email' AND no_registrado = 0 AND caduca IS NOT NULL AND (email_activado = 0 AND caduca > CONCAT_WS(' ',CURDATE(),CURTIME()) OR email_activado = 1)";
			$rs_usuario = $this->getConsulta($sql);
			$usuarios = $rs_usuario->fields;
			$usuarios['existe'] = !$rs_usuario->EOF ? true : false;
			return $usuarios;
		}

			function getUsuarioOirsCiuActivoID($_id) {
			#usuario
			$sql = "select tu.email_activado from {$this->tb_usuarios} tu
			left join {$this->tb_ciudadano} tc
			on tu.id_usuario = tc.id_ciudadano
			where tu.id_usuario='$_id'";
			//print_r($sql);
			//die();
			$rs_usuario = $this->getConsulta($sql);
			return $rs_usuario->fields["activo"];
		}

		function fechaValida($desde, $dias){
			$desde = $this->fechaAMD($desde);
         $feriados = $this->getFeriados_Actuales($desde);

		   //separo la fecha en dia mes y año
            $dia = date('d', strtotime($desde));
            $mes = date('m', strtotime($desde));
            $ano = date('Y', strtotime($desde));

            $mkDesde    = mktime(0,0,0,$mes,$dia,$ano);
            $sumar = $dias;
            $i=1;
            while($i < $sumar){
                $mkDia = mktime(0, 0, 0, $mes, $dia + $i, $ano);

                $resultado = date('Y/m/d', $mkDia);
                if(!$this->esHabil($resultado, $feriados)){
                    $sumar += 1;
                }
                $i++;
            }

            $mkFecha = mktime(0,0,0,$mes, $dia + $sumar, $ano);
            $resultado = date('Y/m/d', $mkFecha);

            if($this->esHabil($resultado, $feriados)){
                $fecha = date('Y/m/d', $mkFecha);
                return $fecha;
            }else{
                return $this->fechaValida($resultado, 1);
            }
        }

        function fechaAMD($fecha, $union = "/"){
            if(strpos($fecha, "-")){
                $datos = split("-", $fecha);
                if(strlen($datos[2]) == 4){
                    $fecha = $datos[2].$union.$datos[1].$union.$datos[0];
                }else{
                    $fecha = $datos[0].$union.$datos[1].$union.$datos[2];
                }
            }else if(strpos($fecha, "/")){
                $datos = split("/", $fecha);
                if(strlen($datos[2]) == 4){
                    $fecha = $datos[2].$union.$datos[1].$union.$datos[0];
                }else{
                    $fecha = $datos[0].$union.$datos[1].$union.$datos[2];
                }
            }

            return $fecha;
        }

function getFeriados_Actuales($fecha) {
            $sql = "select fecha from ".$this->tb_feriados." where fecha >= '$fecha' order by fecha asc";
            $rs = $this->getConsulta($sql);
            $feriados = array();

            while (!$rs->EOF) {
                $fecha = $this->fechaAMD($rs->fields["fecha"]);
                $feriados[$fecha] = $fecha;
                $rs->MoveNext();
            }

            return $feriados;
        }

      function esHabil($fecha, $feriados){
            //separo la fecha en dia mes y año
            $dia = date('d', strtotime($fecha));
            $mes = date('m', strtotime($fecha));
            $ano = date('Y', strtotime($fecha));

            //calculo el timestamp de la fechainicial
            $mkFecha = mktime(0, 0, 0, $mes, $dia, $ano);

            $esHabil = true;

            //realizo la correccion correspondiente por el fin de semana
            switch (date('w', $mkFecha)) {
                case 1: //Lunes
                case 2: //Martes
                case 3: //Miercoles
                case 4: //Jueves
                case 5: //Viernes
                    $esHabil = true;
                    break;
                case 6: //Sabado
                case 0: //Domingo
                    $esHabil = false;
                    break;
            }

            if($esHabil){
                if(array_key_exists($fecha, $feriados)){
                    return false;
                }else{
                    return true;
                }
            }else{
                return false;
            }
        }

    function eCaptcha($public_key){
		return recaptcha_get_html($public_key);
	}

	function eCaptchaValid($private_key,$recaptcha_challenge_field,$recaptcha_response_field){
			$resp = recaptcha_check_answer($private_key,
                                $_SERVER["REMOTE_ADDR"],
                                $recaptcha_challenge_field,
                                $recaptcha_response_field);
         return $resp;
	}

	function existeCodigo($code){
		$sql = "SELECT cod_solicitud FROM $this->tb_oirs WHERE cod_solicitud = '$code'";
		$rs = $this->getConsulta($sql);
		if($rs->EOF){
			$existe = false;
		}else{
			$existe = true;
		}
		return $existe;
	}

	function getRegion(){

		$sql = "SELECT codigo,nombre FROM $this->tb_trans_regiones WHERE activo = '1'
		 ORDER BY codigo asc";
		$rs = $this->getConsulta($sql);
		$regiones = array();
		while(!$rs->EOF){
			$dato["codigo"] = $rs->fields["codigo"];
						
			$dato["nombre"] = $rs->fields["nombre"];
			$regiones[] = $dato;
			$rs->MoveNext();
		}
		
		
        
		
		return $regiones;
	}

	function getComuna($id_padre){

		$sql = "SELECT codigo_comuna,nombre FROM $this->tb_trans_comunas WHERE padre = $id_padre
		ORDER BY nombre";
		$rs = $this->getConsulta($sql);
		$datos = array();
		$datos[""] = "";

		while (!$rs->EOF) {
			$datos[$rs->fields["codigo_comuna"]] = $rs->fields["nombre"];
			$rs->MoveNext();
		}

		return $datos;
	}

	function getRegionxid($id_region){

		$sql = "SELECT nombre FROM $this->tb_trans_regiones WHERE codigo='$id_region'";
		$rs = $this->getConsulta($sql);
		return utf8_encode($rs->fields["nombre"]);
	}

	function getComunaxid($id_comuna){

		$sql = "SELECT nombre FROM $this->tb_trans_comunas WHERE codigo_comuna = '$id_comuna'";
		$rs = $this->getConsulta($sql);
		return $rs->fields["nombre"];
	}

	function actualizarEnvioNotificaciones($id_ciudadano){
		$this->setTransaccion('start');
		$sql = "UPDATE {$this->tb_ciudadano} SET envio_email=1 WHERE id_ciudadano='$id_ciudadano'";
		$this->db->Execute($sql);
		return $this->setTransaccion('end');
	}

	function get_configuration(){
		$sql = "SELECT * FROM {$this->tb_trans_configuration}";
		$rs = $this->getConsulta($sql);
		$datos = array();
		while(!$rs->EOF){
			$datos["company_name"] = $rs->fields["company_name"];
			$datos["address"] = $rs->fields["address"];
			$datos["phone"] = $rs->fields["phone"];
			$rs->MoveNext();
		}
		return $datos;
	}

	function AgregarAdjunto($cmps) {
		$continuar = true;
		$sql = "select * from {$this->tb_trans_adjunto} where id_adjunto=-1";
		$continuar = $this->setGuardar($sql,$cmps);
	}

	function getIDHistorial() {
		$rs = mysql_query("SELECT max(id_historial) AS id FROM {$this->tb_historial}");
		if ($row = mysql_fetch_row($rs)) {
		$id = trim($row[0]);
		}
		return $id;
	}

	function decodificarJSON($url_json){
		$archivo_json = file_get_contents($url_json);
		$json_decodificado = json_decode($archivo_json,true);
		return $json_decodificado;
	}

	function DiasRestantes($desde, $hasta){

		$vencido = false;

		if(strtotime($desde) >= strtotime($hasta)) {
			$vencido = true;
			$desded = $desde;
			$desde = $hasta;
			$hasta = $desded;
		}

		$desde = $this->fechaAMD($desde);
		$feriados = $this->getFeriados_Actuales($desde);

		//separo la fecha en dia mes y año
		$dia = date('d', strtotime($desde));
		$mes = date('m', strtotime($desde));
		$ano = date('Y', strtotime($desde));

		$mkDesde    = mktime(0,0,0,$mes,$dia,$ano);
		$i = 1;
		$sumar = 0;
		$llega=false;

		if(strtotime($desde) != strtotime($hasta)) {
			while(!$llega){
				$mkDia = mktime(0, 0, 0, $mes, $dia + $i, $ano);

				$resultado = date('Y/m/d', $mkDia);
				if($this->esHabil($resultado, $feriados)){
					$sumar += 1;
				}

				$diah = date('d', strtotime($hasta));
				$mesh = date('m', strtotime($hasta));
				$anoh = date('Y', strtotime($hasta));

				$mkHasta    = mktime(0,0,0,$mesh,$diah,$anoh);

				$resultadoHasta = date('Y/m/d', $mkHasta);

				if($resultado >= $resultadoHasta){
					$llega = true;
				}
				$i++;
			}
		}
		if($vencido) {
			$sumar = $sumar*-1;
		}

		return $sumar;
	}
}
?>
