<?php
// Portable UTF-8
use voku\helper\UTF8;
class Galeria_Modelo extends Modelo {

	var $tb;
	var $tb_imagenes;
	var $tb_img_articulos;

	function Galeria_Modelo() {
		parent::Modelo();
		$this->tb = 'galeria';
		$this->tb_imagenes = 'imagenes';		
		$this->tb_img_articulos = 'img_articulos';	
	
	}

	function getImagenes($_id_galeria,$_mn=true) {
		$dir = opendir(_PATH_IMAGENES);
		while ($img_tmp = readdir($dir)) {
			if ($img_tmp != '.' && $img_tmp != '..') $imgs[] = $img_tmp;
		}
		closedir($dir);

		$lrg_imgs = count($imgs);

		for ($x=0;$x<$lrg_imgs;$x++) {
			$a_img = explode("_",$imgs[$x]);
			if ($_mn) {
				if ($a_img[0] == $_id_galeria && $a_img[1] == 'mn') $ls_imagenes[] = $imgs[$x];
			} else {
				if ($a_img[0] == $_id_galeria && $a_img[1] != 'mn') $ls_imagenes[] = $imgs[$x];
			}
		}

		if (count($ls_imagenes) > 0) {
			sort($ls_imagenes);
		} else {
			unset($ls_imagenes);
			$ls_imagenes = false;
		}

		return $ls_imagenes;
	}

	function getImagenesxLote($_id_galeria) {
		$imagenes_mn = $this->getImagenes($_id_galeria,true);
		$imagenes = $this->getImagenes($_id_galeria,false);
		$count_imagenes_mn = count($imagenes_mn);

		$y=1;
		for ($x=0;$x<$count_imagenes_mn;$x+=2) {
		
			$imagen_1_i = explode("_",$imagenes[$x],2);
	//		$nombre_1 = $imagen_1_i[1].$imagen_1_i[2];
			$nombre_1 = $imagen_1_i[1]; 
			$imagen_2_i = explode("_",$imagenes[$x+1],2);
		//	$nombre_2 = $imagen_2_i[1].$imagen_2_i[2]; 
			$nombre_2 = $imagen_2_i[1]; 
						
			$imagen_1_n = explode(".",$nombre_1);
			$imagen_2_n = explode(".",$nombre_2);
			$texto1 = $imagen_1_n[0]; 
			$texto2 = $imagen_2_n[0]; 
			
/*			
			$ls_imagenes[] = array(array('mn'=>$imagen_1_mn[1],'i'=>$imagen_1_i[1]),
				array('mn'=>$imagen_2_mn[1],'i'=>$imagen_2_i[1]));
				
			*/
			$ls_imagenes[] = array(array('mn'=>$imagenes_mn[$x],'i'=>$imagenes[$x],'x'=>$nombre_1,'texto'=>$texto1),
				array('mn'=>$imagenes_mn[$x+1],'i'=>$imagenes[$x+1],'x'=>$nombre_2,'texto'=>$texto2));
		
		$y++;
		}

		return $ls_imagenes;
	}

	//galeria 
	
	function getLista_imagenes($id_galeria) {
	
		$sql = 'select * from '.$this->tb_imagenes.' where id_galeria= "'.$id_galeria.'" AND publicado = 1 order by orden asc';
		$rs = $this->getConsulta($sql);
		$imagen = array();

		while (!$rs->EOF) {
			$imagenes = array();
			//$imagenes['titulo'] = $rs->fields['titulo'];
			$imagenes['url'] = $rs->fields['url'];
			$imagenes['id_imagen'] = $rs->fields['id_imagen'];
			$imagenes['ancho'] = $rs->fields['ancho'];
			$imagenes['alto'] = $rs->fields['alto'];
			$imagen[] = $imagenes;
			$rs->MoveNext();
		}

		$datos['imagenes'] = $imagen;
		return $datos;
	}

	function getDatos_imagen($id_imagen) {		
		$sql = 'select * from '.$this->tb_imagenes.' where id_imagen='.$id_imagen;
		$rs = $this->getConsulta($sql);
		$imagen = array();
		
		$imagen["titulo"] = $rs->fields["titulo"];
		$imagen["id_imagen"] = $rs->fields["id_imagen"];
		$imagen["descripcion"] = $rs->fields["descripcion"];
		$imagen["foto"] = $rs->fields["foto"];
		$imagen["nombre_foto"] = $rs->fields["nombre_foto"];
		$imagen["tipo_foto"] = $rs->fields["tipo_foto"];
		
		return $imagen;
	}



	function getGaleriaLista($_pagina_actual) {
	
		$sql = "select * from {$this->tb} order by id_galeria desc";
		$rs_galeria = $this->getConsulta($sql,true,$_pagina_actual);
		$galerias = array();

		while (!$rs_galeria->EOF) {
			$galeria = array();
			$galeria["id_galeria"] = $rs_galeria->fields["id_galeria"];
			$galeria["nombre"] = $rs_galeria->fields["nombre"];
			$galeria["descripcion"] = $rs_galeria->fields["descripcion"];			
			$glra =  $this->getLista_imagenes($_pagina_actual,$rs_galeria->fields["id_galeria"]);
			$galeria["imagenes"] = $glra["imagenes"] ;
			$galeria["imagenes_ant"] =  $this->getImagenesxLote($rs_galeria->fields["id_galeria"]);
			$galerias[] = $galeria;
			$rs_galeria->MoveNext();
		}

		$datos['galerias'] = $galerias;
		$datos['paginacion'] = $this->getPaginado($rs_galeria->atfirstpage(),$rs_galeria->absolutepage(),
			$rs_galeria->atlastpage(),$rs_galeria->lastpageno());

		$datos['paginacion']['paginar'] = ($rs_galeria->atfirstpage() && ($rs_galeria->lastpageno() == $rs_galeria->absolutepage())) ? "false" : "true";

		return $datos;
	}

	function getUltimaGaleria() {
	
		$sql = 'select * from '.$this->tb.' order by id_galeria desc limit 1';
		$rs_galeria = $this->getConsulta($sql);
		$galeria = array();

		if (!$rs_galeria->EOF) {
			$galeria["id_galeria"] = $rs_galeria->fields["id_galeria"];
			$galeria["nombre"] = $rs_galeria->fields["nombre"];
			$galeria["descripcion"] = $rs_galeria->fields["descripcion"];
			$glra =  $this->getLista_imagenes(0,$rs_galeria->fields["id_galeria"]);
			$galeria["imagenes"] = $glra["imagenes"] ;
		}

		return $galeria;
	}

	function getGaleria($_id_galeria) {
	
		$sql = 'select * from '.$this->tb.' where id_galeria='.$_id_galeria;
		$rs_galeria = $this->getConsulta($sql);
		$galeria = array();

		if (!$rs_galeria->EOF) {
			$galeria["id_galeria"] = $rs_galeria->fields["id_galeria"];
			$galeria["nombre"] = $rs_galeria->fields["nombre"];
			$galeria["descripcion"] = $rs_galeria->fields["descripcion"];
			$glra =  $this->getLista_imagenes(0,$rs_galeria->fields["id_galeria"]);
			$galeria["imagenes"] = $glra["imagenes"] ;
		}

		return $galeria;
	}

function getImagenes_Articulos($id_articulo) {
		$sql = 'select * from '.$this->tb_img_articulos.' where id_articulo= "'.$id_articulo.'"  order by id_imagen desc';
		$rs = $this->getConsulta($sql,false,$_pagina_actual);
		$imagen = array();

		while (!$rs->EOF) {
			$imagenes = array();
			$imagenes['titulo'] = $rs->fields['titulo'];
			$imagenes['id_imagen'] = $rs->fields['id_imagen'];
			$imagenes['id_articulo'] = $rs->fields['id_articulo'];
			$imagenes['ancho'] = $rs->fields['ancho'];
			$imagenes['alto'] = $rs->fields['alto'];
			$imagen[] = $imagenes;
			$rs->MoveNext();
		}

		$datos['imagenes'] = $imagen;
	//	$datos['paginacion'] = $this->getPaginado($rs->atfirstpage(),$rs->absolutepage(),
		//	$rs->atlastpage(),$rs->lastpageno());

		//$datos['paginacion']['paginar'] = ($rs->atfirstpage() && ($rs->lastpageno() == $rs->absolutepage())) ? "false" : "true";

		return $datos;
	}
	
		function getImagenesIndex() {
		
		$sql = "select * from $this->tb_imagenes i, $this->tb g 
		where i.id_galeria=13	
		order by rand() limit 3";
		$rs = $this->getConsulta($sql,false,$_pagina_actual);
		//print_r($rs);
		//die();
		$imagen = array();

		while (!$rs->EOF) {
			$imagenes = array();
			$imagenes['titulo'] = $rs->fields['titulo'];
			$imagenes['id_imagen'] = $rs->fields['id_imagen'];
			$imagenes['ancho'] = $rs->fields['ancho'];
			$imagenes['alto'] = $rs->fields['alto'];
			$imagen[] = $imagenes;
			$rs->MoveNext();
		}

		$datos['imagenes'] = $imagen;
		$datos['paginacion'] = $this->getPaginado($rs->atfirstpage(),$rs->absolutepage(),
			$rs->atlastpage(),$rs->lastpageno());

		$datos['paginacion']['paginar'] = ($rs->atfirstpage() && ($rs->lastpageno() == $rs->absolutepage())) ? "false" : "true";

		return $datos;
	}
	
	function getImagenesBanner() {

		$sql = "select * from $this->tb_imagenes where id_galeria=1 ORDER BY prioridad asc limit 1"; 	
		
		$rs = $this->getConsulta($sql,false,$_pagina_actual);
		//print_r($rs);
		//die();
		$imagen = array();

		while (!$rs->EOF) {
			$imagenes = array();
			$imagenes['titulo'] = $rs->fields['titulo'];
			$imagenes['id_imagen'] = $rs->fields['id_imagen'];
			$imagenes['ancho'] = $rs->fields['ancho'];
			$imagenes['alto'] = $rs->fields['alto'];
			$imagen[] = $imagenes;
			$rs->MoveNext();
		}

		$datos['imagenes'] = $imagen;
		$datos['paginacion'] = $this->getPaginado($rs->atfirstpage(),$rs->absolutepage(),
			$rs->atlastpage(),$rs->lastpageno());

		$datos['paginacion']['paginar'] = ($rs->atfirstpage() && ($rs->lastpageno() == $rs->absolutepage())) ? "false" : "true";

		return $datos;
	}
	
	function getImagenesBannerSuperior() {
/*	print_r("fdmxshjj");
	die(); */
		$sql = "select * from $this->tb_imagenes where id_galeria=2 ORDER BY prioridad asc limit 1";
		$rs = $this->getConsulta($sql,false,$_pagina_actual);
		$imagen = array();

		while (!$rs->EOF) {
			$imagenes = array();
			$imagenes['titulo'] = $rs->fields['titulo'];
			$imagenes['id_imagen'] = $rs->fields['id_imagen'];
			$imagenes['ancho'] = $rs->fields['ancho'];
			$imagenes['alto'] = $rs->fields['alto'];
			$imagen[] = $imagenes;
			$rs->MoveNext();
		}

		$datos['imagenes'] = $imagen;
		$datos['paginacion'] = $this->getPaginado($rs->atfirstpage(),$rs->absolutepage(),
			$rs->atlastpage(),$rs->lastpageno());

		$datos['paginacion']['paginar'] = ($rs->atfirstpage() && ($rs->lastpageno() == $rs->absolutepage())) ? "false" : "true";

		return $datos;
	}
	
}
?>