<?php
// Portable UTF-8
use voku\helper\UTF8;
class Contacto_Pasiva_Modelo {
	var $email;
	var $host;
	var $from;
	var $smarty;

	function Contacto_Pasiva_Modelo() {
		#instancia phpmailer
		$this->email = new PHPMailer();
		$this->email->IsHTML(true);
		$this->email->From = _REMITENTE;
		$this->email->FromName = _NOMBRE_INSTITUCION;
		$this->email->AddCC(_COPIA);
		$this->email->CharSet = "UTF-8";
                
		#instancia smarty
		$this->smarty = new Smarty;
		$this->smarty->template_dir = _SMARTY_TPL."templates/";
        $this->smarty->compile_dir = _SMARTY_TPL."templates_c/";
		$this->smarty->left_delimiter = "<!--{";
		$this->smarty->right_delimiter = "}-->";
		$this->smarty->assign("color_fondo",_COLOR_FONDO);
		$this->smarty->assign("color_titulo",_COLOR_TITULO);
		$this->smarty->assign("color_borde",_COLOR_BORDE);
		$this->smarty->assign("color_fondo_boton",_COLOR_FONDO_BOTON);
	
	}

	function recuperarContrasena($datos) {
		$this->email->AddAddress($datos["email"]);
		$this->email->Subject = "Recuperar Contraseña " . _NOMBRE_INSTITUCION;
		$this->smarty->assign("id_ciudadano",$datos['id_ciudadano']);
		$this->smarty->assign("contrasena",$datos['contrasena']);
		$body = $this->smarty->fetch(_DIRECTORIO_NOTIFICACIONES."recuperar_contrasena_correo.tpl.htm");
		$this->email->Body = $body;
		$this->email->WordWrap = 100;
		return $this->email->Send();
	}

	function registroUsuario($datos_ciudadano,$datos_usuario) {
		$this->email->AddAddress($datos_ciudadano['email']);
		$this->email->Subject = "Registro sistema de solicitudes de información "._NOMBRE_INSTITUCION;
		$this->smarty->assign("nombre_ciudadano",$datos_ciudadano["nombre"]);
		$this->smarty->assign("apellido_paterno_ciudadano",$datos_ciudadano["apellido_paterno_ciudadano"]);
		$this->smarty->assign("apellido_materno_ciudadano",$datos_ciudadano["apellido_materno_ciudadano"]);
		$this->smarty->assign("id_ciudadano",$datos_ciudadano['id_ciudadano']);
		$this->smarty->assign("contrasena",$datos_usuario['contrasena']);
		$this->smarty->assign("codigo_activacion",$datos_usuario['codigo_activacion']);
		$this->smarty->assign("nombre_institucion",_NOMBRE_INSTITUCION);
		$this->smarty->assign("url_contacto",_URL_CONTACTO);
		$body = $this->smarty->fetch(_DIRECTORIO_NOTIFICACIONES."registro_usuario_correo.tpl.htm");
		$this->email->Body = $body;
		$this->email->WordWrap = 100;
		return $this->email->Send();
	}

	function reenvioRegistroUsuario($datos_ciudadano) {
		$this->email->AddAddress($datos_ciudadano['email']);
		$this->email->Subject = "Registro Portal "._NOMBRE_INSTITUCION;
		$this->smarty->assign("nombre",$datos_ciudadano['nombre']);
		$this->smarty->assign("apellidos",$datos_ciudadano['apellido_paterno_ciudadano']." ".$datos_ciudadano['apellido_materno_ciudadano']);
		$this->smarty->assign("nombre_institucion",_NOMBRE_INSTITUCION);
		$this->smarty->assign("id_ciudadano",$datos_ciudadano['id_usuario']);
		$this->smarty->assign("contrasena",$datos_ciudadano['contrasena']);
		$this->smarty->assign("url_contacto",_URL_CONTACTO);
		$this->smarty->assign("codigo_activacion",$datos_ciudadano['codigo_activacion']);
		$body = $this->smarty->fetch(_DIRECTORIO_NOTIFICACIONES."reenvio_registro_usuario.tpl.htm");
		$this->email->Body = $body;
		$this->email->WordWrap = 100;
		return $this->email->Send();

	}

	function enviarRespuestaCorreccion($datos,$historial,$funcionario,$user) {
		$this->email->AddAddress($funcionario['email']);
		$this->email->Subject = "Respuesta Corrección "._NOMBRE_INSTITUCION;
		$this->smarty->assign("nombre_ciudadano",$user['nombre']);
		$this->smarty->assign("apellido_paterno_ciudadano",$user['apellido_paterno_ciudadano']);
		$this->smarty->assign("apellido_materno_ciudadano",$user['apellido_materno_ciudadano']);
		$this->smarty->assign("id_ciudadano",$user['id_ciudadano']);
		$this->smarty->assign("direccion",$user['direccion']);
		$this->smarty->assign("fecha",$historial['fecha']);
		$this->smarty->assign("numero_solicitud",$datos['id_oirs']);
		$this->smarty->assign("respuesta",$historial['respuesta_del_ciudadano']);
		$this->smarty->assign("url_contacto_admin",_URL_CONTACTO_ADMIN);
		$this->smarty->assign("nombre_institucion",_NOMBRE_INSTITUCION);
		$body = $this->smarty->fetch(_DIRECTORIO_NOTIFICACIONES."respuesta_correccion.tpl.htm");
		$this->email->Body = $body;
		$this->email->WordWrap = 100;
		return $this->email->Send();

	}


	function enviarCopiaSolicitudCorreo($datos_solicitud,$email_ciu,$datos_solicitante){
		$this->email->AddAddress(_COPIA);
		$this->email->Subject = "Copia reporte desplegado en el envío de la solicitud";
		$this->smarty->assign("datos_oirs",$datos_solicitud);
		$this->smarty->assign("organismo",$datos_solicitud["organismo"]);
		$this->smarty->assign("region",$datos_solicitud["region_nombre"]);
		$this->smarty->assign("comuna",$datos_solicitud["comuna_nombre"]);
		$this->smarty->assign("region_solicitante",$datos_solicitud["region_nombre_solicitante"]);
		$this->smarty->assign("comuna_solicitante",$datos_solicitud["comuna_nombre_solicitante"]);
		$this->smarty->assign("razon_social",$datos_solicitante["razon_social_solicitante"]);
		$this->smarty->assign("url_contacto",_BASE_WEB);
		$body = $this->smarty->fetch(_DIRECTORIO_NOTIFICACIONES."solicitud_copia_correo.tpl.htm");
		$this->email->Body = $body;
		$this->email->WordWrap = 100;
		return $this->email->Send();
	}

	function enviarSolicitudPasiva($datos,$id_oirs,$funcionario,$datos_ciudadano) {
		$this->email->From = _REMITENTE;
		$this->email->FromName = _NOMBRE_INSTITUCION;
		$this->email->AddAddress($funcionario['email']);
		$this->email->AddCC(_COPIA);
		$this->email->Subject = "Aviso de nuevo requerimiento";
		$this->smarty->assign("nombre_funcionario",$funcionario['nombre']);
		$this->smarty->assign("nombre_institucion",_NOMBRE_INSTITUCION);
		$this->smarty->assign("fecha",$datos['fecha']);
		$this->smarty->assign("id_oirs",$id_oirs);
		$this->smarty->assign("url_contacto",_URL_CONTACTO);
		$this->smarty->assign("url_contacto_admin",_URL_CONTACTO_ADMIN);
		$body = $this->smarty->fetch(_DIRECTORIO_NOTIFICACIONES."ingreso_pasiva_email_funcionario.tpl.htm");
		$this->email->Body = $body;

		$this->email->Send();
		$this->email->ClearAddresses();

		if($datos['envio_email'] == '1'){
			$this->email->From = _REMITENTE;
			$this->email->FromName = _NOMBRE_INSTITUCION;
			$this->email->AddAddress($datos["email_oirs"]);
			$this->email->AddCC(_COPIA);
			$this->email->Subject = "Aviso de recepción de solicitud";

			$this->smarty->assign("id_oirs",$id_oirs);
			$this->smarty->assign("nombre_ciudadano",$datos_ciudadano["nombre"]);
			$this->smarty->assign("apellido_paterno_ciudadano",$datos_ciudadano["apellido_paterno_ciudadano"]);
			$this->smarty->assign("apellido_materno_ciudadano",$datos_ciudadano["apellido_materno_ciudadano"]);
			$this->smarty->assign("fecha_maxima_respuesta",$datos["fecha_maxima_respuesta"]);
			$this->smarty->assign("mensaje",$datos["mensaje"]);
			$this->smarty->assign("observaciones",$datos["observaciones"]);
			$this->smarty->assign("fecha",$datos["fecha"]);
			$this->smarty->assign("codigo_identificador",$datos["cod_solicitud"]);
			$this->smarty->assign("url_contacto",_URL_CONTACTO);
			$this->smarty->assign("cod_solicitud",$datos["cod_solicitud"]);
			$this->smarty->assign("url_contacto",_BASE_WEB);

			$body = $this->smarty->fetch(_DIRECTORIO_NOTIFICACIONES."ingreso_pasiva_email_ciudadano.tpl.htm");

			$this->email->Body = $body;

			$this->email->WordWrap = 100;
			return $this->email->Send();
                       
		}
	}
}
?>
