<?php
	require_once(_BASE_DEP.'smarty/smarty/libs/Smarty.class.php');
class Contacto_Modelo {
	var $email;
	var $host;
	var $from;
	var $smarty;

	function Contacto_Modelo() {
		$this->smarty = new Smarty();
		$this->smarty->template_dir = _SMARTY_TPL."templates/";
		$this->smarty->compile_dir = _SMARTY_TPL."templates_c/";
		$this->smarty->left_delimiter = "<!--{";
		$this->smarty->right_delimiter = "}-->";

		$this->email = new PHPMailer();
		$this->email->IsHTML(true);
	}

	function setRecuperar($datos) {

		#enviar mail
		$this->email->From = _REMITENTE;
		$this->email->FromName = "Portal "._NOMBRE_INSTITUCION;
		$this->email->AddAddress($datos["email"]);
		$this->email->AddCC(_COPIA);
		$this->email->Subject = "Recuperar Contrase�a " . _NOMBRE_INSTITUCION;

		$this->smarty->assign("id_ciudadano",$datos['id_ciudadano']);
		$this->smarty->assign("contrasena",$datos['contrasena']);

		$body = $this->smarty->fetch("recuperar_pass.tpl.htm");

		$this->email->Body = $body;

		$this->email->WordWrap = 100;
		return $this->email->Send();
	}

	function setRegistro_usuario_reenvio($datos_ciudadano) {
		#enviar mail[
		$this->email->From = _REMITENTE;
		$this->email->FromName = "Portal "._NOMBRE_INSTITUCION;

		$this->email->AddAddress($datos_ciudadano['email']);
		$this->email->AddCC(_COPIA);
		$this->email->Subject = "Registro Portal "._NOMBRE_INSTITUCION;
		$this->email->Body = "Estimado Ciudadano {$datos_ciudadano['nombre']} {$datos_ciudadano['apellidos']}:<br><br>".
		"Este es un reenv�o de correo para activaci�n de su cuenta de usuario en la Oficina de Opini�n, Informaci�n, Reclamos y Sugerencias (OIRS) de "._NOMBRE_INSTITUCION."\n".
		"Usted se ha registrado como usuario en la Oficina de Opini�n, Informaci�n, Reclamos y Sugerencias (OIRS) de "._NOMBRE_INSTITUCION.
		", y se asigno el siguiente ID Ciudadano y Contrase�a con las cuales podra revisar sus consultas: <br><br>".
		"ID Ciudadano: {$datos_ciudadano['id_usuario']}<br>".
		"Contrase�a: {$datos_ciudadano['contrasena']}<br>".
		"<a href='".url_contacto."index.php?action=activar&code={$datos_ciudadano['codigo_activacion']}'>Activar cuenta</a><br><br>".
		"(Le rogamos que no responda este correo electr�nico que ha sido dise�ado exclusivamente para el env�o de informaci�n)<br>";
		$this->email->WordWrap = 100;
		return $this->email->Send();

	}

	function setEnviar_Corregido($datos,$historial,$funcionario,$user) {

		$this->email->From = _REMITENTE;
		$this->email->FromName = "Portal "._NOMBRE_INSTITUCION;

		$this->email->AddAddress($funcionario['email']);
		$this->email->AddCC(_COPIA);
		$this->email->Subject = "Respuesta Subsanaci�n";

		$this->smarty->assign("funcionario",$funcionario["nombre"]);
		$this->smarty->assign("nombre_institucion",_NOMBRE_INSTITUCION);
		$this->smarty->assign("nombre_ciudadano",$user["nombre"]);
		$this->smarty->assign("apellido_paterno_ciudadano",$user["apellido_paterno_ciudadano"]);
		$this->smarty->assign("apellido_materno_ciudadano",$user["apellido_materno_ciudadano"]);
		$this->smarty->assign("id_ciudadano",$user["id_ciudadano"]);
		$this->smarty->assign("direccion",$user["direccion"]);
		$this->smarty->assign("fecha",$historial["fecha"]);
		$this->smarty->assign("id_oirs",$datos["id_oirs"]);
		$this->smarty->assign("respuesta_del_ciudadano",$historial["respuesta_del_ciudadano"]);
		$this->smarty->assign("url_contacto",_URL_CONTACTO_ADMIN);
		$this->smarty->assign("fecha_final",$datos["fecha_final"]);

		$body = $this->smarty->fetch("correccion_ciudadano_oirs.tpl.htm");

		$this->email->Body = $body;
		$this->email->WordWrap = 100;
		$this->email->Send();
	}


	function setEnviar_ReporteEmail($datos_solicitud,$email_ciu){

		$this->email->From = _REMITENTE;
		$this->email->FromName = "Portal "._NOMBRE_INSTITUCION;
		$this->email->AddAddress($email_ciu);
		$this->email->AddCC(_COPIA);
		$this->email->Subject = "Copia reporte desplegado en el env�o de la solicitud";

		$oirs_modelo = new OIRS_Modelo();

    	$this->smarty->assign("datos_oirs",$datos_solicitud);

    	$datos_solicitante = $oirs_modelo->getUsuario($datos_solicitud[0]["id_ciudadano"]);

	    $this->smarty->assign("organismo",$oirs_modelo->getOrganoxid($datos_solicitud[0]["id_organo_ciu"]));
	    $this->smarty->assign("datos_solicitante",$datos_solicitante);
	    $this->smarty->assign("region",$oirs_modelo->getRegionxid($datos_solicitante["region"]));
	    $this->smarty->assign("comuna",$oirs_modelo->getComunaxid($datos_solicitante["comuna"]));
	    $this->smarty->assign("region_apoderado",$oirs_modelo->getRegionxid($datos_solicitante["region_apoderado"]));
    	$this->smarty->assign("comuna_apoderado",$oirs_modelo->getComunaxid($datos_solicitante["comuna_apoderado"]));
	    $this->smarty->assign("razon_social",$datos_solicitante["razon_social"]);

		$body = $this->smarty->fetch("solicitud_visualizar_email.tpl.htm");
		$this->email->Body = $body;

		$this->email->WordWrap = 100;

		return $this->email->Send();
	}

	function setRegistro_usuario($datos_ciudadano,$datos_usuario) {

		$this->email->From = _REMITENTE;
		$this->email->FromName = "Portal "._NOMBRE_INSTITUCION;
		$this->email->AddAddress($datos_ciudadano['email']);
		$this->email->AddCC(_COPIA);
		$this->email->Subject = "Registro Portal "._NOMBRE_INSTITUCION;

		$this->smarty->assign("nombre_ciudadano",$datos_ciudadano["nombre"]);
		$this->smarty->assign("apellido_paterno_ciudadano",$datos_ciudadano["apellido_paterno_ciudadano"]);
		$this->smarty->assign("apellido_materno_ciudadano",$datos_ciudadano["apellido_materno_ciudadano"]);
		$this->smarty->assign("id_ciudadano",$datos_ciudadano['id_ciudadano']);
		$this->smarty->assign("contrasena",$datos_usuario['contrasena']);
		$this->smarty->assign("codigo_activacion",$datos_usuario['codigo_activacion']);
		$this->smarty->assign("nombre_institucion",_NOMBRE_INSTITUCION);
		$this->smarty->assign("url_contacto",url_contacto);
		$this->smarty->assign("pasiva",$datos_ciudadano["pasiva"]);

		$body = $this->smarty->fetch("registro_ciudadano_email.tpl.htm");
		$this->email->Body = $body;
		$this->email->WordWrap = 100;
		return $this->email->Send();
	}

	function setEnviar_funcionario($datos,$id_oirs,$funcionario,$email_ciu) {

		if ($datos['id_tipo'] == 2){
			$strtipo = "nueva consulta";
		}elseif($datos['id_tipo'] == 3){
			$strtipo = "nuevo reclamo";
		}else{
			$strtipo = "nueva sugerencia";
		}


		$this->email->From = _REMITENTE;
		$this->email->FromName = "Portal "._NOMBRE_INSTITUCION;
		$this->email->AddAddress($funcionario['email']);
		$this->email->AddCC(_COPIA);
		$this->email->Subject = "Aviso de ".$strtipo;

		$this->smarty->assign("nombre_funcionario",$funcionario['nombre']);
		$this->smarty->assign("nombre_institucion",_NOMBRE_INSTITUCION);
		$this->smarty->assign("fecha",$datos['fecha']);
		$this->smarty->assign("id_oirs",$id_oirs);
		$this->smarty->assign("url_contacto",url_contacto);
		$this->smarty->assign("url_contacto_admin",_URL_CONTACTO_ADMIN);
		$this->smarty->assign("tipo",$datos['id_tipo']);

		$body = $this->smarty->fetch("ingreso_oirs_email_funcionario.tpl.htm");

		$this->email->Body = $body;
		$this->email->Send();
		$this->email->ClearAddresses();

		if($datos['envio_email']=='1'){
		$this->email->AddAddress($email_ciu);
		$this->email->AddCC(_COPIA);
		if ($datos['id_tipo'] == 2){
			$strtipo = "consulta";
		}elseif($datos['id_tipo'] == 3){
			$strtipo = "reclamo";
		}else{
			$strtipo = "sugerencia";
		}

		$this->email->Subject = "Aviso de recepci�n de ".$strtipo;

		$this->smarty->assign("id_oirs",$id_oirs);
		$this->smarty->assign("nombre_ciudadano",$datos["nombre_ciudadano"]);
		$this->smarty->assign("apellido_paterno_ciudadano",$datos["apellido_paterno_ciudadano"]);
		$this->smarty->assign("apellido_materno_ciudadano",$datos["apellido_materno_ciudadano"]);
		$this->smarty->assign("fecha_maxima_respuesta",$datos["fecha_maxima_respuesta"]);
		$this->smarty->assign("tipo",$datos['id_tipo']);

		$body = $this->smarty->fetch("ingreso_oirs_email_ciudadano.tpl.htm");

		$this->email->Body = $body;

		$this->email->WordWrap = 100;
		return $this->email->Send();
		}
	}
}
?>
