<?php
// Portable UTF-8
use voku\helper\UTF8;
class Articulos_Modelo extends Modelo {

	var $tabla;
	var $tabla_comentarios;

	function Articulos_Modelo() {
		parent::Modelo();
		$this->tabla = 'articulos';
		$this->tabla_comentarios = 'articulos_comentarios';
		$this->tabla_imagenes = 'img_articulos';
	}

	function getLista() {
	
		$sql = 'select * from '.$this->tabla.' WHERE prioridad = 1 order by id_articulo desc';
		$rs_articulos = $this->getConsulta($sql,true,$_pagina_actual);
		$articulo = array();

		while (!$rs_articulos->EOF) {
			$articulo_tmp = array();
			$articulo_tmp['id_articulo'] = $rs_articulos->fields['id_articulo'];
			$articulo_tmp['seccion'] = $rs_articulos->fields['seccion'];
			$articulo_tmp['prioridad'] = $rs_articulos->fields['prioridad'];
			$articulo_tmp['fecha'] = $rs_articulos->fields['fecha'];
			$articulo_tmp['titulo'] = $rs_articulos->fields['titulo'];
			$articulo_tmp['bajada'] = $rs_articulos->fields['bajada'];
			
			$bajada = $rs_articulos->fields['bajada'];
			
			preg_match_all('/<img [^>]*src=("[^"]*"|\'[^\']*\')[^>]*>/i',$bajada,$match);
			$imagenes = array_map(create_function('$a','return substr($a, 1, -1);'),$match[1]);
			$articulo_tmp['img_fix'] = $imagenes[0];
			
			$expresion = "<[^>]+>?([^>|^<]*)<?\/[^>]*>";
			while (ereg($expresion,$bajada) == true) $bajada = ereg_replace($expresion,'\\1',$bajada);
			$articulo_tmp['bajada_fix'] = substr($bajada,0,500);
			
			
			
			$size = GetImageSize($articulo_tmp['img_fix']); 
			
			$articulo_tmp['ancho'] = $size[0];
			$articulo_tmp['alto'] = $size[1];
			$articulo_tmp['info'] = $size[3];
			
			
			$articulo[] = $articulo_tmp;
			$rs_articulos->MoveNext();
		}

		$datos['articulo'] = $articulo;
		$datos['paginacion'] = $this->getPaginado($rs_articulos->atfirstpage(),$rs_articulos->absolutepage(),
		$rs_articulos->atlastpage(),$rs_articulos->lastpageno());

		$datos['paginacion']['paginar'] = ($rs_articulos->atfirstpage() &&
		($rs_articulos->lastpageno() == $rs_articulos->absolutepage())) ? "false" : "true";

		
		return $datos;
	}

	function getMiniLista($_seccion,$id_destacado) {
		$sql = "select id_articulo,fecha,titulo,bajada from {$this->tabla} where seccion = '{$_seccion}' and id_articulo <> '{$id_destacado}' and seccion = 'GR' order by prioridad asc limit 2";
		$rs_articulos = $this->getConsulta($sql);
		$articulos = array();

		while (!$rs_articulos->EOF) {
			$articulo = array();
			$articulo['id_articulo'] = $rs_articulos->fields['id_articulo'];
			$articulo['fecha'] = $rs_articulos->fields['fecha'];
			$articulo['titulo'] = $rs_articulos->fields['titulo'];
			$articulo['bajada'] = $rs_articulos->fields['bajada'];
			
			$bajada = $rs_articulos->fields['bajada'];
			
			preg_match_all('/<img [^>]*src=("[^"]*"|\'[^\']*\')[^>]*>/i',$bajada,$match);
			$imagenes = array_map(create_function('$a','return substr($a, 1, -1);'),$match[1]);
			$articulo['img_fix'] = $imagenes[0];
			
			$expresion = "<[^>]+>?([^>|^<]*)<?\/[^>]*>";
			while (ereg($expresion,$bajada) == true) $bajada = ereg_replace($expresion,'\\1',$bajada);
			$articulo['bajada_fix'] = substr($bajada,0,500);
			
			
			
			$size = GetImageSize($articulo['img_fix']); 
			
			$articulo['ancho'] = $size[0];
			$articulo['alto'] = $size[1];
			$articulo['info'] = $size[3];		
			
			$articulos[] = $articulo;
			$rs_articulos->MoveNext();
		}
        


		return $articulos;
	}
	
	function getMarque() {
		//$sql = "select id_articulo,fecha,titulo,bajada from {$this->tabla} where prioridad = '5' and seccion = 'GR' order by prioridad asc limit 8";
		$sql = "select id_articulo,fecha,titulo,bajada from {$this->tabla} where seccion = 'GR' order by prioridad asc limit 8";
		$rs_articulos = $this->getConsulta($sql);
		$articulos = array();

		while (!$rs_articulos->EOF) {
			$articulo = array();
			$articulo['id_articulo'] = $rs_articulos->fields['id_articulo'];
			$articulo['fecha'] = $rs_articulos->fields['fecha'];
			$articulo['titulo'] = $rs_articulos->fields['titulo'];
			$articulo['bajada'] = $rs_articulos->fields['bajada'];
			
			$bajada = $rs_articulos->fields['bajada'];
			
			preg_match_all('/<img [^>]*src=("[^"]*"|\'[^\']*\')[^>]*>/i',$bajada,$match);
			$imagenes = array_map(create_function('$a','return substr($a, 1, -1);'),$match[1]);
			$articulo['img_fix'] = $imagenes[0];
			
			$expresion = "<[^>]+>?([^>|^<]*)<?\/[^>]*>";
			while (ereg($expresion,$bajada) == true) $bajada = ereg_replace($expresion,'\\1',$bajada);
			$articulo['bajada_fix'] = substr($bajada,0,500);
			
			
			
			$size = GetImageSize($articulo['img_fix']); 
			
			$articulo['ancho'] = $size[0];
			$articulo['alto'] = $size[1];
			$articulo['info'] = $size[3];		
			
			$articulos[] = $articulo;
			$rs_articulos->MoveNext();
		}



		return $articulos;
	}

	function getArticulo($_id_articulo) {
	
        $sql = 'select * from '.$this->tabla.' where id_articulo="'.$_id_articulo.'"';
		$rs_articulo = $this->getConsulta($sql);

		$articulo["id_articulo"] = $rs_articulo->fields["id_articulo"];
		$articulo["epigrafe"] = $rs_articulo->fields["epigrafe"];
		$articulo["seccion"] = $rs_articulo->fields["seccion"];
		$articulo["titulo"] = $rs_articulo->fields["titulo"];
		$articulo["cuerpo"] = $rs_articulo->fields["cuerpo"];
		$articulo["bajada"] = $rs_articulo->fields["bajada"];
		$articulo["autor"] = $rs_articulo->fields["autor"];
		$articulo["fecha"] = $rs_articulo->fields["fecha"];



		return $articulo;
	}
	
	
	
	function getArticuloDestacado() {
	
		$articulo = array();		
        $sql = "select * from {$this->tabla} where seccion = 'GR' ORDER BY prioridad ASC LIMIT 1";
		$rs_articulo = $this->getConsulta($sql);

		$articulo["id_articulo"] = $rs_articulo->fields["id_articulo"];
		$articulo["seccion"] = $rs_articulo->fields["seccion"];
		$articulo["titulo"] = $rs_articulo->fields["titulo"];
		$articulo["cuerpo"] = $rs_articulo->fields["cuerpo"];
		$articulo["bajada"] = $rs_articulo->fields["bajada"];
		
		$bajada = $rs_articulo->fields['bajada'];
			
			preg_match_all('/<img [^>]*src=("[^"]*"|\'[^\']*\')[^>]*>/i',$bajada,$match);
			$imagenes = array_map(create_function('$a','return substr($a, 1, -1);'),$match[1]);
			$articulo['img_fix'] = $imagenes[0];
			
			$expresion = "<[^>]+>?([^>|^<]*)<?\/[^>]*>";
			while (ereg($expresion,$bajada) == true) $bajada = ereg_replace($expresion,'\\1',$bajada);
			$articulo['bajada_fix'] = substr($bajada,0,500);		
			
			$size = GetImageSize($articulo['img_fix']); 
			
			$articulo['ancho'] = $size[0];
			$articulo['alto'] = $size[1];
			$articulo['info'] = $size[3];		
		
		
		$articulo["autor"] = $rs_articulo->fields["autor"];
		$articulo["fecha"] = $rs_articulo->fields["fecha"];



		return $articulo;
	}
	


	function getBuscar($_texto,$_pagina_actual) {

		$sql = 'select id_articulo,fecha,titulo,bajada from '.$this->tabla.
		' where fecha like "%'.$_texto.'%" or '.
		'titulo like "%'.$_texto.'%" or '.
		'bajada like "%'.$_texto.'%" or '.
		'bajada like "%'.$_texto.'%" or '.
		'cuerpo like "%'.$_texto.'%" or '.
		'autor like "%'.$_texto.'%" '.
		'order by id_articulo desc';
		$rs_articulos = $this->getConsulta($sql,true,$_pagina_actual);
		$articulos = array();

		while (!$rs_articulos->EOF) {
			$articulo = array();
			$articulo['id_articulo'] = $rs_articulos->fields['id_articulo'];
			$articulo['fecha'] = $rs_articulos->fields['fecha'];
			$articulo['titulo'] = $rs_articulos->fields['titulo'];
			$articulo['bajada'] = $rs_articulos->fields['bajada'];
			$articulos[] = $articulo;
			$rs_articulos->MoveNext();
		}

		$datos['articulos'] = $articulos;
		$datos['paginacion'] = $this->getPaginado($rs_articulos->atfirstpage(),$rs_articulos->absolutepage(),
		$rs_articulos->atlastpage(),$rs_articulos->lastpageno());

		$datos['paginacion']['paginar'] = ($rs_articulos->atfirstpage() &&
		($rs_articulos->lastpageno() == $rs_articulos->absolutepage())) ? "false" : "true";


		return $datos;
	}
	function setAgregarComentario($_cmps) {
		$sql = "select * from {$this->tabla_comentarios} where id_comentario = -1";

		return $this->setGuardar($sql,$_cmps);
	}

	function getComentarios($_id_articulo,$_pagina_actual) {
		$sql = "select * from {$this->tabla_comentarios} where id_articulo=$_id_articulo and habilitar=1 order by id_comentario asc";
		$rs = $this->getConsulta($sql,true,$_pagina_actual);
		$comentarios = array();

		while (!$rs->EOF) {
			$comentario = array();
			$comentario['id_comentario'] = $rs->fields['id_comentario'];
			$comentario['email'] = $rs->fields['email'];
			$comentario['comentario'] = utf8_decode($rs->fields['comentario']);
			$comentarios[] = $comentario;
			$rs->MoveNext();
		}

		$datos['comentarios'] = $comentarios;
		$datos['paginacion'] = $this->getPaginado($rs->atfirstpage(),$rs->absolutepage(),$rs->atlastpage(),$rs->lastpageno());

		$datos['paginacion']['paginar'] = ($rs->lastpageno() == -1) ? 'false' : 'true';

		return $datos;
	}
	
	function getDatos_imagen($id_articulo) {		
		$sql = "select * from {$this->tabla_imagenes} where id_articulo='{$id_articulo}' order by rand() desc limit 1";
		$rs = $this->getConsulta($sql);
		$imagen = array();
		
		$imagen["id_imagen"] = $rs->fields["id_imagen"];
		$imagen["foto"] = $rs->fields["foto"];
		$imagen["nombre_imagen"] = $rs->fields["nombre_imagen"];
		$imagen["tipo_imagen"] = $rs->fields["tipo_imagen"];
		
		return $imagen;
	}
	
		function getInmediatas($_seccion) {

		$sql = "select id_articulo,fecha,titulo,bajada from {$this->tabla} where seccion = '{$_seccion}' order by prioridad asc limit 4";

		$rs_articulos = $this->getConsulta($sql);

		$articulos = array();



		while (!$rs_articulos->EOF) {

			$articulo = array();

			$articulo['id_articulo'] = $rs_articulos->fields['id_articulo'];

			$articulo['fecha'] = $rs_articulos->fields['fecha'];

			$articulo['titulo'] = $rs_articulos->fields['titulo'];

			$articulo['bajada'] = $rs_articulos->fields['bajada'];

			

			$bajada = $rs_articulos->fields['bajada'];

			

			preg_match_all('/<img [^>]*src=("[^"]*"|\'[^\']*\')[^>]*>/i',$bajada,$match);

			$imagenes = array_map(create_function('$a','return substr($a, 1, -1);'),$match[1]);

			$articulo['img_fix'] = $imagenes[0];

			

			$expresion = "<[^>]+>?([^>|^<]*)<?\/[^>]*>";

			while (ereg($expresion,$bajada) == true) $bajada = ereg_replace($expresion,'\\1',$bajada);

			$articulo['bajada_fix'] = substr($bajada,0,500);

			

			

			

			$size = GetImageSize($articulo['img_fix']); 

			

			$articulo['ancho'] = $size[0];

			$articulo['alto'] = $size[1];

			$articulo['info'] = $size[3];		

			

			$articulos[] = $articulo;

			$rs_articulos->MoveNext();

		}



		return $articulos;

	}
	
		function getArticuloOirs() {	

        $sql = 'select * from '.$this->tabla.' ORDER BY prioridad asc limit 1';
		$rs_articulo = $this->getConsulta($sql);	

		return $rs_articulo;
	}

	function get_article_per_id($article_id){
		
		$sql = "SELECT * FROM {$this->tabla} WHERE id_articulo={$article_id}";
		$rs = $this->getConsulta($sql);

		return $rs->fields["bajada"];

	}
	
}
?>
