<?php
require("../../configuraciones/include_xajax.cfg.php");

function setError(&$objResponse,$field,$titulo) {
	$objResponse = new xajaxResponse();

	$objResponse->alert(utf8_encode("Falta ingresar el campo $titulo"));
	$objResponse->script("document.getElementById('$field').focus()");
	return false;
}

function setOIRS($f) {
	$objResponse = new xajaxResponse();
	$continuar = true;


	if($continuar && $f["tipo_persona"]=="1"){

		if ($continuar && $f["rut_persona"]=="")
		{
			$objResponse->alert("Falta ingresar el Rut");
			$objResponse->script("document.getElementById('rut_persona').focus()");
			$continuar =false;
		}

		if ($continuar && !eregi("^[[:digit:]]+[-][0-9kK]{1}$",$f['rut_persona'])){
			$continuar = false;
			$objResponse->alert(utf8_encode('Formato de RUT incorrecto. Use s�lo n�meros, sin puntos. Ej: 9876543-k'));
			$objResponse->script("document.getElementById('rut_persona').focus()");
		}

		if ($continuar){
			list($rut_persona,$rut_dv_persona) = explode('-',$f["rut_persona"]);
			$rut_persona = "$rut_persona";

			$f["rut_persona"]=strtoupper(ereg_replace('\.|,|-','',$f["rut_persona"]));
			$sub_rut=substr($f["rut_persona"],0,strlen($f["rut_persona"])-1);
			$sub_dv=substr($f["rut_persona"],-1);
			$x=2;
			$s=0;
			for ( $i=strlen($sub_rut)-1;$i>=0;$i-- )
			{
				if ( $x >7 )
				{
					$x=2;
				}
				$s += $sub_rut[$i]*$x;
				$x++;
			}
			$dv=11-($s%11);
			if ( $dv==10 )
			{
				$dv='K';
			}
			if ( $dv==11 )
			{
				$dv='0';
			}
			if ( $dv==$sub_dv )
			{
				$continuar = true;
			}
			else
			{
				$continuar = false;
			}

			if ($continuar == false)
			{
				$objResponse->alert(utf8_encode('Error en el ingreso del rut'));
				$objResponse->script("document.getElementById('rut_persona').focus()");
			}
		}

		if ($continuar && $f["nombre_persona"]=="") $continuar = setError($objResponse,'nombre_persona','Nombre Persona Jur�dica');
		if ($continuar && $f["representante"]=="") $continuar = setError($objResponse,'representante','Representante Legal');
		if ($continuar && $f["direccion_persona"]=="") $continuar = setError($objResponse,'direccion_persona','Direcci�n Persona Jur�dica');

	}

	//validacion mensaje

	if ($continuar && $f["asunto"]=="") $continuar = setError($objResponse,'asunto','Asunto');
	if ($continuar && $f["mensaje"]=="") $continuar = setError($objResponse,'mensaje','Mensaje');

	if (is_array($f["adjunto"]) || is_object($f["adjunto"])){
		foreach ($f["adjunto"] as $key => $value) {
			$doc_array = explode("/",$value);

			$doc_name = $doc_array[count($doc_array) - 1];

			if ($doc_name !="") {
				//$continuar = false;
				//$objResponse->alert("Seleccione un documento");
			//} else {
				$ext = strtolower(substr($doc_name,-3));

				if ($ext != 'doc' && $ext != 'xls' && $ext != 'pdf' && $ext != 'txt' && $ext != 'jpg'  && $ext != 'png' && $ext != 'gif'  ) {
					$continuar = false;
					$objResponse->alert("Seleccione un documento con extensión JPG, PNG, GIF, DOC, XLS, PDF ó TXT");
				} else {
					if (file_exists($path.$f['id_oirs'].'_'.$doc_name)) {
						$continuar = false;
						$objResponse->alert(utf8_encode("Ya existe un documento con el nombre de '$doc_name'"));
					}
				}
			}
		}
	}

	if (!$continuar) {
		$objResponse->assign("enviar","value","Enviar");
		$objResponse->assign("enviar","disabled",false);
	} else {
		$objResponse->script("document.frm_oirs.submit()");
	}
	return $objResponse;
}

function setRevisarFormulario($f) {
	$objResponse = new xajaxResponse();
	$continuar = true;

	if ($f["oirs"]=="") $continuar = setError($objResponse,'oirs','OIRS');
	if ($continuar && !is_numeric($f["oirs"])) {
		$objResponse->alert("Error en el ingreso del OIRS");
		$objResponse->script("document.getElementById('oirs').focus()");
		$continuar = false;
	}
	if ($continuar && $f["c"]=="") $continuar = setError($objResponse,'c','C�digo de Validaci�n:');

	if ($continuar) {
		$tp_modelo = new TP_Modelo();
		$oirs = $tp_modelo->getOIRS($f["oirs"],$f["c"]);

		if (empty($oirs['id_oirs'])) {
			$objResponse->alert("Error en el ingreso del OIRS o C�digo de Validaci�n");
			$continuar = false;
		}
	}

	if (!$continuar) {
		$objResponse->assign("buscar_oirs","value","Enviar");
		$objResponse->assign("buscar_oirs","disabled",false);
	} else {
		$objResponse->script("document.frm_oirs.submit()");
	}

	return $objResponse;
}

function setRecuperarTP($f) {
	$objResponse = new xajaxResponse();
	$continuar = true;

	if ($continuar && $f["idormail"] === NULL)   {
		$objResponse->call("mostrarError","Seleccione una opción","Debes seleccionar y completar al menos una de las opciones");
		$continuar = false;
	}

	if($continuar && $f["idormail"] === "1" && $f["iduser"] == ""){
		$objResponse->call("mostrarError","Campo vacío","Debe ingresar el identificador de usuario");
		$objResponse->script("document.getElementById('iduser').focus()");
		$continuar = false;
	}

	if($continuar && $f["idormail"] === "2" && $f["mailuser"] == ""){
		$objResponse->call("mostrarError","Campo vacío","Debe ingresar el correo electrónico del usuario");
		$objResponse->script("document.getElementById('mailuser').focus()");
		$continuar = false;
	}

	if ($continuar && $f["idormail"] === "1" && $f["iduser"] != "") {

		if(!is_numeric($f["iduser"])) {
			$objResponse->call("mostrarError","Campo vacío","Identificador de usuario debe ser numérico");
			$continuar =false;
		}else{
			$tp_modelo = new TP_Modelo();
			$activo = $tp_modelo->getUsuarioOirsCiuID($f['iduser']);
			$enviarpass = $activo["email_activado"] == 0 ? false : true;
			$usuario = $tp_modelo->getUsuarioxid($f["iduser"],$enviarpass);
			if($continuar && !$usuario['existe'] || $activo['no_registrado']) {
				$objResponse->call("mostrarError","Error en los datos","No existe un usuario con los datos ingresados");
				$continuar =false;
			}elseif($continuar && $usuario['existe'] && !$activo["email_activado"]){
				$objResponse->call("mostrarError","Cuenta desactivada","Esta cuenta aún no se encuentra activada. Revise su bandeja de correo");
				$continuar =false;
			}elseif($continuar && $usuario['existe'] && $activo["email_activado"]) {
				$objResponse->call("mostrarAlerta","Contraseña enviada","Contraseña despachada al correo");
			}
		}
	}

	elseif ($continuar && $f["iduser"]=="" && $f["mailuser"]!="") {

			if ($continuar && !preg_match(
				'/^[^0-9][a-zA-Z0-9\-._]+([.][a-zA-Z0-9_]+)*[@][a-zA-Z0-9_]+([.][a-zA-Z0-9_]+)*[.][a-zA-Z]{2,4}$/',$f["mailuser"])) {
				$objResponse->call("mostrarError","","Error en el ingreso del E-mail");
				$objResponse->script("document.getElementById('email').focus()");
				$continuar =false;
			}else {
				$tp_modelo = new TP_Modelo();
				$contacto_modelo = new Contacto_Pasiva_Modelo();
				$activo = $tp_modelo->getUsuarioOirsCiuEmail($f['mailuser']);
				$enviarpass = $activo==0 ? false : true;
				$mail = $tp_modelo->getDatosCiudadanoRegistrado($f['mailuser']);
			
			if($continuar && !$mail['existe']) {
				$objResponse->call("mostrarError","Usuario inexistente","No existe un usuario con los datos ingresados");
				$continuar = false;
			}elseif($continuar && $mail['existe'] && $mail['email_activado']==1 && $mail['no_registrado'] == 0) {
				$objResponse->call("mostrarAlerta","Contraseña enviada","Contraseña despachada al correo");
				$contacto_modelo->recuperarContrasena(array('email'=>$mail["email"],
 															 'id_ciudadano'=>$mail["id_ciudadano"],
 															 'contrasena'=>$mail["contrasena"]));
			}elseif($continuar && $mail['existe'] && $mail['email_activado']==0 && $mail['no_registrado'] == 0 && (strtotime($mail["caduca"]) > strtotime(date("Y-m-d H:i:s")))){
				$objResponse->call("mostrarError","Cuenta desactivada","Esta cuenta aún no se encuentra activada\nRevise su bandeja de correo");
				$continuar = false;
			}
		}
	}
	
	if (!$continuar) {
			$objResponse->assign("enviar","value","Enviar");
			$objResponse->assign("enviar","disabled",false);
	}else {
			$objResponse->script("document.frm_oirs.submit()");
			$objResponse->assign("enviar","value","Enviar");
			$objResponse->assign("enviar","disabled",false);
	}
		return $objResponse;
	}

function setOIRS_responder($f) {
	$objResponse = new xajaxResponse();
	$continuar = true;

	if ($f["respuesta"]=="") {
		$objResponse->alert("Falta ingresar la Respuesta");
		$objResponse->script("document.getElementById('respuesta').focus()");
		$continuar = false;
	}

	if (!$continuar) {
		$objResponse->assign("enviar","value","Enviar");
		$objResponse->assign("enviar","disabled",false);
	} else {
		$objResponse->script("document.frm_oirs.submit()");
	}

	return $objResponse;
}

$xajax = new xajax();
$xajax->register(XAJAX_FUNCTION,"setRevisarFormulario");
$xajax->register(XAJAX_FUNCTION,"setOIRS");
$xajax->register(XAJAX_FUNCTION,"setOIRS_responder");
$xajax->register(XAJAX_FUNCTION,"setRecuperarTP");
$xajax->processRequest();

?>
