<?php
require("../../configuraciones/include_xajax.cfg.php");

function setError(&$objResponse,$field,$titulo) {
	$objResponse = new xajaxResponse();
	
	$objResponse->alert(utf8_encode("Falta ingresar el campo $titulo"));
	$objResponse->script("document.getElementById('$field').focus()");
	return false;
}

function setRellenarComuna($id_region) {
		$objResponse = new xajaxResponse();
		$continuar = true;
		
		$objResponse->script("document.getElementById('comuna').length=0;");
	
		$comunas = array();	
		$tp_modelo = new TP_Modelo();
		$comunas = $tp_modelo->getComuna($id_region);
		
		foreach($comunas as $sOptionValue=>$sOptionText) {
			$sScript = "var objOption = new Option('".utf8_encode($sOptionText)."','$sOptionValue');";
			$sScript .= "document.getElementById('comuna').options.add(objOption);";
			$objResponse->script($sScript);
		}
		
		return $objResponse;
	}

function rellenarFormatos($id_formato){
	$objResponse = new xajaxResponse();
	$tp_modelo = new TP_Modelo();
	$continuar = true;

	$objResponse->script("document.getElementById('formatoentrega').length=0;");

    /*
	if ($id_formato == 1) {
		$json = $tp_modelo->decodificarJSON(_BASE_WEB."data/formatos/formatos_digitales.json");
	}else if ($id_formato == 2 || $id_formato == 3) {
		$json = $tp_modelo->decodificarJSON(_BASE_WEB."data/formatos/formatos_fisicos.json");
	}else if ($id_formato == 0) {
		$json = $tp_modelo->decodificarJSON(_BASE_WEB."data/formatos/formato_inicial.json");
	}
    */
    
    if ($id_formato == 1) {
            $id_formato_entrega = array(0 => 'Seleccione un formato de entrega(*)',
                                    3 => 'Word',
                                    4 => 'Excel',
                                    5 => 'Otros',
                                    6 => 'PDF');              
        }else if ($id_formato == 2 || $id_formato == 3) {
            $id_formato_entrega = array(0 => 'Seleccione un formato de entrega(*)',
                                    1 => 'CD-ROM',
                                    2 => 'Papel',
                                    5 => 'Otros');
        }else if ($id_formato == 0) {
            $id_formato_entrega = array(0 => 'Seleccione un formato de entrega(*)',
                                     1 => 'CD-ROM',
                                     2 => 'Papel',
                                     3 => 'Word',
                                     4 => 'Excel',
                                     5 => 'Otros',
                                     6 => 'PDF');  
        }

	foreach($id_formato_entrega as $sOptionValue=>$sOptionText) {
		$sScript = "var objOption = new Option('".utf8_encode($sOptionText)."','$sOptionValue');";
		$sScript .= "document.getElementById('formatoentrega').options.add(objOption);";
		$objResponse->script($sScript);
	}

	return $objResponse;
}

function setSolicitud($f) {
	$objResponse = new xajaxResponse();
	$continuar = true;
	$tp_modelo = new TP_Modelo();

	if ($continuar && $f["mensaje"]==""){
		$objResponse->call("mostrarError","Campo vac&iacute;o","Debe ingresar un valor para el campo mensaje");
		$objResponse->script("document.getElementById('mensaje').focus()");
		$continuar = false;
	}

	if ($continuar && $f["formarespuesta"]==0){
		$objResponse->call("mostrarError","Seleccionar forma de respuesta","Debe seleccionar una forma de respuesta");
		$objResponse->script("document.getElementById('formarespuesta').focus()");
		$continuar = false;
	}

	if ($continuar && $f["formarespuesta"]==1){

		if ($continuar && $f["email"]==""){
			$objResponse->call("mostrarError","Campo vac&iacute;o","Debe ingresar un valor para el campo correo electr&oacute;nico");
			$objResponse->script("document.getElementById('email').focus()");
			$continuar = false;
		}
	
		if ($continuar && !preg_match(
		'/^[^0-9][a-zA-Z0-9\-._]+([.][a-zA-Z0-9_]+)*[@][a-zA-Z0-9_]+([.][a-zA-Z0-9_]+)*[.][a-zA-Z]{2,4}$/',$f["email"])) {
			$objResponse->call("mostrarError","Error en el ingreso","Error en el ingreso del correo electr&oacute;nico");
			$objResponse->script("document.getElementById('email').focus()");
			$continuar =false;
		}	
		
		$mail = $tp_modelo->getEmailxIdSolicitante($f["id_solicitante"]);
		if($continuar && ($f['email'] != $mail["email"])){	
				if ($continuar && $f['email'] != $f['email_c']) {
					$objResponse->call("mostrarError","Error en el reingreso","Error en el reingreso del correo electr&oacute;nico");
					$objResponse->script("document.getElementById('email_c').focus()");
					$continuar = false;
				}
			}elseif($continuar && $f["email_c"]!=""){
				if ($continuar && $f['email'] != $f['email_c']) {
					$objResponse->call("mostrarError","Error en el reingreso","Error en el reingreso del correo electr&oacute;nico");
					$objResponse->script("document.getElementById('email_c').focus()");
					$continuar = false;
				}
			}
	}

	if ($continuar && $f["formarespuesta"]==2){

		if ($continuar && $f["region"]=='null'){
			$objResponse->call("mostrarError","Seleccionar regi&oacute;n","Debe seleccionar una regi&oacute;n");
			$objResponse->script("document.getElementById('region').focus()");
			$continuar = false;

		}

		if ($continuar && ($f["comuna"]=='' || $f["comuna"] == "null")){
			$objResponse->call("mostrarError","Seleccionar comuna","Debe seleccionar una comuna");
			$objResponse->script("document.getElementById('comuna').focus()");
			$continuar = false;

		}

		if ($continuar && $f["direccion"]==""){
			$objResponse->call("mostrarError","Campo vac&iacute;o","Debe ingresar un valor en el campo direcci&oacute;n");
			$objResponse->script("document.getElementById('direccion').focus()");
			$continuar = false;

		}
	}

	if ($continuar && $f["formatoentrega"]==0){
		$objResponse->call("mostrarError","Seleccione formato entrega","Seleccione un formato de entrega para la respuesta");
		$objResponse->script("document.getElementById('otroformato').focus()");
		$continuar = false;
	}

	if ($continuar && $f["formatoentrega"]==5){

		if ($continuar && $f["otroformato"]==""){
			$objResponse->call("mostrarError","Campo vac&iacute;o","Ingrese un valor en el campo otro formato");
			$objResponse->script("document.getElementById('otroformato').focus()");
			$continuar = false;

		}

	}

	if (is_array($f["adjunto"]) || is_object($f["adjunto"])){
		foreach ($f["adjunto"] as $key => $value) {
			$doc_array = explode("/",$value);

			$doc_name = $doc_array[count($doc_array) - 1];

			if ($doc_name !="") {
				$ext = strtolower(substr($doc_name,-3));
				if ($ext != 'doc' && $ext != 'xls' && $ext != 'pdf' && $ext != 'txt' && $ext != 'jpg'  && $ext != 'png' && $ext != 'gif'  ) {
					$continuar = false;
					$objResponse->call("mostrarError","Tipo de documento no v&aacute;lido","Seleccione un documento con extensi�n JPG, PNG, GIF, DOC, XLS, PDF � TXT");
				} else {
					if (file_exists($path.$f['id_oirs'].'_'.$doc_name)) {
						$continuar = false;
						$objResponse->call("mostrarError","Documento existente","Ya existe un documento con el nombre de '$doc_name'");
					}
				}
			}

			if(empty($value)){
				$objResponse->call("mostrarError","Existen vac&iacute;o","Hay adjunto/s en el que no ha seleccionado archivo/s para subir");
				$continuar = false;
			}
		}
	}
		
	if (!$continuar) {
		$objResponse->assign("enviar","value","Enviar solicitud");
		$objResponse->assign("enviar","disabled",false);
	} else {
		$objResponse->script("document.frm_tp.submit()");
	}
	return $objResponse;
}

function setRevisarFormulario($f) {
	$objResponse = new xajaxResponse();
	$continuar = true;

	if ($f["oirs"]=="") $continuar = setError($objResponse,'oirs','OIRS');
	if ($continuar && !is_numeric($f["oirs"])) {
		$objResponse->alert("Error en el ingreso del OIRS");
		$objResponse->script("document.getElementById('oirs').focus()");
		$continuar = false;
	}
	if ($continuar && $f["c"]=="") $continuar = setError($objResponse,'c','Código de Validación:');

	if ($continuar) {
		$tp_modelo = new TP_Modelo();
		$oirs = $tp_modelo->getOIRS($f["oirs"],$f["c"]);
		
		if (empty($oirs['id_oirs'])) {
			$objResponse->alert("Error en el ingreso del OIRS o Código de Validación");
			$continuar = false;
		}
	}

	if (!$continuar) {
		$objResponse->assign("buscar_oirs","value","Enviar");
		$objResponse->assign("buscar_oirs","disabled",false);
	} else {
		$objResponse->script("document.frm_oirs.submit()");
	}
	
	return $objResponse;
}

function setRecuperarOIRS($f) {
	$objResponse = new xajaxResponse();
	$continuar = true;
	

	if ($f["iduser"]=="" && $f["mailuser"]=="")   {
		$objResponse->alert("Debes seleccionar y completar al menos una de las opciones");	
		$continuar = false;
	}
	
		if ($f["iduser"]!="" && $f["mailuser"]=="") {
			
			if(!is_numeric($f["iduser"])) {
				$objResponse->alert("ID debe ser numerico");
				$continuar =false;			
			}else {
			
			$tp_modelo = new TP_Modelo();
			$contacto_modelo = new Contacto_Modelo();
			$activo = $tp_modelo->getUsuarioOirsCiuID($f['iduser']);
			$enviarpass = $activo==0 ? false : true;
			$usuario = $tp_modelo->getUsuarioxid($f["iduser"],$enviarpass);
			$activo = $tp_modelo->getUsuarioOirsCiuActivoID($f['iduser']);	
						
			if(!$usuario['existe']) {
				$objResponse->alert(utf8_encode("No existe un usuario con los datos ingresados"));	
				$continuar =false;						
			}elseif($usuario['existe'] && $activo==1) {
				$objResponse->alert(utf8_encode("Contraseña despachada al correo"));	
			}elseif($usuario['existe'] && $activo==0){
				$objResponse->alert(utf8_encode("Esta cuenta aún no se encuentra activada\nRevise su bandeja de correo"));
				$continuar =false;	
			}		
		}
	}
	
	elseif ($f["iduser"]=="" && $f["mailuser"]!="") {
				
			if ($continuar && !preg_match(
				'/^[^0-9][a-zA-Z0-9_]+([.][a-zA-Z0-9_]+)*[@][a-zA-Z0-9_]+([.][a-zA-Z0-9_]+)*[.][a-zA-Z]{2,4}$/',$f["mailuser"])) {
				$objResponse->alert("Error en el ingreso del E-mail");
				$objResponse->script("document.getElementById('email').focus()");
				$continuar =false;
			}else {
				$tp_modelo = new TP_Modelo();
				$contacto_modelo = new Contacto_Modelo();
				$activo = $tp_modelo->getUsuarioOirsCiuEmail($f['mailuser']);
				$enviarpass = $activo==0 ? false : true;
				$mail = $tp_modelo->getUsuarioxemail($f["mailuser"],$enviarpass);	
				
							
			if(!$mail['existe']) {
				$objResponse->alert(utf8_encode("No existe un usuario con los datos ingresados"));	
				$continuar =false;						
			}elseif($mail['existe'] && $activo==1) {
				$objResponse->alert(utf8_encode("Contraseña despachada al correo"));	
			}elseif($mail['existe'] && $activo==0){
				$objResponse->alert(utf8_encode("Esta cuenta aún no se encuentra activada\nRevise su bandeja de correo"));
				$continuar =false;	
			}
		}
	
	}else {
		 	 $objResponse->alert(utf8_encode("Ocurrió un error mientras se enviaban los datos."));
		 	 $continuar = false;
	}
	
	if (!$continuar) {
			$objResponse->assign("enviar","value","Enviar");
			$objResponse->assign("enviar","disabled",false);
	}else { 
			$objResponse->script("document.frm_oirs.submit()");		
	}
		return $objResponse;		
}

function responderCorreccion($f){
	$objResponse = new xajaxResponse();
	$continuar = true;

	if ($f["respuesta"]=="") {
		$objResponse->call("mostrarError","Campo vac&iacute;o","Debe ingresar un valor en el campo respuesta");
		$objResponse->script("document.getElementById('respuesta').focus()");
		$continuar =false;
	}
		
	if (!$continuar) {
		$objResponse->assign("enviar","value",$f["btn"]);
		$objResponse->assign("enviar","disabled",false);
	} else {
		$objResponse->script("document.frm_tp.submit()");
	}
		
	return $objResponse;
}

$xajax = new xajax();
$xajax->register(XAJAX_FUNCTION,"setRevisarFormulario");
$xajax->register(XAJAX_FUNCTION,"setSolicitud");
$xajax->register(XAJAX_FUNCTION,"setRecuperarOIRS");
$xajax->register(XAJAX_FUNCTION,"setRellenarComuna");
$xajax->register(XAJAX_FUNCTION,"rellenarFormatos");
$xajax->register(XAJAX_FUNCTION,"responderCorreccion");
$xajax->processRequest();

?>