<?php
require("../../configuraciones/include_xajax.cfg.php");

function setRellenarComuna($id_region) {
		$objResponse = new xajaxResponse();
		$continuar = true;

		$objResponse->script("document.getElementById('comuna').length=0;");

		$comunas = array();
		$tp_modelo = new TP_Modelo();
		$comunas = $tp_modelo->getComuna($id_region);

		foreach($comunas as $sOptionValue=>$sOptionText) {

			if($id_region!="null"){
					$sScript = "var objOption = new Option('".utf8_encode($sOptionText)."','$sOptionValue');";
				}else{
					$sScript = "var objOption = new Option('Seleccione comuna','null');";
				}
			if($sOptionValue == ""){
					$sScript .= "var objOption = new Option('Seleccione una comuna','null');";
				}
			$sScript .= "document.getElementById('comuna').options.add(objOption);";
			$objResponse->script($sScript);
		}

		return $objResponse;
	}

function setRellenarComunaApoderado($id_region) {
		$objResponse = new xajaxResponse();
		$continuar = true;

		$objResponse->script("document.getElementById('comuna_apoderado').length=0;");

		$comunas = array();
		$tp_modelo = new TP_Modelo();
		$comunas = $tp_modelo->getComuna($id_region);

		foreach($comunas as $sOptionValue=>$sOptionText) {
			$sScript = "var objOption = new Option('".utf8_encode($sOptionText)."','$sOptionValue');";
			$sScript .= "document.getElementById('comuna_apoderado').options.add(objOption);";
			$objResponse->script($sScript);
		}

		return $objResponse;
	}

function setRevisarFormulario($f) {
	$objResponse = new xajaxResponse();
	$continuar = true;
	$tp_modelo = new TP_Modelo();

	if($continuar && $f["tipopersona"] == 2){

		if($continuar && $f["razonsocial"] == ""){
				$objResponse->call("mostrarError","Campo vac&iacute;o","Debe ingresar un valor para el campo raz&oacute;n social");
				$objResponse->script("document.getElementById('razonsocial').focus()");
				$continuar = false;	
		}

		if($continuar && $f["tipodireccion"] == 1){

			if($continuar && $f["email"] == ""){
				$objResponse->call("mostrarError","Campo vac&iacute;o","Falta ingresar el campo correo electr&oacute;nico del solicitante");
				$objResponse->script("document.getElementById('email').focus()");
				$continuar =false;
			}

			if ($continuar && $f["email"] != "" && !preg_match('/^[a-zA-Z0-9\-._]+([.][a-zA-Z0-9_]+)*[@][a-zA-Z0-9_]+([.][a-zA-Z0-9_]+)*[.][a-zA-Z]{2,4}$/',$f['email'])) {
				$objResponse->call("mostrarError","Error","Error en el ingreso del correo electr&oacute;nico");
				$objResponse->script("document.getElementById('email').focus()");
				$continuar =false;
			}

			$mail = $tp_modelo->getEmailxId($_SESSION['id_usuario']);

			if($continuar && ($f['email'] != $mail["email"])){
				if ($continuar && $f['email'] != $f['email_c']) {
					$objResponse->call("mostrarError","Error en el reingreso","Error en el reingreso del correo electr&oacute;nico");
					$objResponse->script("document.getElementById('email_c').focus()");
					$continuar = false;
				}
			}elseif($continuar && $f["email_c"]!=""){
				if ($continuar && $f['email'] != $f['email_c']) {
					$objResponse->call("mostrarError","Error en el reingreso","Error en el reingreso del correo electr&oacute;nico");
					$objResponse->script("document.getElementById('email_c').focus()");
					$continuar = false;
				}
			}
		}

		if($continuar && $f["tipodireccion"] == 2){
			if ($continuar && $f["region"]=='null'){
				$objResponse->call("mostrarError","Regi&oacute;n no seleccionada","Debe seleccionar una regi&oacute;n ");
				$objResponse->script("document.getElementById('region').focus()");
				$continuar = false;
			}

			if ($continuar && ($f["comuna"]=='' || $f["comuna"]=='null')){
				$objResponse->call("mostrarError","Comuna no seleccionada","Debe seleccionar una comuna");
				$objResponse->script("document.getElementById('comuna').focus()");
				$continuar = false;
			}

			if ($continuar && $f["direccion"]==""){
				$objResponse->call("mostrarError","Campo vac&iacute;o","Debe ingresar un valor para el campo direcci&oacute;n");
				$objResponse->script("document.getElementById('direccion').focus()");
				$continuar = false;
			}
		}

		if($continuar && $f["tieneapoderado"]=="on"){
			if ($continuar && $f["nombreapoderado"]==""){
				$objResponse->call("mostrarError","Campo vac&iacute;o","Debe ingresar un valor para el campo nombre del apoderado");
				$objResponse->script("document.getElementById('nombreapoderado').focus()");
				$continuar = false;
			}

			if ($continuar && $f["apellidosapoderado_paterno"]==""){
				$objResponse->call("mostrarError","Campo vac&iacute;o","Debe ingresar un valor para el campo apellido paterno del apoderado");
				$objResponse->script("document.getElementById('nombreapoderado').focus()");
				$continuar = false;
			}	
		}
	}



	if($continuar && $f["tipopersona"] == 1){

		if ($continuar && $f["nombre"]==""){
			$objResponse->call("mostrarError","Campo vac&iacute;o","Debe ingresar un valor para el campo nombre del solicitante");
			$objResponse->script("document.getElementById('nombre').focus()");
			$continuar = false;
		}
		if ($continuar && $f["apellido_paterno_ciudadano"]==""){
			$objResponse->call("mostrarError","Campo vac&iacute;o","Debe ingresar un valor para el campo apellido paterno del solicitante");
			$objResponse->script("document.getElementById('apellido_paterno_ciudadano').focus()");
			$continuar = false;
		}

		if ($continuar && $f["tipodireccion"] == 1){

			if($continuar && $f["email"] == "" && $f["correo_apoderado"]==""){
				$objResponse->call("mostrarError","Campo vac&iacute;o","Falta ingresar el campo correo electr&oacute;nico para el solicitante o apoderado");
				$objResponse->script("document.getElementById('email').focus()");
				$continuar =false;
			}

			if ($continuar && $f["email"] !="" && !preg_match(
			'/^[a-zA-Z0-9\-._]+([.][a-zA-Z0-9_]+)*[@][a-zA-Z0-9_]+([.][a-zA-Z0-9_]+)*[.][a-zA-Z]{2,4}$/',$f["email"])) {

				$objResponse->call("mostrarError","Error en el ingreso","Error en el ingreso del correo electr&oacute;nico");
				$objResponse->script("document.getElementById('email').focus()");
				$continuar =false;
			}

			$mail = $tp_modelo->getEmailxId($_SESSION['id_usuario']);
			if($continuar && ($f['email'] != $mail["email"])){
				if ($continuar && $f['email'] != $f['email_c']) {
					$objResponse->call("mostrarError","Error en el reingreso","Error en el reingreso del correo electr&oacute;nico");
					$objResponse->script("document.getElementById('email_c').focus()");
					$continuar = false;
				}
			}elseif($continuar && $f["email_c"]!=""){
				if ($continuar && $f['email'] != $f['email_c']) {
					$objResponse->call("mostrarError","Error en el reingreso","Error en el reingreso del correo electr&oacute;nico");
					$objResponse->script("document.getElementById('email_c').focus()");
					$continuar = false;
				}
			}
		}

		if($continuar && $f["tipodireccion"] == 2){
			if ($continuar && $f["region"]=='null'){
				$objResponse->call("mostrarError","Regi&oacute;n no seleccionada","Debe seleccionar una regi&oacute;n");
				$objResponse->script("document.getElementById('region').focus()");
				$continuar = false;
			}

			if ($continuar && $f["comuna"]=='null'){
				$objResponse->call("mostrarError","Comuna no seleccionada","Debe seleccionar una comuna");
				$objResponse->script("document.getElementById('comuna').focus()");
				$continuar = false;
			}
			if ($continuar && $f["direccion"]==""){
				$objResponse->call("mostrarError","Campo vac&iacute;o","Debe ingresar un valor para el campo direcci&oacute;n");
				$objResponse->script("document.getElementById('direccion').focus()");
				$continuar = false;
			}
		}

		if($continuar && $f["tieneapoderado"]=="on"){
			if ($continuar && $f["nombreapoderado"]==""){
				$objResponse->call("mostrarError","Campo vac&iacute;o","Debe ingresar un valor para el campo nombre del apoderado");
				$objResponse->script("document.getElementById('nombreapoderado').focus()");
				$continuar = false;
			}
			if ($continuar && $f["apellidosapoderado_paterno"]==""){
				$objResponse->call("mostrarError","Campo vac&iacute;o","Debe ingresar un valor para el campo apellido paterno del apoderado");
				$objResponse->script("document.getElementById('apellidosapoderado_paterno').focus()");
				$continuar = false;
			}
		}
	}


	if (!$continuar) {
		$objResponse->assign("continuar","value","Continuar");
		$objResponse->assign("continuar","disabled",false);
	} else {
		$objResponse->script("document.frm_tp.submit()");
	}

	return $objResponse;
}

$xajax = new xajax();
$xajax->register(XAJAX_FUNCTION,"setRevisarFormulario");
$xajax->register(XAJAX_FUNCTION,"setRellenarComuna");

$xajax->processRequest();

?>
