<?php
	require("../../configuraciones/include_xajax.cfg.php");

	function setCheckPass($f) {
		$objResponse = new xajaxResponse();
		$tp_modelo = new TP_Modelo();
		$continuar = true;

		if ($continuar && $f["id_ciudadano"]=="") {
			$objResponse->call("mostrarError","Error","Falta ingresar ID o email de ciudadano");
			$continuar = false;
		}

		if ($f["pass"]=="" && $continuar){
			$objResponse->call("mostrarError","Error","Debe ingresar un valor en el campo contraseña");
			$continuar = false;
		}

		if ($continuar) {
			$usuario = $tp_modelo->getLogin($f["id_ciudadano"],$f['pass']);
			if (!$usuario['existe']) {
				$continuar = false;
				$objResponse->call("mostrarError","Error","Error en al iniciar sesión. Verifique los datos ingresados");
				$objResponse->script("document.getElementById('pass').focus()");
				$objResponse->script("document.getElementById('pass').value=''");
			} else {
				$_SESSION['id_usuario'] = $usuario['id_usuario'];
			}
		}

		if($continuar) {
			$ciu_activo = $tp_modelo->getUsuarioOirsCiuID($_SESSION['id_usuario']);
			if ($ciu_activo["email_activado"] !=1 && !$ciu_activo["no_registrado"]) {
				$continuar = false;
				$objResponse->call("mostrarError","Error al iniciar sesión","Esta cuenta aún no está activada. Revise el email de activación en su bandeja de correo");
				$objResponse->script("document.getElementById('pass').focus()");
				$objResponse->script("document.getElementById('pass').value=''");
				session_destroy();
			}else if($ciu_activo["no_registrado"]){
				$continuar = false;
				$objResponse->call("mostrarError","Área restringida","Usted no tiene permitido ingresar a esta área del sistema");
				$objResponse->script("document.getElementById('id_ciudadano').focus()");
				$objResponse->script("document.getElementById('id_ciudadano').value=''");
				$objResponse->script("document.getElementById('pass').value=''");
				session_destroy();
			} else {
				$_SESSION['id_usuario'] = $usuario['id_usuario'];
			}
		}

		if (!$continuar) {
			$objResponse->assign("aceptar","disabled",false);
		} else {
			$objResponse->script("document.login.submit();");
		}
		return $objResponse;
	}

	$xajax = new xajax();
	$xajax->register(XAJAX_FUNCTION,"setCheckPass");
	$xajax->processRequest();
?>
