<?php
require("../../configuraciones/include_xajax.cfg.php");

function setRellenarComuna($id_region) {
		$objResponse = new xajaxResponse();
		$continuar = true;

		$objResponse->script("document.getElementById('comuna').length=0;");

		$comunas = array();
		$tp_modelo = new TP_Modelo();
		$comunas = $tp_modelo->getComuna($id_region);

		foreach($comunas as $sOptionValue=>$sOptionText) {
				if($id_region!="null"){
					$sScript = "var objOption = new Option('".utf8_encode($sOptionText)."','$sOptionValue');";
				}else{
					$sScript = "var objOption = new Option('Seleccione comuna','null');";
				}
				if($sOptionValue == ""){
				$sScript .= "var objOption = new Option('Seleccione una comuna','null');";
			}
				$sScript .= "document.getElementById('comuna').options.add(objOption);";
				$objResponse->script($sScript);
		}

		return $objResponse;
	}

function setRevisarFormulario($f) {
	$objResponse = new xajaxResponse();
	$continuar = true;

	if ($continuar && $f["nombre"]=="") {
		$objResponse->call("mostrarError","Campo vacío","Debe ingresar un valor para el campo nombre");
		$continuar = false;
	}

	if ($continuar && $f["apellido_paterno_ciudadano"]=="") {
		$objResponse->call("mostrarError","Campo vacío","Debe ingresar un valor para el campo apellido paterno");
		$continuar = false;
	}

	if ($continuar && ($f["email"]=="" && $f["action"] == "ciudadano_agregar")) {
		$objResponse->call("mostrarError","Campo vacío","Debe ingresar un valor para el campo correo electrónico");
		$continuar = false;
	}

	if ($continuar && $f["email"]!=""){
		if ($continuar && !preg_match(
		'/^[^0-9][a-zA-Z0-9\-._]+([.][a-zA-Z0-9_]+)*[@][a-zA-Z0-9_]+([.][a-zA-Z0-9_]+)*[.][a-zA-Z]{2,4}$/',$f["email"])) {
			$objResponse->call("mostrarError","Error en el ingreso del correo","Debe ingresar un valor correcto para el campo correo electrónico");
			$objResponse->script("document.getElementById('email').focus()");
			$continuar =false;
		}
	}

	if($continuar && ($f["direccion"]!="" || $f["localidad"]!="") && $f["region"]=="null"){
		$objResponse->call("mostrarError","Completar datos","Complete los datos de la dirección postal");
		$objResponse->script("document.getElementById('comuna').focus()");
		$continuar =false;
	}


	if($continuar && $f["region"]!="null" && ($f["comuna"]=="null" || $f["comuna"]=="")){
		$objResponse->call("mostrarError","Seleccione comuna","Debe seleccionar una comuna");
		$objResponse->script("document.getElementById('comuna').focus()");
		$continuar =false;
	}

	if($continuar && $f["telefono"]!="" && !is_numeric($f["telefono"])){
		$objResponse->call("mostrarError","Error","Debe ingresar solo números para el campo teléfono");
		$objResponse->script("document.getElementById('telefono').focus()");
		$continuar =false;
	}

	if ($continuar) {
			$tp_modelo = new TP_Modelo();

			if($f["email"]!="" && $f["action"]!="ciudadano_modificar"){

			$mail = $tp_modelo->getEmail($f["email"]);

			$activo = $tp_modelo->getUsuarioOirsCiuEmail($f['email']);
			date_default_timezone_set('America/Santiago');
				$ciudadano_datos = $tp_modelo->getDatosCiudadanoRegistrado($f['email']);
				if($mail['existe'] && $ciudadano_datos['email_activado'] == 0 && $ciudadano_datos['no_registrado'] == 0 && (strtotime($ciudadano_datos["caduca"]) > strtotime(date("Y-m-d H:i:s")))) {
				 $objResponse->call("mostrarError","Correo electrónico ya registrado","Este correo electrónico ya ha sido registrado, pero no se ha activado la cuenta aún, \nse ha reenviado un correo para su activación");
				 $contacto_pasiva_modelo = new Contacto_Pasiva_Modelo();
				 $contacto_pasiva_modelo->reenvioRegistroUsuario($ciudadano_datos);
				 $continuar = false;
			 }elseif($mail['existe'] && $ciudadano_datos['email_activado'] == 1 && $ciudadano_datos['no_registrado'] == 0) {
						$objResponse->call("mostrarError","Correo electrónico ya registrado","Este correo electrónico ya ha sido registrado");
						$continuar = false;
				}
			}
		}

	if (!$continuar) {
		$objResponse->assign("registrar","value",$f["btn"]);
		$objResponse->assign("registrar","disabled",false);
	} else {
		$objResponse->script("document.frm_tp.submit()");
	}

	return $objResponse;
}

$xajax = new xajax();
$xajax->register(XAJAX_FUNCTION,"setRevisarFormulario");
$xajax->register(XAJAX_FUNCTION,"setRellenarComuna");

$xajax->processRequest();

?>
