<?php
	// Portable UTF-8
	use voku\helper\UTF8;
	class SolicitudAgregarNoRegistroAction extends Action {

		function perform($actionMapping,$actionForm) {

			$index_vista = new Index_Vista();
			$tp_modelo = new TP_Modelo();

			if (!is_object($actionForm)) {
				$actionForward = null;

				if(isset($_SESSION['id_usuario_parcial'])){
					$datos_solicitante = $tp_modelo->getSolicitante($_REQUEST['id_solicitante']);
                    $forma_respuesta = $tp_modelo->decodificarJSON(_BASE."data/forma_respuesta/formas.json");
					$formato_entrega = $tp_modelo->decodificarJSON(_BASE."data/formatos/formato_inicial.json");
                    $regiones = $tp_modelo->getRegion();
					
					
					
					$deps_ciu = $tp_modelo->getDepsOIRSCiu();
					$id_usuario = $_SESSION["id_usuario_parcial"];
					$solicitud_manual = ($datos_solicitante['numero_papel'] != NULL && $datos_solicitante['fecha_solicitud']);
					$index_vista->solicitudAgregarNoRegistro($datos_solicitante,$forma_respuesta,$formato_entrega,$regiones,$deps_ciu,$id_usuario,$solicitud_manual,$datos_solicitante['fecha_solicitud']);
				}else{
					header("Location: index.php?action=oirs");
				}
			} else {
				$cmps = array();

				$cmps['id_ciudadano'] = $_POST['id_ciudadano'];
				$cmps['id_solicitante'] = $_POST['id_solicitante'];
				$cmps['id_tipo'] = 5;             
				$cmps['id_organo_ciu'] = $_POST['dep_ciu'];
                $cmps['id_organo'] = 1;
				$cmps['nombre_dep_ciu'] = $tp_modelo->getDepsCiuNombre($_POST['dep_ciu']);
				$cmps['fecha'] = isset($_POST['fecha_solicitud']) ? $_POST['fecha_solicitud'] : date('Y-m-d H:i:s');
				$cmps['mensaje'] = htmlentities($_POST['mensaje'],ENT_COMPAT,'UTF-8');
				$cmps['observaciones'] = htmlentities($_POST['observaciones'],ENT_COMPAT,'UTF-8') === "" ? NULL : htmlentities($_POST['observaciones'],ENT_COMPAT,'UTF-8');
				$cmps['formato_entrega'] = $_POST['formatoentrega'];

				if($_POST["formatoentrega"] == 5 ){
					$cmps['otro_formato'] = htmlentities($_POST["otroformato"],ENT_COMPAT,'UTF-8');
				}
				$cmps['tipo_respuesta'] = $_POST['formarespuesta'];
				$cmps['tramitado'] = 0;
				$cmps['id_estado'] = 'EP';

				if($_POST['formarespuesta'] == 1){
					$cmps['email_oirs'] = $_POST['email'];
					$cmps['envio_email'] = 1;
				}

				if($_POST['formarespuesta'] == 2){
					$cmps['region_oirs'] = $_POST['region'];
					$cmps['comuna_oirs'] = $_POST['comuna'];
					$cmps['direccion_oirs'] = $_POST['direccion'];
					$cmps['localidad_oirs'] = $_POST['localidad'];
				}

				do{
					$a = uniqid();
					$code = substr($a, 5);
					//echo $a;

				}while($tp_modelo->existeCodigo($code));

				$cmps['cod_solicitud'] = $code;


				$tipo = $tp_modelo->getTiposOIRSxId($cmps['id_tipo']);
				$cmps["solicitud_informacion"] = $tipo["solicitud_informacion"];

				$fecha = $tp_modelo->fechaValida($cmps['fecha'], $tipo["plazo"]);
				$cmps['fecha_maxima_respuesta'] = $fecha;
				$cmps['solicitud_manual'] = $_POST['solicitud_manual'];

				$tp_modelo = new TP_Modelo();
				$contacto_pasiva_modelo = new Contacto_Pasiva_Modelo();

				$tp_modelo->Start();
				$ok = true;

				if ($tp_modelo->setAgregarOIRS($cmps)) {
					$id_oirs = $tp_modelo->setInsertID();
					$cmp_historial['id_estado'] = 'EP';
					$cmp_historial['id_oirs'] = $id_oirs;
					$cmp_historial['id_organo'] = $_POST['dep_ciu'];
					$cmp_historial['fecha'] = date('Y-m-d H:i:s');

					if($ok){
						if(!$tp_modelo->setAgregarHistorial($cmp_historial)){
							$tp_modelo->FailTrans();
							$ok = false;
						}

						/* Insertar archivos */
						if (isset($_FILES['adjunto'])) {
						$tot = count($_FILES['adjunto']["name"]);
						$adjuntos = $_FILES['adjunto']["name"];

						$count = 0;
						foreach($adjuntos as $x){
							$adjuntos_visibles[$count] = 0;
							$count ++;
						}

						for ($i = 0; $i < $tot; $i++){
							$cmps_adj = array();
							$cmps_adj['id_oirs'] = $id_oirs;
							$cmps_adj['id_organo'] = 1;
							$cmps_adj['fecha_hora'] = date("Y-m-d H:m:s");
							$cmps_adj['publico'] = 1;
							$idhistorial = $tp_modelo->getIDHistorial();
						    $cmps_adj['id_historial'] = $idhistorial;
							$fp = fopen($_FILES['adjunto']['tmp_name'][$i], 'rb');
							$content = fread($fp, $_FILES['adjunto']['size'][$i]);
							fclose($fp);

							$cmps_adj['adjunto'] = $content;
							$cmps_adj['nombre'] = $_FILES['adjunto']['name'][$i];
							$cmps_adj['tipo'] = $_FILES['adjunto']['type'][$i];

							$tp_modelo->AgregarAdjunto($cmps_adj);

							}
						}

					/* Fin insertar archivos */

					}

					$funcionario = $tp_modelo->getFuncionario(1);
					
					if($cmps['envio_email'] == 1 && $_POST["formarespuesta"] == 1){
						$datos_solicitud = $tp_modelo->getOIRSxId($id_oirs);
						$datos_solicitante = $tp_modelo->getUsuario($datos_solicitud["id_ciudadano"]);
						$contacto_pasiva_modelo->enviarCopiaSolicitudCorreo($datos_solicitud,$cmps["email_oirs"],$datos_solicitante);
					}

					$datos_ciudadano = $tp_modelo->getUsuario($cmps["id_ciudadano"]);
					$datos_solicitante = $tp_modelo->getSolicitante($cmps["id_solicitante"]);
					$contacto_pasiva_modelo->enviarSolicitudPasiva($cmps,$id_oirs,$funcionario,$datos_ciudadano,$datos_solicitante);
					$ok = true;
				} else {
					$ok = false;
					$tp_modelo->FailTrans();
				}

				$tp_modelo->End();

				if($ok){
					$actionForward = $actionMapping->get("mantenedor");
					//$actionForward->setAttribute("id_oirs",$cmp_historial['id_oirs']);
					if ($_POST['solicitud_manual']) {
						$actionForward->setAttribute("sm",$_POST['solicitud_manual']);
					}
					unset($_SESSION["id_usuario_parcial"]);
					$_SESSION['id_tp'] = $id_oirs;
				} else {
					$actionForward = $actionMapping->get("formulario");
				}
			}
			return $actionForward;
		}
	}
?>
