<?php
	// Portable UTF-8
	use voku\helper\UTF8;
	class SolicitanteAgregarNoRegistroAction extends Action {

		private function format_date($date){
			$ex = explode(" ", $_POST['fecha_solicitud']);
			$date = explode("/", $ex[0]);
			return date("{$date[2]}-{$date[1]}-{$date[0]} {$ex[1]}");
		}

		function perform($actionMapping,$actionForm) {

		$tp_modelo = new TP_Modelo();
		$index_vista = new Index_Vista();

		if (!is_object($actionForm)) {
			$actionForward = null;
			$datos_usuario = $tp_modelo->getUsuario($_SESSION['id_usuario']);
			$regiones = $tp_modelo->getRegion();
			
			array_walk_recursive($regiones, function (&$value) {
	            //Elimina el caracter BOM si lo tiene.
	            $value = UTF8::remove_bom($value);
	            //Convierte a iso-8859-1 si detecta utf-8, si no no realiza cambios.
	            if (UTF8::str_detect_encoding($value) == 'UTF-8'){
	                $value = UTF8::utf8_decode($value);
	            } else {
	                $value = UTF8::utf8_encode($value);
	            }
	        });

			if($_POST['numero_solicitud'] && $_POST['fecha_solicitud']){
				$numero_solicitud = $_POST['numero_solicitud'];
				$fecha_solicitud = $this->format_date($_POST['fecha_solicitud']);
                if (isset($_SESSION["id_usuario"])){
                    unset($_SESSION["id_usuario"]);
                }
                
			} 
            
			$index_vista->solicitanteAgregarNoRegistro($datos_usuario,$regiones,$numero_solicitud,$fecha_solicitud);

		} else {
		        if($_POST['numero_solicitud'] && $_POST['fecha_solicitud']){
                    $numero_solicitud = $_POST['numero_solicitud'];
                    $fecha_solicitud = $this->format_date($_POST['fecha_solicitud']);
                    if (isset($_SESSION["id_usuario"])){
                        unset($_SESSION["id_usuario"]);
                    }
                    
                } 
            
				$cmps = array();

				$cmp_usuario['contrasena'] = uniqid();
				$cmp_usuario['codigo_activacion'] = $tp_modelo->codigoActivacion();
				$cmp_usuario['tipo'] = 'ciudadano';

				if($_POST["tipopersona"] == 1){
					$cmp_solicitante['tipo'] = $_POST["tipopersona"];
					$cmp_solicitante['nombre'] = htmlentities($_POST['nombre'],ENT_COMPAT,'UTF-8');
					$cmp_solicitante['apellido_paterno_ciudadano'] = htmlentities($_POST['apellido_paterno_ciudadano'],ENT_COMPAT,'UTF-8');
					$cmp_solicitante['apellido_materno_ciudadano'] = htmlentities($_POST['apellido_materno_ciudadano'],ENT_COMPAT,'UTF-8');
				}elseif($_POST["tipopersona"] == 2){
					$cmp_solicitante['razon_social'] = htmlentities($_POST['razonsocial']);
					$cmp_solicitante['tipo'] = $_POST["tipopersona"];
				}

				if($_POST["tipodireccion"] == 1){
					$cmp_solicitante['email'] = $_POST['email'];
					$cmp_solicitante['email_o_postal'] = $_POST["tipodireccion"];
				}elseif($_POST["tipodireccion"] == 2){
					$cmp_solicitante['direccion'] = htmlentities($_POST['direccion'],ENT_COMPAT,'UTF-8');
					$cmp_solicitante['region'] = $_POST['region'];
					$cmp_solicitante['comuna'] = $_POST['comuna'];
					$cmp_solicitante['localidad'] = htmlentities($_POST['localidad'],ENT_COMPAT,'UTF-8');
					$cmp_solicitante['email_o_postal'] = $_POST["tipodireccion"];
				}

				if($_POST["tieneapoderado"] == 'on'){
					$cmp_solicitante['apoderado'] = 1;
					$cmp_solicitante['nombre_apoderado'] = htmlentities($_POST['nombreapoderado'],ENT_COMPAT,'UTF-8');
					$cmp_solicitante['ap_paterno_apoderado'] = htmlentities($_POST['apellidosapoderado_paterno'],ENT_COMPAT,'UTF-8');
					$cmp_solicitante['ap_materno_apoderado'] = htmlentities($_POST['apellidosapoderado_materno'],ENT_COMPAT,'UTF-8');
				}

				if ($_POST['numero_solicitud'] && $_POST['fecha_solicitud']) {
					$cmp_solicitante['numero_papel'] = $_POST['numero_solicitud'];
					$cmp_solicitante['fecha_solicitud'] = $_POST['fecha_solicitud'];
				}

				$cmp_solicitante['telefono'] = $_POST['telefono'] == 0 ? NULL : $_POST['telefono'];
				$cmp_solicitante['no_registrado'] = true;

				$tp_modelo->Start();
				$ok = true;

				if ($tp_modelo->setAgregarUsuario($cmp_usuario)) {

					$id_usuario = $tp_modelo->setInsertID();
					$cmp_solicitante['id_ciudadano'] = "$id_usuario";

					if(!$tp_modelo->setAgregarCiudadano($cmp_solicitante)){
						$tp_modelo->FailTrans();
						$ok = false;
					}

					if ($tp_modelo->setAgregarSolicitante($cmp_solicitante)) {

						$id_solicitante = $tp_modelo->setInsertID();
 						$cmp_solicitante['id_solicitante'] = "$id_solicitante";

					} else {
						$ok = false;
						$tp_modelo->FailTrans();
					}
				} else {
					$ok = false;
					$tp_modelo->FailTrans();
				}

				$tp_modelo->End();

				if($ok){
					$_SESSION['id_usuario_parcial'] = $id_usuario;
					$actionForward = $actionMapping->get("oirs");
					$actionForward->setAttribute("id_solicitante",$cmp_solicitante['id_solicitante']);
				} else {
					$actionForward = $actionMapping->get("formulario");
				}
			}
			return $actionForward;
		}
	}
?>
