<?php
	// Portable UTF-8
	use voku\helper\UTF8;
	class SolicitanteAgregarAction extends Action {
		function perform($actionMapping,$actionForm) {

		$tp_modelo = new TP_Modelo();	
		$index_vista = new Index_Vista();
			
		if (!is_object($actionForm)) {
			$actionForward = null;

      		if(isset($_SESSION['id_usuario'])){
				$datos_usuario = $tp_modelo->getUsuario($_SESSION['id_usuario']);
				$tipos_oirs = $tp_modelo->getTiposOIRS();
				$regiones = $tp_modelo->getRegion();
				$index_vista->solicitanteAgregar($datos_usuario,$tipos_oirs,$regiones);
				
				array_walk_recursive($regiones, function (&$value) {
		            //Elimina el caracter BOM si lo tiene.
		            $value = UTF8::remove_bom($value);
		            //Convierte a iso-8859-1 si detecta utf-8, si no no realiza cambios.
		            if (UTF8::str_detect_encoding($value) == 'UTF-8'){
		                $value = UTF8::utf8_encode($value);
		            } else {
		                $value = UTF8::utf8_decode($value);
		            }
		        });
				
				
			}else{
				header("Location: index.php?action=oirs");			
			}

		} else {
				$cmp_solicitante = array();
				
				if($_POST["tipopersona"]==1){
					$cmp_solicitante['tipo'] = 1;		
					$cmp_solicitante['nombre'] = htmlentities($_POST['nombre'],ENT_COMPAT,'UTF-8');		
					$cmp_solicitante['apellido_paterno_ciudadano'] = htmlentities($_POST['apellido_paterno_ciudadano'],ENT_COMPAT,'UTF-8');
					$cmp_solicitante['apellido_materno_ciudadano'] = htmlentities($_POST['apellido_materno_ciudadano'],ENT_COMPAT,'UTF-8');
				}elseif($_POST["tipopersona"]==2){
					$cmp_solicitante['razon_social'] = htmlentities($_POST['razonsocial'],ENT_COMPAT,'UTF-8');
					$cmp_solicitante['tipo'] = 2;
				}

				if($_POST["tipodireccion"]==1){
					$cmp_solicitante['email'] = $_POST['email'];
					$cmp_solicitante['email_o_postal'] = 1;
				}elseif($_POST["tipodireccion"]==2){
					$cmp_solicitante['direccion'] = htmlentities($_POST['direccion'],ENT_COMPAT,'UTF-8');
					$cmp_solicitante['region'] = $_POST['region'];
					$cmp_solicitante['comuna'] = $_POST['comuna'];
					$cmp_solicitante['localidad'] = htmlentities($_POST['localidad'],ENT_COMPAT,'UTF-8');
					$cmp_solicitante['email_o_postal'] = 2;
				}

				if($_POST["tieneapoderado"] == 'on'){
					$cmp_solicitante['apoderado'] = 1;
					$cmp_solicitante['nombre_apoderado'] = htmlentities($_POST['nombreapoderado'],ENT_COMPAT,'UTF-8');
					$cmp_solicitante['ap_paterno_apoderado'] = htmlentities($_POST['apellidosapoderado_paterno'],ENT_COMPAT,'UTF-8');
					$cmp_solicitante['ap_materno_apoderado'] = htmlentities($_POST['apellidosapoderado_materno'],ENT_COMPAT,'UTF-8');
				}

				$cmp_solicitante['telefono'] = $_POST['telefono']==0 ? NULL : $_POST['telefono'];
				
				$tp_modelo = new TP_Modelo();
				
				$tp_modelo->Start();	
				$ok = true;

				if ($tp_modelo->setAgregarSolicitante($cmp_solicitante)) {
					
					$id_solicitante = $tp_modelo->setInsertID();
					$cmp_solicitante['id_solicitante'] = "$id_solicitante";					
					
				} else {
					$ok = false;
					$tp_modelo->FailTrans();								
				}
				
				$tp_modelo->End();
				
				if($ok){
					$actionForward = $actionMapping->get("oirs"); 
					$actionForward->setAttribute("id_solicitante",$cmp_solicitante['id_solicitante']);
					$actionForward->setAttribute("tipo_solicitud",$_POST["tipo_solicitud"]);									
				} else {
					$actionForward = $actionMapping->get("formulario");
				}
			}	
			return $actionForward;
		}
	}
?>