<?php
/**
 *	class to create Phrame Mapping arrays
 *
 *	@author		Jason E. Sweat
 *	@since		2003-01-13
 *	@package	Phrame
 */
class MappingBuilder extends Object
{
	/**
	 *	@var	array
	 */
	var $_aaMap = array(
		 _ACTION_FORMS		=> array()
		,_ACTION_MAPPINGS	=> array()
		,_ACTION_FORWARDS	=> array()
		,_ACTION_USERS		=> array()
		);

	/**
	 *	@var	array
	 */
	var $_aaOptions = array();

	/**
	 *	constructor
	 *
	 *	@return void
	 */
	function MappingBuilder()
	{
		trigger_error("MappingBuilder is a virtual class, please extend for your application");
		return false;
	}

        /**
         *      add a form to the mapping
         *
         *      "protected" function to be used by the constructor function of a derived class
         *      @param  string  $psIdent        the identifer for the form
         *      @param  string  $psType         the name of this form's class
         *      @return boolean sucess
         */
	function _AddForm($psIdent, $psType)
	{
		if (!is_string($psIdent) || 0 == strlen($psIdent)) {
			trigger_error("invalid form identifier '$psIdent'");
			return false;
		}
		if (!is_string($psType) || 0 == strlen($psType)) {
			trigger_error("invalid form type '$psType'");
			return false;
		}

		$a_new_form = array(_TYPE => $psType);
		$this->_aaMap[_ACTION_FORMS][$psIdent] = $a_new_form;
	}

	/**
	 * Add properties to forms.
	 * @param string $psIdent the identifier for the form
	 * @param string $psName the name of the property
	 * @param string $psInitial the initial value of the property
	 * @access protected
	 * @return void
	 */
	function _AddFormProperty($psIdent, $psName, $psInitial)
	{
		if (!is_string($psIdent) || 0 == strlen($psIdent)) {
			trigger_error("invalid form identifier '$psIdent'");
			return false;
		}
		if (!is_string($psName) || 0 == strlen($psName)) {
			trigger_error("invalid form property name '$psName'");
			return false;
		}

		if ( !array_key_exists(_ACTION_FORMS_PROPERTY, $this->_aaMap[_ACTION_FORMS][$psIdent]) )
		{
			$this->_aaMap[_ACTION_FORMS][$psIdent][_ACTION_FORMS_PROPERTY] = array();
		}
		$this->_aaMap[_ACTION_FORMS][$psIdent][_ACTION_FORMS_PROPERTY][$psName] = $psInitial;
	}

	/**
	 *	add a map to the mapping
	 *
	 *	"protected" function to be used by the constructor function of a derived class
	 *	@param string $psIdent Name (ID) of the mapping
	 *	@param string $psType Type (Action class name) to execute
	 *	@param string $psInput Input template to call back to if validating form fails [optional]
	 *	@param string $psForm Form associated with this mapping [optional]
	 *	@param bool $pbValidate Whether or not to validate the form [optional]
	 *	@param string $psScope Scope in which to store the form ("request" or "session") [optional]
	 *	@param bool $pbUnknown If this action is to be executed if no other action found. [optional]
	 *	@return	boolean sucess
	 */
	function _AddMapping($psIdent, $psType, $psInput, $psForm='_DEFAULT_', $pbValidate=false, $psScope='request', $pbUnknown=false, $psRoles='', $psForward=null)
	{
		if (!is_string($psIdent) || 0 == strlen($psIdent)) {
			trigger_error("invalid mapping identifier '$psIdent'");
			return false;
		}
		if ( ($psForward=='') && (!is_string($psType) || 0 == strlen($psType)) ) {
			trigger_error("invalid mapping type '$psType'");
			return false;
		}
		if ('_DEFAULT_' == $psForm) $psForm=null;
		/*if ('_DEFAULT_' == $psForm) {
			$psForm = $psIdent;
			if (!array_key_exists($psForm, $this->_aaMap[_ACTION_FORMS])) {
				trigger_error("no form mapping to '$psForm' has been established");
				return false;
			}
		}*/
		if (!is_bool($pbValidate)) {
			$pbValidate = (1 == $pbValidate);
		}

		// Lowercase the path / identity if the option is selected,
		// to repair for Windows which conveniently lowercases
		// the URL when using mod_rewrite.
		if (defined('USE_LOWERCASE_FOR_ACTIONS') && (USE_LOWERCASE_FOR_ACTIONS)) {
			$psIdent = strtolower($psIdent);
		}

		$a_new_map = array(
			 _TYPE				=> $psType
			,_NAME				=> $psForm
			,_PATH				=> $psIdent
			,_INPUT				=> $psInput
			,_VALIDATE			=> $pbValidate
			,_SCOPE				=> $psScope
			,_UNKNOWN			=> $pbUnknown
			,_SECURITY_ROLES	=> $psRoles
			,_FORWARD			=> $psForward
			,_ACTION_FORWARDS	=> array()
			);

		$this->_aaMap[_ACTION_MAPPINGS][$psIdent] = $a_new_map;
		return true;
	}

	/**
	 *	add a forward to an existing mapping
	 *
	 *	"protected" function to be used by the constructor function of a derived class
	 *	@param string $psMapIdent name (ID) of mapping
	 *	@param string $psFwdIdent name (ID) of forward
	 *	@param string $psPath path of forward
	 *	@param bool $pbRedir Redirect or normal forward. [optional]
	 *	@param bool $psEngine Which engine to use. [optional]
	 *	@return	boolean sucess
	 */
	function _AddForward($psMapIdent, $psFwdIdent, $psPath='_DEFAULT_', $pbRedir=false, $psEngine=null)
	{
		if (defined('USE_LOWERCASE_FOR_ACTIONS') && (USE_LOWERCASE_FOR_ACTIONS)) {
			$psMapIdent = strtolower($psMapIdent);
		}
		if (!array_key_exists($psMapIdent, $this->_aaMap[_ACTION_MAPPINGS])) {
			trigger_error("invalid mapping identifier '$psMapIdent'");
			return false;
		}
		if (!is_string($psFwdIdent) || 0 == strlen($psFwdIdent)) {
			trigger_error("invalid mapping forward identifier '$psFwdIdent'");
			return false;
		}
		if (!is_string($psPath) || 0 == strlen($psPath)) {
			trigger_error("invalid mapping forward path '$psPath'");
			return false;
		} elseif ('_DEFAULT_' == $psPath) {
			$psPath = $this->_aaMap[_ACTION_MAPPINGS][$psMapIdent][_INPUT];
		}
		if (!is_bool($pbRedir)) {
			$pbRedir = (1 == $pbRedir);
		}

		$a_new_fwd = array (
			 _PATH			=> $psPath
			,_REDIRECT		=> $pbRedir
			,_VIEWENGINE	=> $psEngine
			);

		$this->_aaMap[_ACTION_MAPPINGS][$psMapIdent][_ACTION_FORWARDS][$psFwdIdent] =
			$a_new_fwd;
		return true;
	}

	/**
	 * Add a welcome file.
	 * @param string $psName Name of the welcome-file
	 * @return	boolean sucess
	 */
	function _AddWelcomeFile($psPath, $pbRedir=false, $psEngine=null)
	{
		$a_new_fwd = array (
			 _PATH			=> $psPath
			,_REDIRECT		=> $pbRedir
			,_VIEWENGINE	=> $psEngine
		);
		$this->_aaMap[_WELCOME_FILE]= $a_new_fwd;
		return true;
	}

	/**
	 *	add a forward to an existing mapping
	 *
	 *	"protected" function to be used by the constructor function of a derived class
	 *	@param string $psFwdIdent name (ID) of forward
	 *	@param string $psPath path of forward
	 *	@param bool $pbRedir Redirect or normal forward. [optional]
	 *	@param bool $psEngine Which engine to use. [optional]
	 *	@return	boolean sucess
	 */
	function _AddGlobalForward($psFwdIdent, $psPath='_DEFAULT_', $pbRedir=false, $psEngine=null)
	{
		if (!is_string($psFwdIdent) || 0 == strlen($psFwdIdent)) {
			trigger_error("invalid mapping forward identifier '$psFwdIdent'");
			return false;
		}
		if (!is_string($psPath) || 0 == strlen($psPath)) {
			trigger_error("invalid mapping forward path '$psPath'");
			return false;
		} elseif ('_DEFAULT_' == $psPath) {
			$psPath = $this->_aaMap[_ACTION_MAPPINGS][$psMapIdent][_INPUT];
		}
		if (!is_bool($pbRedir)) {
			$pbRedir = (1 == $pbRedir);
		}

		$a_new_fwd = array (
			 _PATH			=> $psPath
			,_REDIRECT		=> $pbRedir
			,_VIEWENGINE	=> $psEngine
			);
		$this->_aaMap[_ACTION_FORWARDS][$psFwdIdent] = $a_new_fwd;
		return true;
	}

	/**
	 * Add a new user.
	 *	@param string $psName Name of the user
	 *	@param string $psPassword Password of the user
	 *	@param string $psRoles Comma separated list of roles
	 *	@return	boolean sucess
	 */
	function _AddUser($psName, $psPassword, $psRoles)
	{
		if (!is_string($psName) || 0 == strlen($psName)) {
			trigger_error("invalid username '$psName'");
			return false;
		}
		if (!is_string($psPassword) || 0 == strlen($psPassword)) {
			trigger_error("invalid password '$psPassword'");
			return false;
		}
		if (!is_string($psRoles) || 0 == strlen($psRoles)) {
			trigger_error("invalid role identifier '$psRoles'");
			return false;
		}
		$a_new_user = array (
			 _USER_NAME			=> $psName
			,_USER_PASSWORD		=> $psPassword
			,_SECURITY_ROLES	=> $psRoles
			);
		$this->_aaMap[_ACTION_USERS][$psName] = $a_new_user;
		return true;
	}

	/**
	 *
	 *	@return void
	 */
	function _SetOptions($psDefaultAction='ShowView'
					,$psErrorHandler='handle_error'
					,$piCache=0
					,$piErrorReporting=-1
					)
	{
		if (!1 == $piCache) {
			$piCache = 0;
		}
		if (-1 == $piErrorReporting) {
			$piErrorReporting = E_USER_ERROR | E_USER_WARNING | E_USER_NOTICE;
		}

		$this->_aaOptions = array(
				 _CACHE 			=> $piCache
				,_ERROR_REPORTING	=> $piErrorReporting
				,_ERROR_HANDLER		=> $psErrorHandler
				,_DEFAULT_ACTION	=> $psDefaultAction
			);
	}

	/**
	 *	retrieve mappings
	 *
	 *	@return	ActionMappings
	 */
	function &GetMappings()
	{
		return new ActionMappings($this->_aaMap);
	}

	/**
	 * Retrieve mappings array. This doesn't return an
	 * ActionMappings object, but the phrame 2.0-like mapping array.
	 * @return	array
	 */
	function GetMappingsArray()
	{
		return $this->_aaMap;
	}

	/**
	 *	retrieve option (?)
	 *
	 *	@return	array
	 */
	function &GetOptions()
	{
		return $this->_aaOptions;
	}
}

?>
