
function runslideshow(div, images, counter, width, height) {
	$(div).fadeOut(1000, function () {
		var  clientimage = images[counter];
		$(div).html('<img src="'+clientimage+'" width="'+width+'" height="'+height+'" />');
		counter = counter+1;
		if (counter>(images.length-1)) counter = 0;
		$(div).fadeIn(1000);
	});  
}



function slideshow(div, images, counter, width, height) {
	this.div = div;
	this.images = images;
	this.counter = counter;
	this.width = width;
	this.height = height;
	this.image = '';
	this.load = function () {
		this.fadein();
		this.count();
		this.change();
		var _self = this;
		setTimeout(function () {
			_self.fadeout();
		}, 3000);
	}
	this.fadein = function () {
		$(this.div).fadeIn(1000);
	}
	this.fadeout = function () {
		$(this.div).fadeOut(1000);
	}
	this.change = function () {
		$(this.div).html('<img src="'+this.image+'" width="'+this.width+'" height="'+this.height+'" />');
	}
	this.count = function () {
		this.image = this.images[this.counter];
		this.counter = this.counter+1;
		if (this.counter>(this.images.length-1)) this.counter = 0;
	}
}


function submitform() {
	// form validation
	var error = false;
	if (document.contact.name.value.length<1) {
		$("#contactname").html('<img src="/images/alert.gif" width="20" height="16" />');
		error=true;
	}
	if (!document.contact.type.selectedIndex) {
		$("#contacttype").html('<img src="/images/alert.gif" width="20" height="16" />');
		error=true;
	}
	if (!document.contact.how.selectedIndex) {
		$("#contacthow").html('<img src="/images/alert.gif" width="20" height="16" />');
		error=true;
	}
	if (!validEmail(document.contact.email.value)) {
		$("#contactemail").html('<img src="/images/alert.gif" width="20" height="16" />');
		error=true;
	}

	if (!error) {
		postData();
		displaySending();
	}
}

function displaySending() {
	$("#contactform").html('<h1>Sending</h1><img src="/images/loadingAnimation.gif" /><br /><br />');
	$("#getintouchbutton").css('background-image','none');
}

function postData() {
	$.post("/processform.php", {
		name:document.contact.name.value,
		company:document.contact.company.value,
		type:document.contact.type.selectedIndex,
		town:document.contact.town.value,
		email:document.contact.email.value,
		phone:document.contact.phone.value,
		website:document.contact.website.value,
		how:document.contact.how.selectedIndex,
		project_branding:document.contact.project_branding.checked,
		project_design:document.contact.project_design.checked,
		project_redesign:document.contact.project_redesign.checked,
		project_cms:document.contact.project_cms.checked,
		project_ecommerce:document.contact.project_ecommerce.checked,
		project_flash:document.contact.project_flash.checked,
		project_marketing:document.contact.project_marketing.checked,
		project_hosting:document.contact.project_hosting.checked,
		comments:document.contact.comments.value
	}, delayDisplayComplete);
}

function delayDisplayComplete() {
	setTimeout("displayComplete()", 1000);
}

function displayComplete() {
	$("#contactform").html('<h1>Sent. Thank You.</h1>');
	setTimeout("closePanel()", 2000);
}

function closePanel() {
	$("#contactform").slideUp("slow");
	$("#getintouchbutton").css('background-image','url(/images/getintouch-sent.gif)');
}

function checkvalid(ref, name) {
	switch (name) {
		case "contactname":
			if (ref.value.length>=1) $("#contactname").html('<img src="/images/tick.gif" width="20" height="16" />');
			else $("#contactname").html('<img src="/images/alert.gif" width="20" height="16" />');
			break;
		case "contacttype":
			if (ref.selectedIndex) $("#contacttype").html('<img src="/images/tick.gif" width="20" height="16" />');
			else $("#contacttype").html('<img src="/images/alert.gif" width="20" height="16" />');
			break;
		case "contactemail":
			if (validEmail(ref.value)) $("#contactemail").html('<img src="/images/tick.gif" width="20" height="16" />');
			else $("#contactemail").html('<img src="/images/alert.gif" width="20" height="16" />');
			break;
		case "contacthow":
			if (ref.selectedIndex) $("#contacthow").html('<img src="/images/tick.gif" width="20" height="16" />');
			else $("#contacthow").html('<img src="/images/alert.gif" width="20" height="16" />');
			break;
	}
}

function validEmail(s) {
	var reg = /^([A-Za-z0-9_\-\.])+\@([A-Za-z0-9_\-\.])+\.([A-Za-z]{2,4})$/;
	if(reg.test(s) == false) {
		return false;
	} else {
		return true;
	}
}

function toggleContactForm(act) {
	if(act == '1'){		
		if ($("#contactform:first").is(":hidden")) {
			$("#contactform").html($("#contactformframe"));
			$("#contactformframe").show();
			$("#getintouchbutton").css('background-image','url(/images/closeform.gif)'); 
			$("#contactform").slideDown("slow");
		} else {
			$("#getintouchbutton").css('background-image','url(/images/getintouch.gif)'); 
			$("#contactform").slideUp("slow");
		}
	}
	else{
		$("#getintouchbutton").css('background-image','url(/images/getintouch.gif)'); 
		$("#contactform").slideUp("slow");
	}
}

function togglePrueba(act) {
	if(act == '1'){		
		if ($("#prueba:first").is(":hidden")) {
			$("#prueba").html($("#pruebaframe"));
			$("#pruebaframe").show();
			$("#getintouchbutton").css('background-image','url(/images/closeform.gif)'); 
			$("#prueba").slideDown("slow");
		} else {
			$("#getintouchbutton").css('background-image','url(/images/getintouch.gif)'); 
			$("#prueba").slideUp("slow");
		}
	}
	else{
		$("#getintouchbutton").css('background-image','url(/images/getintouch.gif)'); 
		$("#prueba").slideUp("slow");
	}
}

function toggleAno(act) {
	if(act == '1'){		
		if ($("#ano:first").is(":hidden")) {
			$("#ano").html($("#anoframe"));
			$("#anioframe").show();
			$("#getintouchbutton").css('background-image','url(/images/closeform.gif)'); 
			$("#ano").slideDown("slow");
		} else {
			$("#getintouchbutton").css('background-image','url(/images/getintouch.gif)'); 
			$("#ano").slideUp("slow");
		}
	}
	else{
		$("#getintouchbutton").css('background-image','url(/images/getintouch.gif)'); 
		$("#ano").slideUp("slow");
	}
}
function toggleAnoMes(act) {
	if(act == '1'){		
		if ($("#ano_mes:first").is(":hidden")) {
			$("#ano_mes").html($("#ano_mesframe"));
			$("#ano_mesframe").show();
			$("#getintouchbutton").css('background-image','url(/images/closeform.gif)'); 
			$("#ano_mes").slideDown("slow");
		} else {
			$("#getintouchbutton").css('background-image','url(/images/getintouch.gif)'); 
			$("#ano_mes").slideUp("slow");
		}
	}
	else{
		$("#getintouchbutton").css('background-image','url(/images/getintouch.gif)'); 
		$("#ano_mes").slideUp("slow");
	}
}

var names = new Array('intro','what','who','why');
function changePanel(id) {
	for (var i=0; i<=3; i++) {
		if (i==id) {
			turnOn('homepage-panel-'+names[i]);
			changeBackgroundImage('homepage-tab-'+names[i], '/images/homepage-tabs/'+names[i]+'-on.gif');
		} else {
			turnOff('homepage-panel-'+names[i]);
			changeBackgroundImage('homepage-tab-'+names[i], '/images/homepage-tabs/'+names[i]+'-off.gif');
		}
	}
}

function changeBackgroundImage(DivID, Image) {
	document.getElementById(DivID).style.backgroundImage = 'url('+Image+')';
}

// turn off function
function turnOff(DivID) {
	if (document.getElementById) { //gecko(NN6) & IE 5+
		document.getElementById(DivID).style.visibility = "hidden";
		document.getElementById(DivID).style.display = "none";
	} else if (document.all) { // IE 4+
		document.all[DivID].style.visibility = "hidden";
		document.all[DivID].style.display = "none";
	} else if (document.layers) { // NS4+
		document.layers[DivID].visibility = "hide";
		document.layers[DivID].display = "none";
	} else {
		// nothing
	}
}

// turn on function
function turnOn(DivID) {
	if (document.getElementById) { //gecko(NN6) & IE 5+
		document.getElementById(DivID).style.visibility = "visible";
		document.getElementById(DivID).style.display = "block";
	} else if (document.all) { // IE 4+
		document.all[DivID].style.visibility = "visible";
		document.all[DivID].style.display = "block";
	} else if (document.layers) { // NS4+
		document.layers[DivID].visibility = "show";
		document.layers[DivID].display = "block";
	} else {
	}
}