<?php
	class Galeria_Vista extends Vista {

		function Galeria_Vista() {
			parent::Vista();

			$this->tpl->assign("op",'galeria');
		}

		function setFormularioAgregar() {
			$xajax = new xajax("controles/xajax/galeria.xjx.php");
			$xajax->registerFunction("setRevisarFormulario");
			$this->tpl->assign("xajax_include",$xajax->getJavascript('bibliotecas/xajax'));

			$this->tpl->assign("action","galeria_agregar");
			$this->tpl->assign("title","Administraci&oacute;n Banners - Agregar");
			$this->tpl->assign('front_end',_BASE_WEB_FRONT);
			$this->tpl->assign('admin_tpl','galeria_formulario.tpl.htm');
			$this->tpl->assign('left_tpl','sidebar.tpl.htm');
			$this->tpl->display('index.tpl.htm');
		}

		function setFormularioModificar($_galeria_datos) {
			$xajax = new xajax("controles/xajax/galeria.xjx.php");
			$xajax->registerFunction("setRevisarFormulario");
			$this->tpl->assign("xajax_include",$xajax->getJavascript('bibliotecas/xajax'));

			$this->tpl->assign("action","galeria_modificar");
			$this->tpl->assign("title","Administraci&oacute;n Banners - Modificar");

			$this->tpl->assign("id_galeria",$_galeria_datos['id_galeria']);
			$this->tpl->assign("nombre",$_galeria_datos['nombre']);
			$this->tpl->assign("descripcion",$_galeria_datos['descripcion']);
			$this->tpl->assign('front_end',_BASE_WEB_FRONT);
			$this->tpl->assign('admin_tpl','galeria_formulario.tpl.htm');
			$this->tpl->assign('left_tpl','sidebar.tpl.htm');
			$this->tpl->display("index.tpl.htm");
		}

		function setMantenedor($_ls_galeria,$_paginacion) {
			$this->tpl->assign('title','Administraci&oacute;n Banners');
			$this->tpl->assign('admin_tpl','galeria_mantenedor.tpl.htm');
			$this->tpl->assign('left_tpl','index_left.tpl.htm');
			$this->tpl->assign("ls_galeria",$_ls_galeria);
			$this->setPaginado("galeria_mantenedor",$_paginacion);
			$this->tpl->assign('front_end',_BASE_WEB_FRONT);
			$this->tpl->display('index.tpl.htm');
		}

		function setMantenedorImagen($_id_galeria,$_ls_imagenes,$orden_menor,$mayor_opcion) {
			$xajax = new xajax("controles/xajax/imagen.xjx.php");
			$xajax->registerFunction("setRevisarFormulario");
			$xajax->registerFunction("setCambiarOrden");			
			$this->tpl->assign("xajax_include",$xajax->getJavascript('bibliotecas/xajax'));

			$this->tpl->assign("title","Administraci&oacute;n Banners");
			$this->tpl->assign("action","imagenes_mantenedor");
			$this->tpl->assign("ls_imagenes",$_ls_imagenes);
			//print_r($_ls_imagenes);
			//die();
			// $galerias = array("TP"=>"Transparencia Pasiva",
			// 				  "OS"=>"OIRS");
			// $this->tpl->
			$galerias_modelo = new Galeria_Modelo();
			$this->tpl->assign("items",$galerias_modelo->get_galleries());
			$this->tpl->assign("selected",$_GET["id_galeria"]);
			$this->tpl->assign("id_galeria",$_id_galeria);
			$this->tpl->assign("orden_menor",$orden_menor);
			$this->tpl->assign("mayor_opcion",$mayor_opcion);
			$this->tpl->assign("path",_PATH_IMAGENES);
			$this->tpl->assign('front_end',_BASE_WEB_FRONT);
			$this->tpl->assign('admin_tpl','imagenes.tpl.htm');
			$this->tpl->assign('left_tpl','sidebar.tpl.htm');
			$this->tpl->display('index.tpl.htm');
		}
		
		function setFormularioModificarImagen($_imagen_datos) {
			$xajax = new xajax("controles/xajax/galeria.xjx.php");
			$xajax->registerFunction("setRevisarFormularioImagen");
			$this->tpl->assign("xajax_include",$xajax->getJavascript('bibliotecas/xajax'));

			$this->tpl->assign("action","imagen_modificar");
			$this->tpl->assign("title","Administraci&oacute;n - Banners - Modificar Banner");

			$this->tpl->assign("url",$_imagen_datos["url"]);
			$this->tpl->assign("id_imagen",$_imagen_datos["id_imagen"]);
			$this->tpl->assign("id_galeria",$_imagen_datos["id_galeria"]);
			$this->tpl->assign("publicado",$_imagen_datos["publicado"]);
			$this->tpl->assign('admin_tpl','imagen_formulario.tpl.htm');
			$this->tpl->assign('left_tpl','sidebar.tpl.htm');
			$this->tpl->display("index.tpl.htm");
		}
		
		function setFormularioAgregarImagen() {
			$xajax = new xajax("controles/xajax/galeria.xjx.php");
			$xajax->registerFunction("setRevisarFormularioImagenAgregar");
			$this->tpl->assign("xajax_include",$xajax->getJavascript('bibliotecas/xajax'));

			$this->tpl->assign("action","imagen_agregar");
			$this->tpl->assign("title","Administraci&oacute;n - Banners - Agregar Banner");
			
			$this->tpl->assign("id_galeria",$_REQUEST['id_galeria']);

			$this->tpl->assign('admin_tpl','imagen_formulario_agregar.tpl.htm');
			$this->tpl->assign('left_tpl','sidebar.tpl.htm');
			$this->tpl->display("index.tpl.htm");
		}
	}
?>