<?php
class Funcionarios_Vista extends Vista {
	
	function Funcionarios_Vista() {
		parent::Vista();
		$this->tpl->assign('op','funcionarios');
	}
	
	function setMantenedor($funcionarios) {		
		$this->tpl->assign('title','Administracin - Funcionarios');
		$this->tpl->assign('admin_tpl','funcionarios_mantenedor.tpl.htm');
		$this->tpl->assign('left_tpl','sidebar_buttons.tpl.htm');				
		
		$this->tpl->assign("funcionarios",$funcionarios["funcionarios"]);
		$this->tpl->assign("action",'funcionarios_mantenedor');
		$this->setPaginado("funcionarios_mantenedor",$funcionarios["paginacion"]);	
		$this->tpl->display('index.tpl.htm');
	}
	
	function setFormularioAgregar() {
		$xajax = new xajax("controles/xajax/funcionarios.xjx.php");
		$xajax->registerFunction("setRevisarFormulario");
		$this->tpl->assign("xajax_include",$xajax->getJavascript('bibliotecas/xajax/'));
		$this->tpl->assign('title','Administracin - Funcionarios - Agregar');
		$this->tpl->assign('action','funcionarios_agregar');
		
		$this->tpl->assign('admin_tpl','funcionarios_formulario.tpl.htm');
		$this->tpl->assign('left_tpl','sidebar_buttons.tpl.htm');				
		$this->tpl->display('index.tpl.htm');
	}
	
	function setFormularioModificar($funcionario) {		
		$xajax = new xajax("controles/xajax/funcionarios.xjx.php");
		$xajax->registerFunction("setRevisarFormulario");
		$this->tpl->assign("xajax_include",$xajax->getJavascript('bibliotecas/xajax/'));
		$this->tpl->assign('title','Administracin - Funcionarios - Modificar');
		$this->tpl->assign('action','funcionarios_modificar');	
		
		$this->tpl->assign("rut",$_REQUEST['rut']);				
		$this->tpl->assign("funcionarios",$funcionario);	
		$this->tpl->assign("funcionarios_rut","{$funcionario['rut']}-{$funcionario['rut_dv']}");
		
		$this->tpl->assign('admin_tpl','funcionarios_formulario.tpl.htm');
		$this->tpl->assign('left_tpl','sidebar_buttons.tpl.htm');				
		$this->tpl->display('index.tpl.htm');
	}
        function setFormularioAsignarCargo($funcionario,$cargos) {
                $xajax = new xajax("controles/xajax/funcionarios.xjx.php");
                $xajax->registerFunction("setRevisarFormularioAsignarCargo");
                $this->tpl->assign("xajax_include",$xajax->getJavascript('bibliotecas/xajax/'));
                $this->tpl->assign('title','Administracin - Funcionarios - Asignar Cargo');
                $this->tpl->assign('action','funcionarios_asignar_cargo');

                $this->tpl->assign("rut",$_REQUEST['rut']);
                $this->tpl->assign("funcionarios",$funcionario);
                $this->tpl->assign("funcionarios_rut","{$funcionario['rut']}-{$funcionario['rut_dv']}");
		
				$this->tpl->assign("cargos",$cargos);

                $this->tpl->assign('admin_tpl','funcionarios_asignar_cargo.tpl.htm');
                $this->tpl->assign('left_tpl','sidebar_buttons.tpl.htm');
                $this->tpl->display('index.tpl.htm');
        }
        function setFormularioAsignarResolucion($funcionario,$cargos) {
                $xajax = new xajax("controles/xajax/funcionarios.xjx.php");
                $xajax->registerFunction("setRevisarFormularioAsignarResolucion");
                $this->tpl->assign("xajax_include",$xajax->getJavascript('bibliotecas/xajax/'));
                $this->tpl->assign('title','Administracin - Funcionarios - Asignar Resoluci&oacute;n');
                $this->tpl->assign('action','funcionarios_asignar_resolucion');

                $this->tpl->assign("rut",$_REQUEST['rut']);
                $this->tpl->assign("funcionarios",$funcionario);
                $this->tpl->assign("funcionarios_rut","{$funcionario['rut']}-{$funcionario['rut_dv']}");

                $this->tpl->assign("cargos",$cargos);

                $this->tpl->assign('admin_tpl','funcionarios_asignar_resolucion.tpl.htm');
                $this->tpl->assign('left_tpl','sidebar_buttons.tpl.htm');
                $this->tpl->display('index.tpl.htm');
        }
	
	
}
?>
