<?php
// Portable UTF-8
use voku\helper\UTF8;
	class Usuarios_Modelo extends Modelo {

		var $tb_usuarios;
		var $tb_modulos;
		var $tb_usuarios_modulos;
		var $tb_funcionarios;
		var $tb_organos;
		//var $tb_php121_users;

		function Usuarios_Modelo() {
			parent::Modelo();
			$this->tb_usuarios = 'trans_usuarios';
			$this->tb_modulos = 'trans_modulos';
			$this->tb_usuarios_modulos = 'trans_usuarios_modulos';
			$this->tb_funcionarios = 'trans_funcionario';
			$this->tb_organos = 'trans_organo_administrativo';
		}
	

		function Agregar($_cmps) {
			$this->setTransaccion('start');
			//Si viene el campo pass, lo cifra.
			if (isset($_cmps['pass'])){
				$_cmps['pass']	=	$this->getPassCifrado($_cmps['pass']);
			}
			#usuarios
			$sql = 'select * from '.$this->tb_funcionarios.' where id_funcionario = -1';
			$this->setGuardar($sql,$_cmps);
			$id_usuario = $this->getInsertID();			
			
			return $this->setTransaccion('end');
		}
			
		function setInsertID() {
				return $this->getInsertID();
		}
		
		function setAgregar_Usuario($cmps) {
			$this->setTransaccion('start');
			
			$sql = "select * from {$this->tb_usuarios} where id_usuario = -1";
			 $this->setGuardar($sql,$cmps);
			 $id_usuario = $this->getInsertID();
			
			
			#modulos
			$sql = 'select * from '.$this->tb_usuarios_modulos.' where id_usuario = -1 and id_modulo = -1';
			$_cmps['id_usuario'] = $id_usuario;
			foreach ($cmps['modulos'] as $id_modulo) {
				$_cmps['id_modulo'] = $id_modulo;
				$this->setGuardar($sql,$_cmps);
			}
			return $this->setTransaccion('end');
		}

		function ModificarUsuario($_cmps) {		
			#usuarios
			$sql = 'select * from '.$this->tb_usuarios.' where id_usuario = '.$_cmps['id_usuario'];
			return $this->setModificar($sql,$_cmps);
        }
		
		function Modificar_organo($cmps){
			$sql = 'select * from '.$this->tb_organos.' where id_organo = '.$cmps['id_organo'];
			return $this->setModificar($sql,$cmps);
		}

		function Modificar($_cmps) {
			$this->setTransaccion('start');
						
			#usuarios
			$sql = 'select * from '.$this->tb_funcionarios.' where id_funcionario = '.$_cmps['id_funcionario'];
			$this->setModificar($sql,$_cmps);
	
			#modulos
			$sql = 'delete from '.$this->tb_usuarios_modulos.' where id_usuario = '.$_cmps['id_funcionario'];
			$this->db->Execute($sql);

			$sql = 'select * from '.$this->tb_usuarios_modulos.' where id_usuario = -1 and id_modulo = -1';
			$cmps['id_usuario'] = $_cmps['id_funcionario'];
			foreach ($_cmps['modulos'] as $id_modulo) {
				$cmps['id_modulo'] = $id_modulo;
				$this->setGuardar($sql,$cmps);
			}
	
			return $this->setTransaccion('end');
		}

		function Eliminar($_id_usuario) {
			$this->setTransaccion('start');

			$sql = 'delete from '.$this->tb_funcionarios.' where id_funcionario = '.$_id_usuario;
			$this->db->Execute($sql);

			$sql = 'delete from '.$this->tb_usuarios.' where id_usuario = '.$_id_usuario;
			$this->db->Execute($sql);

			return $this->setTransaccion('end');
		}

		function getUsuarios($_pagina_actual) {
			$sql = 'select id_funcionario,nick,nombre,email from '.$this->tb_funcionarios.' order by nombre asc';
			$rs_usuarios = $this->getConsulta($sql,true,$_pagina_actual);
			$usuarios = array();

			while (!$rs_usuarios->EOF) {
				$usuario = array();
				$usuario['id_funcionario'] = $rs_usuarios->fields['id_funcionario'];
				$usuario['nick'] = $rs_usuarios->fields['nick'];
				$usuario['nombre'] = $rs_usuarios->fields['nombre'];
				$usuario['email'] = $rs_usuarios->fields['email'];	
				$usuario['organo'] =  $this->getOrganoxusuario($rs_usuarios->fields['id_funcionario']);					
				$usuarios[] = $usuario;
				$rs_usuarios->MoveNext();
			}

			$datos['usuarios'] = $usuarios;
			$datos['paginacion'] = $this->getPaginado($rs_usuarios->atfirstpage(),$rs_usuarios->absolutepage(),
				$rs_usuarios->atlastpage(),$rs_usuarios->lastpageno());

			$datos['paginacion']['paginar'] = ($rs_usuarios->atfirstpage() && ($rs_usuarios->lastpageno() == $rs_usuarios->absolutepage())) ? "false" : "true";

			return $datos;
		}
		
		function getOrganoxusuario($id_funcionario) {
			$sql = "select * from {$this->tb_organos} where id_funcionario='{$id_funcionario}' ";
			
			$rs = $this->getConsulta($sql);
			$funcionario = array();
			$funcionario['existe'] = (!$rs->EOF) ? true : false;
			$funcionario["id_organo"] = $rs->fields["id_organo"];
			$funcionario["id_funcionario"] = $rs->fields["id_funcionario"];
			$funcionario["id_organo_padre"] = $rs->fields["id_organo_padre"];
			$funcionario["nombre"] = $rs->fields["nombre"];			
		
			return $funcionario;
		}

		function getModulos() {
			$sql = 'select id_modulo,nombre from '.$this->tb_modulos.' order by nombre asc';
			$rs_modulos = $this->getConsulta($sql);
			$modulos = array();

			while (!$rs_modulos->EOF) {
				$modulo = array();
				$modulo['id_modulo'] = $rs_modulos->fields['id_modulo'];
				$modulo['nombre'] = $rs_modulos->fields['nombre'];
				$modulos[] = $modulo;
				$rs_modulos->MoveNext();
			}

			return $modulos;
		}

		function getModulosxUsuario($_id_usuario) {
			$sql = 'select id_modulo from '.$this->tb_usuarios_modulos.' where id_usuario='.$_id_usuario;
			$rs_modulos = $this->getConsulta($sql);
			$modulos = array();

			while (!$rs_modulos->EOF) {
				$modulo = array();
				$modulo['id_modulo'] = $rs_modulos->fields['id_modulo'];
				$modulos[] = $modulo;
				$rs_modulos->MoveNext();
			}

			return $modulos;
		}

		function getUsuario($_id_usuario) {		
			#usuario				
			$sql = "select *, (select tipo from  {$this->tb_usuarios} where id_usuario='{$_id_usuario}') as tipo from {$this->tb_funcionarios} where id_funcionario='{$_id_usuario}' ";
			$rs_usuario = $this->getConsulta($sql);
			$usuario = array();
			$usuario["id_funcionario"] = $rs_usuario->fields["id_funcionario"];
			$usuario["nick"] = $rs_usuario->fields["nick"];
			$usuario["tipo"] = $rs_usuario->fields["tipo"];			
			$usuario["nombre"] = $rs_usuario->fields["nombre"];			
			$usuario["email"] = $rs_usuario->fields["email"];
			$usuario["telefono"] = $rs_usuario->fields["telefono"];
		
			return $usuario;
		}

		function getUsuarioxNick($_nick) {
			$usuario = array();

			#usuario
			$sql = 'select * from '.$this->tb_usuarios.' where nick="'.$_nick.'"';
			$rs_usuario = $this->getConsulta($sql);

			if ($rs_usuario->EOF){
				return $usuario['existe']=false;
			} else {
				$usuario["id_usuario"] = $rs_usuario->fields["id_usuario"];
				$usuario["nick"] = $rs_usuario->fields["nick"];
				$usuario["tipo"] = $rs_usuario->fields["tipo"];
				$usuario["nombres"] = $rs_usuario->fields["nombres"];
				$usuario["apellidos"] = $rs_usuario->fields["apellidos"];
				$usuario["email"] = $rs_usuario->fields["email"];
				$usuario["ip"] = $rs_usuario->fields["ip"];
				$usuario["modulos"] = $this->getModulosxUsuario($rs_usuario->fields["id_usuario"]);
				$usuario['existe']=true;
			}
			return $usuario;
		}

		function getExisteUsuario($_nick) {
			$sql = 'select nick from '.$this->tb_funcionarios.' where nick="'.$_nick.'"';
			$rs_usuario = $this->getConsulta($sql);

			return (!$rs_usuario->EOF) ? true : false;
		}

		function getLogin($_nick,$_pass) {
			$pass_cifrado = $this->getPassCifrado($_pass);
			
			$sql = "select u.*, f.* from {$this->tb_usuarios} u,{$this->tb_funcionarios} f where f.nick='{$_nick}' 
			and u.contrasena='{$pass_cifrado}' and f.id_funcionario = u.id_usuario";

			$rs_usuario = $this->getConsulta($sql);
			$usuario['existe'] = (!$rs_usuario->EOF) ? true : false;
			$usuario["id_usuario"] = $rs_usuario->fields["id_usuario"];
			$usuario["nick"] = $rs_usuario->fields["nick"];		
            $usuario["nombre"] = $rs_usuario->fields["nombre"]; 	
			$usuario["contrasena"] = $rs_usuario->fields["contrasena"];
			$usuario["tipo"] = $rs_usuario->fields["tipo"];
			$usuario["email"] = $rs_usuario->fields["email"];
			$usuario["id_organo"] = $this->getOrganoFuncionario($rs_usuario->fields["id_funcionario"]);
			//$usuario["nombres"] = $rs_usuario->fields["nombres"];
			//$usuario["apellidos"] = $rs_usuario->fields["apellidos"];

			return $usuario;
		}

		function setLogout() {
			unset($_SESSION['usuario']);
		}

		function setLogin($usuario) {
			$_SESSION['usuario']['id_usuario'] = $usuario['id_usuario'];
			$_SESSION['usuario']['nick'] = $usuario['nick'];
			$_SESSION['usuario']['tipo'] = $usuario['tipo'];
			$_SESSION['usuario']['nombres'] = $usuario['nombres'];
			$_SESSION['usuario']['apellidos'] = $usuario['apellidos'];
		}

		function getPermisoModulo($_modulo) {
			$modulos = $this->getModulosxUsuario($_SESSION['usuario']['id_usuario']);
			$count = count($modulos);
			$return = false;

			for ($x=0;$x<$count;$x++) {
				if ($modulos[$x]['id_modulo'] == $_modulo) {
					$return = true;
					break;
				}
			}

			return $return;
		}
		function getPassCifrado($pass){
			$pass_cifrado=md5(md5($pass."_-_Ac"));
			return $pass_cifrado;
		}
        function getRandString($length = 10, $letters = '1234567890qwertyuiopasdfghjklzxcvbnm'){
              $s = '';
              $lettersLength = strlen($letters)-1;

              for($i = 0 ; $i < $length ; $i++)
              {
              $s .= $letters[rand(0,$lettersLength)];
              }
              return $s;
        }
        function getOrganoFuncionario($id_funcionario){
        	$sql = "SELECT id_organo FROM {$this->tb_organos} WHERE id_funcionario = ?";
        	$rs = $this->db->Execute($sql,array($id_funcionario));
        	return $rs->fields["id_organo"];
        }
	}
?>