<?php

/* Autor : Gino Berr�os
   Fecha : 05-11-2013
   Cambio: Nueva clase modelo para imprimir pdf con datos de una solicitud 
   */

/**
 * Autor : Fernando Gallardo
 * Fecha : 08-06-2017
 * Cambio: Modificación a la función getReporte() para corregir visualización y agregar historial
 * 
 * @param $oirs     - Información de la solicitud
 * 
 * @param $historial- Arreglo con información de los movimientos realizados en la solicitud
 * 
 * @param $usuario  - Información del usuario solicitante
 */   

// Portable UTF-8
use voku\helper\UTF8;
class Reporte_Modelo extends FPDF{
	var $reporte;
    var $id_solicitud;
    var $nombre_user;

    function Footer(){   
        // Posición: a 1,5 cm del final
        $this->SetY(-10);
        $this->SetX(-10);
        // Arial italic 8
        $this->SetFont('Arial','I',8.8);
        // Número de página
        $this->Cell(0,0,$this->PageNo(),0,0,'L');
    }
    
    function Header(){   
        $this->SetFont('Arial','',16);
        $this->ln();
        $this->Cell(0,0,utf8_decode('Reporte Solicitud - Transparencia Pasiva'),0,1,'C');
        $this->SetFont('Arial','',13);
 
        $this->Cell(0,10,utf8_decode('Solicitud ID '. $this->id_solicitud),0,1,'C');
        $this->SetFont('Arial','',10);
        $this->Cell(0,6,'Emitido por: '. $this->nombre_user.' el '.date('d-m-Y').' a las '.
                                    date('H:i:s'),0,1, 'C');
    }
    

    function getReporte($oirs, $historial, $usuario) {

        $this->id_solicitud = $oirs['id_oirs'];
        $this->nombre_user = $usuario['nombre'];
        
        $this->SetLeftMargin(20);
        $this->AddPage('P','Letter');     
        //logo mail
        //$this->Image(_BASE_WEB."ruta_imagen.png",144,40,52);       
        
        
        

        
		array_walk_recursive($oirs, function (&$value) {
            //Elimina el caracter BOM si lo tiene.
            //Convierte a iso-8859-1 si detecta utf-8, si no no realiza cambios.
            $value = str_replace("&aacute;","á",$value);
			$value = str_replace("&eacute;","é",$value);
			$value = str_replace("&iacute;","í",$value);
			$value = str_replace("&oacute;","ó",$value);
			$value = str_replace("&uacute;","ú",$value);
			$value = str_replace("&Aacute;","Á",$value);
			$value = str_replace("&Eacute;","É",$value);
			$value = str_replace("&Iacute;","Í",$value);
			$value = str_replace("&Oacute;","Ó",$value);
			$value = str_replace("&Uacute;","Ú",$value);
			$value = str_replace("&ntilde;","ñ",$value);
			$value = str_replace("&Ntilde;","Ñ",$value);
			$value = str_replace("&auml;","ä",$value);
			$value = str_replace("&euml;","ë",$value);
			$value = str_replace("&iuml;","ï",$value);
			$value = str_replace("&ouml;","ö",$value);
			$value = str_replace("&uuml;","ü",$value);
			$value = str_replace("&Auml;","Ä",$value);
			$value = str_replace("&Euml;","Ë",$value);
			$value = str_replace("&Iuml;","Ï",$value);
			$value = str_replace("&Ouml;","Ö",$value);
			$value = str_replace("&Uuml;","Ü",$value);
			$value = str_replace("&quot;","'",$value);
			$value = str_replace("&deg;","°",$value);
			$value = str_replace("&amp;","&",$value);
			$value = str_replace("&lt;","<",$value);
			$value = str_replace("&gt;",">",$value);
			$value = str_replace("&iquest;","¿",$value);
        });
		

	
        
        
        $this->SetFont('Arial','B',10);
        $this->Cell(45,6,utf8_decode('Datos de la solicitud'),0,1);
        
        $this->SetFont('Arial','',10);                            
        $this->Cell(45,6,utf8_decode('ID'),0,0);
        $this->Cell(0,6,utf8_decode(' : '. $oirs['id_oirs']),0,1);
        
        $this->Cell(45,6,utf8_decode('Tipo'),0,0);
        $this->Cell(0,6,utf8_decode(' : '. $oirs['tipo']),0,1);
        
        $this->Cell(45,6,utf8_decode('Estado'),0,0);
        $this->Cell(0,6,utf8_decode(' : '. $oirs['estado']),0,1);
        
        $this->Cell(45,6,utf8_decode('Unidad activa'),0,0);
        $this->Cell(0,6,utf8_decode(' : '. $historial['historiales'][0]['nombre']),0,1);
        
        $this->Cell(45,6,utf8_decode('Fecha ingreso'),0,0);      
        $this->Cell(0,6,utf8_decode(' : '. date("d-m-Y", strtotime($oirs['fecha']))),0,1);
        
        if($oirs["id_estado"]=='EC'){           
            $this->Cell(45,6,utf8_decode('Fecha máxima modificación'),0,0);
            $this->Cell(0,6,utf8_decode(' : '. date("d-m-Y", strtotime($oirs['fecha_modificar']))),0,1);
        }
        if($oirs["fecha_maxima_respuesta"]!=''){
            $this->Cell(45,6,utf8_decode('Fecha máxima respuesta'),0,0);
            $this->Cell(0,6,utf8_decode(' : '. date("d-m-Y", strtotime($oirs['fecha_maxima_respuesta']))),0,1);
        }
        if($oirs["fecha_extendido"]!=''){
            $this->Cell(45,6,utf8_decode('Fecha extendida'),0,0);
            $this->Cell(0,6,utf8_decode(' : '. date("d-m-Y", strtotime($oirs['fecha_extendido']))),0,1);
        }
        
        $this->Ln();
        $this->SetFont('Arial','B',10);
        $this->Cell(45,6,utf8_decode('Datos del solicitante'),0,1);
        
        $this->SetFont('Arial','',10);     
            
        if($oirs['razon_social']==""){
            $this->Cell(45,6,utf8_decode('Nombre o Razón Social'),0,0);
            $this->Cell(0,6,utf8_decode(' : '. $oirs['nombre'].' '. 
                                 $oirs['apellido_paterno_ciudadano'].' '. 
                                 $oirs['apellido_materno_ciudadano']),0,1);           
        } else {
            $this->Cell(45,6,utf8_decode('Nombre o Razón Social'),0,0);
            $this->Cell(0,6,utf8_decode(' : '.$oirs['razon_social']),0,1);                
        }       
        
        if($oirs["email"]!=''){
            $this->Cell(45,6,utf8_decode('Email'),0,0);
            $this->Cell(0,6,utf8_decode(' : '. $oirs['email']),0,1);
        }

        if($oirs["telefono"]!=''){
            $this->Cell(45,6,utf8_decode('Teléfono'),0,0);
            $this->Cell(0,6,utf8_decode(' : '. $oirs['telefono']),0,1);
        }
        
        if($oirs["direccion"]!=''){
            $this->Cell(45,6,utf8_decode('Dirección'),0,0);
            $this->Cell(0,6,utf8_decode(' : '. $oirs['direccion']),0,1);
        }

        $this->Ln();
        $this->SetFont('Arial','B',10);
        $this->Cell(45,6,utf8_decode('Contenido de la solicitud'),0,1);
        
        $this->SetFont('Arial','',10);     

        if($oirs["asunto"]!=''){
            $this->Cell(45,6,utf8_decode('Asunto'),0,0);
            $this->Cell(0,6,utf8_decode(' : '. $oirs['asunto']),0,1);
        }
        
        $this->Cell(45,6,utf8_decode('Mensaje'),0,0);
        $this->MultiCell(100,6,utf8_decode(' : '. $oirs['mensaje']),0,1);
        
        $this->Ln();
        
        $this->Ln();
        $this->SetFont('Arial','B',10);
        $this->Cell(45,6,utf8_decode('Historial de la solicitud'),0,1);
        
        $this->SetFont('Arial','',8);     
        //---------------------------------------
        //Ahora se crea la Tabla de historial
        //primero header y asignar  anchos
        $header = array(' Fecha','Unidad', utf8_decode('Resp. Ciud'), utf8_decode('Respuesta'),'Nota Interna', 'Estado');
        // Cabecera
        $ancho = array(20, 35,30, 35, 40, 25);
        for($i=0;$i<count($header);$i++):
        
            if ($i == 0)
                $this->Cell($ancho[$i],5,$header[$i],1,0,'C');
                
            if (($i != 0)&&($i != 5))
                $this->Cell($ancho[$i],5,$header[$i],1,0,'C');
                
            if ($i == 5)
                $this->Cell($ancho[$i],5,$header[$i],1,1,'C');
                        
        endfor;

        
        for ($i=0;$i<count($historial['historiales']);$i++):       
            #---Datos de historial
            if ($i+1<count($historial['historiales'])):
                $this->Cell($ancho[0],6,substr(date("d-m-Y", strtotime(($historial['historiales'][$i]['fecha']))), 0, 20),1);
                $this->Cell($ancho[1],6,utf8_decode(substr(($historial['historiales'][$i]['nombre'])), 0, 25),1);
                $this->Cell($ancho[2],6, utf8_decode(substr($historial['historiales'][$i]['respuesta_del_ciudadano']), 0, 20),1);
                $this->Cell($ancho[3],6, utf8_decode(substr($historial['historiales'][$i]['nota_al_ciudadano'], 0, 20)),1);
                $this->Cell($ancho[4],6, utf8_decode(substr($historial['historiales'][$i]['nota_interna'], 0, 25)),1);
                $historial['historiales'][$i]['estado'] = str_replace("&oacute;","ó",$historial['historiales'][$i]['estado']);
                $historial['historiales'][$i]['estado'] = str_replace("&aacute;","á",$historial['historiales'][$i]['estado']);
                $this->Cell($ancho[5],6,utf8_decode($historial['historiales'][$i]['estado']),1,1);    
            else:
                $this->Cell($ancho[0],6,substr((date("d-m-Y", strtotime($historial['historiales'][$i]['fecha']))), 0, 20),1);
                $this->Cell($ancho[1],6,utf8_decode(substr(($historial['historiales'][$i]['nombre']), 0, 25)),1);
                $this->Cell($ancho[2],6, utf8_decode(substr($historial['historiales'][$i]['respuesta_del_ciudadano']), 0, 20),1);
                $this->Cell($ancho[3],6, utf8_decode(substr($historial['historiales'][$i]['nota_al_ciudadano']), 0, 20),1);
                $this->Cell($ancho[4],6, utf8_decode(substr($historial['historiales'][$i]['nota_interna']), 0, 25),1);
                $historial['historiales'][$i]['estado'] = str_replace("&oacute;","ó",$historial['historiales'][$i]['estado']);
                $historial['historiales'][$i]['estado'] = str_replace("&aacute;","á",$historial['historiales'][$i]['estado']);
                $this->Cell($ancho[5],6,utf8_decode($historial['historiales'][$i]['estado']),1,1); 
            endif;           
        endfor;        
             
        
        
        $this->Ln();
        
        
        
        return $this->Output();        
    }
	
}
?>