<?php

/* Autor : Gino Berros
   Fecha : 05-11-2013
   Cambio: Nueva clase modelo para imprimir pdf con datos de una solicitud 
   */
class Reporte_Modelo {
	var $reporte;

	function Reporte_Modelo() {
		$this->reporte = new FPDF();
		
	}
	
	function getReporte($oirs) {

    	$this->reporte->AddPage();
    	$this->reporte->SetFont('Arial','B',16);
   		$this->reporte->Cell(50,10,'Reporte Solicitud',1,1);
   		$this->reporte->Cell(40,10,'ID : '. $oirs['id_oirs'],0,1);
   		$this->reporte->Cell(40,10,'Tipo : '. $oirs['tipo'],0,1);
   		$this->reporte->Cell(40,10,'Estado : '. $oirs['estado'],0,1);
   		$this->reporte->Cell(100,10,$oirs['historial']['id_organo'] == 0 ? 'Organo administrativo : Oficina Central' : $oirs['historial']['nombre'],0,1);
   		$this->reporte->Cell(40,10, 'Fecha Ingreso: '. $oirs['fecha'],0,1);
   		if($oirs["id_estado"]=='EC'){
   			$this->reporte->Cell(40,10, 'Fecha Mxima Modificacin: '. $oirs['fecha_modificar'],0,1);
   		}
   		if($oirs["fecha_maxima_respuesta"]!=''){
   			$this->reporte->Cell(40,10, 'Fecha Mxima Respuesta: '. $oirs['fecha_maxima_respuesta'],0,1);
   		}
   		if($oirs["fecha_extendido"]!=''){
   			$this->reporte->Cell(40,10, 'Fecha Extendida: '. $oirs['fecha_extendido'],0,1);
   		}
   		if($oirs["email"]!=''){
   			$this->reporte->Cell(40,10, 'Email: '. $oirs['email'],0,1);
   		}
   		$this->reporte->Cell(40,10,$oirs['razon_social']=="" ? 'Nombre o Razn Social : '. $oirs['nombre'].' '. $oirs['apellido_paterno_ciudadano'].' '. $oirs['apellido_materno_ciudadano'] : 'Nombre o Razn Social : '. $oirs['razon_social'],0,1);
   		if($oirs["telefono"]!=''){
   			$this->reporte->Cell(40,10, 'Telfono: '. $oirs['telefono'],0,1);
   		}
   		if($oirs["direccion"]!=''){
   			$this->reporte->Cell(40,10, 'Direccin: '. $oirs['direccion'],0,1);
   		}
   		if($oirs["asunto"]!=''){
   			$this->reporte->Cell(40,10, 'Asunto: '. $oirs['asunto'],0,1);
   		}
   		$this->reporte->Cell(40,10,'Mensaje : '. $oirs['mensaje'],0,1);
   		return $this->reporte->Output();		
	}	
}
?>