<?php
// Portable UTF-8
use voku\helper\UTF8;
	class Plantillas_Modelo extends Modelo{

		var $tabla					= null;
		var $opciones				= null;	
		var $generador  			= null;
		var $generador_plantilla	= null;		
		var $csv_usuario			= null;
        var $archivo_usuario		= null;
		var $plantilla_accion		= null;
        var $plantilla_enlace		= null;
        var $funcionario    		= null;
		var $archivo_contenido    	= null;
		var $contenido  			= null;
		var $plantilla				= null;
				
        
		function Plantillas_Modelo() {
			parent::Modelo();
			
			$this->tabla 				= 'trans_plantillas';		
			$this->opciones 			= 'trans_transparencia_opciones';		
			$this->generador			= 'trans_transparencia_generador';			
			$this->generador_plantilla	= 'trans_transparencia_generador_plantilla';			
			$this->csv_usuario          = 'trans_transparencia_csv_usuario';		
            $this->archivo_usuario      = 'trans_transparencia_archivo_usuario';			
			$this->plantilla_accion 	= 'trans_transparencia_plantilla_accion';
            $this->plantilla_enlace 	= 'trans_transparencia_enlaces';			
            $this->funcionario 			= 'trans_usuarios';
			$this->archivo_contenido 	= 'trans_transparencia_solo_archivo';			
			$this->generador_area		= 'trans_transparencia_generador_area';
		}		
		
		

		function Agregar($_cmps) {
			$sql = 'SELECT * FROM '.$this->tabla.' WHERE id_plantilla = -1';
			return $this->setGuardar($sql,$_cmps);
		}		
		

        function AgregarCSVusuario($_cmps) {
                $sql = 'SELECT * FROM '.$this->csv_usuario.' WHERE csv_anio = -1';
                return $this->setGuardar($sql,$_cmps);
        }

        function AgregarArchivousuario($_cmps,$cmps_contenido) {
			$this->setTransaccion('start');
			
                $sql = 'SELECT * FROM '.$this->archivo_usuario.' WHERE archivo_anio = -1';
				$this->setGuardar($sql,$_cmps);
						
				$cmps_contenido['id_archivo']  = $this->getInsertID();
						
				$sql_contenido = 'SELECT * FROM '.$this->archivo_contenido.' WHERE id_archivo = -1';
				$this->setGuardar($sql_contenido,$cmps_contenido);
				
			return $this->setTransaccion('end');
             
        }
		
		
		function AgregarEnlace($_cmps) {
			$sql = 'SELECT * FROM '.$this->plantilla_enlace.' WHERE id_enlace = -1';
			return $this->setGuardar($sql,$_cmps);
		}



		function Modificar($_cmps) {
			$sql = 'SELECT * FROM '.$this->tabla.' WHERE id_plantilla = '.$_cmps['id_plantilla'];
			return $this->setModificar($sql,$_cmps);
		}



        function setInsertID() {
            return $this->getInsertID();
        }




        function ModificarCSV($_cmps) {
                $sql = "SELECT * FROM {$this->csv_usuario} WHERE id_generador = {$_cmps['id_generador']} and  id_generador_area = {$_cmps['id_generador_area']} and csv_mes = {$_cmps['csv_mes']} and csv_anio = {$_cmps['csv_anio']}";
                return $this->setModificar($sql,$_cmps);
        }

        function ModificarArchivo($_cmps) {
                $sql = "SELECT * FROM {$this->archivo_usuario} WHERE id_generador = {$_cmps['id_generador']} and  id_generador_area = {$_cmps['id_generador_area']} and archivo_mes = {$_cmps['archivo_mes']} and archivo_anio = {$_cmps['archivo_anio']}";
                return $this->setModificar($sql,$_cmps);
        }
		function Eliminar($_id_plantilla) {
			$sql = 'delete FROM '.$this->tabla.' WHERE id_plantilla = '.$_id_plantilla;
			return $this->setEliminar($sql);
		}
		
		function getOpcionesAsistente(){
                $sql = "SELECT * FROM {$this->generador} WHERE id_padre = '0' order by id_generador asc";
                $rs = $this->getConsulta($sql);
                $opciones = array();
                while (!$rs->EOF) {
                        $opcion['id_opcion'] 	= $rs->fields['id_opcion'];
                        $opcion['id_padre'] 	= $rs->fields['id_padre'];						
						$opcion['id_generador'] = $rs->fields['id_generador'];						
						$opcion['generador_titulo']= $rs->fields['generador_titulo'];
						$opcion['generadores']	= array();
						$sql_gen= "SELECT * FROM {$this->generador} WHERE id_padre =".$opcion['id_generador'];
						$rs_gen = $this->getConsulta($sql_gen);
						while (!$rs_gen->EOF) {
							$generador['id_generador'] = $rs_gen->fields['id_generador'];
							$generador['id_opcion'] = $rs_gen->fields['id_opcion'];
							$generador['generador_titulo'] = $rs_gen->fields['generador_titulo'];
							$generador['generador_tipo'] = $rs_gen->fields['generador_tipo'];
							$opcion['generadores'][]=$generador;
							$rs_gen->MoveNext();
						}
						$opciones[]=$opcion;
                        $rs->MoveNext();
                	}
        	        return $opciones;
	        }
			/*
		function getOpcionesAsistente(){
                $sql = "SELECT * FROM {$this->opciones} order by opcion_titulo asc";
                $rs = $this->getConsulta($sql);
                $opciones = array();
                while (!$rs->EOF) {
                        $opcion['id_opcion'] 	= $rs->fields['id_opcion'];
				$opcion['opcion_titulo']= $rs->fields['opcion_titulo'];
				$opcion['generadores']	= array();
				$sql_gen= "SELECT * FROM {$this->generador} WHERE id_opcion =".$opcion['id_opcion'];
				$rs_gen = $this->getConsulta($sql_gen);
				while (!$rs_gen->EOF) {
					$generador['id_generador'] = $rs_gen->fields['id_generador'];
					$generador['id_opcion'] = $rs_gen->fields['id_opcion'];
					$generador['generador_titulo'] = $rs_gen->fields['generador_titulo'];
					$generador['generador_tipo'] = $rs_gen->fields['generador_tipo'];
					$opcion['generadores'][]=$generador;
					$rs_gen->MoveNext();
				}
				$opciones[]=$opcion;
                        	$rs->MoveNext();
                	}
        	        return $opciones;
	        }
**/
		function getGenerador($_id_generador){
			$sql = "SELECT * FROM {$this->generador} WHERE id_generador = {$_id_generador} order by generador_titulo asc";
			$rs  = $this->getConsulta($sql);
			$generador = array();
            while (!$rs->EOF) {
                $generador['id_generador']         = $rs->fields['id_generador'];
                $generador['generador_titulo']     = $rs->fields['generador_titulo'];
                $generador['generador_encabezado'] = $rs->fields['generador_encabezado'];
                $rs->MoveNext();
			}
			return $generador;
		}


		function getPlantillas($_id_generador,$_id_generador_area){
				$sql = "SELECT * FROM {$this->generador_area} WHERE id_generador = {$_id_generador} and id_generador_area = {$_id_generador_area}";
				$rs  = $this->getConsulta($sql);
				$area = array();
				while (!$rs->EOF) {
					$area['id_generador']         = $rs->fields['id_generador'];
					$area['id_generador_area']    = $rs->fields['id_generador_area'];
					$area['selec_plantilla_titulo']         = $rs->fields['selec_plantilla_titulo'];
					$rs->MoveNext();
				}
				$sql_ar = "SELECT * FROM {$this->generador_plantilla} WHERE id_generador = {$_id_generador} and id_generador_area = {$_id_generador_area}";
				$rs_ar  = $this->getConsulta($sql_ar);
				$area['plantillas'] = array();

				while (!$rs_ar->EOF) {
						$plantilla['id_generador_area']     = $rs_ar->fields['id_generador_area'];
						$plantilla['id_generador']          = $rs_ar->fields['id_generador'];
						$plantilla['id_generador_plantilla']= $rs_ar->fields['id_generador_plantilla'];
						$plantilla['plantilla_titulo']      = $rs_ar->fields['plantilla_titulo'];
						$plantilla['plantilla_nombre']      = $rs_ar->fields['plantilla_nombre'];
						$plantilla['plantilla_descripcion'] = $rs_ar->fields['plantilla_descripcion'];	
		
						$area['plantillas'][]  =  $plantilla;
						$rs_ar->MoveNext();
				}
				return $area;
		}

		function getTextCSV(){
			$text_csv = "";
			$separador = "";
			$tipo_separador = ";";
			foreach ($this->plantilla['columna'] as $columna){
				$text_csv .= "$separador\"".$columna['titulo']."\"";
				$separador = $tipo_separador;
			}
			foreach ($this->plantilla['columna'][0]['dato'] as $fil=>$fila){
				$text_csv .= "\n";
				$separador = "";
				foreach ($this->plantilla['columna'] as $col=>$columna){
					if (is_numeric($columna['dato'][$fil])){
                                                $text_csv .= "$separador".$columna['dato'][$fil];
                                                $separador = $tipo_separador;
					} else {
                                		$text_csv .= "$separador\"".$columna['dato'][$fil]."\"";
						$separador = $tipo_separador;
					}
                        	}
                        }
						
			return $text_csv;

		}
		
		function setBdCSV($_id_generador,$_csv_mes, $_csv_anio, $_id_archivo){
			$sql = "SELECT *,UNIX_TIMESTAMP(au.archivo_fecha_ingreso) 'archivo_fecha_ingreso_unix', ta.archivo_archivo as contenido FROM {$this->archivo_usuario} au
             inner join {$this->generador} ge on au.id_generador = ge.id_generador inner join {$this->archivo_contenido} ta on au.id_archivo = ta.id_archivo
             WHERE au.id_generador = {$_id_generador} and au.id_archivo = {$_id_archivo} and au.archivo_mes = {$_csv_mes} and au.archivo_anio = {$_csv_anio}
                    ";
			$rs  = $this->getConsulta($sql);
			$datos = array();
			while (!$rs->EOF) {
				$datos['id_generador']         	= $rs->fields['id_generador'];
				$datos['id_archivo']         	= $rs->fields['id_archivo'];
				$datos['archivo_mes']       		= $rs->fields['archivo_mes'];
				$datos['archivo_anio']       		= $rs->fields['archivo_anio'];
                $datos['archivo_anio']       		= $rs->fields['archivo_anio'];
                $datos['generador_descripcion']       		= $rs->fields['generador_descripcion'];
				$datos['archivo_nombre'] 	= $rs->fields['archivo_nombre'];
				$datos['archivo_fecha_ingreso_unix']	= $rs->fields['archivo_fecha_ingreso_unix'];
				//$csv_serializado				= $rs->fields['archivo_archivo'];
				$csv_serializado				= $rs->fields['contenido'];
				$rs->MoveNext();
			}
			$sql_pl = "SELECT * FROM {$this->generador_plantilla} WHERE id_generador = {$_id_generador}";
			$rs_pl  = $this->getConsulta($sql_pl);
			$area['plantillas'] = array();

			while (!$rs_pl->EOF) {
				$datos['plantilla_titulo']      = $rs_pl->fields['plantilla_titulo'];
				$datos['plantilla_nombre']      = $rs_pl->fields['plantilla_nombre'];
				$datos['plantilla_descripcion'] = $rs_pl->fields['plantilla_descripcion'];
				$datos['plantilla_observacion'] = $rs_pl->fields['plantilla_observacion'];
				
				$rs_pl->MoveNext();
			}
			$this->plantilla=unserialize($csv_serializado);
			return $datos;
			
			
		}

		function getArchivoBD($_id_generador,$_archivo_mes, $_archivo_anio, $_id_archivo){
			//$sql = "SELECT *,UNIX_TIMESTAMP(archivo_fecha_ingreso) 'archivo_fecha_ingreso_unix' FROM {$this->archivo_usuario} WHERE id_generador = {$_id_generador} and id_archivo = {$_id_archivo} and archivo_mes = {$_archivo_mes} and archivo_anio = {$_archivo_anio}";
			
			$sql = "SELECT au.*,UNIX_TIMESTAMP(au.archivo_fecha_ingreso) 'archivo_fecha_ingreso_unix',arc.archivo_archivo as contenido FROM {$this->archivo_usuario} as au, {$this->archivo_contenido} as arc  WHERE au.id_generador = {$_id_generador} and au.id_archivo = {$_id_archivo} and au.archivo_mes = {$_archivo_mes} and au.archivo_anio = {$_archivo_anio} and au.id_archivo = arc.id_archivo";
			
			$rs  = $this->getConsulta($sql);
			$datos = array();
			while (!$rs->EOF) {
				$datos['id_generador']          = $rs->fields['id_generador'];
                $datos['id_archivo']          = $rs->fields['id_archivo'];
				$datos['archivo_mes']       	= $rs->fields['archivo_mes'];
				$datos['archivo_anio']       	= $rs->fields['archivo_anio'];
				$datos['archivo_nombre']        = $rs->fields['archivo_nombre'];
				$datos['archivo_fecha_ingreso_unix']= $rs->fields['archivo_fecha_ingreso_unix'];
				$datos['archivo_tipo']          = $rs->fields['archivo_tipo'];
				//$datos['archivo_archivo']		= $rs->fields['archivo_archivo'];
				$datos['archivo_archivo']		= $rs->fields['contenido'];
				$rs->MoveNext();
			}
            /*
			$sql_pl = "SELECT * FROM {$this->generador_plantilla} WHERE id_generador = {$_id_generador} and id_generador_plantilla = {$_id_generador_plantilla}";
			$rs_pl  = $this->getConsulta($sql_pl);
			$area['plantillas'] = array();
			while (!$rs_pl->EOF) {
				$datos['id_generador_plantilla']= $rs_pl->fields['id_generador_plantilla'];
				$datos['plantilla_titulo']      = $rs_pl->fields['plantilla_titulo'];
				$datos['plantilla_nombre']      = $rs_pl->fields['plantilla_nombre'];
				$datos['plantilla_descripcion'] = $rs_pl->fields['plantilla_descripcion'];
				$datos['plantilla_observacion'] = $rs_pl->fields['plantilla_observacion'];

				$rs_pl->MoveNext();
			}*/
			return $datos;


		}

		function setCSV($_ruta_archivo){
			$plantilla = array();
			$return    = false;
			$tipo_separador = ";";
			$handle = fopen("$_ruta_archivo", "r");
			if ($handle!=FALSE){
				while (($datos = fgetcsv($handle, 1000, $tipo_separador)) !== FALSE) {
        				$datos_arreglo[] = $datos;
				}		
				fclose($handle);
			
				foreach ($datos_arreglo[0] as $col=>$valor){
                        		$plantilla['columna'][$col]['titulo']=$valor;
                        	}
				for ($fil=1;$fil<count($datos_arreglo);$fil++){
					foreach ($datos_arreglo[$fil] as $col=>$valor){
						$plantilla['columna'][$col]['dato'][$fil-1]=$valor;
					}
				$return = true;
				}
			}
			$this->plantilla = $plantilla;
			return $return;
		}

		function setHTML($_ruta_archivo){
			$plantilla  = array();
			$return     = false;
            $texto      = file_get_contents($_ruta_archivo);
            if ($texto==false){
                $return=false;
            } else {
                $return=true;
                $this->plantilla    = $texto;
            }
			return $return;
		}
		function setPDF($_ruta_archivo){
			$return     = false;
            $gestor = fopen($_ruta_archivo, "rb");
            $contenido = fread($gestor, filesize($_ruta_archivo));
            fclose($gestor);
            if ($gestor==false){
                $return=false;
            } else {
                $return=true;
                $this->contenido    = $contenido;
            }
			return $return;
		}
		function setIMG($_ruta_archivo){
			$return     = false;
            $gestor = fopen($_ruta_archivo, "rb");
            $contenido = fread($gestor, filesize($_ruta_archivo));
            fclose($gestor);
            if ($gestor==false){
                $return=false;
            } else {
                $return=true;
                $this->contenido    = $contenido;
            }
			return $return;
		}
		function setPlantilla_Test(){
			//Formato de trabajo interno

			$plantilla  = array();

			$plantilla['columna'][1]['titulo'] = "Nombre";
			$plantilla['columna'][2]['titulo'] = "Apellido Paterno";
			$plantilla['columna'][3]['titulo'] = "Apellido Materno";
			$plantilla['columna'][4]['titulo'] = "Fecha Nacimiento";

			$plantilla['columna'][0]['dato'][0]= '16301132';
			$plantilla['columna'][1]['dato'][0]= 'Andres';
			$plantilla['columna'][2]['dato'][0]= 'Bravo';
			$plantilla['columna'][3]['dato'][0]= 'Van Treek';
			$plantilla['columna'][4]['dato'][0]= '18/01/1986';

                        $plantilla['columna'][0]['dato'][1]= '1456776';
                        $plantilla['columna'][1]['dato'][1]= 'Edmundo';
                        $plantilla['columna'][2]['dato'][1]= 'Varas';
                        $plantilla['columna'][3]['dato'][1]= 'di Ferro';
                        $plantilla['columna'][4]['dato'][1]= '18/01/1992';
			$this->plantilla = $plantilla;
			return true;
		}
		function getPlantilla(){
			return $this->plantilla;
		}
		function setPlantilla($_plantilla){
			$this->plantilla=$_plantilla;
		}
		function quitarColumna($_columna){
			$plantilla = $this->plantilla;
			unset($plantilla['columna'][$_columna]);
            		$this->plantilla = $plantilla;
			return true;
		}
		function filtrarCampo($_campo, $_texto_buscar){
			$plantilla = array();
			if (!is_array($_texto_buscar)){
				$aux = $_texto_buscar;
				$_texto_buscar  = array();
				$_texto_buscar[]= $aux;
			}
			foreach ($this->plantilla['columna'] as $col=>$columna){
					$plantilla['columna'][$col]['titulo']=$columna['titulo'];
			}
			foreach	($this->plantilla['columna'][$_campo]['dato'] as $fil=>$dato){
				if (in_array($dato, $_texto_buscar)){
					foreach ($this->plantilla['columna'] as $col=>$columna){
						$plantilla['columna'][$col]['dato'][]=$columna['dato'][$fil];
					}
				}
			}
			$this->plantilla = $plantilla;
		}
		function formatearCampoEnlace($_campo){
			foreach ($this->plantilla['columna'][$_campo]['dato'] as $fil=>$valor){
				$this->plantilla['columna'][$_campo]['dato'][$fil]="<a href=\"".$valor."\" >Ver enlace</a>";
            }
		}
		
		function formatearPlantillaEnlace(){
           foreach ($this->plantilla['columna'] as $col=>$columna){
                foreach ($this->plantilla['columna'][$col]['dato'] as $fil=>$valor){
                    if ($this->esEnlace($valor)){
                        $this->plantilla['columna'][$col]['dato'][$fil]="<a href=\"".$valor."\" >$valor</a>";
                    }
                }
            }
		}
		function esEnlace($_texto){
            if  (   (strpos($_texto,"http://")===0)
                or  (strpos($_texto,"https://")===0)
                    ){
                return true;
            } else {
                return false;
            }
		}
		
		
		function aplicarAcciones($_id_generador,$_id_generador_area,$_id_generador_plantilla){
			$sql = "SELECT * FROM {$this->plantilla_accion} WHERE id_generador = {$_id_generador} and id_generador_area = {$_id_generador_area} and id_generador_plantilla = {$_id_generador_plantilla} order by accion_orden asc";
			$rs  = $this->getConsulta($sql);
			$acciones = array();
			while (!$rs->EOF) {
				$accion['id_generador']         = $rs->fields['id_generador'];
				$accion['id_generador_area']    = $rs->fields['id_generador_area'];
				$accion['id_generador_plantilla']    = $rs->fields['id_generador_plantilla'];
				$accion['id_plantilla_accion']  = $rs->fields['id_plantilla_accion'];
				$accion['accion_tipo']          = $rs->fields['accion_tipo'];
				$accion['accion_parametros']    = $rs->fields['accion_parametros'];
				$acciones[]=$accion;
				$rs->MoveNext();
			}
			
			
			foreach ($acciones as $accion){
				if ($accion['accion_tipo']=="fil"){
					$parametros = unserialize($accion['accion_parametros']);
					$this->filtrarCampo($parametros['campo'],$parametros['texto_buscar']);
				}
				if ($accion['accion_tipo']=="eco"){
					$parametros = unserialize($accion['accion_parametros']);
					$this->quitarColumna($parametros['columna']);
				}
				if ($accion['accion_tipo']=="fen"){
					$parametros = unserialize($accion['accion_parametros']);
					$this->formatearCampoEnlace($parametros['columna']);
				}

			}
			return true;

		}
		function getAnios(){
			$anios=array();
			$anio_actual = date('Y');
                        for ($a=2000;$a<=$anio_actual+1;$a++){
				$anios[$a]=$a;
                        }
			return $anios;
			
		}
		function getMeses(){
			$meses = array('','Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre');
			unset($meses[0]);
			return $meses;
		}
        
        //Se obtiene el menu principal de las plantillas
        function getMenuPrincipal(){
            $sql = "SELECT * FROM ".$this->generador."  WHERE id_padre='0' ORDER BY id_generador ASC";
            
            $rs  = $this->getConsulta($sql);
            $menus = array();
            while (!$rs->EOF) {
                $menu = array();
				$menu['id_opcion'] 	= $rs->fields['id_opcion'];
                $menu['id_padre'] 	= $rs->fields['id_padre'];						
				$menu['id_generador'] = $rs->fields['id_generador'];						
				$menu['generador_titulo']= $rs->fields['generador_titulo'];
						
                /*$menu['id_opcion']         = $rs->fields['id_opcion'];
                $menu['opcion_titulo']    = $rs->fields['opcion_titulo'];
                $menu['opcion_orden']    = $rs->fields['opcion_orden'];*/
                $menus[] = $menu;
                
                $rs->MoveNext();
            }
            
            return $menus;
        }
        
        //Se verifica la existencia de una opcion asociada a un menu
        function getExisteOpcion($datos){
            $sql = "SELECT * FROM ".$this->generador." WHERE (generador_titulo = '".$datos["generador_titulo"]."')";
            $sql .= " AND (id_opcion = ".$datos["id_opcion"].")";
            if($datos["id_generador"] != ""){
                $sql .= " AND (id_generador != ".$datos["id_generador"].")";
            }
            $rs = $this->getConsulta($sql);
            if(!$rs->EOF){
                return true;
            }else{
                return false;
            }
        }
        
        //Se obtienen los datos de un generador
        function getGenerador_modificar($id_generador){
            $sql = "SELECT * FROM ".$this->generador." WHERE (id_generador = ".$id_generador.")";            
            
            $generador = array();
            $rs = $this->getConsulta($sql);
            if(!$rs->EOF){
                $generador["id_generador"] = $rs->fields["id_generador"];
                $generador["id_opcion"] = $rs->fields["id_opcion"];
                $generador["id_padre"] = $rs->fields["id_padre"];				
                $generador["generador_titulo"] = $rs->fields["generador_titulo"];
                $generador["generador_encabezado"] = $rs->fields["generador_encabezado"];
                $generador["generador_descripcion"] = $rs->fields["generador_descripcion"];
            }        
            
            return $generador;
        }
        
        //Se agrega una nueva opcion a un menu principal
        function setAgregar_opcion($cmps){
            $sql = "SELECT * FROM {$this->generador} WHERE id_opcion = -1";
            return $this->setGuardar($sql, $cmps);
        }
        
        //Se modifican los datos de una opcion
        function setModificar_opcion($_cmps){
            $this->setTransaccion('start');
            
            #usuarios
            $sql = 'SELECT * FROM '.$this->generador.' WHERE id_generador = '.$_cmps['id_generador'];
            $this->setModificar($sql, $_cmps);
    
            return $this->setTransaccion('end');
        }
                
        //Se elimina una opcion del menu principal
        function Eliminar_opcion($id_generador){
            $this->setTransaccion('start');

            $sql = 'DELETE FROM '.$this->generador.' WHERE id_generador = '.$id_generador;
            $this->db->Execute($sql);

            return $this->setTransaccion('end');            
        }        
        
        //Se obtiene el historial de un generador
        function getHistorial_generador($id_generador,$pagina_actual){
            //Obtengo html, pdf, img
            $sql = "SELECT A.archivo_mes,A.archivo_anio,A.id_generador,A.id_archivo,A.id_usuario,A.archivo_nombre,A.archivo_fecha_ingreso,A.archivo_publicar,A.archivo_tipo,F.* FROM ".$this->archivo_usuario." A, ".$this->funcionario;
            $sql .= " F WHERE (A.id_generador = ".$id_generador.") AND (A.id_usuario = F.id_usuario)"; 
            $sql .= " ORDER BY A.id_archivo desc";

            $historia = array();
            $rs = $this->getConsulta($sql,true,$pagina_actual);
            $meses	=	$this->getMeses();
            $meses[0] ="--";
            while(!$rs->EOF){

                $historial = array();
                $historial["mes"]           = $rs->fields["archivo_mes"];
                $historial["mes_nombre"]    = $meses[$historial["mes"]];
                $historial["anio"]          = $rs->fields["archivo_anio"];
                $historial["id_archivo"]    = $rs->fields["id_archivo"];
                $historial["id_generador"]  = $id_generador;
                $historial["fecha_ingreso"] = $rs->fields["archivo_fecha_ingreso"];
                $historial["archivo_nombre"]= $rs->fields["archivo_nombre"];
                $historial["nombres"]        = $rs->fields["nombres"];
                $historial["publicar"]      = $rs->fields["archivo_publicar"];
                $historial["tipo"]          = $rs->fields["archivo_tipo"];
                $historia[$historial["fecha_ingreso"]] = $historial;
                $rs->moveNext();
				
			
            }
            //Obtengo enlaces    
				$historia['paginacion'] = $this->getPaginado($rs->atfirstpage(),$rs->absolutepage(),$rs->atlastpage(),$rs->lastpageno());

			$historia['paginacion']['paginar'] = ($rs->atfirstpage() && ($rs->lastpageno() == $rs->absolutepage())) ? "false" : "true";             
            $sql = "SELECT E.*,F.* FROM ".$this->plantilla_enlace." E, ".$this->funcionario;
            $sql .= " F WHERE (E.id_generador = ".$id_generador.") AND (E.id_funcionario = F.id_usuario)"; 
            $sql .= " ORDER BY E.enlace_fecha_ingreso DESC";
            
            $rs = $this->getConsulta($sql);
            while(!$rs->EOF){
                $historial = array();
                $historial["id_enlace"] = $rs->fields["id_enlace"];
                $historial["mes_nombre"]    = "--";
                $historial["anio"]          = "--";
                $historial["id_generador"] = $id_generador;
                $historial["fecha_ingreso"] = $rs->fields["enlace_fecha_ingreso"];                
                $historial["nombre"] = $rs->fields["nombre"];
                $historial["publicar"] = $rs->fields["enlace_publicar"];
                $historial["url"] = $rs->fields["enlace_url"];
                $historial["tipo"] = "enl";
                $historia[$historial["fecha_ingreso"]] = $historial;
                $rs->moveNext();
            }        
           // ksort($historia);
            array_reverse($historia);   
	
            return $historia;         
        } 
		
		
		function getHistorial_Busqueda($cmps,$pagina_actual){
	
		//	if (!empty($cmps['desde'])&&!empty($cmps['hasta'])) {
					//$desde = $this->getFecha($cmps['desde']);
					//$hasta = $this->getFecha($cmps['hasta']);
					//$sql_fecha = " and a.archivo_fecha_ingreso between '$desde' and '$hasta'";
			//	}
	
			$sql = "select a.*,f.* from {$this->archivo_usuario} a left join {$this->funcionario} f on a.id_usuario = f.id_usuario where a.id_generador = '{$cmps['id_generador']}' and (a.archivo_nombre like '%{$cmps['buscar_texto']}%' or a.nombre_despliegue like '%{$cmps['buscar_texto']}%' or a.descripcion_archivo like '%{$cmps['buscar_texto']}%') and a.archivo_tipo = '{$cmps['tipo']}' and a.archivo_mes between '{$cmps['desde_mes']}' and '{$cmps['hasta_mes']}' and a.archivo_anio between '{$cmps['desde_anio']}' and '{$cmps['hasta_anio']}' order by a.id_archivo desc";

            $archivos = array();
            $rs = $this->getConsulta($sql,true,$pagina_actual);
            $meses	=	$this->getMeses();
            $meses[0] ="--";
            while(!$rs->EOF){
                $archivo = array();
                $archivo["mes"]           = $rs->fields["archivo_mes"];
               	$archivo["mes_nombre"]    = $meses[$archivo["mes"]];
                $archivo["anio"]          = $rs->fields["archivo_anio"];
                $archivo["id_archivo"]    = $rs->fields["id_archivo"];
                $archivo["id_generador"]  = $cmps['id_generador'];
                $archivo["fecha_ingreso"] = $rs->fields["archivo_fecha_ingreso"];
                $archivo["archivo_nombre"]= $rs->fields["archivo_nombre"];
                $archivo["nombres"]        = $rs->fields["nombres"];
                $archivo["publicar"]      = $rs->fields["archivo_publicar"];
                $archivo["tipo"]          = $rs->fields["archivo_tipo"];
                $archivos[] = $archivo;
				$rs->MoveNext();
			}

			$datos['archivo'] = $archivos;
			$datos['paginacion'] = $this->getPaginado($rs->atfirstpage(),$rs->absolutepage(),
				$rs->atlastpage(),$rs->lastpageno());

			$datos['paginacion']['paginar'] = ($rs->atfirstpage() && ($rs->lastpageno() == $rs->absolutepage())) ? "false" : "true";

             //Limpiar planilla
            array_walk_recursive($historial, function (&$value) {
                //Elimina el caracter BOM si lo tiene.
                $value = UTF8::remove_bom($value);
                //Convierte a iso-8859-1 si detecta utf-8, si no no realiza cambios.
                if (UTF8::str_detect_encoding($value) == 'UTF-8'){
                    $value = UTF8::utf8_decode($value);
                } else {
                    $value = UTF8::utf8_encode($value);
                }
            });

			return $datos;      
        } 		
		
		
		
		
		
		                       
        
        //Se elimina un enlace
        function Eliminar_enlace($id_enlace){
            $this->setTransaccion('start');

            $sql = 'DELETE FROM '.$this->plantilla_enlace.' WHERE id_enlace = '.$id_enlace;
            $this->db->Execute($sql);

            return $this->setTransaccion('end');            
        }        

        //Se elimina un archivo
        function Eliminar_archivo($mes, $anio, $id, $id_archivo, $tipo){
            $this->setTransaccion('start');

            $sql = "DELETE FROM ".$this->archivo_usuario." WHERE (archivo_mes = ".$mes.")";
            $sql .= " AND (archivo_anio = ".$anio.") AND (id_generador = ".$id.") AND ";
            $sql .= "(id_archivo = ".$id_archivo.") AND (archivo_tipo = '".$tipo."')";
            $this->db->Execute($sql);
			
			$sql_contenido = "DELETE FROM {$this->archivo_contenido} WHERE id_archivo = '{$id_archivo}'";            
            $this->db->Execute($sql_contenido);

            return $this->setTransaccion('end');            
        }        
        
        //Se publica un enlace
        function Publicar_enlace($id_generador, $id_enlace, $tipo){
            $this->setTransaccion('start');

            $sql = "UPDATE ".$this->plantilla_enlace." SET enlace_publicar = '";
            if($tipo == "s"){
                $sql .= "n";
            }else{
                $sql .= "s";
            }            
            $sql .= "' WHERE id_enlace = ".$id_enlace;
            
            $this->db->Execute($sql);
            
            if($tipo == "n"){
                $sql = "UPDATE ".$this->plantilla_enlace." SET enlace_publicar = 'n'";
                $sql .= " WHERE (id_generador = ".$id_generador.") AND (id_enlace != ".$id_enlace.")";
                
                $this->db->Execute($sql);                

                $sql = "UPDATE ".$this->archivo_usuario." SET archivo_publicar = 'n'";
                $sql .= " WHERE id_generador = ".$id_generador;
                
                $this->db->Execute($sql);
            }

            return $this->setTransaccion('end');                                    
        }

        //Se publica un enlace
        function Publicar_archivo($id_generador, $mes, $anio,$id_archivo, $tipo_archivo, $tipo){
            $this->setTransaccion('start');

            $sql = "UPDATE ".$this->archivo_usuario." SET archivo_publicar = '";
            if($tipo == "s"){
                $sql .= "n";
            }else{
                $sql .= "s";
            }            
			if ($id_archivo=="t"){
				$sql .= "' WHERE ";
			} else {
				$sql .= "' WHERE (archivo_mes = ".$mes.") AND (archivo_anio = ".$anio.") AND (id_archivo = ".$id_archivo.") AND";
			}
            $sql .= " (id_generador = ".$id_generador.") AND ";
            $sql .= "(archivo_tipo = '".$tipo_archivo."')";
            $this->db->Execute($sql);
            
            if($tipo == "n"){
                $sql = "UPDATE ".$this->plantilla_enlace." SET enlace_publicar = 'n'";
                $sql .= " WHERE (id_generador = ".$id_generador.")";
            
                $this->db->Execute($sql);

                $sql = "UPDATE ".$this->archivo_usuario." SET archivo_publicar = 'n'";
                $sql .= " WHERE ";
                $sql .= "(id_generador = ".$id_generador.") AND ";
                $sql .= "(archivo_tipo != '".$tipo_archivo."')";
                
                $this->db->Execute($sql);
            }
            
            return $this->setTransaccion('end');                        
        }        
	}
?>