<?php
// Portable UTF-8
use voku\helper\UTF8;
	class Organos_Modelo extends Modelo {

		var $tb_funcionario;
		var $tb_organos;
		var $tb_historial;
		var $tb_oirs;
	
		function Organos_Modelo() {
			parent::Modelo();
			$this->tb_funcionario = 'trans_funcionario';	
			$this->tb_organos = 'trans_organo_administrativo';
			$this->tb_historial = 'trans_historial';
			$this->tb_oirs = 'trans_oirs';
		}
		
		
		function getOrganos() {
		
			$sql = 'select * from '.$this->tb_organos.' order by id_organo asc';
			$rs_org = $this->getConsulta($sql);
			$organos = array();

			while (!$rs_org->EOF) {		
				$organos[$rs_org->fields['id_organo']] = $rs_org->fields['nombre'];				
				$rs_org->MoveNext();
			}
			return $organos;
		}
		
		function getOrgano($id_organo) {
			$sql = "select * from {$this->tb_organos} where id_organo='{$id_organo}' ";
			$rs = $this->getConsulta($sql);
			$organo = array();
			$organo['existe'] = (!$rs->EOF) ? true : false;			
			$organo["id_organo"] = $rs->fields["id_organo"];
			$organo["id_funcionario"] = $rs->fields["id_funcionario"];
			$organo["id_organo_padre"] = $rs->fields["id_organo_padre"];
			$organo["nombre"] = $rs->fields["nombre"];			
		
			return $organo;
		}
		
		function getOrganos_Funcionario() {
		
			$sql = 'select id_funcionario,nombre from '.$this->tb_funcionario.' order by nombre asc';
			$rs = $this->getConsulta($sql);
			$funcionario = array();

			while (!$rs->EOF) {		
				$existe = $this->getOrgano_Padre($rs->fields['id_funcionario']);
				if(!$existe['existe']){
					$funcionario[$rs->fields['id_funcionario']] = $rs->fields['nombre'];				
				}	
				$rs->MoveNext();
			}
			return $funcionario;
		}
		
		function getFuncionario_organo($id_organo) {
		
			$sql = "select f.*,o.nombre as nombre_org from {$this->tb_funcionario} f, {$this->tb_organos} o 
			where o.id_organo = '{$id_organo}' and o.id_funcionario = f.id_funcionario";	
			$rs = $this->getConsulta($sql);
						
				$funcionario['nombre'] = $rs->fields['nombre'];
				$funcionario['nick'] = $rs->fields['nick'];	
				$funcionario['email'] = $rs->fields['email'];
				$funcionario['nombre_org'] = $rs->fields['nombre_org'];							
			
			return $funcionario;
		}
		
			
			function getOrgano_Padre($id_funcionario) {
		
			$sql = "select * from {$this->tb_organos}
			where id_funcionario = '{$id_funcionario}'";	
			$rs = $this->getConsulta($sql);
				
				$organo['existe'] = (!$rs->EOF) ? true : false;
				$organo['id_organo'] = $rs->fields['id_organo'];
				$organo['id_funcionario'] = $rs->fields['id_funcionario'];	
				$organo['id_organo_padre'] = $rs->fields['id_organo_padre'];
				$organo['nombre'] = $rs->fields['nombre'];							
			
			return $organo;
		}
		
		function getOrgano_historial($id_organo) {
			$sql = "select * from $this->tb_historial h,$this->tb_oirs o
			where h.id_organo='$id_organo' and o.id_oirs=h.id_oirs 
			order by h.fecha desc limit 1";
			$rs = $this->getConsulta($sql);

			$organo['existe'] = (!$rs->EOF) ? true : false;			
			$organo["id_organo"] = $rs->fields["id_organo"];
			$organo["id_oirs"] = $rs->fields["id_oirs"];
			return $organo;
		}
	
		function getOrganismos($_pagina_actual) {
		
			$sql = "select o.*, f.nombre as nombre_funcionario from $this->tb_organos o, $this->tb_funcionario f 
			where o.id_funcionario = f.id_funcionario order by o.id_organo asc";
			$rs = $this->getConsulta($sql,true,$_pagina_actual);
		
			$organismos = array();

			while (!$rs->EOF) {
				$organo = array();
				$organo['id_funcionario'] = $rs->fields['id_funcionario'];
				$organo['id_organo'] = $rs->fields['id_organo'];
				$organo['nombre'] = $rs->fields['nombre'];
				$organo['nombre_funcionario'] = $rs->fields['nombre_funcionario'];
				$organo['oirs'] = $this->getOrgano_historial($rs->fields['id_organo']);					
				$organismos[] = $organo;
				$rs->MoveNext();
			}
			
			$datos["organos"] = $organismos;
			$datos["paginacion"] = $this->getPaginado($rs->atfirstpage(),$rs->absolutepage(),$rs->atlastpage(),$rs->lastpageno());
			$datos['paginacion']['paginar'] = ($rs->atfirstpage() && ($rs->lastpageno() == $rs->absolutepage())) ? "false" : "true";
			return $datos;
		}

		function Agregar($_cmps) {
			$this->setTransaccion('start');
			//Si viene el campo pass, lo cifra.
			if (isset($_cmps['pass'])){
				$_cmps['pass']	=	$this->getPassCifrado($_cmps['pass']);
			}
			#usuarios
			$sql = 'select * from '.$this->tb_funcionarios.' where id_funcionario = -1';
			$this->setGuardar($sql,$_cmps);
			$id_usuario = $this->getInsertID();
			
			return $this->setTransaccion('end');
		}
			
		function setInsertID() {
				return $this->getInsertID();
		}
		
		function setAgregar_organo($cmps) {
			$sql = "select * from {$this->tb_organos} where id_organo = -1";
			return $this->setGuardar($sql,$cmps);
		}

		function Modificar($cmps){
			$sql = 'select * from '.$this->tb_organos.' where id_organo = '.$cmps['id_organo'];
			return $this->setModificar($sql,$cmps);
		}
		
		function Eliminar($id_organo) {
			$this->setTransaccion('start');

			$sql = 'delete from '.$this->tb_organos.' where id_organo = '.$id_organo;
			$this->db->Execute($sql);

			return $this->setTransaccion('end');
		}
	}
?>