<?php
// Portable UTF-8
use voku\helper\UTF8;
class OIRS_Modelo extends Modelo {

	var $tb_oirs;
	var $tb_estados_oirs;
	var $tb_tipo_oirs;
	var $tb_funcionarios;
	var $tb_historial;
	var $tb_ciudadano;
	var $tb_persona;
	var $tb_ciudadano_persona;
	 
	var $tb_organo;
	var $tb_usuarios;
	
	var $tb_trans_adjunto;
	var $tb_trans_oirs_binario;
	var $tb_feriados;
	var $tb_trans_regiones;
	var $tb_trans_comunas;
	var $tb_trans_solicitante;
	
	

	function OIRS_Modelo() {
		parent::Modelo();
		$this->tb_oirs = 'trans_oirs';
		$this->tb_estados_oirs = 'trans_estados_oirs';
		$this->tb_tipo_oirs = 'trans_tipo_oirs';
		$this->tb_funcionarios = 'trans_funcionario';
		$this->tb_historial = 'trans_historial';
		$this->tb_ciudadano = 'trans_ciudadano';
		$this->tb_persona = 'trans_persona_juridica';
		$this->tb_ciudadano_persona = 'trans_ciudadano_persona_juridica';
		
		$this->tb_organo = 'trans_organo_administrativo';
		$this->tb_usuarios = 'trans_usuarios';
		$this->tb_trans_adjunto = 'trans_adjunto';
		$this->tb_trans_oirs_binario = 'trans_oirs_binario';
		$this->tb_feriados = 'trans_feriados';
		$this->tb_trans_regiones = 'trans_regiones';
		$this->tb_trans_comunas = 'trans_comunas';
		$this->tb_trans_solicitante = 'trans_solicitante';
	}
	//funciones transaccion
	function Start() {
		$this->setTransaccion('start');
	}
	
	function End() {
		$this->setTransaccion('end');
	}
	
	function FailTrans() {
		$this->setTransaccion('fail');
	}
	
	function setInsertID() {
		return $this->getInsertID();
	}
	//funciones ingresar consulta
	function setAgregarOIRS($cmps) {
		$sql = "select * from {$this->tb_oirs} where id_oirs = -1";
		return $this->setGuardar($sql,$cmps);
	}
	//agregar ciudadano
	function setAgregarUsuario($cmps) {
		$sql = "select * from {$this->tb_usuarios} where id_usuario = -1";
		return $this->setGuardar($sql,$cmps);
	}

	function setAgregarSolicitante($cmps){
		$sql = "select * from {$this->tb_trans_solicitante} where id_solicitante = -1";
		return $this->setGuardar($sql,$cmps);
	}
	
	function setAgregarCiudadano($cmps) {
		$sql = "select * from {$this->tb_ciudadano} where id_ciudadano = -1";
		return $this->setGuardar($sql,$cmps);
	}
	//agregar ciudadano persona juridica
	function setAgregarCiudadano_persona($cmps) {
		$sql = "select * from {$this->tb_ciudadano_persona}";
		return $this->setGuardar($sql,$cmps);
	}
	
	function setAgregarPersona_juridica($cmps) {
		$sql = "select * from {$this->tb_persona}";
		return $this->setGuardar($sql,$cmps);
	}
	//modificar ciudadano
	function setModificarUsuario($cmps) {
		$sql = "select * from {$this->tb_usuarios} where id_usuario = {$cmps['id_usuario']}";
		return $this->setModificar($sql,$cmps);
	}
	
	function setModificarCiudadano($cmps) {
		$sql = "select * from {$this->tb_ciudadano} where id_ciudadano = {$cmps['id_ciudadano']}";
		return $this->setModificar($sql,$cmps);
	}
	//tipos de oirs
	function getTiposOIRS() {
		$sql = "select * from {$this->tb_tipo_oirs} order by tipo asc";
		$rs = $this->getConsulta($sql);
		$estados = array();
		while (!$rs->EOF) {
			$estados[$rs->fields['id_tipo']] = $rs->fields['tipo'];
			$rs->MoveNext();
		}
		return $estados;
	}
	//Ciudadanos
	function getLista_ciudadano() {
		$sql = "select * from {$this->tb_ciudadano} order by nombre asc";
		$rs = $this->getConsulta($sql);
		$estados = array();
		while (!$rs->EOF) {
			$estados[$rs->fields['id_ciudadano']] = $rs->fields['nombre']." ".$rs->fields['apellido_paterno_ciudadano'];
			$rs->MoveNext();
		}
		return $estados;
	}
	//datos funcionario de un organo
	function getFuncionario($id_organo) {
		
		$sql = "select f.*,o.id_organo from {$this->tb_organo} o, $this->tb_funcionarios f 
		where o.id_organo='$id_organo' and o.id_funcionario=f.id_funcionario";
		$rs_usuario = $this->getConsulta($sql);
				
		$usuario["id_organo"] = $rs_usuario->fields["id_organo"];
		$usuario["email"] = $rs_usuario->fields["email"];
		$usuario["nombre"] = $rs_usuario->fields["nombre"];
		$usuario["id_funcionario"] = $rs_usuario->fields["id_funcionario"];

 

		return $usuario;
	}
	
	//funciones administrador oirs
	function  getEstados_cierre() {
		
		$sql = "select * from {$this->tb_estados_oirs} where admisible= '0' order by estado asc";
		$rs = $this->getConsulta($sql);
		$estados = array();

		while (!$rs->EOF) {		
			$estados[$rs->fields['id_estado']] = $rs->fields['estado'];				
			$rs->MoveNext();
		}
		return $estados;
	}
	
	function  getEstados_Tramite() {
		
		$sql = "select * from {$this->tb_estados_oirs} where id_estado = 'DE' or id_estado = 'RP' or id_estado = 'ET' order by estado desc";
		$rs = $this->getConsulta($sql);
		$estados = array();

		while (!$rs->EOF) {		
			$estados[$rs->fields['id_estado']] = $rs->fields['estado'];				
			$rs->MoveNext();
		}
		return $estados;
	}

	/*
	Autor : Gino Berríos
	Fecha : 08/11/2013
	Cambio: Nuevo metódo getEstados_Tramite_Extendido para en caso de estar extendida la solicitud solo muestre dos estados derivado - respondido 
	*/

	function  getEstados_Tramite_Extendido() {
		
		$sql = "select * from {$this->tb_estados_oirs} where id_estado = 'DE' or id_estado = 'RP' order by estado desc";
		$rs = $this->getConsulta($sql);
		$estados = array();

		while (!$rs->EOF) {		
			$estados[$rs->fields['id_estado']] = $rs->fields['estado'];				
			$rs->MoveNext();
		}
		return $estados;
	}
	
	function getEstados_No_Oficina() {
		
		//$sql = "select * from {$this->tb_estados_oirs} where id_estado = 'DE' or id_estado = 'ET' order by estado desc";
		$sql = "select * from {$this->tb_estados_oirs} where id_estado = 'DE' order by estado desc";
		$rs = $this->getConsulta($sql);
		$estados = array();

		while (!$rs->EOF) {		
			$estados[$rs->fields['id_estado']] = $rs->fields['estado'];				
			$rs->MoveNext();
		}
		return $estados;
	}
	
		function  getEstado_Derivar() {
		
		$sql = "select * from {$this->tb_estados_oirs} where id_estado = 'DE' or id_estado = 'ET' order by estado desc";
		$rs = $this->getConsulta($sql);
		$estados = array();

		while (!$rs->EOF) {		
			$estados[$rs->fields['id_estado']] = $rs->fields['estado'];				
			$rs->MoveNext();
		}
		return $estados;
	}
		
	function getEstado($id_estado){
		
		$sql = "select * from {$this->tb_estados_oirs} where id_estado= '{$id_estado}' order by id_estado asc";
		$rs = $this->getConsulta($sql);
		$estados = array();

		$estados["id_estado"] = $rs->fields["id_estado"];
		$estados["estado"] = $rs->fields["estado"];
		
		return $estados;
	}
		
	
	function setModificar_Oirs($cmps_oirs) {
		$sql = "select * from {$this->tb_oirs} where id_oirs={$cmps_oirs['id_oirs']}";
		return $this->setModificar($sql,$cmps_oirs);
	}
	
	function setAgregar_Historial($cmps) {
		$sql = "select * from {$this->tb_historial} where id_historial = -1";
		return $this->setGuardar($sql,$cmps);
	}

	function setOIRSModificar($cmps) {
		$sql = "select * from {$this->tb_historial} where id_oirs={$cmps['id_oirs']}";
		return $this->setModificar($sql,$cmps);
	}
		
		function DiasRestantes($desde, $hasta){
			
			$feriados_modelo = new Feriado_Modelo();
		
			$vencido = false;
			/*print_r(strtotime($desde));
			print_r("/");
			print_r(strtotime($hasta));*/ 	
			if(strtotime($desde) >= strtotime($hasta)) {
				$vencido = true;
				$desded = $desde;
				$desde = $hasta;
				$hasta = $desded;			
			}
			
			$desde = $feriados_modelo->fechaAMD($desde);
         $feriados = $feriados_modelo->getFeriados_Actuales($desde);
     
		   //separo la fecha en dia mes y año
            $dia = date('d', strtotime($desde));
            $mes = date('m', strtotime($desde));
            $ano = date('Y', strtotime($desde));

            $mkDesde    = mktime(0,0,0,$mes,$dia,$ano);
            $i = 1;
            $sumar = 0;
            $llega=false;
            
           if(strtotime($desde) != strtotime($hasta)) {
            while(!$llega){            
                $mkDia = mktime(0, 0, 0, $mes, $dia + $i, $ano);
                
                $resultado = date('Y/m/d', $mkDia);
                if($feriados_modelo->esHabil($resultado, $feriados)){
                    $sumar += 1;
                }

					$diah = date('d', strtotime($hasta));
           		 $mesh = date('m', strtotime($hasta));
           		 $anoh = date('Y', strtotime($hasta)); 
           		 
           		 $mkHasta    = mktime(0,0,0,$mesh,$diah,$anoh);
           		 
           		 $resultadoHasta = date('Y/m/d', $mkHasta);           
                
                if($resultado >= $resultadoHasta){
                	$llega = true;                	
                }                
                	$i++;
            }
            }
            	if($vencido) {
            		$sumar = $sumar*-1;
            }
            	
            	return $sumar;       
        }
        
    function getDepsCiuNombre($id_dep){
			$sql = "SELECT * FROM {$this->tb_organo} WHERE id_organo = '".$id_dep."'";
			$rs = $this->getConsulta($sql);
			return $rs->fields["nombre"];
		}	


	function getSolicitante($id_solicitante){

		$sql = "SELECT * FROM {$this->tb_trans_solicitante} WHERE id_solicitante = '$id_solicitante'";
		$rs= $this->getConsulta($sql);

		$solicitante["id_solicitante"] = $rs->fields["id_solicitante"];
		$solicitante["razon_social_solicitante"] = $rs->fields["razon_social"];
		$solicitante["nombre_solicitante"] = $rs->fields["nombre"];
		$solicitante["apellido_paterno_solicitante"] = $rs->fields["apellido_paterno_ciudadano"];
		$solicitante["apellido_materno_solicitante"] = $rs->fields["apellido_materno_ciudadano"];
		$solicitante["email_o_postal"] = $rs->fields["email_o_postal"];
		$solicitante["email_solicitante"] = $rs->fields["email"];
		$solicitante["direccion_solicitante"] = $rs->fields["direccion"];
		$solicitante["region_solicitante"] = $rs->fields["region"];
		$solicitante["comuna_solicitante"] = $rs->fields["comuna"];
		$solicitante["localidad_solicitante"] = $rs->fields["localidad"];
		$solicitante["tipo_solicitante"] = $rs->fields["tipo"];
		$solicitante["apoderado_solicitante"] = $rs->fields["apoderado"];
		$solicitante["nombre_apoderado"] = $rs->fields["nombre_apoderado"];	
		$solicitante["ap_paterno_apoderado"] = $rs->fields["ap_paterno_apoderado"];	
		$solicitante["ap_materno_apoderado"] = $rs->fields["ap_materno_apoderado"];
		$solicitante["fecha_solicitud"] = $rs->fields["fecha_solicitud"];
		$solicitante["numero_papel"] = $rs->fields["numero_papel"];

		return $solicitante;
	}
			
	function getOIRSs($_pagina_actual,$id_organo) {
	
		$sql="select o.*,c.*,t.tipo as tipo_oirs,t.solicitud_informacion, e.*		
		from {$this->tb_oirs} o
		inner join {$this->tb_estados_oirs} e on o.id_estado = e.id_estado 
		inner join {$this->tb_tipo_oirs} t on o.id_tipo = t.id_tipo 
		inner join {$this->tb_ciudadano} c on o.id_ciudadano = c.id_ciudadano		
		where (o.id_estado ='RE' or o.id_estado ='EP' or o.id_estado ='ET' or o.id_estado ='DE' or o.id_estado ='CO' or o.id_estado ='EC') 
		and (o.id_organo = $id_organo OR o.id_organo = 0)
		order by o.fecha desc";
		
		//print_r($sql);
		
		$rs = $this->getConsulta($sql,true,$_pagina_actual);
		$oirss = array();
	
		$feriados_modelo = new Feriado_Modelo();
		while (!$rs->EOF) {
			$oirs = array();
			$oirs['historial'] = $this->getUltimo_historial($rs->fields['id_oirs']);
			$oirs['id_oirs'] = $rs->fields['id_oirs'];
			$oirs['razon_social'] = $rs->fields['razon_social'];
			$oirs['id_ciudadano'] = $rs->fields['id_ciudadano'];	
			$oirs['id_tipo'] = $rs->fields['id_tipo'];	
			$oirs['id_estado'] = $rs->fields['id_estado'];
			$oirs['asunto'] = $rs->fields['asunto'];	
			$oirs['tipo_solicitante'] = $rs->fields['tipo_solicitante'];	
			$oirs['fecha'] = $rs->fields['fecha'];	
			$oirs['fecha_modificar'] = $rs->fields['fecha_modificar'];	
			$oirs['mensaje'] = $rs->fields['mensaje'];	
			$oirs['fecha_maxima_respuesta'] = $rs->fields['fecha_maxima_respuesta'];	
			$oirs['fecha_extendido'] = $rs->fields['fecha_extendido'];	
			$oirs['id_organo_ciu'] = $rs->fields['id_organo_ciu'];
			$oirs['solicitud_informacion'] = $rs->fields['solicitud_informacion'];
			$oirs['extendido'] = $rs->fields['extendido'];
				
				if($oirs['id_estado'] == 'EP') {
					$oirs['fechafinal'] = $rs->fields['fecha_maxima_respuesta'];
				}elseif($oirs['id_estado'] == 'RE'){
					$oirs['fechafinal'] = $feriados_modelo->fechaValida($oirs['fecha'],_DIAS_RESP);				
				}elseif($oirs['id_estado'] == 'ET'){
					$oirs['fechafinal'] = $rs->fields['fecha_extendido'];				
				}elseif($oirs['id_estado'] == 'EC'){
					$oirs['fechafinal'] = $rs->fields['fecha_modificar'];
				}elseif($oirs['id_estado'] == 'CO' and $rs->fields['fecha_maxima_respuesta'] > $rs->fields['fecha_extendido']){
					$oirs['fechafinal'] = $rs->fields['fecha_maxima_respuesta'];
				}elseif($oirs['id_estado'] == 'CO' and $rs->fields['fecha_maxima_respuesta'] < $rs->fields['fecha_extendido']){
					$oirs['fechafinal'] = $rs->fields['fecha_extendido'];
				}elseif($oirs['id_estado'] == 'DE' and $rs->fields['fecha_maxima_respuesta'] > $rs->fields['fecha_extendido']) {
					$oirs['fechafinal'] = $rs->fields['fecha_maxima_respuesta'];
				}elseif($oirs['id_estado'] == 'DE' and $rs->fields['fecha_maxima_respuesta'] < $rs->fields['fecha_extendido']) {
					$oirs['fechafinal'] = $rs->fields['fecha_extendido'];
				}else{
					$oirs['fechafinal'] = 'N/A';
				}

			/* Datos solicitante */
			if($rs->fields["solicitud_informacion"]==1){
			$solicitante = $this->getSolicitante($rs->fields["id_solicitante"]);
			}
			$oirs['solicitud_manual'] = $rs->fields['solicitud_manual'];
			$oirs['fecha_solicitud'] = $solicitante["fecha_solicitud"];				
			$oirs['numero_papel'] = $solicitante["numero_papel"];				
			/* Fin datos solicitante */

			/* Datos ciudadano */
			
			switch($solicitante["tipo_solicitante"]){
				case 1:
				$oirs['nombre'] = $rs->fields["solicitud_informacion"] == 1 ? ucwords($solicitante["nombre_solicitante"]) : ucwords($rs->fields['nombre']);				
				$oirs['apellido_paterno_ciudadano'] = $rs->fields["solicitud_informacion"] == 1 ? ucwords($solicitante["apellido_paterno_solicitante"]) : $rs->fields["apellido_paterno_ciudadano"];
				$oirs['apellido_materno_ciudadano'] = $rs->fields["solicitud_informacion"] == 1 ? ucwords($solicitante["apellido_materno_solicitante"]) : $rs->fields["apellido_materno_ciudadano"];

				break;

				case 2:
				$oirs['nombre'] = $rs->fields["solicitud_informacion"] == 1 ? ucwords($solicitante["razon_social_solicitante"]) : ucwords($rs->fields['nombre']);
				break;
			}
			
			/*$oirs['nombre'] = $rs->fields["solicitud_informacion"] == 1 ? ucwords($solicitante["nombre_solicitante"]) : ucwords($rs->fields['nombre']);				
			$oirs['apellido_paterno_ciudadano'] = $rs->fields["solicitud_informacion"] == 1 ? ucwords($solicitante["apellido_paterno_solicitante"]) : $rs->fields["apellido_paterno_ciudadano"];
			$oirs['apellido_materno_ciudadano'] = $rs->fields["solicitud_informacion"] == 1 ? ucwords($solicitante["apellido_materno_solicitante"]) : $rs->fields["apellido_materno_ciudadano"];*/

			$oirs['direccion'] = $rs->fields['direccion'];	
			$oirs['tramitado'] = $rs->fields['tramitado'];	
			$oirs['estado'] = $rs->fields['estado'];	
			$oirs['tipo'] = $rs->fields['tipo'];
			$oirs['tipo_oirs'] = $rs->fields['tipo_oirs'];
			$oirs['tipo_respuesta'] = $rs->fields['tipo_respuesta'];
			$oirs['nombre_dep'] = $this->getDepsCiuNombre($rs->fields['id_organo_ciu']);
			/* Fin datos ciudadano */

			/* Formato entrega */
			if ($rs->fields['formato_entrega'] != 5 && $rs->fields['formato_entrega'] != 0 && $rs->fields["solicitud_informacion"] == 1) {
				$oirs['formato_entrega'] = $rs->fields['formato_entrega'];
			}elseif($rs->fields['formato_entrega'] == 5 && $rs->fields["solicitud_informacion"] == 1){
				$oirs['formato_entrega'] = $rs->fields['otro_formato'];
			}elseif ($rs->fields["solicitud_informacion"] == 0 && $rs->fields['formato_entrega'] == 0) {
				$oirs['formato_entrega'] = "No aplica";
			}
            /* Fin formato entrega */
			
			/* Aquí realizar el calculo de los días restante*/		
			
			if($oirs['id_estado'] == 'EP') {			
			$oirs['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$oirs['fechafinal']);			
			}elseif ($oirs['id_estado'] == 'RE') {
			$oirs['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$oirs['fechafinal']);
			}elseif ($oirs['id_estado'] == 'ET') {
			$oirs['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$oirs['fechafinal']);
			}
			elseif ($oirs['id_estado'] == 'CO') {
			$oirs['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$oirs['fechafinal']);
			}
			elseif ($oirs['id_estado'] == 'EC') {
			$oirs['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$oirs['fechafinal']);
			}
			elseif ($oirs['id_estado'] == 'DE') {
			$oirs['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$oirs['fechafinal']);
			}
			else {
				$oirs['diasrestantes'] = 'N/A';
			}

			$oirs['derivado_de'] = $this->getDerivado_de($rs->fields['id_oirs']);		
			
			$date = date('Y-m-d H:i:s');		
			if($oirs['fecha_maxima_respuesta'] != "" and $oirs['tramitado'] == "0"){
				$oirs['alert'] =  $feriados_modelo->Alert($date,$rs->fields['fecha_maxima_respuesta']);	
			}			
			if($oirs['fecha_modificar'] != "" and $oirs['tramitado'] == "0"){
				$oirs['alert_correc']=  $feriados_modelo->Alert($date,$rs->fields['fecha_modificar']);	
			}
			/* Se define el color de la fila según los días restantes */
			$oirs['colorfila'] = $oirs['estado']!='Contestado' /*&& $oirs['solicitud_informacion']!= 0 */?($oirs['diasrestantes']<=3 ?'#FFCCCC':(($oirs['diasrestantes']<=8 && $oirs['diasrestantes']>=3)?'#FFFFCC':'#DDFFCC')):'#fff';
			$oirs['classfila'] = $oirs['estado']!='Contestado' /*&& $oirs['solicitud_informacion']!= 0 */?($oirs['diasrestantes']<=3 ?'fondo_plazo_1':(($oirs['diasrestantes']<=8 && $oirs['diasrestantes']>=3)?'fondo_plazo_2':'fondo_plazo_3')):'fondo_plazo_0';
			$oirss[] = $oirs;
			$rs->MoveNext();
			
		}

		$datos["oirss"] = $oirss;
		$datos["paginacion"] = $this->getPaginado($rs->atfirstpage(),$rs->absolutepage(),$rs->atlastpage(),$rs->lastpageno());
		$datos['paginacion']['paginar'] = ($rs->atfirstpage() && ($rs->lastpageno() == $rs->absolutepage())) ? "false" : "true";
		
		return $datos;
	}
	
		function getOIRSs_Organo($_pagina_actual,$id_organo) {		
		
		$sql="select o.*,c.*, e.estado, t.tipo as tipo_oirs, t.solicitud_informacion, oa.id_organo, oa.nombre as nombre_organismo	 
		from {$this->tb_oirs} o, 
		{$this->tb_estados_oirs} e, 
		{$this->tb_tipo_oirs} t, 
		{$this->tb_ciudadano} c, 
		{$this->tb_organo} oa, 
		{$this->tb_historial } h 
		where o.id_ciudadano = c.id_ciudadano 
		and e.id_estado = o.id_estado 
		and o.id_tipo = t.id_tipo 
		and o.id_oirs = h.id_oirs 
		and o.id_organo = '{$id_organo}' 
		and o.id_organo = h.id_organo 
		and oa.id_organo = '{$id_organo}' 
		and o.id_estado = h.id_estado
		group by o.id_oirs desc";
        
        //print_r($sql);

		$rs = $this->getConsulta($sql,true,$_pagina_actual);
		$oirss = array();
	
		$feriados_modelo = new Feriado_Modelo();
		while (!$rs->EOF) {
			$oirs = array();
			$oirs['historial'] = $this->getUltimo_historial($rs->fields['id_oirs']);
			$oirs['id_oirs'] = $rs->fields['id_oirs'];
			$oirs['rut_persona_juridica'] = $rs->fields['rut_persona_juridica'];
			$oirs['id_ciudadano'] = $rs->fields['id_ciudadano'];	
			$oirs['id_tipo'] = $rs->fields['id_tipo'];	
			$oirs['id_estado'] = $rs->fields['id_estado'];
			$oirs['asunto'] = $rs->fields['asunto'];	
			$oirs['tipo_solicitante'] = $rs->fields['tipo_solicitante'];	
			$oirs['fecha'] = $rs->fields['fecha'];	
			$oirs['fecha_modificar'] = $rs->fields['fecha_modificar'];	
			$oirs['mensaje'] = $rs->fields['mensaje'];	
			$oirs['fecha_maxima_respuesta'] = $rs->fields['fecha_maxima_respuesta'];	
			$oirs['fecha_extendido'] = $rs->fields['fecha_extendido'];
			$oirs['solicitud_informacion'] = $rs->fields['solicitud_informacion'];
			$oirs['razon_social'] = $rs->fields['razon_social'];
			$oirs['extendido'] = $rs->fields['extendido'];
			
			//if($oirs['solicitud_informacion']==1) {			
				if($oirs['id_estado'] == 'EP') {
					$oirs['fechafinal'] = $rs->fields['fecha_maxima_respuesta'];
				}elseif($oirs['id_estado'] == 'RE'){
					$oirs['fechafinal'] = $feriados_modelo->fechaValida($oirs['fecha'],_DIAS_RESP);				
				}elseif($oirs['id_estado'] == 'ET'){
					$oirs['fechafinal'] = $rs->fields['fecha_extendido'];				
				}elseif($oirs['id_estado'] == 'CO' and $rs->fields['fecha_maxima_respuesta'] > $rs->fields['fecha_extendido']){
					$oirs['fechafinal'] = $rs->fields['fecha_maxima_respuesta'];
				}elseif($oirs['id_estado'] == 'CO' and $rs->fields['fecha_maxima_respuesta'] < $rs->fields['fecha_extendido']){
					$oirs['fechafinal'] = $rs->fields['fecha_extendido'];
				}elseif($oirs['id_estado'] == 'DE' and $rs->fields['fecha_maxima_respuesta'] > $rs->fields['fecha_extendido']) {
					$oirs['fechafinal'] = $rs->fields['fecha_maxima_respuesta'];
				}elseif($oirs['id_estado'] == 'DE' and $rs->fields['fecha_maxima_respuesta'] < $rs->fields['fecha_extendido']) {
					$oirs['fechafinal'] = $rs->fields['fecha_extendido'];
				}else{
				$oirs['fechafinal'] = 'N/A';
				}
			/*}else {
				$oirs['fechafinal'] = 'N/A';
			}	*/	
				
			$oirs['nombre'] = $rs->fields['nombre'];	
			$oirs['direccion'] = $rs->fields['direccion'];	
			$oirs['tramitado'] = $rs->fields['tramitado'];
			$oirs['nombre_organismo'] = $rs->fields['nombre'];			
			
			$oirs['derivado_de'] = $this->getDerivado_de($rs->fields['id_oirs']);
						
			//$oirs['apellidos'] = $rs->fields['apellidos'];
			$oirs['apellido_paterno_ciudadano'] = $rs->fields['apellido_paterno_ciudadano'];	
			$oirs['apellido_materno_ciudadano'] = $rs->fields['apellido_materno_ciudadano'];		
			$oirs['estado'] = $rs->fields['estado'];	
			$oirs['tipo_oirs'] = $rs->fields['tipo_oirs'];
			$oirs['tipo_respuesta'] = $rs->fields['tipo_respuesta'];
			
			/* Aquí realizar el calculo de los días restante*/

			/* Formato entrega */
			if ($rs->fields['formato_entrega'] != 5 && $rs->fields['formato_entrega'] != 0 && $rs->fields["solicitud_informacion"] == 1) {
				$oirs['formato_entrega'] = $rs->fields['formato_entrega'];
			}elseif($rs->fields['formato_entrega'] == 5 && $rs->fields["solicitud_informacion"] == 1){
				$oirs['formato_entrega'] = $rs->fields['otro_formato'];
			}elseif ($rs->fields["solicitud_informacion"] == 0 && $rs->fields['formato_entrega'] == 0) {
				$oirs['formato_entrega'] = "No aplica";
			}
            /* Fin formato entrega */
			
			//if($oirs['solicitud_informacion']==1) {			
			if($oirs['id_estado'] == 'EP') {			
			$oirs['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$oirs['fechafinal']);			
			}elseif ($oirs['id_estado'] == 'RE') {
			$oirs['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$oirs['fechafinal']);
			}elseif ($oirs['id_estado'] == 'ET') {
			$oirs['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$oirs['fechafinal']);
			}
			elseif ($oirs['id_estado'] == 'CO') {
			$oirs['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$oirs['fechafinal']);
			}
			elseif ($oirs['id_estado'] == 'DE') {
			$oirs['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$oirs['fechafinal']);
			}
			else {
				$oirs['diasrestantes'] = 'N/A';
			}
		/*}else {
				$oirs['diasrestantes'] = 'N/A';
			}	*/
			/* Fin del cálculo de los días restante */
			/* Datos solicitante */
			if($rs->fields["solicitud_informacion"]==1){
			$solicitante = $this->getSolicitante($rs->fields["id_solicitante"]);
			}
			$oirs['solicitud_manual'] = $rs->fields['solicitud_manual'];
			$oirs['fecha_solicitud'] = $solicitante["fecha_solicitud"];				
			$oirs['numero_papel'] = $solicitante["numero_papel"];				
			/* Fin datos solicitante */
			

			$date = date('Y-m-d H:i:s');		
			if($oirs['fecha_maxima_respuesta'] != "" and $oirs['tramitado'] == "0"){
				$oirs['alert'] =  $feriados_modelo->Alert($date,$rs->fields['fecha_maxima_respuesta']);	
			}			
			if($oirs['fecha_modificar'] != "" and $oirs['tramitado'] == "0"){
				$oirs['alert_correc']=  $feriados_modelo->Alert($date,$rs->fields['fecha_modificar']);	
			}
			$oirs['colorfila'] = $oirs['estado']!='Contestado' /*&& $oirs['solicitud_informacion']!= 0*/ ?($oirs['diasrestantes']<=3 ?'#FFCCCC':(($oirs['diasrestantes']<=8 && $oirs['diasrestantes']>=3)?'#FFFFCC':'#DDFFCC')):'#fff';
			$oirs['classfila'] = $oirs['estado']!='Contestado' /*&& $oirs['solicitud_informacion']!= 0 */?($oirs['diasrestantes']<=3 ?'fondo_plazo_1':(($oirs['diasrestantes']<=8 && $oirs['diasrestantes']>=3)?'fondo_plazo_2':'fondo_plazo_3')):'fondo_plazo_0';
			$oirss[] = $oirs;	
			$rs->MoveNext();
		}
			
		$datos["oirss"] = $oirss;
		$datos["paginacion"] = $this->getPaginado($rs->atfirstpage(),$rs->absolutepage(),$rs->atlastpage(),$rs->lastpageno());
		$datos['paginacion']['paginar'] = ($rs->atfirstpage() && ($rs->lastpageno() == $rs->absolutepage())) ? "false" : "true";

		
		return $datos;
	}

	function getArchivados($_pagina_actual) {
		//$sql = "select o.*, e.estado, t.tipo from {$this->tb_oirs} o inner join {$this->tb_estados_oirs} e on o.estado_oirs=e.id_estado inner join {$this->tb_tipo_oirs} t on o.tipo_oirs=t.id_tipo where o.archivado=1 order by o.id_oirs desc";
		
		$sql="select o.*, c.email, eo.estado, t.tipo
	 from {$this->tb_oirs} o,{$this->tb_ciudadano} c,{$this->tb_historial} h,{$this->tb_estados_oirs} eo , {$this->tb_tipo_oirs} t 
	 where o.rut_ciudadano = c.rut_ciudadano and o.id_oirs = h.id_oirs and eo.id_estado = h.id_estado and h.id_estado='4' and o.id_tipo = t.id_tipo
	 order by h.fecha desc ";
		
		$rs = $this->getConsulta($sql,true,$_pagina_actual);
		$oirss = array();

		while (!$rs->EOF) {
			array_push($oirss,$rs->fields);
			$rs->MoveNext();
		}

		$datos["oirss"] = $oirss;
		$datos["paginacion"] = $this->getPaginado($rs->atfirstpage(),$rs->absolutepage(),$rs->atlastpage(),$rs->lastpageno());
		$datos['paginacion']['paginar'] = ($rs->atfirstpage() && ($rs->lastpageno() == $rs->absolutepage())) ? "false" : "true";
		
		
		return $datos;
	}

	function getFecha($f) {
		list($dd,$mm,$aa) = explode('/',$f);
		return "$aa-$mm-$dd";
	}

	function getBuscar($cmps,$_pagina_actual) {

		if (!empty($cmps['buscar_texto'])) {
			$sql_like = " and (o.id_oirs like '%{$cmps['buscar_texto']}%' or c.nombre like '%{$cmps['buscar_texto']}%'
				or c.apellido_paterno_ciudadano like '%{$cmps['buscar_texto']}%' or c.apellido_materno_ciudadano like '%{$cmps['buscar_texto']}%' or c.email like '%{$cmps['buscar_texto']}%' or o.asunto like '%{$cmps['buscar_texto']}%' or o.mensaje like '%{$cmps['buscar_texto']}%')";
		}
		
		if (!empty($cmps['desde'])&&!empty($cmps['hasta'])) {
			$desde = $this->getFecha($cmps['desde']);
			$hasta = $this->getFecha($cmps['hasta']);
			$sql_fecha .= " and o.fecha between '$desde' and '$hasta'";
		}
		
		if ($cmps['estado'] != "0") {
			$sql_estado .= "and o.id_estado = '{$cmps['estado']}'";
		}
		
		if ($cmps['tipo'] != "0") {
			$sql_tipo .= "and o.id_tipo = '{$cmps['tipo']}'";
		}
		
		if ($cmps['ciudadano'] != "0") {
			$sql_ciudadano .= "and o.id_ciudadano = '{$cmps['ciudadano']}'";
		}		
		
		
		if ($cmps['organo'] != "0") {			
			if($cmps['organo'] == "1") {
				$sql_organo .= "and (o.id_organo = '{$cmps['organo']}' or o.id_organo = '0')";
			}else{
				$sql_organo .= "and o.id_organo = '{$cmps['organo']}'";
			}
		}
		
		if ($cmps['tipoconsulta'] == "1") {
			$sql="select  o.*, h.id_historial,h.id_oirs,h.id_estado,h.id_organo,h.nota_al_ciudadano,h.nota_interna,h.respuesta_del_ciudadano,h.respuesta_fecha, c.*, eo.estado, t.tipo
				 from {$this->tb_oirs} o, {$this->tb_ciudadano} c, {$this->tb_estados_oirs} eo, {$this->tb_tipo_oirs} t, {$this->tb_historial} h
				 where h.id_organo = {$cmps['organo']} and o.id_ciudadano = c.id_ciudadano and eo.id_estado = o.id_estado and o.id_tipo = t.id_tipo and h.id_oirs = o.id_oirs $sql_like $sql_fecha $sql_estado $sql_tipo $sql_ciudadano 
				 group by h.id_oirs
				 order by o.fecha desc";
		}
		
		if ($cmps['tipoconsulta'] == "0") {
			$sql="select o.*, c.*, eo.estado, t.tipo
				 from {$this->tb_oirs} o, {$this->tb_ciudadano} c, {$this->tb_estados_oirs} eo, {$this->tb_tipo_oirs} t 	 
				 where o.id_ciudadano = c.id_ciudadano and o.id_estado = eo.id_estado and o.id_tipo = t.id_tipo $sql_like $sql_fecha $sql_estado $sql_tipo $sql_ciudadano $sql_organo
				 order by o.fecha desc";
	 	
		}
		
		if (empty($cmps['tipoconsulta'])) {
			$sql="select  o.*, c.*, eo.estado, t.tipo as tipo_oirs, t.solicitud_informacion
				 from {$this->tb_oirs} o, {$this->tb_ciudadano} c, {$this->tb_estados_oirs} eo, {$this->tb_tipo_oirs} t 
				 where o.id_ciudadano = c.id_ciudadano and o.id_estado = eo.id_estado and o.id_tipo = t.id_tipo $sql_like $sql_fecha $sql_estado $sql_tipo $sql_ciudadano $sql_organo
				 order by o.fecha desc";
		}
		
		//print_r($sql);
		//die();
		$rs = $this->getConsulta($sql,true,$_pagina_actual);
		$oirss = array();

		$feriados_modelo = new Feriado_Modelo();
		while (!$rs->EOF) {
			$oirs = array();
			$oirs['historial'] = $this->getUltimo_historial($rs->fields['id_oirs']);
			$oirs['id_oirs'] = $rs->fields['id_oirs'];
			$oirs['rut_persona_juridica'] = $rs->fields['rut_persona_juridica'];
			$oirs['id_ciudadano'] = $rs->fields['id_ciudadano'];	
			$oirs['id_tipo'] = $rs->fields['id_tipo'];	
			$oirs['id_estado'] = $rs->fields['id_estado'];
			$oirs['asunto'] = $rs->fields['asunto'];	
			$oirs['tipo_solicitante'] = $rs->fields['tipo_solicitante'];	
			$oirs['fecha'] = $rs->fields['fecha'];	
			$oirs['fecha_modificar'] = $rs->fields['fecha_modificar'];	
			$oirs['mensaje'] = $rs->fields['mensaje'];	
			$oirs['fecha_maxima_respuesta'] = $rs->fields['fecha_maxima_respuesta'];	
			$oirs['fecha_extendido'] = $rs->fields['fecha_extendido'];
			$oirs['solicitud_informacion'] = $rs->fields['solicitud_informacion'];
			$oirs['extendido'] = $rs->fields['extendido'];
			$oirs['razon_social'] = $rs->fields['razon_social'];
			
			//if($oirs['solicitud_informacion']==1) {			
				if($oirs['id_estado'] == 'EP') {
					$oirs['fechafinal'] = $rs->fields['fecha_maxima_respuesta'];
				}elseif($oirs['id_estado'] == 'RE'){
					$oirs['fechafinal'] = $feriados_modelo->fechaValida($oirs['fecha'],_DIAS_RESP);				
				}elseif($oirs['id_estado'] == 'ET'){
					$oirs['fechafinal'] = $rs->fields['fecha_extendido'];				
				}elseif($oirs['id_estado'] == 'CO' and $rs->fields['fecha_maxima_respuesta'] > $rs->fields['fecha_extendido']){
					$oirs['fechafinal'] = $rs->fields['fecha_maxima_respuesta'];
				}elseif($oirs['id_estado'] == 'CO' and $rs->fields['fecha_maxima_respuesta'] < $rs->fields['fecha_extendido']){
					$oirs['fechafinal'] = $rs->fields['fecha_extendido'];
				}elseif($oirs['id_estado'] == 'EC'){
					$oirs['fechafinal'] = $rs->fields['fecha_modificar'];		
				}elseif($oirs['id_estado'] == 'DE' and $rs->fields['fecha_maxima_respuesta'] > $rs->fields['fecha_extendido']) {
					$oirs['fechafinal'] = $rs->fields['fecha_maxima_respuesta'];
				}elseif($oirs['id_estado'] == 'DE' and $rs->fields['fecha_maxima_respuesta'] < $rs->fields['fecha_extendido']) {
					$oirs['fechafinal'] = $rs->fields['fecha_extendido'];
				}else{
				$oirs['fechafinal'] = 'N/A';
				}
			/*}else {
				$oirs['fechafinal'] = 'N/A';
			}*/	
			
			$oirs['nombre'] = $rs->fields['nombre'];	
			$oirs['direccion'] = $rs->fields['direccion'];	
			$oirs['tramitado'] = $rs->fields['tramitado'];		
			$oirs['apellido_paterno_ciudadano'] = $rs->fields['apellido_paterno_ciudadano'];
			$oirs['apellido_materno_ciudadano'] = $rs->fields['apellido_materno_ciudadano'];
			$oirs['estado'] = $rs->fields['estado'];	
			
			$oirs['derivado_de'] = $this->getDerivado_de($rs->fields['id_oirs']);
			
			$oirs['tipo_oirs'] = $rs->fields['tipo_oirs'];
			$oirs['tipo_respuesta'] = $rs->fields['tipo_respuesta'];
			$oirs['nombre_dep'] = $this->getDepsCiuNombre($rs->fields['id_organo_ciu']);

			/* Formato entrega */
			if ($rs->fields['formato_entrega'] != 5 && $rs->fields['formato_entrega'] != 0 && $rs->fields["solicitud_informacion"] == 1) {
				$oirs['formato_entrega'] = $rs->fields['formato_entrega'];
			}elseif($rs->fields['formato_entrega'] == 5 && $rs->fields["solicitud_informacion"] == 1){
				$oirs['formato_entrega'] = $rs->fields['otro_formato'];
			}elseif ($rs->fields["solicitud_informacion"] == 0 && $rs->fields['formato_entrega'] == 0) {
				$oirs['formato_entrega'] = "No aplica";
			}
            /* Fin formato entrega */
			
			/* Aquí realizar el calculo de los días restante*/
			
			//if($oirs['solicitud_informacion']==1) {			
			if($oirs['id_estado'] == 'EP') {			
			$oirs['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$oirs['fechafinal']);			
			}elseif ($oirs['id_estado'] == 'RE') {
			$oirs['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$oirs['fechafinal']);
			}elseif ($oirs['id_estado'] == 'ET') {
			$oirs['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$oirs['fechafinal']);
			}
			elseif ($oirs['id_estado'] == 'CO') {
			$oirs['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$oirs['fechafinal']);
			}
			elseif ($oirs['id_estado'] == 'EC') {
			$oirs['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$oirs['fechafinal']);
			}
			elseif ($oirs['id_estado'] == 'DE') {
			$oirs['diasrestantes'] = $this->DiasRestantes(date('Y-m-d'),$oirs['fechafinal']);
			}
			else {
				$oirs['diasrestantes'] = 'N/A';
			}
		/*}else {
				$oirs['diasrestantes'] = 'N/A';
			}	*/
			/* Fin del cálculo de los días restante */

			/* Datos solicitante */
			if($rs->fields["solicitud_informacion"]==1){
			$solicitante = $this->getSolicitante($rs->fields["id_solicitante"]);
			}
			$oirs['solicitud_manual'] = $rs->fields['solicitud_manual'];
			$oirs['fecha_solicitud'] = $solicitante["fecha_solicitud"];				
			$oirs['numero_papel'] = $solicitante["numero_papel"];				
			/* Fin datos solicitante */
			
			
			$date = date('Y-m-d H:i:s');			
			if($oirs['fecha_maxima_respuesta'] != "" and $oirs['tramitado'] == "0"){
				$oirs['alert'] =  $feriados_modelo->Alert($date,$rs->fields['fecha_maxima_respuesta']);	
			}
			if($oirs['fecha_modifiicar'] != "" and $oirs['tramitado'] == "0"){			
				$oirs['alert_correc'] =  $feriados_modelo->Alert($date,$rs->fields['fecha_modificar']);	
			}
			$oirs['colorfila'] = $oirs['estado']!='Contestado' /*&& $oirs['solicitud_informacion']!= 0*/ ?($oirs['diasrestantes']<=3 ?'#FFCCCC':(($oirs['diasrestantes']<=8 && $oirs['diasrestantes']>=3)?'#FFFFCC':'#DDFFCC')):'#fff';
			$oirs['classfila'] = $oirs['estado']!='Contestado' /*&& $oirs['solicitud_informacion']!= 0 */?($oirs['diasrestantes']<=3 ?'fondo_plazo_1':(($oirs['diasrestantes']<=8 && $oirs['diasrestantes']>=3)?'fondo_plazo_2':'fondo_plazo_3')):'fondo_plazo_0';
            
			$oirss[] = $oirs;
			$rs->MoveNext();
		}

		$datos["oirss"] = $oirss;
		$datos["paginacion"] = $this->getPaginado($rs->atfirstpage(),$rs->absolutepage(),$rs->atlastpage(),$rs->lastpageno());
		$datos['paginacion']['paginar'] = ($rs->atfirstpage() && ($rs->lastpageno() == $rs->absolutepage())) ? "false" : "true";
		
		return $datos;
	}

	function getOIRS($id_oirs) {
		$sql = "select o.*,c.*, e.estado, e.id_estado, t.tipo from {$this->tb_oirs} o,{$this->tb_estados_oirs} e ,{$this->tb_historial} h,{$this->tb_ciudadano} c,{$this->tb_tipo_oirs} t where o.id_tipo=t.id_tipo and o.id_oirs = $id_oirs and c.id_ciudadano = o.id_ciudadano and o.id_oirs = h.id_oirs and h.id_estado = e.id_estado";

		$rs = $this->getConsulta($sql);

		return $rs->fields;
	}

	function getDatos_oirs($id_oirs){
		$sql = "select o.*, t.tipo, t.solicitud_informacion,t.plazo, c.nombre, c.apellido_paterno_ciudadano, c.apellido_materno_ciudadano, c.email, c.direccion
		 from {$this->tb_oirs} o,{$this->tb_ciudadano} c, {$this->tb_tipo_oirs} t
		 where id_oirs = '$id_oirs' and o.id_tipo = t.id_tipo and o.id_ciudadano = c.id_ciudadano";

		$rs = $this->getConsulta($sql);
		$rs->fields["derivado_de"] = $this->getDerivado_de($rs->fields['id_oirs']);

		return $rs->fields;
	}
	function getEstados() {
		$sql = "select * from {$this->tb_estados_oirs} order by estado asc";
		$rs = $this->getConsulta($sql);
		$estados = array();
		while (!$rs->EOF) {
			$estados[$rs->fields['id_estado']] = $rs->fields['estado'];
			$rs->MoveNext();
		}
		return $estados;
	}
	
	
	function getDerivado_de($id_oirs) {
			
		$sql = "select h.*, oa.nombre from {$this->tb_historial} h,  {$this->tb_organo} oa
		where h.id_oirs = '{$id_oirs}' and h.id_organo = oa.id_organo order by id_historial desc, fecha asc limit 2";	

		$rs = $this->getConsulta($sql);
		$historiales = array();
		
		while (!$rs->EOF) {
			$historial = array();
			$historial['id_oirs'] = $rs->fields['id_oirs'];
			$historial['id_historial'] = $rs->fields['id_historial'];
			$historial['id_organo'] = $rs->fields['id_organo'];
			$historial['id_estado'] = $rs->fields['id_estado'];
			$historial['fecha'] = $rs->fields['fecha'];	
			$historial['nota_al_ciudadano'] = $rs->fields['nota_al_ciudadano'];	
			$historial['nota_interna'] = $rs->fields['nota_interna'];
			$historial['nombre'] = $rs->fields['nombre'];
			$historiales[] = $historial;
			$rs->MoveNext();
		}
		
		return $historiales;
		}

	function getHistorial($id_oirs,$_pagina_actual) {
			
		$sql = "select h.*, e.estado, oa.nombre from {$this->tb_historial} h, {$this->tb_estados_oirs} e, {$this->tb_organo} oa
		where h.id_oirs = '{$id_oirs}' and e.id_estado = h.id_estado and h.id_organo = oa.id_organo  order by id_historial desc,  fecha desc";	

		$this->max_reg  = 5;	
		$rs = $this->getConsulta($sql,true,$_pagina_actual);
		$historiales = array();
		
		while (!$rs->EOF) {
			$historial = array();
			$historial['id_oirs'] = $rs->fields['id_oirs'];
			$historial['id_historial'] = $rs->fields['id_historial'];
			$historial['id_organo'] = $rs->fields['id_organo'];
			$historial['id_estado'] = $rs->fields['id_estado'];
			$historial['fecha'] = $rs->fields['fecha'];	
			$historial['nota_al_ciudadano'] = $rs->fields['nota_al_ciudadano'];	
			$historial['nota_interna'] = $rs->fields['nota_interna'];
			$historial['respuesta_del_ciudadano'] = $rs->fields['respuesta_del_ciudadano'];
			$historial['nombre'] = $rs->fields['nombre'];
			$historial['estado'] = $rs->fields['estado'];
			$historial['derivado_de'] = $this->getDerivado_de($rs->fields['id_oirs']);		
			$historiales[] = $historial;
			$rs->MoveNext();
			
		}
		
		$datos["historiales"] = $historiales;
		$datos["paginacion"] = $this->getPaginado($rs->atfirstpage(),$rs->absolutepage(),$rs->atlastpage(),$rs->lastpageno());
		$datos['paginacion']['paginar'] = ($rs->atfirstpage() && ($rs->lastpageno() == $rs->absolutepage())) ? "false" : "true";
		
		//Limpiar planilla
        array_walk_recursive($datos["historiales"], function (&$value) {
            //Elimina el caracter BOM si lo tiene.
            $value = UTF8::remove_bom($value);
            //Convierte a iso-8859-1 si detecta utf-8, si no no realiza cambios.
            if (UTF8::str_detect_encoding($value) == 'UTF-8'){
                $value = UTF8::utf8_encode($value);
            } else {
                $value = UTF8::utf8_encode($value);
            }
        });
		
		
		return $datos;
	}
		
	function getHistorial_detalle($id_historial) {

		$sql = "select h.*, e.estado as estado, o.nombre as nombre from {$this->tb_historial} h, {$this->tb_estados_oirs} e, {$this->tb_organo} o
		where h.id_historial = '{$id_historial}'  and h.id_estado = e.id_estado and h.id_organo = o.id_organo
		order by h.fecha desc";

		$rs = $this->getConsulta($sql);

			$historial['id_historial'] = $rs->fields['id_historial'];
			$historial['id_oirs'] = $rs->fields['id_oirs'];	
			$historial['fecha'] = $rs->fields['fecha'];	

			$historial['nota_al_ciudadano'] = $rs->fields['nota_al_ciudadano'];	
			$historial['nota_interna'] = $rs->fields['nota_interna'];
			$historial['respuesta_del_ciudadano'] = $rs->fields['respuesta_del_ciudadano'];
			$historial['estado'] = $rs->fields['estado'];
			$historial['id_estado'] = $rs->fields['id_estado'];	
			$historial['nombre'] = $rs->fields['nombre'];			
        	
		return $historial;
	}
	

	/*
	Autor : Gino Berríos
	Fecha : 08/11/2013
	Cambio: Agregar al arreglo oirs el campo extendido, sacar todo respecto a persona juridica
	*/

	function getDetalle_oirs($id_oirs) {
		$sql = "select o.*,c.*,t.*,e.estado,e.id_estado,s.numero_papel,s.fecha_solicitud
		from {$this->tb_oirs} o,{$this->tb_ciudadano} c,{$this->tb_tipo_oirs} t,{$this->tb_estados_oirs} e,{$this->tb_trans_solicitante} s
		where o.id_oirs='$id_oirs' and o.id_ciudadano=c.id_ciudadano and o.id_tipo=t.id_tipo and o.id_estado=e.id_estado and o.id_solicitante = s.id_solicitante"; 
		
		$rs = $this->getConsulta($sql);

		$oirs["rut_ciudadano"] = $rs->fields["rut_ciudadano"];
		$oirs["rut_dv"] = $rs->fields["rut_dv"];
		$oirs["razon_social"] = $rs->fields["razon_social"];
		$oirs["nombre"] = $rs->fields["nombre"];
		$oirs["extendido"] = $rs->fields["extendido"];
		//$oirs["apellidos"] = $rs->fields["apellidos"];
		$oirs["apellido_paterno_ciudadano"] = $rs->fields["apellido_paterno_ciudadano"];
		$oirs["apellido_materno_ciudadano"] = $rs->fields["apellido_materno_ciudadano"];
		$oirs["email"] = $rs->fields["email"];
		$oirs["telefono"] = $rs->fields["telefono"];
		$oirs["direccion"] = $rs->fields["direccion"];
		$oirs["id_oirs"] = $rs->fields["id_oirs"];
		$oirs["id_ciudadano"] = $rs->fields["id_ciudadano"];
		$oirs["asunto"] = $rs->fields["asunto"];
		$oirs["mensaje"] = $rs->fields["mensaje"];
		$oirs["observaciones"] = $rs->fields["observaciones"];
		$oirs["fecha"] = $rs->fields["fecha"];
		$oirs["fecha_modificar"] = $rs->fields["fecha_modificar"];
		$oirs["fecha_maxima_respuesta"] = $rs->fields["fecha_maxima_respuesta"];
		$oirs["fecha_extendido"] = $rs->fields["fecha_extendido"];
		$oirs["tipo"] = $rs->fields["tipo"];
		$oirs["estado"] = $rs->fields["estado"];
		$oirs["id_estado"] = $rs->fields["id_estado"];
		$oirs["tipo_solicitante"] = $rs->fields["tipo_solicitante"];
		$oirs['historial'] = $this->getUltimo_historial($rs->fields['id_oirs']);
		$oirs["derivado_de"] = $this->getDerivado_de($rs->fields['id_oirs']);
		$oirs["numero_papel"] = $rs->fields['numero_papel'];
		$oirs["fecha_solicitud"] = $rs->fields['fecha_solicitud'];
		$oirs["solicitud_manual"] = $rs->fields['solicitud_manual'];
		//$oirs["respuesta_del_ciudadano"] = $rs->fields["respuesta_del_ciudadano"];	
		//$oirs["persona_juridica"] = $this->getPersona_juridica($rs->fields['rut_persona_juridica']);	
		
		
		//Limpiar planilla
        array_walk_recursive($oirs, function (&$value) {
            //Elimina el caracter BOM si lo tiene.
            $value = UTF8::remove_bom($value);
            //Convierte a iso-8859-1 si detecta utf-8, si no no realiza cambios.
            if (UTF8::str_detect_encoding($value) == 'UTF-8'){
                $value = UTF8::utf8_decode($value);
            } else {
                $value = UTF8::utf8_encode($value);
            }
        });
		
		return $oirs;
	}
	
	function getPersona_juridica($rut_persona_juridica) {
		$sql = "select p.*,cp.* from $this->tb_persona p,$this->tb_ciudadano_persona cp,$this->tb_ciudadano c
		where p.rut_persona_juridica='$rut_persona_juridica' and p.rut_persona_juridica=cp.rut_persona_juridica
		and cp.id_ciudadano=c.id_ciudadano";
		$rs = $this->getConsulta($sql);

		$persona["nombre_persona"] = $rs->fields["nombre"];
		$persona["cargo"] = $rs->fields["cargo"];
		$persona["representante_legal"] = $rs->fields["representante_legal"];
		$persona["telefono"] = $rs->fields["telefono"];
		$persona["direccion"] = $rs->fields["direccion"];
		
		return $persona;
	}
	
	function getUltimo_historial($id_oirs) {
		$sql = "select * from $this->tb_historial h,$this->tb_oirs o,$this->tb_estados_oirs e 
		where h.id_oirs='$id_oirs' and o.id_oirs=h.id_oirs and h.id_estado=e.id_estado
		order by h.id_historial desc limit 1";
		$rs = $this->getConsulta($sql);

		$historial["estado"] = $rs->fields["estado"];
		$historial["id_estado"] = $rs->fields["id_estado"];
		$historial["plazo_dias"] = $rs->fields["plazo_dias"];
		$historial["id_organo"] = $rs->fields["id_organo"];
		$historial["organo"] = $this->getOrgano($rs->fields['id_organo']);
		$historial["plazo_dias_adicionales"] = $rs->fields["plazo_dias_adicionales"];
		$historial["nota_ciudadano"] = $rs->fields["nota_ciudadano"];
		$historial["respuesta_del_ciudadano"] = $rs->fields["respuesta_del_ciudadano"];
		$historial["id_historial"] = $rs->fields["id_historial"];
		
		return $historial;
	}
	
	function getOrgano($id_organo) {
	
		$sql = "select * from $this->tb_organo where id_organo = $id_organo";
		$rs = $this->getConsulta($sql);

		$organo["id_organo"] = $rs->fields["id_organo"];
		$organo["nombre"] = $rs->fields["nombre"];
			
		return $organo;
	}
	
	function getCiudadano($id_ciudadano) {
	
		$sql = "select * from $this->tb_ciudadano where id_ciudadano = $id_ciudadano";
		$rs = $this->getConsulta($sql);

		$ciudadano["id_ciudadano"] = $rs->fields["id_ciudadano"];
		$ciudadano["rut_ciudadano"] = $rs->fields["rut_ciudadano"];
		$ciudadano["rut_dv"] = $rs->fields["rut_dv"];
		$ciudadano["nombre"] = $rs->fields["nombre"];
		$ciudadano["apellido_paterno_ciudadano"] = $rs->fields["apellido_paterno_ciudadano"];
		$ciudadano["apellido_materno_ciudadano"] = $rs->fields["apellido_materno_ciudadano"];
		$ciudadano["email"] = $rs->fields["email"];
		$ciudadano["telefono"] = $rs->fields["telefono"];
		$ciudadano["direccion"] = $rs->fields["direccion"];
		$ciudadano["envio_email"] = $rs->fields["envio_email"];
		$ciudadano["no_registrado"] = $rs->fields["no_registrado"];
		
		return $ciudadano;
	}
	
		function setCopiarDocumento($_id_oirs,$_documento) {
		return copy($_documento["tmp_name"], _PATH_ARCHIVOS.$_id_oirs.'_'.$_documento["name"]);
	}
	
	/*function getAdjunto($_id_archivo) {
		$dir = opendir(_PATH_ARCHIVOS);
		while ($doc = readdir($dir)) {
			if ($doc != '.' && $doc != '..') $docs[] = $doc;
		}
		closedir($dir);
		$count_docs = count($docs);
		$ls_docs = array();

		for ($x=0;$x<$count_docs;$x++) {
			$doc_array = explode("_",$docs[$x]);
			if ($doc_array[0] == $_id_archivo) $ls_docs[] = $docs[$x];
		}


		if (count($ls_docs) > 0) {
			sort($ls_docs);
			$count_ls_docs = count($ls_docs);
			for ($x=0;$x<$count_ls_docs;$x++) {
				switch (strtolower(substr($ls_docs[$x],-3))) {
					case 'jpg': $ls_docs[$x] = array('doc'=>$ls_docs[$x],'doc_fix'=>$doc_array[1],'tp'=>'jpg'); break;
					case 'png': $ls_docs[$x] = array('doc'=>$ls_docs[$x],'doc_fix'=>$doc_array[1],'tp'=>'png'); break;
					case 'gif': $ls_docs[$x] = array('doc'=>$ls_docs[$x],'doc_fix'=>$doc_array[1],'tp'=>'gif'); break;
					case 'doc': $ls_docs[$x] = array('doc'=>$ls_docs[$x],'doc_fix'=>$doc_array[1],'tp'=>'doc'); break;
					case 'xls': $ls_docs[$x] = array('doc'=>$ls_docs[$x],'doc_fix'=>$doc_array[1],'tp'=>'xls'); break;
					case 'pdf': $ls_docs[$x] = array('doc'=>$ls_docs[$x],'doc_fix'=>$doc_array[1],'tp'=>'pdf'); break;
					case 'txt': $ls_docs[$x] = array('doc'=>$ls_docs[$x],'doc_fix'=>$doc_array[1],'tp'=>'txt'); break;
				}
			}
		} else {
			unset($ls_docs);
			$ls_docs = false;
		}

		return $ls_docs;
	}*/
	
	function getAdjuntos($id_historial) {
		$rs = $this->getConsulta("select * from {$this->tb_trans_adjunto} where id_historial=$id_historial");
		$adjuntos = array();
		while (!$rs->EOF) {
			array_push($adjuntos,$rs->fields);
			$rs->MoveNext();
		}
		return $adjuntos;
	}

	function getAdjuntosOirs($id_oirs) {
		$rs = $this->getConsulta("select * from {$this->tb_trans_adjunto} where id_oirs=$id_oirs");
		$adjuntos = array();
		while (!$rs->EOF) {
			array_push($adjuntos,$rs->fields);
			$rs->MoveNext();
		}
		return $adjuntos;
	}
	
	
	function getAdjunto($id_adjunto,$id_historial) {
		$rs = $this->getConsulta("select * from {$this->tb_trans_adjunto} where id_adjunto={$id_adjunto} and id_historial={$id_historial}");
		return $rs->fields;
	}
	
	function getInformes($tipo,$pagina_actual,$paginar) {


		switch ($tipo) {
			case '1':					
				//$sql = "select * from {$this->tb_oirs} where id_estado ='DE' or id_estado = 'EP' or id_estado = 'ET' or id_estado = 'RE' order by fecha asc";
				$sql = "select * from {$this->tb_oirs} ORDER BY fecha asc";
				break;
			case '2':					
				$sql = "select * from {$this->tb_oirs} o 
				LEFT JOIN {$this->tb_tipo_oirs} t 
				ON o.id_tipo = t.id_tipo
				WHERE t.solicitud_informacion = 1 
				ORDER BY fecha asc";			
				break;
			case '3':			
				$sql = "select * from {$this->tb_oirs} o 
				LEFT JOIN {$this->tb_tipo_oirs} t 
				ON o.id_tipo = t.id_tipo
				WHERE t.solicitud_informacion = 0 
				ORDER BY fecha asc";
				break;
			case '4':					
				$sql = "select o.*, org.nombre as nombre_organo
				from {$this->tb_oirs} o, {$this->tb_organo} org, {$this->tb_historial} h 
				where o.id_estado = 'DE' and o.id_oirs = h.id_oirs and h.id_estado ='DE' and h.id_organo = org.id_organo order by o.fecha asc";			
				break;
			case '5':			
				$sql = "select o.*, e.estado
				from {$this->tb_oirs} o, {$this->tb_estados_oirs} e
				where o.id_estado = 'EP' or o.id_estado= 'DE' and o.id_estado = e.id_estado  order by o.id_oirs, o.asunto asc";
				break;
			case '6':			
				$sql = "select * from {$this->tb_organo}";			
				break;
			}

			$rs = $this->getConsulta($sql,$paginar,$pagina_actual);					
			//$informes = array();

			$feriados_modelo = new Feriado_Modelo();

			if ($tipo !="6"){
			
				$informes = array();
				
				while (!$rs->EOF) {
					$informe = array();
					$informe['id_oirs'] = $rs->fields['id_oirs'];
					$informe['asunto'] = $rs->fields['asunto'];
					$informe['mensaje'] = $rs->fields['mensaje'];	
					$informe['fecha'] = $rs->fields['fecha'];	
					$informe['fecha_maxima_respuesta'] = $rs->fields['id_estado']=='ET'?$rs->fields['fecha_extendido']:$rs->fields['fecha_maxima_respuesta'];
					$informe['nombre_organo'] = $rs->fields['nombre_organo'];	
					$informe['direccion'] = $rs->fields['direccion'];	
					$informe['tramitado'] = $rs->fields['tramitado'];	
					$informe['tipo'] = $this->getTiposOIRSxId($rs->fields['id_tipo']);
					$informe['estado'] = $this->getEstado($rs->fields["id_estado"]);	
					$informe['id_estado'] = $rs->fields['id_estado'];		
					$informe['fecha_respuesta'] = $rs->fields['fecha_respuesta'];							
					$date = date('Y-m-d H:i:s');		
					if($informe['fecha_maxima_respuesta'] != "" and $informe['tramitado'] == "0"){
						$informe['alert'] =  $feriados_modelo->Alert($date,$rs->fields['fecha_maxima_respuesta']);			
						}			
				
					$informes[] = $informe;
					$rs->MoveNext();
					}	
					if ($pagina_actual<=$rs->lastpageno()) $datos['informe'] = $informes;
			}else{
				$organos = array();
				
				while (!$rs->EOF) {
				$organo= array();	
				$organo['id_organo'] = $rs->fields['id_organo'];
				$organo['nombre'] = $rs->fields['nombre'];									
				$organo['total'] = $this->getTotal_oirs($rs->fields['id_organo']);
				$organo['suma_oirs'] = $this->getSuma_oirs($rs->fields['id_organo']);				
				//$organo['porcentaje'] = $organo['suma_oirs']*$organo['total']/100;
				$organo['porcentaje'] = $organo['total']/$organo['suma_oirs']*100;						

				
				$organos[] = $organo;
				$rs->MoveNext();
				}			

				if ($pagina_actual<=$rs->lastpageno()) $datos['informe'] = $organos;	
			}
	
			$datos['paginacion'] = $this->getPaginado($rs->atfirstpage(),$rs->absolutepage(),$rs->atlastpage(),$rs->lastpageno());
			$datos['paginacion']['paginar'] = ($rs->lastpageno() == 1) ? "false" : "true";
		
		return $datos;
	}
	
	function getInformes_Organos($organo,$pagina_actual) {
		
			$sql = "select o.*, org.nombre as nombre_organo 
			from {$this->tb_oirs} o, {$this->tb_organo} org, {$this->tb_historial} h 
			where o.id_estado = 'DE' and o.id_oirs = h.id_oirs and h.id_estado ='DE' and h.id_organo = org.id_organo and  org.id_organo = '{$organo}'
			 order by org.nombre asc";

			$rs = $this->getConsulta($sql,true,$pagina_actual);					
			$informes = array();
	
			$feriados_modelo = new Feriado_Modelo();
			while (!$rs->EOF) {
				$informe = array();
				$informe['id_oirs'] = $rs->fields['id_oirs'];
				$informe['asunto'] = $rs->fields['asunto'];
				$informe['mensaje'] = $rs->fields['mensaje'];	
				$informe['fecha'] = $rs->fields['fecha'];	
				$informe['fecha_maxima_respuesta'] = $rs->fields['fecha_maxima_respuesta'];
				$informe['nombre_organo'] = $rs->fields['nombre_organo'];	
				$informe['direccion'] = $rs->fields['direccion'];	
				$informe['tramitado'] = $rs->fields['tramitado'];	
				$informe['estado'] = $rs->fields['estado'];					
				$date = date('Y-m-d H:i:s');		
				if($informe['fecha_maxima_respuesta'] != "" and $informe['tramitado'] == "0"){
					$informe['alert'] =  $feriados_modelo->Alert($date,$rs->fields['fecha_maxima_respuesta']);	
				}			
			
				$informes[] = $informe;
				$rs->MoveNext();
			}		
				
			if ($pagina_actual<=$rs->lastpageno()) $datos['informe'] = $informes;
	
			$datos['paginacion'] = $this->getPaginado($rs->atfirstpage(),$rs->absolutepage(),$rs->atlastpage(),$rs->lastpageno());
			$datos['paginacion']['paginar'] = ($rs->lastpageno() == 1) ? "false" : "true";
		
		return $datos;
	}
	
		function getTotal_oirs($id_organo){
			$contador = array();

			$sql = "select COUNT('id_oirs') as numero_organos
			from {$this->tb_historial}
			where id_organo = '{$id_organo}' and id_estado= 'RP'";
			$rs = $this->getConsulta($sql);
			$numero = $rs->fields["numero_organos"];
			
			return $numero;		
		
		}
	
	function getSuma_oirs($id_organo) {
		
		$sql = "select o.*, h.respuesta_fecha	, h.id_organo				
			from {$this->tb_historial} h, {$this->tb_oirs} o
			where o.id_oirs = h.id_oirs and h.id_organo = '{$id_organo}' and h.id_estado = 'RP'";
					
			$rs = $this->getConsulta($sql);				
	
			$feriados_modelo = new Feriado_Modelo();
			
			while (!$rs->EOF) {				
				$cant_dia =  $feriados_modelo->Alert($rs->fields['fecha'],$rs->fields['respuesta_fecha']);					
				$total = $total + $cant_dia;			
				$rs->MoveNext();
			}	
		

		return $total;
	}
	
	function AgregarAdjunto($cmps) {
		$continuar = true;

			$sql = "select * from {$this->tb_trans_adjunto} where id_adjunto=-1";
			$continuar = $this->setGuardar($sql,$cmps);					
		   //$id_oirs = $cmps['id_oirs'];
		//print_r('entra');
		//die()
		/*if ($continuar) {
		$id_binario = $this->getInsertID();		
			$fp = fopen($adjunto['tmp_name'], 'rb');
			$content = fread($fp, $adjunto['size']);
			fclose($fp);
		$continuar = $this->db->UpdateBlob($this->tb_trans_adjunto,'adjunto',$content,"id_adjunto=$id_binario");
		}				
		return $continuar;*/
	}
	
	function Publicar_archivo($id_adjunto,$publico){
            //$this->setTransaccion('start');

            $sql = "UPDATE ".$this->tb_trans_adjunto." SET publico = '";
			
            if($publico == "0"){
                $sql .= "1";
            }else{
                $sql .= "0";
            }
			
			
			if (isset($id_adjunto)){
				$sql .= "' WHERE (id_adjunto = ".$id_adjunto.")";				
			} else {
				$sql .= "' WHERE ";
			}
			//$sql .= " WHERE (id_adjunto = ".$id_adjunto.") AND";
			//$sql .= "(publico = '".$publico."')";
          
            $this->db->Execute($sql);
			//return $this->setTransaccion('end');
			//print_r($sql);
			//die();           
               				
			}                  
        
	
	function getIDHistorial() {
		$rs = mysql_query("SELECT max(id_historial) AS id FROM {$this->tb_historial}"); 
		if ($row = mysql_fetch_row($rs)) { 
		$id = trim($row[0]); 
		}
		return $id;
	}
	
			function getAdjuntosHistorial() {
			$sql = "select ta.* from {$this->tb_trans_adjunto} ta
			inner join {$this->tb_historial} h on
			ta.id_historial = h.id_historial
			";
			
			/*SELECT ta . * 
FROM trans_adjunto ta
INNER JOIN trans_historial h
ON h.id_historial = ta.id_historial
WHERE h.id_historial = 745
LIMIT 0 , 30*/
			$rs = $this->getConsulta($sql);				
			$datos = array();		
			while (!$rs->EOF) {
			
					$dato = $rs->fields;
//					print_r(count($dato));
	//				die();								
					//array_push($datos,$rs->fields);
					$datos[$dato['id_historial'][$x]] = "<div id='".$dato['id_historial']."' class='ventana-cargo' align='center' style='display:none;'>
					<p>Lista de archivos:</p></br>
					<p>".$dato['nombre']."</p></br>
					</div>";
					
					$rs->MoveNext();										
				}
			return $datos;		
		}
		
		
		function getAdminOrganismo($id_func) {
		$sql = "select * from $this->tb_organo where id_funcionario = $id_func";
		$rs_admin = $this->getConsulta($sql);
		
		$admin['existe'] = (!$rs_admin->EOF) ? true : false;
		$admin["id_funcionario"] = $rs_admin->fields["id_funcionario"];		

		return $admin;
	}
	
	function getCiudadanoAdmin() {

			$sql = "select o.id_oirs,c.id_ciudadano,c.email,c.direccion,c.region,c.comuna,c.localidad from trans_oirs o left join trans_ciudadano c on o.id_ciudadano = c.id_ciudadano";
			//print_r($sql);
			//die();
			
			$rs = $this->getConsulta($sql);
			$datos = array();
			while (!$rs->EOF) {		
					$dato = $rs->fields;					
					if($dato['direccion']!=""){
					$datos[$dato['id_oirs']] = "<div id='".$dato['id_oirs']."' class='ventana-info' align='center' style='display:none;'>
					<h1>Datos de contacto</h1></br>
					Direcci&oacute;n postal: ".$dato['direccion']." ".$dato['localidad']."</a></br>
					Regi&oacute;n: ".$dato['region']."</a></br>
					Comuna: ".$dato['comuna']."</a></br>";
					}elseif($dato['email']!=""){
					$datos[$dato['id_oirs']] = "<div id='".$dato['id_oirs']."' class='ventana-info' align='center' style='display:none;'>
					<h1>Datos de contacto</h1></br>				
					E-mail: ".$dato['email']."</div>";
					}					
					$rs->MoveNext();					
			}
			
			return $datos;
	}
/* 
Autor : Gino Berríos
Fecha : 15-10-2013
Cambio : Método para actualizar la fecha de las solicitudes se llama desde la acción sumar días */

	function actualizarFechaFinal($id){
		
		$this->setTransaccion('start');
		$feriados_modelo = new Feriado_Modelo();

		$datos_oirs = $this->getDatos_oirs($id);
		$plazo_solicitud = $datos_oirs["plazo"]+5;
		//print_r($datos_oirs);
		//die();
		$fecha = $feriados_modelo->fechaValida($datos_oirs["fecha"], $plazo_solicitud);
		$sql = "UPDATE {$this->tb_oirs} SET fecha_maxima_respuesta='$fecha' WHERE id_oirs = $id";
		$this->db->Execute($sql);

		return $this->setTransaccion('end');
	}

	/*
	Autor : Gino Berríos
	Fecha : 30-10-2013
	Cambio: Agregar métodos para consultar regiones, comunas, ciudadanos, email ciudadano, datos usuario, tipos de solicitudes, 
	obtener departamentos, agregar atributos de clase para las tablas regiones y comunas
	*/

	function getRegion(){

		$sql = "SELECT codigo,nombre FROM $this->tb_trans_regiones WHERE activo = '1' 
		 ORDER BY codigo asc";
		$rs = $this->getConsulta($sql);
		$datos = array();
		while(!$rs->EOF){
			$dato["codigo"] = $rs->fields["codigo"];
			$dato["nombre"] = $rs->fields["nombre"];
			$datos[] = $dato;
			$rs->MoveNext();
		}
		return $datos;
	}	

	function getComuna($id_padre){

		$sql = "SELECT codigo_comuna,nombre FROM $this->tb_trans_comunas WHERE padre = $id_padre 
		ORDER BY nombre";
		$rs = $this->getConsulta($sql);
		$datos = array();
		$datos[""] = "";

		while (!$rs->EOF) {
			$datos[$rs->fields["codigo_comuna"]] = $rs->fields["nombre"];
			$rs->MoveNext();
		}

		return $datos;
	}

	function getEmail($email) {
		$sql = "select * from $this->tb_ciudadano c where c.email='$email'";
		$rs_mail = $this->getConsulta($sql);
		
		$mail['existe'] = (!$rs_mail->EOF) ? true : false;
		$mail["email"] = $rs_mail->fields["email"];		

		return $mail;
	}

	function getUsuarioOirsCiuEmail($_email) {
			#usuario
			/*
			Autor : Gino Berríos
			Fecha : 22-10-2013
			Cambio : Cambiar columna activo por email_activado esto también se debe cambiar en la tabla trans_usuarios
			*/
			$sql = "select tu.email_activado from {$this->tb_usuarios} tu
			left join {$this->tb_ciudadano} tc
			on tu.id_usuario = tc.id_ciudadano			
			where tc.email='$_email'";
			//print_r($sql);
			//die();		
			$rs_usuario = $this->getConsulta($sql);
			return $rs_usuario->fields["email_activado"];
		}

	function getDatosCiudadano($_email) {
			#usuario
			$usuarios = array();			
			$sql = "select * from {$this->tb_usuarios} tu
			left join {$this->tb_ciudadano} tc
			on tu.id_usuario = tc.id_ciudadano			
			where tc.email='$_email'";			
			$rs_usuario = $this->getConsulta($sql);
			$usuarios = $rs_usuario->fields;	
			return $usuarios;
		}


	function codigoActivacion(){
			$code = sha1(mt_rand().time().mt_rand().$_SERVER['REMOTE_ADDR']);			
			return $code;
		}

	function getUsuario($id_ciudadano) {
		$sql = "select c.*,u.contrasena from $this->tb_ciudadano c,$this->tb_usuarios u where c.id_ciudadano='$id_ciudadano' 
		and c.id_ciudadano=u.id_usuario ";
		$rs_usuario = $this->getConsulta($sql);
		
		$usuario["id_ciudadano"] = $rs_usuario->fields["id_ciudadano"];
		$usuario["rut_ciudadano"] = $rs_usuario->fields["rut_ciudadano"];
		$usuario["rut_dv"] = $rs_usuario->fields["rut_dv"];
		$usuario["email"] = $rs_usuario->fields["email"];
		$usuario["email_apoderado"] = $rs_usuario->fields["email_apoderado"];
		$usuario["envio_email"] = $rs_usuario->fields["envio_email"];	
		$usuario["telefono"] = $rs_usuario->fields["telefono"];
		$usuario["nombre"] = ucwords($rs_usuario->fields["nombre"]);
		/*
		Autor : Gino Berríos
		Fecha : 18-10-2013/21-10-2013/24-10-2013
		Cambio : Separar columna apellidos en apellido materno y apellido paterno/agregar columnas razon_social, tipo/agregar columna apoderado,direccion_apoderado,
		localidad_apoderado,region_apoderado,comuna_apoderado,email_apoderado
		*/
		//$usuario["apellidos"] = ucwords($rs_usuario->fields["apellidos"]);
		$usuario["apellido_paterno_ciudadano"] = ucwords($rs_usuario->fields["apellido_paterno_ciudadano"]);
		$usuario["apellido_materno_ciudadano"] = ucwords($rs_usuario->fields["apellido_materno_ciudadano"]);
		$usuario["direccion"] = $rs_usuario->fields["direccion"];
		$usuario["localidad"] = $rs_usuario->fields["localidad"];
		$usuario["region"] = $rs_usuario->fields["region"];
		$usuario["comuna"] = $rs_usuario->fields["comuna"];
		$usuario["nombre_apoderado"] = ucwords($rs_usuario->fields["nombre_apoderado"]);
		$usuario["ap_materno_apoderado"] = ucwords($rs_usuario->fields["ap_materno_apoderado"]);
		$usuario["ap_paterno_apoderado"] = ucwords($rs_usuario->fields["ap_paterno_apoderado"]);
		$usuario["direccion_apoderado"] = $rs_usuario->fields["direccion_apoderado"];
		$usuario["localidad_apoderado"] = $rs_usuario->fields["localidad_apoderado"];
		$usuario["region_apoderado"] = $rs_usuario->fields["region_apoderado"];
		$usuario["comuna_apoderado"] = $rs_usuario->fields["comuna_apoderado"];
		$usuario["contrasena"] = $rs_usuario->fields["contrasena"];
		$usuario["razon_social"] = $rs_usuario->fields["razon_social"];
		$usuario["apoderado"] = $rs_usuario->fields["apoderado"];
		$usuario["tipo"] = $rs_usuario->fields["tipo"];
		return $usuario;
	}

	function getTiposSolicitudes() {
		$sql = "select * from {$this->tb_tipo_oirs} order by id_tipo asc";
		$rs = $this->getConsulta($sql);
		$estados = array();
		while (!$rs->EOF) {
			$estado = array();
			$estado["id_tipo"] = $rs->fields['id_tipo'];
			$estado["tipo"] = $rs->fields['tipo'];
			$estados[] = $estado;
			$rs->MoveNext();
		}
		return $estados;
	}


	/*
	Autor : Gino Berríos
	Fecha : 30-10-2013
	Cambio : Nuevo método para obtener la imágen del tipo de oirs
	*/

	function getImagenTipo($id_tipo) {
		$sql = "select imagen from {$this->tb_tipo_oirs} where id_tipo = $id_tipo";
		$rs = $this->getConsulta($sql);
		$estados = array();
		while (!$rs->EOF) {
			$estado = array();
			$estado["imagen"] = $rs->fields['imagen'];
			$estados[] = $estado;
			$rs->MoveNext();
		}
		return $estados;
	}

	function getDepsOIRSCiu() {
		$sql = "select o.id_organo,o.nombre from {$this->tb_organo} o
				inner join trans_funcionario f on o.id_funcionario = f.id_funcionario
				where o.id_organo <> 1 order by o.id_organo desc";
		$rs = $this->getConsulta($sql);
		$estados = array();
		while (!$rs->EOF) {
			$estados[$rs->fields['id_organo']] = $rs->fields['nombre'];
			$rs->MoveNext();
		}
		return $estados;
	}

	function existeCodigo($code){
		$sql = "SELECT cod_solicitud FROM $this->tb_oirs WHERE cod_solicitud = '$code'";
		$rs = $this->getConsulta($sql);
		if($rs->EOF){
			$existe = false;
		}else{
			$existe = true;
		}
		return $existe;
	}

	function actualizarEnvioNotificaciones($id_ciudadano){
		$this->setTransaccion('start');				
		$sql = "UPDATE {$this->tb_ciudadano} SET envio_email=1 WHERE id_ciudadano='$id_ciudadano'";
		$this->db->Execute($sql);				
		return $this->setTransaccion('end');
	}

	function getTiposOIRSxId($id) {
		$sql = "select * from {$this->tb_tipo_oirs} where id_tipo = '$id' order by tipo asc";
		$rs = $this->getConsulta($sql);
		$estados = array();
		while (!$rs->EOF) {
			$estados["id_tipo"] = $rs->fields['id_tipo'];
			$estados["plazo"] = $rs->fields['plazo'];
			$estados["solicitud_informacion"] = $rs->fields['solicitud_informacion'];
			$estados["tipo"] = $rs->fields['tipo'];
			$rs->MoveNext();
		}
		return $estados;
	}

	function setAgregarHistorial($cmps) {
		$sql = "select * from {$this->tb_historial} where id_historial = -1";
		return $this->setGuardar($sql,$cmps);
	}

	function fechaValida($desde, $dias){
			$desde = $this->fechaAMD($desde);
         $feriados = $this->getFeriados_Actuales($desde);
		
		   //separo la fecha en dia mes y año
            $dia = date('d', strtotime($desde));
            $mes = date('m', strtotime($desde));
            $ano = date('Y', strtotime($desde));

            $mkDesde    = mktime(0,0,0,$mes,$dia,$ano);
            $sumar = $dias;
            $i=1;
            while($i < $sumar){            
                $mkDia = mktime(0, 0, 0, $mes, $dia + $i, $ano);
                
                $resultado = date('Y/m/d', $mkDia);
                if(!$this->esHabil($resultado, $feriados)){
                    $sumar += 1;
                }
                $i++;
            }
            
            $mkFecha = mktime(0,0,0,$mes, $dia + $sumar, $ano);			
            $resultado = date('Y/m/d', $mkFecha);

            if($this->esHabil($resultado, $feriados)){
                $fecha = date('Y/m/d', $mkFecha);
                return $fecha;
            }else{       				       
                return $this->fechaValida($resultado, 1);
            }
        }

        function fechaAMD($fecha, $union = "/"){
            if(strpos($fecha, "-")){
                $datos = split("-", $fecha);
                if(strlen($datos[2]) == 4){
                    $fecha = $datos[2].$union.$datos[1].$union.$datos[0];
                }else{
                    $fecha = $datos[0].$union.$datos[1].$union.$datos[2];
                }
            }else if(strpos($fecha, "/")){
                $datos = split("/", $fecha);
                if(strlen($datos[2]) == 4){
                    $fecha = $datos[2].$union.$datos[1].$union.$datos[0];
                }else{
                    $fecha = $datos[0].$union.$datos[1].$union.$datos[2];
                }            
            }
            
            return $fecha;
        }
        
function getFeriados_Actuales($fecha) {
            $sql = "select fecha from ".$this->tb_feriados." where fecha >= '$fecha' order by fecha asc";
            $rs = $this->getConsulta($sql);
            $feriados = array();

            while (!$rs->EOF) {                        
                $fecha = $this->fechaAMD($rs->fields["fecha"]);
                $feriados[$fecha] = $fecha;
                $rs->MoveNext();
            }
            
            return $feriados;
        }
        
      function esHabil($fecha, $feriados){            
            //separo la fecha en dia mes y año
            $dia = date('d', strtotime($fecha));
            $mes = date('m', strtotime($fecha));
            $ano = date('Y', strtotime($fecha));
 
            //calculo el timestamp de la fechainicial
            $mkFecha = mktime(0, 0, 0, $mes, $dia, $ano);
 
            $esHabil = true;
            
            //realizo la correccion correspondiente por el fin de semana            
            switch (date('w', $mkFecha)) {
                case 1: //Lunes
                case 2: //Martes
                case 3: //Miercoles
                case 4: //Jueves
                case 5: //Viernes
                    $esHabil = true;
                    break;
                case 6: //Sabado
                case 0: //Domingo
                    $esHabil = false;
                    break;
            }
            
            if($esHabil){
                if(array_key_exists($fecha, $feriados)){                    
                    return false;
                }else{
                    return true;
                }                
            }else{
                return false;
            }
        }

         function getRegionxid($id_region){

			$sql = "SELECT nombre FROM $this->tb_trans_regiones WHERE activo = '1' and codigo = $id_region";
			$rs = $this->getConsulta($sql);
			return $rs->fields["nombre"];
		}	

		function getComunaxid($id_comuna){

			$sql = "SELECT nombre FROM $this->tb_trans_comunas WHERE codigo_comuna = $id_comuna";
			$rs = $this->getConsulta($sql);
			return $rs->fields["nombre"];
		}

        function getDatosContactoOirs($id_oirs){

        	$sql = "SELECT o.id_ciudadano,o.id_solicitante,o.id_tipo,t.solicitud_informacion,c.email,c.direccion,c.region,c.comuna,	
        	c.localidad,c.nombre,c.apellido_paterno_ciudadano,c.apellido_materno_ciudadano, 
        	ts.email as email_solicitante,
        	ts.direccion as direccion_solicitante,
        	ts.region as region_solicitante,
        	ts.comuna as comuna_solicitante, 
        	ts.localidad as localidad_solicitante,
        	ts.tipo as tipo_persona, 
        	ts.nombre as nombre_solicitante,
        	ts.apellido_paterno_ciudadano as apellido_paterno_solicitante,
        	ts.apellido_materno_ciudadano as apellido_materno_solicitante, 
        	ts.apoderado as tiene_apoderado,
        	ts.razon_social as razon_social_solicitante, 
        	ts.nombre_apoderado as nombre_completo_apoderado,
        	ts.ap_paterno_apoderado as apellido_paterno_apoderado, 
        	ts.ap_materno_apoderado as apellido_materno_apoderado

        	FROM $this->tb_oirs o
        	LEFT JOIN $this->tb_tipo_oirs t ON o.id_tipo = t.id_tipo
        	LEFT JOIN $this->tb_trans_solicitante ts ON o.id_solicitante = ts.id_solicitante
        	LEFT JOIN $this->tb_ciudadano c ON o.id_ciudadano = c.id_ciudadano
        	WHERE o.id_oirs = $id_oirs";

        	

        	$rs = $this->getConsulta($sql);

        	$datos = array();

        	while (!$rs->EOF) {
        		$datos["solicitud_informacion"] = $rs->fields["solicitud_informacion"];
        		$datos["tipo_solicitante"] = $rs->fields["tipo_persona"];
        		

        		if($datos["solicitud_informacion"]==1 & $datos["tipo_solicitante"]==1){
        			$datos["apoderado"] = $rs->fields["tiene_apoderado"];
        			$datos["nombre_completo"] = $rs->fields["nombre_solicitante"]." ".$rs->fields["apellido_paterno_solicitante"]." ".$rs->fields["apellido_materno_solicitante"];
 	        		$datos["email"] = $rs->fields["email_solicitante"];
	        		$datos["direccion"] = $rs->fields["direccion_solicitante"];
	        		$datos["region"] = $rs->fields["region_solicitante"] == 0 ? "Sin región" : $this->getRegionxid($rs->fields["region_solicitante"]);
	        		$datos["comuna"] = $rs->fields["comuna_solicitante"] == 0 ? "Sin comuna" : $this->getComunaxid($rs->fields["comuna_solicitante"]);
	        		$datos["localidad"] = $rs->fields["localidad_solicitante"];
	        		$datos["nombre_apoderado"] = $rs->fields["nombre_completo_apoderado"]." ".$rs->fields["apellido_paterno_apoderado"]." ".$rs->fields["apellido_materno_apoderado"];
	        	}elseif($datos["solicitud_informacion"]==0){
	        		$datos["nombre_completo"] = $rs->fields["nombre"]." ".$rs->fields["apellido_paterno_ciudadano"]." ".$rs->fields["apellido_materno_ciudadano"];
	        		$datos["email"] = $rs->fields["email"];
	        		$datos["direccion"] = $rs->fields["direccion"];
	        		$datos["region"] = $rs->fields["region"] == 0 ? "Sin región" : $this->getRegionxid($rs->fields["region"]);
	        		$datos["comuna"] = $rs->fields["comuna"] == 0 ? "Sin comuna" : $this->getComunaxid($rs->fields["comuna"]);
	        		$datos["localidad"] = $rs->fields["localidad"];
	        	}elseif($datos["solicitud_informacion"]==1 && $datos["tipo_solicitante"]==2){
	        		$datos["apoderado"] = $rs->fields["tiene_apoderado"];
	        		$datos["razon"] = $rs->fields["razon_social_solicitante"];
	        		$datos["email"] = $rs->fields["email_solicitante"];
	        		$datos["direccion"] = $rs->fields["direccion_solicitante"];
	        		$datos["region"] = $rs->fields["region_solicitante"] == 0 ? "Sin región" : $this->getRegionxid($rs->fields["region_solicitante"]);
	        		$datos["comuna"] = $rs->fields["comuna_solicitante"] == 0 ? "Sin comuna" : $this->getComunaxid($rs->fields["comuna_solicitante"]);
	        		$datos["localidad"] = $rs->fields["localidad_solicitante"];
	        		$datos["nombre_apoderado"] = $rs->fields["nombre_completo_apoderado"]." ".$rs->fields["apellido_paterno_apoderado"]." ".$rs->fields["apellido_materno_apoderado"];
	        	
	        	}

        		$rs->MoveNext();
        	}

        	return $datos;
        }

        function existeCodigoSubsanacion($subsanar_no_registro){
        	$sql = "SELECT subsanar_no_registro FROM $this->tb_oirs WHERE subsanar_no_registro = '$subsanar_no_registro'";
        	$rs = $this->getConsulta($sql);
        	if($rs->EOF){
        		$existe = false;
        	}else{
        		$existe = true;
        	}
        	return $existe;
        }

        function existenOirs(){
        	$sql = "SELECT COUNT(id_tipo) as existe_oirs FROM $this->tb_oirs WHERE id_tipo <> '5'";
        	$rs = $this->getConsulta($sql);
        	if($rs->fields["existe_oirs"] > 0){
        		$existe = true;
        	}else{
        		$existe = false;
        	}
        	return $existe;
        }

    function existe_numero_papel($numero_papel){
		$sql = "SELECT numero_papel FROM {$this->tb_trans_solicitante} WHERE numero_papel = {$numero_papel}";
		$rs = $this->getConsulta($sql);
		if($rs->EOF){
			$existe = false;
		}else{
			$existe = true;
		}
		return $existe;
	}
}
	
	
	/*	function getAdjuntos($id_historial) {
		$rs = $this->getConsulta("select * from {$this->tb_trans_adjunto} where id_historial=$id_historial");
		$adjuntos = array();
		while (!$rs->EOF) {
			array_push($adjuntos,$rs->fields);
			$rs->MoveNext();
		}
		return $adjuntos;
	}*/
?>
