<?php
class Modelo {
	/**
	 * objeto conexion a la base de datos
	 * @var objet
	 */
	var $db;
	var $max_reg;

	function Modelo() {
		global $__DB;

		$this->db = ADONewConnection($__DB["tipo_base_datos"]);
		$this->db->PConnect($__DB["host"],$__DB["usuario"],$__DB["password"],$__DB["base_datos"]);
		$this->db->ErrorMsg();
		$this->db->SetFetchMode(ADODB_FETCH_ASSOC);
		$this->max_reg = 20;
	}

	/**
	 * devuelve un objeto recordset con el sql entregado
	 * @param string $sql
	 * @return object $recordset
	 */
	function getConsulta($sql, $paginado=false, $pagina_actual=1) {

		if(!$this->db->Execute($sql)) die($sql."<br>".$this->db->ErrorMsg());
		$recordset = ($paginado) ? $this->db->PageExecute($sql,$this->max_reg,$pagina_actual) : $this->db->Execute($sql);

		return $recordset;
	}

	/**
	 * guarda los campos en la base de datos
	 * @param string $sql_null
	 * @param array $cmps
	 * @return boolean
	 */
	function setGuardar($sql_null,$cmps) {
		
		$return = true;
		$recordset = $this->db->Execute($sql_null);
		
		$sql_insert = $this->db->GetInsertSQL($recordset,$cmps);
	
		$recordset = $this->db->Execute($sql_insert);
		
		if(!is_object($recordset)) $return = false;
		 
		return $return;
		
	}

	/**
	 * modifica los datos del registro seleccionado
	 * @param string $sql
	 * @param array $cmps
	 * @return boolean
	 */
	function setModificar($sql,$cmps) {
		$return = true;
		$recordset = $this->db->Execute($sql);
		$sql_update = $this->db->GetUpdateSQL($recordset,$cmps);
		if (!empty($sql_update)) {
			$recordset = $this->db->Execute($sql_update);
			if(is_object($recordset)) $return = true;
		}
		return $return;
	}

	/**
	 * elimina un registro seleccionado
	 * @param string $sql_del
	 * @return boolean
	 */
	function setEliminar($sql_del) {
		$return = true;
		$recordset = $this->db->Execute($sql_del);
		if(!is_object($recordset)) $return = false;
		return $return;
	}
	
	/**
	 * inicia o termina una transaccion
	 * @param string $estado 'start' 'end'
	 * @param boolean $autoComplete se utiliza en el caso CompleteTrans
	 * @return boolean
	 */
	function setTransaccion($estado,$autoComplete=true) {
		$return = true;
		switch ($estado) {
			case 'start': $this->db->StartTrans(); break;
			case 'end': $return = $this->db->CompleteTrans($autoComplete); break;
		}
		return $return;
	}

	/**
	 * retorna el ultimo id autonumerico ingresado
	 * @return integer
	 */
	function getInsertID() {
		return $this->db->Insert_ID();
	}

	/**
	 * retorna el paginado de los registros
	 * @param boolean $atfirstpage
	 * @param integer $absolutepage
	 * @param boolean $atlastpage
	 * @param integer $lastpageno
	 * @return arrray
	 */
	function getPaginado($atfirstpage,$absolutepage,$atlastpage,$lastpageno) {
		if(!$atfirstpage) {
			$paginacion["first"] = 1;
			$paginacion["previous"] = $absolutepage - 1;
		}
		if(!$atlastpage) {
			$paginacion["next"] = $absolutepage + 1;
			$paginacion["last"] = $lastpageno;
		}
		$paginacion["current"] = $absolutepage;

		return $paginacion;
	}
}
?>
