<?php
// Portable UTF-8
use voku\helper\UTF8;
class Galeria_Modelo extends Modelo {

	var $tb;
	var $tb_imagenes;

	function Galeria_Modelo() {
		parent::Modelo();
		$this->tb = 'galeria';
		$this->tb_imagenes = 'imagenes';

	}

	function Agregar($_cmps) {
		$this->setTransaccion('start');
		$sql_null = "select * from ".$this->tb." where id_galeria = -1";
		$this->setGuardar($sql_null,$_cmps);
		return $this->setTransaccion('end');
	}

	function Modificar($_cmps) {
		$this->setTransaccion('start');
		$sql_mod = "select * from ".$this->tb." where id_galeria = ".$_cmps['id_galeria'];
		$this->setModificar($sql_mod,$_cmps);
		return $this->setTransaccion('end');
	}

	function Eliminar($_id_galeria) {
		$this->setTransaccion('start');

		#galeria
		$sql_del = "delete from ".$this->tb." where id_galeria = $_id_galeria";
		$this->db->Execute($sql_del);

		if ($this->setTransaccion('end')) {
			$Eliminar = true;
			$this->setEliminarImagenes($_id_galeria);
		} else {
			$Eliminar = false;
		}

		return $Eliminar;
	}

	function getGaleriaLista($_pagina_actual,$seccion) {
		$sql = "select * from ".$this->tb."  order by id_galeria desc";
		$rs_galeria = $this->getConsulta($sql,true,$_pagina_actual);
		$galerias = array();

		while (!$rs_galeria->EOF) {
			$galeria = array();
			$galeria["id_galeria"] = $rs_galeria->fields["id_galeria"];
			$galeria["nombre"] = $rs_galeria->fields["nombre"];
			$galerias[] = $galeria;
			$rs_galeria->MoveNext();
		}

		$datos['galerias'] = $galerias;
		$datos['paginacion'] = $this->getPaginado($rs_galeria->atfirstpage(),$rs_galeria->absolutepage(),
			$rs_galeria->atlastpage(),$rs_galeria->lastpageno());

		$datos['paginacion']['paginar'] = ($rs_galeria->atfirstpage() && ($rs_galeria->lastpageno() == $rs_galeria->absolutepage())) ? "false" : "true";

		return $datos;
	}

	function getGaleria($_id_galeria) {
		$sql = "select * from ".$this->tb." where id_galeria=$_id_galeria";
		$rs_galeria = $this->getConsulta($sql);

		return $rs_galeria->fields;
	}
	
	//gakeria nueva en base de datos
	
	function Agregar_Imagen($_cmps,$adjunto) {
		$continuar = true;
		$sql = "select * from $this->tb_imagenes where id_imagen = -1";
		$continuar = $this->setGuardar($sql,$_cmps);

		if ($continuar) {
			$id_imagen = $this->getInsertID();
			$fp = fopen($adjunto['tmp_name'], 'rb');
			$content = fread($fp, $adjunto['size']);
			fclose($fp);
			$continuar = $this->db->UpdateBlob($this->tb_imagenes,'foto',$content,"id_imagen=$id_imagen");
			$continuar= true;
		}
		return $continuar;
	}
	
	function Modificar_Imagen($_cmps,$adjunto) {
		$continuar = true;
		$sql = "select * from $this->tb_imagenes where id_imagen = {$_cmps['id_imagen']}";
		$continuar = $this->setModificar($sql,$_cmps);
		
		//print_r($adjunto);
		//die();

		if ($continuar && !empty($adjunto["tmp_name"])) {
			//$id_imagen = $this->getInsertID();
		
			$id_imagen = $_cmps['id_imagen'];
			$fp = fopen($adjunto['tmp_name'], 'rb');
			$content = fread($fp, $adjunto['size']);
			fclose($fp);
			$continuar = $this->db->UpdateBlob($this->tb_imagenes,'foto',$content,"id_imagen=$id_imagen");
			$continuar= true;
		}
		return $continuar;
	}
	
	function getLista_imagenes($_pagina_actual,$id_galeria) {
		$sql = 'select * from '.$this->tb_imagenes.' where id_galeria= "'.$id_galeria.'"  order by orden asc';
		$rs = $this->getConsulta($sql,false,$_pagina_actual);
		$imagen = array();

		while (!$rs->EOF) {
			$imagenes = array();
			$imagenes['url'] = $rs->fields['url'];
			$imagenes['id_imagen'] = $rs->fields['id_imagen'];
			$imagenes['id_galeria'] = $rs->fields['id_galeria'];
			$imagenes['ancho'] = $rs->fields['ancho'];
			$imagenes['alto'] = $rs->fields['alto'];
			$imagenes['orden'] = $rs->fields['orden'];
			$imagenes['nombre_foto'] = $rs->fields['nombre_foto'];
			$imagenes['publicado'] = $rs->fields['publicado'];
			$imagen[] = $imagenes;
			$rs->MoveNext();
		}

		$datos['imagenes'] = $imagen;
		$datos['paginacion'] = $this->getPaginado($rs->atfirstpage(),$rs->absolutepage(),
			$rs->atlastpage(),$rs->lastpageno());

		$datos['paginacion']['paginar'] = ($rs->atfirstpage() && ($rs->lastpageno() == $rs->absolutepage())) ? "false" : "true";

		return $datos;
	}

	function getDatos_imagen($id_imagen) {		
		$sql = 'select * from '.$this->tb_imagenes.' where id_imagen='.$id_imagen;
		$rs = $this->getConsulta($sql);
		$imagen = array();
		
		$imagen["url"] = $rs->fields["url"];
		$imagen["id_imagen"] = $rs->fields["id_imagen"];
		$imagen["descripcion"] = $rs->fields["descripcion"];
		$imagen["foto"] = $rs->fields["foto"];
		$imagen["nombre_foto"] = $rs->fields["nombre_foto"];
		$imagen["tipo_foto"] = $rs->fields["tipo_foto"];
		
		return $imagen;
	}
	
	function getDatos_imagen_nombre($nombre) {		
		$sql = "select * from $this->tb_imagenes where nombre_foto='$nombre'";
		$rs = $this->getConsulta($sql);
		$imagen = array();
		
		$imagen['existe'] = (!$rs->EOF) ? true : false;
		$imagen["url"] = $rs->fields["url"];
		$imagen["id_imagen"] = $rs->fields["id_imagen"];
		$imagen["descripcion"] = $rs->fields["descripcion"];
		$imagen["foto"] = $rs->fields["foto"];
		$imagen["nombre_foto"] = $rs->fields["nombre_foto"];
		$imagen["tipo_foto"] = $rs->fields["tipo_foto"];
		
		return $imagen;
	}
	
	function Eliminar_imagen($id_imagen) {
		$sql = "delete from {$this->tb_imagenes} where id_imagen = $id_imagen";
		return $this->setEliminar($sql);
	}
	
	/*galeria imagenes anterior*/
	function setCopiarImagen($_id_galeria,$_imagen) {
		copy($_imagen["tmp_name"], _PATH_IMAGENES.$_id_galeria.'_'.$_imagen["name"]);

		$img = imagecreatefromjpeg(_PATH_IMAGENES.$_id_galeria.'_'.$_imagen["name"]);
		$thumb = imagecreatetruecolor(100,75);
		imagecopyresized($thumb,$img,0,0,0,0,100,75,ImageSX($img),ImageSY($img));
		imagejpeg($thumb,_PATH_IMAGENES.$_id_galeria.'_mn_'.$_imagen["name"],100);
	}

	function setEliminarImagen($_id_galeria,$_imagen_mn) {
		$img_tmp = explode('_',$_imagen_mn);
		$lrg_img_tmp = count($img_tmp);
		for ($x=2;$x<$lrg_img_tmp;$x++) {
			if (!empty($imagen_org)) $imagen_org .= '_';
			$imagen_org .= $img_tmp[$x];
		}

		unlink(_PATH_IMAGENES.$_id_galeria.'_'.$imagen_org);
		unlink(_PATH_IMAGENES.$_imagen_mn);
	}

	function setEliminarImagenes($_id_galeria) {
		$ls_imagenes_mn = $this->getImagenes($_id_galeria,true);
		$ls_imagenes = $this->getImagenes($_id_galeria,false);
		foreach ($ls_imagenes_mn as $imagen_mn) { unlink(_PATH_IMAGENES.$imagen_mn); }
		foreach ($ls_imagenes as $imagen) { unlink(_PATH_IMAGENES.$imagen); }
	}

	function getImagenes($_id_galeria,$_mn=true) {
		$dir = opendir(_PATH_IMAGENES);
		while ($img_tmp = readdir($dir)) {
			if ($img_tmp != '.' && $img_tmp != '..') $imgs[] = $img_tmp;
		}
		closedir($dir);
		$lrg_imgs = count($imgs);

		for ($x=0;$x<$lrg_imgs;$x++) {
			$a_img = explode("_",$imgs[$x]);
			if ($_mn) {
				if ($a_img[0] == $_id_galeria && $a_img[1] == 'mn') $ls_imagenes[] = $imgs[$x];
			} else {
				if ($a_img[0] == $_id_galeria && $a_img[1] != 'mn') $ls_imagenes[] = $imgs[$x];
			}
		}

		if (count($ls_imagenes) > 0) {
			sort($ls_imagenes);
		} else {
			unset($ls_imagenes);
			$ls_imagenes = false;
		}

		return $ls_imagenes;
	}

	function getImagenesxLote($_id_galeria) {
		$ls_imagenes = $this->getImagenes($_id_galeria,true);
		$lrg_imgs = count($ls_imagenes);

		for ($x=0;$x<$lrg_imgs;$x+=3) {
			$ls_imagenes_tmp[] = array($ls_imagenes[$x],$ls_imagenes[$x+1],$ls_imagenes[$x+2]);
		}

		return $ls_imagenes_tmp;
	}
	
	function getMenor($id_galeria) {
		$sql = "select * from {$this->tb_imagenes} where id_galeria=".$id_galeria." order by orden asc";						
		$rs_menor = $this->getConsulta($sql);
			
		return $rs_menor->fields["orden"];
	}
	
	function getOrden($_id_galeria,$_id_imagen) {
		$sql = "select * from {$this->tb_imagenes} where id_galeria={$_id_galeria} AND id_imagen={$_id_imagen}";						
		$rs_orden = $this->getConsulta($sql);
			
		return $rs_orden->fields["orden"];
	}
				
	function Modificar_Orden($_cmps) {
		
		if (array_key_exists("orden",$_cmps)) {
			$orden = $this->getOrden($_cmps["id_galeria"],$_cmps["id_imagen"]);
			if ($orden != $_cmps["orden"] && $_cmps["orden"] != '99') {
				#cambio la prioridad
				$sql = "select * from {$this->tb_imagenes} where orden = {$_cmps["orden"]} AND id_galeria={$_cmps["id_galeria"]}";
				$this->setModificar($sql,array("orden"=>$orden));
			}
		}
	
		$sql = "select * from {$this->tb_imagenes} where id_galeria=".$_cmps["id_galeria"]." AND id_imagen=".$_cmps['id_imagen'];
		return $this->setModificar($sql,$_cmps);
	}
	
	function getMayor($_id_galeria) {
		$sql = "select * from {$this->tb_imagenes} where id_galeria=$_id_galeria order by orden desc";						
		$rs_mayor = $this->getConsulta($sql);
			
		return $rs_mayor->fields["orden"];
	}
	
	function getImagen($_id_imagen) {
		$sql = "select * from {$this->tb_imagenes} where id_imagen=$_id_imagen";						
		$rs = $this->getConsulta($sql);
			
		return $rs->fields;
	}
	
	function Publicar_imagen($_id_galeria,$_id_imagen){
            $this->setTransaccion('start');

            $sql = "UPDATE ".$this->tb_imagenes." SET publicado = 1 WHERE id_galeria = ".$_id_galeria." AND id_imagen=".$_id_imagen;
            $this->db->Execute($sql);
       
            return $this->setTransaccion('end');                        
        }
        
  function Despublicar_imagen($_id_galeria,$_id_imagen){
            $this->setTransaccion('start');

            $sql = "UPDATE ".$this->tb_imagenes." SET publicado = 0 WHERE id_galeria =".$_id_galeria." AND id_imagen=".$_id_imagen;
            $this->db->Execute($sql);
       
            return $this->setTransaccion('end');                        
        }

    // function get_data_gallery($_seccion){
    // 	$sql = "SELECT g.id_galeria, g.nombre FROM {$this->tb} g WHERE g.seccion = '{$_seccion}'";
    // 	$rs = $this->getConsulta($sql);
    // 	$dato = array();
    // 	while(!$rs->EOF){
    // 		$datos = array();
    // 		$datos[$rs->fields["id_galeria"]] = $rs->fields["nombre"];
    // 		$dato[] = $datos;
    // 		$rs->MoveNext();
    // 	}
    // 	return $dato;
    // }

    function get_sections(){
    	$sql = "SELECT g.seccion FROM {$this->tb} g GROUP BY g.seccion ORDER BY g.seccion DESC";
    	$rs = $this->getConsulta($sql);
    	
    		$dato = array();
    		$dato["seccion"] = $rs->fields["seccion"];
    		$dato["menu"] = $this->get_data_gallery($rs->fields["seccion"]);

    	return $dato;
    }


    function get_galleries_son($seccion,$nivel){
    	$sql = "SELECT g.nombre,g.id_galeria FROM {$this->tb} g WHERE g.seccion='{$seccion}'";
    	$rs = $this->getConsulta($sql);
                $items = array();
                while (!$rs->EOF) {
                	$item = $rs->fields;
                	$item['nivel'] = $nivel;
					$item['indent'] = str_repeat("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;", $nivel);
					$items[]=$item;
                    $rs->MoveNext();
        }
         return $items;
    }

    function get_galleries($nivel = 0) {
    	
    		$sql = "SELECT g.seccion FROM {$this->tb} g GROUP BY g.seccion ORDER BY g.seccion DESC";
    		
    		$rs = $this->getConsulta($sql);
                $items = array();
                while (!$rs->EOF) {
                        $item = $rs->fields;
			$item['nivel'] = $nivel;
			$item['indent'] = str_repeat("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;", $nivel);
			$items_hijo = $this->get_galleries_son($item["seccion"], $nivel+1);
			$items[]=$item;
			$items=array_merge($items,$items_hijo);
                        $rs->MoveNext();
            }
         return $items;
        }
    }

?>