<?php
// Portable UTF-8
use voku\helper\UTF8;
	class Feriado_Modelo extends Modelo {
		
		var $tb_feriados;

		function Feriado_Modelo() {
			parent::Modelo();			
			$this->tb_feriados = 'trans_feriados';
		}
		
		
		function getFeriados($pagina_actual) {
			$sql = 'select * from '.$this->tb_feriados.' order by fecha asc';
			$rs = $this->getConsulta($sql,true,$pagina_actual);
			$feriados = array();

			while (!$rs->EOF) {		
                $feriado = array();
                $feriado['id_feriado'] = $rs->fields['id_feriado'];
                $feriado['fecha'] = $this->fechaDMA($rs->fields['fecha']);
                $feriado['motivo'] = $rs->fields['motivo'];
                
                $feriados[] = $feriado;
				$rs->MoveNext();
			}
            
			$datos["feriados"] = $feriados;
			$datos["paginacion"] = $this->getPaginado($rs->atfirstpage(),$rs->absolutepage(),$rs->atlastpage(),$rs->lastpageno());
			$datos['paginacion']['paginar'] = ($rs->atfirstpage() && ($rs->lastpageno() == $rs->absolutepage())) ? "false" : "true";
			
   
            
			return $datos;
        }
		
        function getFeriados_Actuales($fecha) {
            $sql = "select fecha from ".$this->tb_feriados." where fecha >= '".$fecha."' order by fecha asc";
            $rs = $this->getConsulta($sql);
            $feriados = array();

            while (!$rs->EOF) {                        
                $fecha = $this->fechaAMD($rs->fields["fecha"]);
                $feriados[$fecha] = $fecha;
                $rs->MoveNext();
            }
            
 
            
            return $feriados;
        }
        
        function getFeriados_Anio($fecha) {
            $sql = "select fecha from ".$this->tb_feriados." where fecha >= '".$fecha."' order by fecha asc";
            $rs = $this->getConsulta($sql);
            $feriados = array();

            while (!$rs->EOF) {                        
                $fecha = $this->fechaAMD($rs->fields["fecha"]);
                $feriados[$fecha] = $fecha;
                $rs->MoveNext();
            }
            
            return $feriados;
        }
        
        function existe($fecha, $id) {
            $fecha = $this->fechaAMD($fecha);
            $sql = "select * from {$this->tb_feriados} where fecha='{$fecha}' and id_feriado != '{$id}'";
            $rs = $this->getConsulta($sql);
            if(!$rs->EOF){
                return true;
            }else{
                return false;
            }
        }
        
		function getFeriado($id_feriado) {
			$sql = "select * from {$this->tb_feriados} where id_feriado='{$id_feriado}' ";
			$rs = $this->getConsulta($sql);
			$feriado = array();
			$feriado["id_feriado"] = $rs->fields["id_feriado"];
			$feriado["fecha"] = $this->fechaDMA($rs->fields["fecha"]);
			$feriado["motivo"] = $rs->fields["motivo"];

        
			return $feriado;
		}
					
		function setInsertID() {
				return $this->getInsertID();
		}
		
		function setAgregar_feriado($cmps) {
            $cmps['fecha'] = $this->fechaAMD($cmps['fecha']);
            
			$sql = "select * from {$this->tb_feriados} where id_feriado = -1";
			return $this->setGuardar($sql,$cmps);
		}

		function Modificar($cmps){
            $cmps['fecha'] = $this->fechaAMD($cmps['fecha']);
			$sql = 'select * from '.$this->tb_feriados.' where id_feriado = '.$cmps['id_feriado'];
			return $this->setModificar($sql,$cmps);
		}
		
		function Eliminar($id_feriado) {
			$this->setTransaccion('start');

			$sql = 'delete from '.$this->tb_feriados.' where id_feriado = '.$id_feriado;
			$this->db->Execute($sql);

			return $this->setTransaccion('end');
		}
        
        function fechaAMD($fecha, $union = "/"){
            if(strpos($fecha, "-")){
                $datos = split("-", $fecha);
                if(strlen($datos[2]) == 4){
                    $fecha = $datos[2].$union.$datos[1].$union.$datos[0];
                }else{
                    $fecha = $datos[0].$union.$datos[1].$union.$datos[2];
                }
            }else if(strpos($fecha, "/")){
                $datos = split("/", $fecha);
                if(strlen($datos[2]) == 4){
                    $fecha = $datos[2].$union.$datos[1].$union.$datos[0];
                }else{
                    $fecha = $datos[0].$union.$datos[1].$union.$datos[2];
                }            
            }
            
            return $fecha;
        }
        
        function fechaDMA($fecha, $union = "/"){
            if(strpos($fecha, "-")){
                $datos = split("-", $fecha);
                if(strlen($datos[0]) == 4){
                    $fecha = $datos[2].$union.$datos[1].$union.$datos[0];
                }else{
                    $fecha = $datos[0].$union.$datos[1].$union.$datos[2];
                }
            }else if(strpos($fecha, "/")){
                $datos = split("/", $fecha);
                if(strlen($datos[0]) == 4){
                    $fecha = $datos[2].$union.$datos[1].$union.$datos[0];
                }else{
                    $fecha = $datos[0].$union.$datos[1].$union.$datos[2];
                }            
            }
            
            return $fecha;
        }
        
        //Se realiza el calculo de dias habiles a partir de una fecha y se devuelve
        //la fecha corespondiente a la suma de dias habiles.
        function fechaValida($desde, $dias){
			$desde = $this->fechaAMD($desde);
         $feriados = $this->getFeriados_Actuales($desde);
		
		   //separo la fecha en dia mes y a�o
            $dia = date('d', strtotime($desde));
            $mes = date('m', strtotime($desde));
            $ano = date('Y', strtotime($desde));

            $mkDesde    = mktime(0,0,0,$mes,$dia,$ano);
            $sumar = $dias;
            $i=1;
            while($i < $sumar){            
                $mkDia = mktime(0, 0, 0, $mes, $dia + $i, $ano);
                
                $resultado = date('Y/m/d', $mkDia);
                if(!$this->esHabil($resultado, $feriados)){
                    $sumar += 1;
                }
                $i++;
            }
            
            $mkFecha = mktime(0,0,0,$mes, $dia + $sumar, $ano);			
            $resultado = date('Y/m/d', $mkFecha);

            if($this->esHabil($resultado, $feriados)){
                $fecha = date('Y/m/d', $mkFecha);
                return $fecha;
            }else{       				       
                return $this->fechaValida($resultado, 1);
            }
        }
        
        
        function fechaValidaRestante($desde, $dias){
			$desde = $this->fechaAMD($desde);
         $feriados = $this->getFeriados_Actuales($desde);
		
		   //separo la fecha en dia mes y a�o
            $dia = date('d', strtotime($desde));
            $mes = date('m', strtotime($desde));
            $ano = date('Y', strtotime($desde));

            $mkDesde    = mktime(0,0,0,$mes,$dia,$ano);
            $sumar = $dias;
            $i=1;
            while($i < $sumar){            
                $mkDia = mktime(0, 0, 0, $mes, $dia + $i, $ano);
                
                $resultado = date('Y/m/d', $mkDia);
                if(!$this->esHabil($resultado, $feriados)){
                    $sumar += 1;
                }
                $i++;
            }
            
            $mkFecha = mktime(0,0,0,$mes, $dia + $sumar, $ano);			
            $resultado = date('Y/m/d', $mkFecha);

            if($this->esHabil($resultado, $feriados)){
                $fecha = date('Y/m/d', $mkFecha);
                return $fecha;
            }else{       				       
                return $this->fechaValida($resultado, 1);
            }
        }
		
		function diff_date($date1, $date2)
		{
    		if (!is_integer($date1)) $date1 = strtotime($date1);
    		if (!is_integer($date2)) $date2 = strtotime($date2);
   			 return floor(abs($date1 - $date2) / 60 / 60 / 24);
		} 

		function Alert($desde,$hasta){
			$desde = $this->fechaAMD($desde);
            $feriados = $this->getFeriados_Actuales($desde);
		
		   //separo la fecha en dia mes y a�o
            $dia = date('d', strtotime($desde));
            $mes = date('m', strtotime($desde));
            $ano = date('Y', strtotime($desde));

            $mkDesde    = mktime(0,0,0,$mes,$dia,$ano);
            $sumar = $this->diff_date($desde, $hasta);
            $i=0;
			$alert=0;
            while($i <= $sumar){            
                $mkDia = mktime(0, 0, 0, $mes, $dia + $i, $ano);
                
                $resultado = date('Y/m/d', $mkDia);
                if($this->esHabil($resultado, $feriados)){
                    $alert++;
                }
                $i++;
            }
            
			return  $alert;	
		}
        
        function esHabil($fecha, $feriados){            
            //separo la fecha en dia mes y a�o
            $dia = date('d', strtotime($fecha));
            $mes = date('m', strtotime($fecha));
            $ano = date('Y', strtotime($fecha));
 
            //calculo el timestamp de la fechainicial
            $mkFecha = mktime(0, 0, 0, $mes, $dia, $ano);
 
            $esHabil = true;
            
            //realizo la correccion correspondiente por el fin de semana            
            switch (date('w', $mkFecha)) {
                case 1: //Lunes
                case 2: //Martes
                case 3: //Miercoles
                case 4: //Jueves
                case 5: //Viernes
                    $esHabil = true;
                    break;
                case 6: //Sabado
                case 0: //Domingo
                    $esHabil = false;
                    break;
            }
            
            if($esHabil){
                if(array_key_exists($fecha, $feriados)){                    
                    return false;
                }else{
                    return true;
                }                
            }else{
                return false;
            }
        }
        
        function getFeriadosEntreFechas($fecha_desde,$fecha_hasta) {
            $sql = "SELECT fecha FROM trans_feriados WHERE fecha BETWEEN '$fecha_desde' AND '$fecha_hasta' ORDER BY fecha ASC";
            //print_r($sql);
            $rs = $this->getConsulta($sql);
            $feriados = array();

            while (!$rs->EOF) {                        
                $fecha = $this->fechaAMD($rs->fields["fecha"]);
                $feriados[$fecha] = $fecha;
                $rs->MoveNext();
            }
            
            return $feriados;
        }
        
	}
?>