<?php
// Portable UTF-8
use voku\helper\UTF8;
class Contacto_Pasiva_Modelo {
	var $email;
	var $host;

	function Contacto_Pasiva_Modelo() {
		$this->email = new PHPMailer();
		$this->email->IsHTML(true);
	}

	function setExtendidoPasiva($cmps,$datos,$datos_oirs,$cmps_oirs,$dato_adjunto) {
	
		require_once(_SMARTY_DIR.'Smarty.class.php');				
		$smarty = new Smarty;
		$smarty->template_dir = _SMARTY_TPL."templates/";
        $smarty->compile_dir = _SMARTY_TPL."templates_c/";
		$smarty->left_delimiter = "<!--{";
		$smarty->right_delimiter = "}-->";

		$this->email->From = _REMITENTE;
		$this->email->FromName = "Portal ".utf8_decode(_NOMBRE_INSTITUCION);
		
		$this->email->AddAddress($datos_oirs['email_oirs']);
		$this->email->AddCC(_COPIA);
		$this->email->Subject = utf8_decode("Aviso de extensión");
		$smarty->assign("fecha_extendido",$cmps_oirs["fecha_extendido"]);
		$smarty->assign("nombre",$datos["nombre"]);
		$smarty->assign("apellido_paterno_ciudadano",$datos["apellido_paterno_ciudadano"]);
		$smarty->assign("apellido_materno_ciudadano",$datos["apellido_materno_ciudadano"]);
		$smarty->assign("url_contacto",_HOME_WEB);
		$smarty->assign("cod_solicitud",$cmps["cod_solicitud"]);

		$body = $smarty->fetch("extension_email.tpl.htm");

		$this->email->Body = $body;
		$this->email->WordWrap = 100;
		return $this->email->Send();		
	}
	
	function setCerrar_Pasiva($email,$mensaje,$estado,$cmps,$asunto,$cmps_email_oirs,$cmps_email_solinfo,$cmps_tipo_respuesta) {
		
		require_once(_SMARTY_DIR.'Smarty.class.php');				
		$smarty = new Smarty;
		$smarty->template_dir = _SMARTY_TPL."templates/";
        $smarty->compile_dir = _SMARTY_TPL."templates_c/";
		$smarty->left_delimiter = "<!--{";
		$smarty->right_delimiter = "}-->";

		$this->email->From = _REMITENTE;
		$this->email->FromName = "Portal ".utf8_decode(_NOMBRE_INSTITUCION);

		if($cmps_email_solinfo != 1){
			$this->email->AddAddress($email);
			$this->email->AddCC(_COPIA);
		}else{
			$this->email->AddAddress($cmps_email_oirs);
			$this->email->AddCC(_COPIA);
		}
		$this->email->Subject = "Cierre Requerimiento";

		$smarty->assign("nombre_ciudadano",$cmps["nombre_ciudadano"]);
		$smarty->assign("apellido_paterno_ciudadano",$cmps["apellido_paterno_ciudadano"]);
		$smarty->assign("apellido_materno_ciudadano",$cmps["apellido_materno_ciudadano"]);
		$smarty->assign("id_oirs",$cmps["id_oirs"]);
		$smarty->assign("asunto",$asunto);
		$smarty->assign("mensaje",$mensaje);
		$smarty->assign("estado",$estado["estado"]);
		$smarty->assign("nota_al_ciudadano",$cmps["nota_al_ciudadano"]);
		$smarty->assign("tipo",$cmps["tipo"]);
		$smarty->assign("url_contacto",_HOME_WEB);
		$smarty->assign("cod_solicitud",$cmps["cod_solicitud"]);

		$body = $smarty->fetch("cierre_email.tpl.htm");

		$this->email->Body = $body;
		$this->email->WordWrap = 100;	

		return $this->email->Send();		
	}
	
	function setRespuestaPasiva($cmps,$datos,$datos_oirs,$dato_adjunto) {

		require_once(_SMARTY_DIR.'Smarty.class.php');				
		$smarty = new Smarty;
		$smarty->template_dir = _SMARTY_TPL."templates/";
        $smarty->compile_dir = _SMARTY_TPL."templates_c/";
		$smarty->left_delimiter = "<!--{";
		$smarty->right_delimiter = "}-->";
	
		$this->email->From = _REMITENTE;
		$this->email->FromName = "Portal ".utf8_decode(_NOMBRE_INSTITUCION);		
		$this->email->AddAddress($datos_oirs['email_oirs']);
		$this->email->AddCC(_COPIA);
		$this->email->Subject = "Respuesta a su solicitud";		

		$smarty->assign("organismo",$cmps["organismo"]["nombre"]);
		$smarty->assign("tipo_respuesta",$datos_oirs["tipo_respuesta"]);
		$smarty->assign("email_oirs",$datos_oirs["email_oirs"]);
		$smarty->assign("mensaje",$datos_oirs["mensaje"]);
		$smarty->assign("formato_entrega",$datos_oirs["formato_entrega"]);
		$smarty->assign("enlaceadmin",_HOME_WEB."index.php?action=login_solicitud_informacion&solicitud_informacion=1");
		$smarty->assign("url_contacto",_HOME_WEB);
		$smarty->assign("nota_al_ciudadano",$cmps["nota_al_ciudadano"]);

		$smarty->assign("cod_solicitud",$cmps["cod_solicitud"]);
		$smarty->assign("no_registrado",$datos["no_registrado"]);

		$body = $smarty->fetch("respuesta_email.tpl.htm");

		$this->email->Body = $body;		
		$this->email->WordWrap = 100;
		return $this->email->Send();		
	}
	
	function setDerivar($cmps,$datos,$datos_oirs,$organo,$dato_adjunto_der,$funcionario) {	
		
		require_once(_SMARTY_DIR."Smarty.class.php");				
		$smarty = new Smarty;
		$smarty->template_dir = _SMARTY_TPL."templates/";
        $smarty->compile_dir = _SMARTY_TPL."templates_c/";
		$smarty->left_delimiter = "<!--{";
		$smarty->right_delimiter = "}-->";

		$oirs_modelo = new OIRS_Modelo();		
		$funcionario = $oirs_modelo->getFuncionario(1);

		$this->email->From = "{$funcionario["email"]}";
		$this->email->FromName = "Portal ".utf8_decode(_NOMBRE_INSTITUCION);		
		$this->email->AddAddress($organo["email"]);
		$this->email->AddCC(_COPIA);
		$this->email->Subject = utf8_decode("Aviso de Derivación");

		$smarty->assign("nombre_org",$organo["nombre_org"]);
		$smarty->assign("id_oirs",$cmps["id_oirs"]);
		$smarty->assign("asunto",$datos_oirs["asunto"]);
		$smarty->assign("mensaje",$datos_oirs["mensaje"]);
		$smarty->assign("nota_interna",$cmps["nota_interna"]);
		$smarty->assign("diasrestantes",$cmps["diasrestantes"]);

		$smarty->assign("fechafinal",$datos_oirs['fechafinal']);

		$body = $smarty->fetch("derivacion_email.tpl.htm");
				
		$this->email->Body = $body;
		
		$this->email->WordWrap = 100;
	
		return $this->email->Send();			
	}

	function setEnviarSolicitudPasiva($datos,$id_oirs,$funcionario,$datos_ciudadano) {

		require_once(_SMARTY_DIR.'Smarty.class.php');				
		$smarty = new Smarty;
		$smarty->template_dir = _SMARTY_TPL."templates/";
        $smarty->compile_dir = _SMARTY_TPL."templates_c/";
		$smarty->left_delimiter = "<!--{";
		$smarty->right_delimiter = "}-->";

		$this->email->From = _REMITENTE;
		$this->email->FromName = "Portal ".utf8_decode(_NOMBRE_INSTITUCION);		
		$this->email->AddAddress($funcionario['email']);
		$this->email->AddCC(_COPIA);
		$this->email->Subject = "Aviso de nuevo requerimiento";

		$smarty->assign("nombre_funcionario",$funcionario['nombre']);
		$smarty->assign("nombre_institucion",_NOMBRE_INSTITUCION);
		$smarty->assign("fecha",$datos['fecha']);
		$smarty->assign("id_oirs",$id_oirs);
		$smarty->assign("url_contacto",url_contacto);
		$smarty->assign("url_contacto_admin",_URL_CONTACTO_ADMIN);

		$body = $smarty->fetch("ingreso_pasiva_email_funcionario.tpl.htm");

		$this->email->Body = $body;
		$this->email->Send();	
		$this->email->ClearAddresses();

		if($datos['envio_email']=='1'){
		$this->email->From = _REMITENTE;
		$this->email->FromName = "Portal ".utf8_decode(_NOMBRE_INSTITUCION);	
		$this->email->AddAddress($datos["email_oirs"]);	
		$this->email->AddCC(_COPIA);		
		$this->email->Subject = "Portal ".utf8_decode(_NOMBRE_INSTITUCION);

		$smarty->assign("nombre_ciudadano",$datos_ciudadano["nombre"]);
		$smarty->assign("apellido_paterno_ciudadano",$datos_ciudadano["apellido_paterno_ciudadano"]);
		$smarty->assign("apellido_materno_ciudadano",$datos_ciudadano["apellido_materno_ciudadano"]);
		$smarty->assign("fecha_maxima_respuesta",$datos["fecha_maxima_respuesta"]);

		$smarty->assign("id_oirs",$id_oirs);

		$body = $smarty->fetch("ingreso_pasiva_email_ciudadano.tpl.htm");

		$this->email->Body = $body;

		$this->email->WordWrap = 100;
		return $this->email->Send();
		}
	}
}
?>
