<?php
// Portable UTF-8
use voku\helper\UTF8;

class Contacto_Modelo {
	var $email;
	var $host;

	function Contacto_Modelo() {
		$this->email = new PHPMailer();
		$this->email->IsHTML(true);
	}

	function setDerivar($cmps,$datos,$datos_oirs,$organo,$dato_adjunto_der,$funcionario) {

		require_once(_SMARTY_DIR."Smarty.class.php");
		$smarty = new Smarty;
		$smarty->template_dir = _SMARTY_TPL."templates/";
        $smarty->compile_dir = _SMARTY_TPL."templates_c/";
		$smarty->left_delimiter = "<!--{";
		$smarty->right_delimiter = "}-->";

		$oirs_modelo = new OIRS_Modelo();
		$funcionario = $oirs_modelo->getFuncionario(1);

		$this->email->From = "{$funcionario["email"]}";
		$this->email->FromName = _NOMBRE_INSTITUCION;
		$this->email->AddAddress($organo["email"]);
		$this->email->AddCC(_COPIA);
		$this->email->Subject = "Aviso de Derivación";

		$smarty->assign("nombre_org",$organo["nombre_org"]);
		$smarty->assign("id_oirs",$cmps["id_oirs"]);
		$smarty->assign("asunto",$datos_oirs["asunto"]);
		$smarty->assign("mensaje",$datos_oirs["mensaje"]);
		$smarty->assign("nota_interna",$cmps["nota_interna"]);
		$smarty->assign("diasrestantes",$cmps["diasrestantes"]);
		$smarty->assign("enlaceadmin",_HOME_WEB."/index.php?action=login");
		$smarty->assign("tipo",$cmps['tipo_oirs']);

		$smarty->assign("fechafinal",$datos_oirs['fechafinal']);

		$body = $smarty->fetch("derivacion_email.tpl.htm");

		$this->email->Body = $body;

		$this->email->WordWrap = 100;

		return $this->email->Send();
	}

	function setExtendido($cmps,$datos,$datos_oirs,$cmps_oirs,$dato_adjunto) {

		require_once(_SMARTY_DIR.'Smarty.class.php');
		$smarty = new Smarty;
		$smarty->template_dir = _SMARTY_TPL."templates/";
        $smarty->compile_dir = _SMARTY_TPL."templates_c/";
		$smarty->left_delimiter = "<!--{";
		$smarty->right_delimiter = "}-->";

		$this->email->From = _REMITENTE;
		$this->email->FromName = _NOMBRE_INSTITUCION;
		$this->email->AddAddress($datos_oirs['email']);
		$this->email->AddCC(_COPIA);
		$this->email->Subject = "Aviso de extensión";

		$smarty->assign("fecha_extendido",$cmps_oirs["fecha_extendido"]);
		$smarty->assign("nombre",$datos["nombre"]);
		$smarty->assign("apellido_paterno_ciudadano",$datos["apellido_paterno_ciudadano"]);
		$smarty->assign("apellido_materno_ciudadano",$datos["apellido_materno_ciudadano"]);
		$smarty->assign("tipo",$cmps['tipo_oirs']);

		$smarty->assign("id_oirs",$cmps["id_oirs"]);

		$body = $smarty->fetch("extension_email.tpl.htm");

		$this->email->Body = $body;
		$this->email->WordWrap = 100;
		return $this->email->Send();
	}


	function setRespuestaOIRS($cmps,$datos,$datos_oirs,$dato_adjunto) {

		require_once(_SMARTY_DIR.'Smarty.class.php');
		$smarty = new Smarty;
		$smarty->template_dir = _SMARTY_TPL."templates/";
        	$smarty->compile_dir = _SMARTY_TPL."templates_c/";
		$smarty->left_delimiter = "<!--{";
		$smarty->right_delimiter = "}-->";

		$this->email->From = _REMITENTE;
		$this->email->FromName = _NOMBRE_INSTITUCION;
		$this->email->AddAddress($datos['email']);
		$this->email->AddCC(_COPIA);
		$this->email->Subject = "Respuesta a su solicitud";

		$smarty->assign("nota_al_ciudadano",$cmps["nota_al_ciudadano"]);
		$smarty->assign("organismo",$cmps["organismo"]["nombre"]);
		$smarty->assign("tipo_respuesta",$datos_oirs["tipo_respuesta"]);
		$smarty->assign("email_oirs",$datos_oirs["email_oirs"]);
		$smarty->assign("mensaje",$datos_oirs["mensaje"]);
		$smarty->assign("formato_entrega",$datos_oirs["formato_entrega"]);
		$smarty->assign("enlaceadmin",_HOME_WEB."index.php?action=oirs");
		$smarty->assign("tipo",$cmps['tipo_oirs']);
		$smarty->assign("id_oirs",$cmps["id_oirs"]);
		$smarty->assign("no_registrado",$datos["no_registrado"]);
		$smarty->assign("url_contacto", _HOME_WEB);
		$body = $smarty->fetch("respuesta_email.tpl.htm");

		$this->email->Body = $body;
		$this->email->WordWrap = 100;
		return $this->email->Send();
	}


	function setCorreccion($cmps,$datos,$datos_oirs,$cmps_oirs) {

		require_once(_SMARTY_DIR.'Smarty.class.php');
		$smarty = new Smarty;
		$smarty->template_dir = _SMARTY_TPL."templates/";
        $smarty->compile_dir = _SMARTY_TPL."templates_c/";
		$smarty->left_delimiter = "<!--{";
		$smarty->right_delimiter = "}-->";

		$this->email->CharSet = 'UTF-8';
		$this->email->From = _REMITENTE;
		$this->email->FromName = _NOMBRE_INSTITUCION;
		$this->email->AddAddress($datos_oirs["solicitud_informacion"]==1 ? $datos_oirs['email_oirs'] : $datos["email"]);
		$this->email->AddCC(_COPIA);
		$this->email->Subject = "Responder solicitud subsanación / "._NOMBRE_INSTITUCION;

		$smarty->assign("nombre_ciudadano",$datos["nombre"]);
		$smarty->assign("apellido_paterno_ciudadano",$datos["apellido_paterno_ciudadano"]);
		$smarty->assign("apellido_materno_ciudadano",$datos["apellido_materno_ciudadano"]);
		$smarty->assign("id_oirs",$cmps["id_oirs"]);
		$smarty->assign("nota_al_ciudadano",$cmps["nota_al_ciudadano"]);
		$smarty->assign("url_contacto",url_contacto);
		$smarty->assign("tipo",$cmps['tipo']);

		$smarty->assign("no_registrado",$datos['no_registrado']);
		$smarty->assign("fecha_modificar",$cmps_oirs['fecha_modificar']);
		$smarty->assign("cod_solicitud",$cmps_oirs['cod_solicitud']);

		$body = $smarty->fetch("subsanacion_email.tpl.htm");

		$this->email->Body = $body;
		$this->email->WordWrap = 100;

		return $this->email->Send();
	}

	function setProceso($cmps,$datos,$datos_oirs) {

		require_once(_SMARTY_DIR.'Smarty.class.php');
		$smarty = new Smarty;
		$smarty->template_dir = _SMARTY_TPL."templates/";
        $smarty->compile_dir = _SMARTY_TPL."templates_c/";
		$smarty->left_delimiter = "<!--{";
		$smarty->right_delimiter = "}-->";

		$this->email->From = _REMITENTE;
		$this->email->FromName = _NOMBRE_INSTITUCION;
		$this->email->AddAddress($datos['email']);
		$this->email->AddCC(_COPIA);
		$this->email->Subject = "Trámite Requerimiento";

		$smarty->assign("id_oirs",$cmps['id_oirs']);
		$smarty->assign("asunto",$datos_oirs['asunto']);
		$smarty->assign("mensaje",$datos_oirs['mensaje']);
		$smarty->assign("nota_al_ciudadano",$cmps['nota_al_ciudadano']);

		$body = $smarty->fetch("proceso_email.tpl.htm");

		$this->email->Body = $body;
		$this->email->WordWrap = 100;
		return $this->email->Send();
	}

	function setCerrar_Oirs($email,$mensaje,$estado,$cmps,$asunto,$cmps_email_oirs,$cmps_email_solinfo,$cmps_tipo_respuesta) {

		require_once(_SMARTY_DIR.'Smarty.class.php');
		$smarty = new Smarty;
		$smarty->template_dir = _SMARTY_TPL."templates/";
        $smarty->compile_dir = _SMARTY_TPL."templates_c/";
		$smarty->left_delimiter = "<!--{";
		$smarty->right_delimiter = "}-->";

		$this->email->From = _REMITENTE;
		$this->email->FromName = _NOMBRE_INSTITUCION;

		$this->email->AddAddress($email);
		$this->email->AddCC(_COPIA);
		$this->email->Subject = "Cierre Requerimiento";

		$smarty->assign("nombre_ciudadano",$cmps["nombre_ciudadano"]);
		$smarty->assign("apellido_paterno_ciudadano",$cmps["apellido_paterno_ciudadano"]);
		$smarty->assign("apellido_materno_ciudadano",$cmps["apellido_materno_ciudadano"]);
		$smarty->assign("id_oirs",$cmps["id_oirs"]);
		$smarty->assign("asunto",$asunto);
		$smarty->assign("mensaje",$mensaje);
		$smarty->assign("estado",$estado["estado"]);
		$smarty->assign("nota_al_ciudadano",$cmps["nota_al_ciudadano"]);

		$body = $smarty->fetch("cierre_email.tpl.htm");

		$this->email->Body = $body;
		$this->email->WordWrap = 100;

		return $this->email->Send();
	}

	function setRegistro_usuario($datos_ciudadano,$datos_usuario) {

		require_once(_SMARTY_DIR.'Smarty.class.php');
		$smarty = new Smarty;
		$smarty->template_dir = _SMARTY_TPL."templates/";
        $smarty->compile_dir = _SMARTY_TPL."templates_c/";
		$smarty->left_delimiter = "<!--{";
		$smarty->right_delimiter = "}-->";

		$this->email->From = _REMITENTE;
		$this->email->FromName = _NOMBRE_INSTITUCION;

		$this->email->AddAddress($datos_ciudadano['email']);
		$this->email->AddCC(_COPIA);
		$this->email->Subject = "Registro Portal "._NOMBRE_INSTITUCION;

		$smarty->assign("nombre_ciudadano",$datos_ciudadano["nombre"]);
		$smarty->assign("apellido_paterno_ciudadano",$datos_ciudadano["apellido_paterno_ciudadano"]);
		$smarty->assign("apellido_materno_ciudadano",$datos_ciudadano["apellido_materno_ciudadano"]);
		$smarty->assign("id_ciudadano",$datos_ciudadano['id_ciudadano']);
		$smarty->assign("contrasena",$datos_usuario['contrasena']);
		$smarty->assign("codigo_activacion",$datos_usuario['codigo_activacion']);
		$smarty->assign("nombre_institucion",_NOMBRE_INSTITUCION);
		$smarty->assign("url_contacto",url_contacto);

		$body = $smarty->fetch("registro_ciudadano_email.tpl.htm");

		$this->email->Body = $body;

		$this->email->WordWrap = 100;

		return $this->email->Send();

	}

	function setRegistro_usuario_reenvio($datos_ciudadano) {
		#enviar mail[
		$this->email->From = _REMITENTE;
		$this->email->FromName = "Portal "._NOMBRE_INSTITUCION;

		$this->email->AddAddress($datos_ciudadano['email']);
		$this->email->AddCC(_COPIA);
		$this->email->Subject = "Registro Portal "._NOMBRE_INSTITUCION;
		$this->email->Body = "Estimado Ciudadano {$datos_ciudadano['nombre']} {$datos_ciudadano['apellidos']}:<br><br>".
		"Este es un reenvío de correo para activación de su cuenta de usuario en la Oficina de Opinión, Información, Reclamos y Sugerencias (OIRS) de "._NOMBRE_INSTITUCION."\n".
		"Usted se ha registrado como usuario en la Oficina de Opinión, Información, Reclamos y Sugerencias (OIRS) de "._NOMBRE_INSTITUCION.
		", y se asigno el siguiente ID Ciudadano y Contraseńa con las cuales podra revisar sus consultas: <br><br>".
		"ID Ciudadano: {$datos_ciudadano['id_usuario']}<br>".
		"Contraseńa: {$datos_ciudadano['contrasena']}<br>".
		"<a href='".url_contacto."index.php?action=activar&code={$datos_ciudadano['codigo_activacion']}&adm=si'>Activar cuenta</a><br><br>".
		"(Le rogamos que no responda este correo electrónico que ha sido diseńado exclusivamente para el envío de información)<br>";
		$this->email->WordWrap = 100;
		return $this->email->Send();

	}

	function setEnviar_funcionario($datos,$id_oirs,$funcionario,$email_ciu) {

		require_once(_SMARTY_DIR.'Smarty.class.php');
		$smarty = new Smarty;
		$smarty->template_dir = _SMARTY_TPL."templates/";
        $smarty->compile_dir = _SMARTY_TPL."templates_c/";
		$smarty->left_delimiter = "<!--{";
		$smarty->right_delimiter = "}-->";

		$this->email->From = _REMITENTE;
		$this->email->FromName = _NOMBRE_INSTITUCION;
		$this->email->AddAddress($funcionario['email']);
		$this->email->AddCC(_COPIA);
		$this->email->Subject = "Aviso de nuevo requerimiento";

		$smarty->assign("nombre_funcionario",$funcionario['nombre']);
		$smarty->assign("nombre_institucion",_NOMBRE_INSTITUCION);
		$smarty->assign("fecha",$datos['fecha']);
		$smarty->assign("id_oirs",$id_oirs);
		$smarty->assign("url_contacto",url_contacto);
		$smarty->assign("url_contacto_admin",_URL_CONTACTO_ADMIN);

		$smarty->assign("id_oirs",$id_oirs);

		$body = $smarty->fetch("ingreso_oirs_email_funcionario.tpl.htm");

		$this->email->Body = $body;
		$this->email->Send();
		$this->email->ClearAddresses();

		if($datos['envio_email']=='1'){
		$this->email->AddAddress($email_ciu);
		$this->email->AddCC(_COPIA);
		$this->email->Subject = "OIRS "._NOMBRE_INSTITUCION;

		$smarty->assign("nombre_ciudadano",$datos["nombre_ciudadano"]);
		$smarty->assign("apellido_paterno_ciudadano",$datos["apellido_paterno_ciudadano"]);
		$smarty->assign("apellido_materno_ciudadano",$datos["apellido_materno_ciudadano"]);

		$body = $smarty->fetch("ingreso_oirs_email_ciudadano.tpl.htm");

		$this->email->Body = $body;

		$this->email->WordWrap = 100;
		return $this->email->Send();
		}
	}
}
?>
