<?php
// Portable UTF-8
use voku\helper\UTF8;
	class Articulos_Modelo extends Modelo {

		var $tabla;
		var $tabla_comentarios;
		var $table_imagenes;

		function Articulos_Modelo() {
			parent::Modelo();
			$this->tabla = 'articulos';
			$this->tabla_comentarios = 'articulos_comentarios';
			$this->tabla_imagenes = 'img_articulos';
		}

		function setAgregar($_cmps) {		
			$sql = 'select * from '.$this->tabla.' where id_articulo = -1';
			return $this->setGuardar($sql,$_cmps);
		}

		function Modificar($_cmps) {
			$sql = 'select * from '.$this->tabla.' where id_articulo = '.$_cmps['id_articulo'];
			return $this->setModificar($sql,$_cmps);
		}

		function Eliminar($_id_articulo) {
			$sql = 'delete from '.$this->tabla.' where id_articulo = '.$_id_articulo;
			return $this->setEliminar($sql);
		}

		function getLista($_pagina_actual,$_seccion) {
			$sql = 'select id_articulo,fecha,titulo,prioridad from '.$this->tabla.' where seccion = "'.$_seccion.'" order by prioridad asc, id_articulo desc';
			$rs_articulos = $this->getConsulta($sql,true,$_pagina_actual);
			$articulo = array();

			while (!$rs_articulos->EOF) {
				$articulo_tmp = array();
				$articulo_tmp['id_articulo'] = $rs_articulos->fields['id_articulo'];
				$articulo_tmp['fecha'] = $rs_articulos->fields['fecha'];
				$articulo_tmp['titulo'] = $rs_articulos->fields['titulo'];
				$articulo_tmp['epigrafe'] = $rs_articulos->fields['epigrafe'];
				$articulo_tmp['prioridad'] = $rs_articulos->fields['prioridad'];
				$articulo_tmp['totalcom'] = $this->getComentariosDes($articulo_tmp['id_articulo']) ;
				$articulo[] = $articulo_tmp;
				$rs_articulos->MoveNext();
			}

			$datos['articulo'] = $articulo;
			$datos['paginacion'] = $this->getPaginado($rs_articulos->atfirstpage(),$rs_articulos->absolutepage(),
				$rs_articulos->atlastpage(),$rs_articulos->lastpageno());

			$datos['paginacion']['paginar'] = ($rs_articulos->atfirstpage() && ($rs_articulos->lastpageno() == $rs_articulos->absolutepage())) ? "false" : "true";

			return $datos;
		}

		function getArticulo($_id_articulo) {
			$articulo = array();

			#articulo
			$sql = 'select * from '.$this->tabla.' where id_articulo='.$_id_articulo;
			$rs_articulo = $this->getConsulta($sql);

			$articulo["id_articulo"] = $rs_articulo->fields["id_articulo"];
			$articulo["titulo"] = $rs_articulo->fields["titulo"];
			$articulo["epigrafe"] = $rs_articulo->fields["epigrafe"];
			$articulo["cuerpo"] = $rs_articulo->fields["cuerpo"];
			$articulo["bajada"] = $rs_articulo->fields["bajada"];
			$articulo["prioridad"] = $rs_articulo->fields["prioridad"];
			$articulo["autor"] = $rs_articulo->fields["autor"];
			$articulo["seccion"] = $rs_articulo->fields["seccion"];
            

			return $articulo;
		}
		function setAgregarComentario($_cmps) {
			$sql = 'select * from '.$this->tabla_comentarios.' where id_comentario = -1';
			return $this->setGuardar($sql,$_cmps);
		}

		function ModificarComentario($cmps) {
			$sql = "select * from {$this->tabla_comentarios} where id_comentario = {$cmps['id_comentario']}";
			return $this->setModificar($sql,$cmps);
		}

		function EliminarComentario($_id_comentario) {
			$sql = "delete from {$this->tabla_comentarios} where id_comentario = $_id_comentario";
			return $this->setEliminar($sql);
		}

		function getComentario($id_comentario) {
			$sql = "select * from {$this->tabla_comentarios} where id_comentario=$id_comentario";
			$rs_comentario = $this->getConsulta($sql,true,$_pagina_actual);
			return $rs_comentario->fields;
		}

		function getComentariosLista($_id_articulo,$_pagina_actual) {
			$sql = "select * from ".$this->tabla_comentarios." where id_articulo=$_id_articulo order by id_comentario desc";
			$rs_comentarios = $this->getConsulta($sql,true,$_pagina_actual);
			$comentarios = array();

			while (!$rs_comentarios->EOF) {
				$comentario = array();
				$comentario["id_comentario"] = $rs_comentarios->fields["id_comentario"];
				$comentario["email"] = $rs_comentarios->fields["email"];
				$comentario["comentario"] = utf8_decode($rs_comentarios->fields["comentario"]);
				$comentario["habilitar"] = $rs_comentarios->fields["habilitar"];
				$comentarios[] = $comentario;
				$rs_comentarios->MoveNext();
			}

			$datos['comentarios'] = $comentarios;
			$datos['paginacion'] = $this->getPaginado($rs_comentarios->atfirstpage(),$rs_comentarios->absolutepage(),
			$rs_comentarios->atlastpage(),$rs_comentarios->lastpageno());

			$datos['paginacion']['paginar'] = ($rs_comentarios->atfirstpage() &&
				($rs_comentarios->lastpageno() == $rs_comentarios->absolutepage())) ? "false" : "true";

			return $datos;
		}

		function getComentariosDes($_id_articulo) {
			$sql = "select count(*) from ".$this->tabla_comentarios." where id_articulo=$_id_articulo and habilitar= '0'";
			$rs_comentarios = $this->getConsulta($sql);
			$comentarios = array();

			
			return $rs_comentarios->fields["count(*)"];;
		}
		
		function getLista_Articulos_imagenes($_pagina_actual,$id_articulo) {
		$sql = 'select * from '.$this->tabla_imagenes.' where id_articulo= "'.$id_articulo.'"  order by titulo asc';
		$rs = $this->getConsulta($sql,false,$_pagina_actual);
		$imagen = array();

		while (!$rs->EOF) {
			$imagenes = array();
			$imagenes['titulo'] = $rs->fields['titulo'];
			$imagenes['id_imagen'] = $rs->fields['id_imagen'];
			$imagenes['ancho'] = $rs->fields['ancho'];
			$imagenes['alto'] = $rs->fields['alto'];
			$imagen[] = $imagenes;
			$rs->MoveNext();
		}

		$datos['imagenes'] = $imagen;
		$datos['paginacion'] = $this->getPaginado($rs->atfirstpage(),$rs->absolutepage(),
			$rs->atlastpage(),$rs->lastpageno());

		$datos['paginacion']['paginar'] = ($rs->atfirstpage() && ($rs->lastpageno() == $rs->absolutepage())) ? "false" : "true";


		
		return $datos;
	}
		
		function Agregar_Imagen_Articulo($_cmps,$adjunto,$tthumb) {
	
			$continuar = true;
			$sql = "select * from $this->tabla_imagenes where id_imagen = -1";
			$continuar = $this->setGuardar($sql,$_cmps);
	
			if ($continuar) {
				$id_imagen = $this->getInsertID();
				$fp = fopen($adjunto['tmp_name'], 'rb');
				$content = fread($fp, $adjunto['size']);
				fclose($fp);
				//$continuar = $this->db->UpdateBlob($this->tabla_imagenes,'foto',$content,"id_imagen=$id_imagen");
				$continuar = $this->db->UpdateBlob($this->tabla_imagenes,'foto',$tthumb,"id_imagen=$id_imagen");
				$continuar= true;
			}
			return $continuar;
		}
		
		function getDatos_imagen_art($id_imagen) {		
			$sql = 'select * from '.$this->tabla_imagenes.' where id_imagen='.$id_imagen;
			$rs = $this->getConsulta($sql);
			$imagen = array();
			
			$imagen["titulo"] = $rs->fields["titulo"];
			$imagen["id_imagen"] = $rs->fields["id_imagen"];
			$imagen["foto"] = $rs->fields["foto"];
			$imagen["nombre_imagen"] = $rs->fields["nombre_imagen"];
			$imagen["tipo_imagen"] = $rs->fields["tipo_imagen"];
			
			return $imagen;
		}
		
		function Eliminar_imagen_art($id_imagen) {
		$sql = "delete from {$this->tabla_imagenes} where id_imagen = $id_imagen";
		return $this->setEliminar($sql);
	}
			function getUltimoServicio(){
				$sql = "select id_articulo from {$this->tabla} order by id_articulo desc limit 1";
				$rs_servicio = $this->getConsulta($sql);
				
				return $rs_servicio->fields;
				
				}
	
	}
?>