<?php

	require("../../configuraciones/include_xajax.cfg.php");

	function setError(&$objResponse,$field,$titulo) {
		$objResponse->addAlert("Falto ingresar el campo $titulo");
		$objResponse->addScript("document.getElementById('$field').focus()");
		return false;
	}

	function setRevisarFormulario($f) {
		$objResponse = new xajaxResponse();
		$usuarios_modelo = new Usuarios_Modelo();
		$continuar = true;
	
		if ($f["nombres"]=="") $continuar = setError($objResponse,'nombres','Nombre');

		if ($f["nick"]=="" && $continuar) $continuar = setError($objResponse,'nick','Nick');
		if ($f["nick"] != $f["nick_old"] && $continuar) {
			if ($usuarios_modelo->getExisteUsuario($f["nick"])) {
				$objResponse->addAlert("Error en el ingreso del Nick\nYa existe un usuario con ese nick");
				$objResponse->addScript("document.getElementById('nick').focus()");
				$continuar = false;
			}
		}
		
		if($f["action"] !='usuarios_modificar'){
				if ($f["pass"]=="" && $continuar) $continuar = setError($objResponse,'pass','Password');	
					
			//	if ($f["pass_con"]=="" && $continuar) $continuar = setError($objResponse,'pass_con',' Confirmar Password');
//		
//				if ($f["pass"] != $f["pass_con"] && $continuar){
//					$objResponse->addAlert(utf8_decode("Los Password ingresados no son iguales"));
//					$objResponse->addScript("document.getElementById('pass_con').focus()");
//					$continuar = false;		
//			}	
			}	
		
		if ($f["email"]=="" && $continuar) $continuar = setError($objResponse,'email','E-mail');
		if ($continuar && !preg_match(
		'/^[^0-9][a-zA-Z0-9_]+([.][a-zA-Z0-9_]+)*[@][a-zA-Z0-9_]+([.][a-zA-Z0-9_]+)*[.][a-zA-Z]{2,4}$/',$f["email"])) {
			$objResponse->addAlert("Error en el ingreso del E-mail");
			$objResponse->addScript("document.getElementById('email').focus()");
			$continuar =false;
		}

		if (!$continuar) {
			$objResponse->addAssign("guardar","value","Guardar");
			$objResponse->addAssign("guardar","disabled",false);
		} else {
			$objResponse->addScript("document.usuarios.submit();");
		}

		return $objResponse;
	}

	$xajax = new xajax();
	$xajax->registerFunction("setRevisarFormulario");
	$xajax->processRequests();
?>