<?php
	require("../../configuraciones/include_xajax.cfg.php");

	function setError(&$objResponse,$field,$titulo) {
		$objResponse->addAlert("Falto ingresar el campo $titulo");
		$objResponse->addScript("document.getElementById('$field').focus()");
		return false;
	}

	function setCheckRecuperar($f) {
		$objResponse = new xajaxResponse();
		$usuarios_modelo = new Usuarios_Modelo();
        $contacto_modelo = new Contacto_Modelo();
		$continuar = true;

		if ($f["nick"]=="") $continuar = setError($objResponse,'nick','Usuario');

		if ($continuar) {
			$usuario = $usuarios_modelo->getUsuarioxNick($f['nick']);
			if (!$usuario['existe']) {
				$continuar = false;
				$objResponse->addAlert("Error en al recuperar password\nVerifique los datos ingresados");
				$objResponse->addScript("document.getElementById('nick').focus()");
				$objResponse->addScript("document.getElementById('nick').value=''");
			} else {
                $resultado_mail =   false;
                $recuperar_pass_string      =   $usuarios_modelo->getRandString(32);
                $cmps_mail['email']         =   $usuario['email'];
                $cmps_mail['recuperar_pass']=   "<a href=\""._BASE_WEB."index.php?action=recuperar_pass&id_usuario=".$usuario['id_usuario']."&rp=".$recuperar_pass_string."\">Cambiar Clave</a>";

                $cmps_usr['usuario']['id_usuario']      =    $usuario['id_usuario'];
                $cmps_usr['usuario']['recuperar_pass']  =    $recuperar_pass_string;
                $resultado_mod_usr          =   $usuarios_modelo->ModificarUsuario($cmps_usr);
                if ($resultado_mod_usr){
                        $resultado_mail  =   $contacto_modelo->setEnviarRecuperarPass($cmps_mail);
                } else {
                        $continuar  =   false;
                }
                if (!$resultado_mail){
                    $objResponse->addAlert("Error interno al recuperar password\nVuelva a intentarlo en otro momento");
                }
			}
		}

		if (!$continuar) {
			$objResponse->addAssign("aceptar","value","Aceptar");
			$objResponse->addAssign("aceptar","disabled",false);
		} else {
            $objResponse->addAlert("Recuperando clave de usuario. Un email ha sido enviado a su cuenta de correo.");
			$objResponse->addScript("document.recuperar.submit();");
		}

		return $objResponse->getXML();
	}

	$xajax = new xajax();
	$xajax->registerFunction("setCheckRecuperar");
	$xajax->processRequests();
?>