<?php
header("Content-Type: text/html; charset=iso-8859-1");
require("../../configuraciones/include_xajax.cfg.php");

function setError($field,$titulo) {
	global $objResponse;
	
	$objResponse->addAlert("Falta ingresar el campo $titulo");
	$objResponse->addScript("document.getElementById('$field').focus()");
	return false;
}

function RandomString($num=6){
	$voc = array (a,e,i,o,u); 
	$con = array (b,c,d,f,g,h,j,k,l,m,n,p,q,r,s,t,w,x,y,z);
	$psw = '';                // cadena que contendr el password.
	$vc  = mt_rand(0,1);    // define si empieza por vocal o consonante.
	for ($n=0; $n<$num; $n++){
		if ($vc==1){
				$vc=0;
				$psw .= $con[mt_rand(0,count($con)-1)];
		}
		$psw .= $voc[mt_rand(0,count($voc)-1)];
		$psw .= $con[mt_rand(0,count($con)-1)];
	}
	$psw = ereg_replace (q,qu,$psw);
	$psw = ereg_replace (quu,que,$psw);
	$psw = ereg_replace (yi,ya,$psw);
	$psw = ereg_replace (iy,ay,$psw);
	$psw = substr($psw,0,$num);
	return $psw;
}

function setOIRS($f) {
	global $objResponse;
	$continuar = true;
	
		
	if($continuar && $f["tipo_persona"]=="1"){
		
		if ($continuar && $f["rut_persona"]=="") 
		{
			$objResponse->addAlert("Falta ingresar el Rut");
			$objResponse->addScript("document.getElementById('rut_persona').focus()");
			$continuar =false;
		}
		
		if ($continuar && !eregi("^[[:digit:]]+[-][0-9kK]{1}$",$f['rut_persona'])){
			$continuar = false;
			$objResponse->addAlert('Formato de RUT incorrecto. Use slo nmeros, sin puntos. Ej: 9876543-k');
			$objResponse->addScript("document.getElementById('rut_persona').focus()");
		}
	
		if ($continuar){	
			list($rut_persona,$rut_dv_persona) = explode('-',$f["rut_persona"]);
			$rut_persona = "$rut_persona";	
			
			$f["rut_persona"]=strtoupper(ereg_replace('\.|,|-','',$f["rut_persona"]));
			$sub_rut=substr($f["rut_persona"],0,strlen($f["rut_persona"])-1);
			$sub_dv=substr($f["rut_persona"],-1);
			$x=2;
			$s=0;
			for ( $i=strlen($sub_rut)-1;$i>=0;$i-- )
			{
				if ( $x >7 )
				{
					$x=2;
				}
				$s += $sub_rut[$i]*$x;
				$x++;
			}
			$dv=11-($s%11);
			if ( $dv==10 )
			{
				$dv='K';
			}
			if ( $dv==11 )
			{
				$dv='0';
			}
			if ( $dv==$sub_dv )
			{
				$continuar = true;
			}
			else
			{
				$continuar = false;
			}
		
			if ($continuar == false)
			{
				$objResponse->addAlert('Error en el ingreso del rut');
				$objResponse->addScript("document.getElementById('rut_persona').focus()");
			}
		}
		
		if ($continuar && $f["nombre_persona"]=="") $continuar = setError('nombre_persona','Nombre Persona Jurdica');
		if ($continuar && $f["representante"]=="") $continuar = setError('representante','Representante Legal');	
		if ($continuar && $f["direccion_persona"]=="") $continuar = setError('direccion_persona','Direccin Persona Jurdica');		

	}
	
	//validacion mensaje
	
	if ($continuar && $f["asunto"]=="") $continuar = setError('asunto','Asunto');	
	if ($continuar && $f["mensaje"]=="") $continuar = setError('mensaje','Mensaje');
	
	if (!$continuar) {
		$objResponse->addAssign("enviar","value","Enviar");
		$objResponse->addAssign("enviar","disabled",false);
	} else {
		$objResponse->addScript("document.frm_oirs.submit()");
	}
	return $objResponse;
}

function setRevisarFormulario($f) {
	global $objResponse;
	$continuar = true;

	if ($f["oirs"]=="") $continuar = setError('oirs','OIRS');
	if ($continuar && !is_numeric($f["oirs"])) {
		$objResponse->addAlert("Error en el ingreso del OIRS");
		$objResponse->addScript("document.getElementById('oirs').focus()");
		$continuar = false;
	}
	if ($continuar && $f["c"]=="") $continuar = setError('c','Cdigo de Validacin:');

	if ($continuar) {
		$oirs_modelo = new OIRS_Modelo();
		$oirs = $oirs_modelo->getOIRS($f["oirs"],$f["c"]);
		
		if (empty($oirs['id_oirs'])) {
			$objResponse->addAlert("Error en el ingreso del OIRS o Cdigo de Validacin");
			$continuar = false;
		}
	}

	if (!$continuar) {
		$objResponse->addAssign("buscar_oirs","value","Enviar");
		$objResponse->addAssign("buscar_oirs","disabled",false);
	} else {
		$objResponse->addScript("document.frm_oirs.submit()");
	}
	
	return $objResponse;
}

function setRecuperarOIRS($f) {
	global $objResponse;
	$continuar = true;
	

	if ($continuar && $f["id_ciudadano"]=="") {
		$objResponse->addAlert("Falta ingresar el ID Ciudadano");
		$objResponse->addScript("document.getElementById('id_ciudadano').focus()");
		$continuar =false;
	}
	
	if ($continuar && $f["email"]=="") $continuar = setError('email','Email');

	if ($continuar && !preg_match(
	'/^[^0-9][a-zA-Z0-9_]+([.][a-zA-Z0-9_]+)*[@][a-zA-Z0-9_]+([.][a-zA-Z0-9_]+)*[.][a-zA-Z]{2,4}$/',$f["email"])) {
		$objResponse->addAlert("Error en el ingreso del E-mail");
		$objResponse->addScript("document.getElementById('email').focus()");
		$continuar =false;
	}
	
	if ($continuar && $f['email'] != $f['email_c']) {
		$objResponse->addAlert("Error en el reingreso del Email");
		$objResponse->addScript("document.getElementById('email_c').focus()");
		$continuar = false;
	}
	
	if ($continuar) {
		$oirs_modelo = new OIRS_Modelo();
		$contacto_modelo = new Contacto_Modelo();
		$usuario = $oirs_modelo->getUsuarioxemail($f["id_ciudadano"],$f["email"]);
		if (!$usuario['existe']) {
			$continuar = false;
			$objResponse->addAlert("No existe un usuario con los datos ingresados");
			$objResponse->addScript("document.getElementById('pass').focus()");
			$objResponse->addScript("document.getElementById('pass').value=''");
		} else {			
		  if($contacto_modelo->setRecuperar($usuario)){
			  $objResponse->addAlert("La contrasea ya fue despachada al correo ingresado");
			  $objResponse->addScript("document.frm_oirs.submit()");
		  } else {
		 	 $objResponse->addAlert("Ocurri un error mientras se enviaban los datos.");
			 $continuar = false;
		  }
		}
	}

	if (!$continuar) {
		$objResponse->addAssign("enviar","value","Enviar");
		$objResponse->addAssign("enviar","disabled",false);
	} 
		
	return $objResponse;
}

$objResponse = new xajaxResponse();

$xajax = new xajax();
$xajax->registerFunction("setRevisarFormulario");
$xajax->registerFunction("setOIRS");
$xajax->registerFunction("setRecuperarOIRS");
$xajax->processRequests();

?>