<?php
require("../../configuraciones/include_xajax.cfg.php");

function setError($field,$titulo) {
	global $objResponse;
	$objResponse->addAlert(utf8_encode("Falto ingresar el campo $titulo"));
	$objResponse->addScript("document.getElementById('$field').focus()");
	return false;
}

function setRevisarFormulario($f) {
	global $objResponse;
	$continuar = true;
	
	if($f["nota_envio"]=="on"){
		if ($f["nota_ciudadano"]=="") $continuar = setError('nota_ciudadano','Nota Ciudadano');

	}
	
	//if ($f["nota_interna"]=="" && $continuar) $continuar = setError('nota_interna','Nota Interna');
	
	
	if (is_array($f["adjunto"]) || is_object($f["adjunto"])){
		foreach ($f["adjunto"] as $key => $value) {
			$doc_array = explode("/",$value);

			$doc_name = $doc_array[count($doc_array) - 1];

			if ($doc_name !="") {
				//$continuar = false;
				//$objResponse->addAlert("Seleccione un documento");
			//} else {
				$ext = strtolower(substr($doc_name,-3));

				if ($ext != 'doc' && $ext != 'xls' && $ext != 'pdf' && $ext != 'txt' && $ext != 'jpg'  && $ext != 'png' && $ext != 'gif' && $ext != 'zip' ) {
					$continuar = false;
					$objResponse->addAlert("Seleccione un documento con extensión JPG, PNG, GIF, DOC, XLS, PDF, ZIP ó TXT");
				} else {
					if (file_exists($path.$f['id_oirs'].'_'.$doc_name)) {
						$continuar = false;
						$objResponse->addAlert(utf8_encode("Ya existe un documento con el nombre de '$doc_name'"));
					}
				}
			}
		}
	}
	
	if ($f["fecha_estado"]=="" && $continuar) $continuar = setError('fecha_estado','Fecha');

	if ($f['estado'] == 'DE' && $f['organos'] == $_SESSION['usuario']['id_organo']) {
		$continuar = false;
		$objResponse->addAlert("No puede derivar una solicitud a su propia unidad");
	}

	if (!$continuar) {
		$objResponse->addAssign("guardar","value","Guardar");
		$objResponse->addAssign("guardar","disabled",false);
	} else {
		$objResponse->addScript("document.oirs.submit();");
	}

	return $objResponse;
}

function setArchivar($id_oirs) {
	global $objResponse;
	
	$cmps = array();
	$cmps['id_oirs'] = $id_oirs;
	$cmps['id_estado'] = 4;
	
	$oirs_modelo = new OIRS_Modelo();
	$oirs_modelo->setOIRSModificar($cmps);
	$objResponse->addScript('location.href="index.php?action=oirs_mantenedor"');

	return $objResponse;
}

function setActivar($id_oirs) {
	global $objResponse;
	
	$cmps = array();
	$cmps['id_oirs'] = $id_oirs;
	$cmps['archivado'] = 0;
	
	$oirs_modelo = new OIRS_Modelo();
	$oirs_modelo->setOIRSModificar($cmps);
	$objResponse->addScript('location.href="index.php?action=oirs_mantenedor"');

	return $objResponse;
}

function setBuscar($f) {
	global $objResponse;
	$continuar = true;

	$buscar_texto = trim($f["buscar_texto"]);

	/*if ($buscar_texto=="" && empty($f['desde']) && empty($f['hasta'])) {
		$continuar = false;
		setError('buscar_texto','Criterio de B�squeda');
	}*/

	if (empty($f['desde'])&&!empty($f['hasta'])) {
		$continuar = false;
		$objResponse->addAlert("Ingrese fecha Desde");
	}

	if (!empty($f['desde'])&&empty($f['hasta'])) {
		$continuar = false;
		$objResponse->addAlert("Ingrese fecha Hasta");
	}

	if ($continuar && (!empty($f['desde'])&&!empty($f['hasta']))) {
		list($dd_d,$mm_d,$aa_d) = explode('/',$f['desde']);
		list($dd_h,$mm_h,$aa_h) = explode('/',$f['hasta']);

		if ((mktime(0,0,0,$mm_d,$dd_d,$aa_h) - mktime(0,0,0, $mm_h,$dd_h,$aa_h))>0) {
			$objResponse->addAlert("Rango de fechas incorrectas");
			$continuar = false;
		}
	}
	
	if ($continuar) {
			$oirs_modelo = new OIRS_Modelo();			
			$admin = $oirs_modelo->getAdminOrganismo($_SESSION['usuario']['id_usuario']);				
				if($admin['existe']) {
					//$objResponse->addAlert("Usuario existe en la bd");	
					$continuar = true;					
				}else{
					$continuar = false;				
			}
		
		}	
	/*if ($continuar) {
			$oirs_modelo = new OIRS_Modelo();			
			$admin = $oirs_modelo->getAdminOrganismo($_SESSION['usuario']['id_usuario']);				
				if(!$admin['existe']) {
					$objResponse->addAlert("Usuario no existe en la bd");	
					$continuar = false;					
				}
				
			}*/	

	if ($continuar) {
		$objResponse->addScript("document.frm_buscar.submit();");
	} else {
		$objResponse->addAssign("buscar","value","Buscar");
		$objResponse->addAssign("buscar","disabled",false);
	}

	return $objResponse;
}

$xajax = new xajax();
$objResponse = new xajaxResponse();
$xajax->registerFunction("setRevisarFormulario");
$xajax->registerFunction("setArchivar");
$xajax->registerFunction("setActivar");
$xajax->registerFunction("setBuscar");
$xajax->processRequests();
?>