<?php
	require("../../configuraciones/include_xajax.cfg.php");

	function setError(&$objResponse,$field,$titulo) {
		$objResponse->addAlert("Falto ingresar el campo $titulo");
		$objResponse->addScript("document.getElementById('$field').focus()");
		return false;
	}

	function setCheckPass($f) {
		$objResponse = new xajaxResponse();
		$usuarios_modelo = new Usuarios_Modelo();
		$continuar = true;
        
		if ($f["nick"]=="") $continuar = setError($objResponse,'nick','Usuario');
		if ($f["pass"]=="" && $continuar) $continuar = setError($objResponse,'pass','Contraseña');

		if ($continuar) {
			$usuario = $usuarios_modelo->getLogin($f['nick'],$f['pass']);

			if (!$usuario['existe']) {
				$continuar = false;
				$objResponse->addAlert("Error en al iniciar sesión\nVerifique los datos ingresados");
				$objResponse->addScript("document.getElementById('pass').focus()");
				$objResponse->addScript("document.getElementById('pass').value=''");
			} else {
				$_SESSION['usuario']['id_usuario'] = $usuario['id_usuario'];
				$_SESSION['usuario']['nick'] = $usuario['nick'];
				$_SESSION['usuario']['tipo'] = $usuario['tipo'];
				$_SESSION['usuario']['nombre'] = $usuario['nombre'];
				$_SESSION['usuario']['id_organo'] = $usuario['id_organo'];
			}
		}

		if (!$continuar) {
			$objResponse->addAssign("aceptar","value","Aceptar");
			$objResponse->addAssign("aceptar","disabled",false);
		} else {
			$objResponse->addScript("document.login.submit();");
		}

		return $objResponse->getXML();
	}

	$xajax = new xajax();
	$xajax->registerFunction("setCheckPass");
	$xajax->processRequests();
?>