<?php
require("../../configuraciones/include_xajax.cfg.php");

function setError($field,$titulo) {
	global $objResponse;
	$objResponse->addAlert(utf8_encode("Falta ingresar el campo $titulo"));
	$objResponse->addScript("document.getElementById('$field').focus()");
	return false;
}

function setRevisarFormulario($f) {
	global $objResponse;
	$continuar = true;

	if($continuar && $f["numero_solicitud"] == "") $continuar = setError('numero_solicitud','Numero de papel');

	if($continuar && $f["fecha_solicitud"] == "") $continuar = setError('fecha_solicitud','Fecha ingreso solicitud');

	if ($continuar && $f['numero_solicitud'] != "" && !is_numeric($f['numero_solicitud'])) {
		$objResponse->addAlert(utf8_encode("Error en número de papel, favor ingresar solo números en el campo de texto"));
		$objResponse->addScript("document.getElementById('numero_solicitud').focus()");
		$continuar = false;
	}

	$oirs_modelo = new OIRS_Modelo();

	if ($continuar && $f['numero_solicitud'] != "" && $oirs_modelo->existe_numero_papel($f['numero_solicitud'])) {
		$objResponse->addAlert(utf8_encode("Ya existe ese n�mero de papel, intente con otro por favor"));
		$objResponse->addScript("document.getElementById('numero_solicitud').focus()");
		$continuar = false;
	}

	$datetime = explode(" ", $f["fecha_solicitud"]);
	$date = explode("/",$datetime[0]);

	if ($continuar && $f["fecha_solicitud"] != "" && !checkdate($date[1], $date[0], $date[2])) {
		 $objResponse->addAlert(utf8_encode("Problemas con el ingreso de la fecha, verifique por favor y vuelva a intentarlo"));
		 $objResponse->addScript("document.getElementById('fecha_solicitud').focus()");
		 $continuar = false;
	}

	if (!$continuar) {
		$objResponse->addAssign("registrar","value",$f["value_btn"]);
		$objResponse->addAssign("registrar","disabled",false);
	} else {
		$objResponse->addScript("document.frm_solicitud.submit()");
	}

	return $objResponse;
}


$objResponse = new xajaxResponse();

$xajax = new xajax();
$xajax->registerFunction("setRevisarFormulario");
$xajax->processRequests();

?>
