<?php

	require("../../configuraciones/include_xajax.cfg.php");

	function setError(&$objResponse,$field,$titulo) {
		$objResponse->addAlert("Falto ingresar el campo $titulo");
		$objResponse->addScript("document.getElementById('$field').focus()");
		return false;
	}

	function setRevisarFormulario($f) {
		$objResponse = new xajaxResponse();
		$continuar = true;

		if ($f["nombre"]=="") $continuar = setError($objResponse,'nombre','Nombre');

		if (!$continuar) {
			$objResponse->addAssign("guardar","value","Guardar");
			$objResponse->addAssign("guardar","disabled",false);
		} else {
			$objResponse->addScript("document.galeria.submit();");
		}

		return $objResponse;
	}
	
	function setRevisarFormularioImagen($f) {
		$objResponse = new xajaxResponse();
		$continuar = true;
		//if ($f["imagen"]=="") $continuar = setError($objResponse,'imagen','Imagen');
		$ext = explode(".",$f["imagen"]);
		$ext = strtolower($ext[1]);
		
		if($f["imagen"]!= "" && $ext != "jpg" && $ext != "gif" && $ext != "png" && $ext != "bmp"){
			$objResponse->addAlert("El archivo debe ser en formato jpg, png, gif o bmp");
			$continuar = false;
		}

		if ($f["url"]=="") $continuar = setError($objResponse,'url','URL');

		if (!$continuar) {
			$objResponse->addAssign("guardar","value","Guardar");
			$objResponse->addAssign("guardar","disabled",false);
		} else {
			$objResponse->addScript("document.imagen.submit();");
		}
		
		//print_r($objResponse); die();

		return $objResponse;
	}
	
	function setRevisarFormularioImagenAgregar($f) {
		$objResponse = new xajaxResponse();
		$continuar = true;
		
		if ($f["imagen"]=="") $continuar = setError($objResponse,'imagen','Imagen');	

		$ext = explode(".",$f["imagen"]);
		$ext = strtolower($ext[1]);
		
		if($ext != "jpg" && $ext != "gif" && $ext != "png" && $ext != "bmp"){
			$objResponse->addAlert("El archivo debe ser en formato jpg, png, gif o bmp");
			$continuar = false;
		}


		if ($f["url"]=="") $continuar = setError($objResponse,'url','URL');
		if ($f["publicado"]=="") $continuar = setError($objResponse,'publicado','Publicacion');
		
		if (!$continuar) {
			$objResponse->addAssign("guardar","value","Guardar");
			$objResponse->addAssign("guardar","disabled",false);
		} else {
			$objResponse->addScript("document.imagen_agregar.submit();");
		}
		return $objResponse;
	}

	$xajax = new xajax();
	$xajax->registerFunction("setRevisarFormulario");
	$xajax->registerFunction("setRevisarFormularioImagen");
	$xajax->registerFunction("setRevisarFormularioImagenAgregar");
	$xajax->processRequests();
?>