<?php
require("../../configuraciones/include_xajax.cfg.php");

function setError($field,$titulo) {
	global $objResponse;
	$objResponse->addAlert("Falto ingresar el campo $titulo");
	$objResponse->addScript("document.getElementById('$field').focus()");
	return false;
}

function setRevisarFormulario($f) {
	global $objResponse;
	$continuar = true;
	$funcionarios_modelo = new Funcionarios_Modelo();	
	
	if($continuar && $f["action"]=="funcionarios_agregar"){
		
		if ($continuar && $f["rut"]=="") $continuar = setError('rut','Rut');
		
		if ($continuar && !eregi("^[[:digit:]]+[-][0-9kK]{1}$",$f['rut'])){
			$continuar = false;
			$objResponse->addAlert('Formato de RUT incorrecto. Use slo nmeros, sin puntos. Ej: 9876543-k');
			$objResponse->addScript("document.getElementById('rut').focus()");
		}
	
		if ($continuar){	
			list($rut,$rut_dv) = explode('-',$f["rut"]);
			$rut = "$rut";	
			
			$f["rut"]=strtoupper(ereg_replace('\.|,|-','',$f["rut"]));
			$sub_rut=substr($f["rut"],0,strlen($f["rut"])-1);
			$sub_dv=substr($f["rut"],-1);
			$x=2;
			$s=0;
			for ( $i=strlen($sub_rut)-1;$i>=0;$i-- )
			{
				if ( $x >7 )
				{
					$x=2;
				}
				$s += $sub_rut[$i]*$x;
				$x++;
			}
			$dv=11-($s%11);
			if ( $dv==10 )
			{
				$dv='K';
			}
			if ( $dv==11 )
			{
				$dv='0';
			}
			if ( $dv==$sub_dv )
			{
				$continuar = true;
			}
			else
			{
				$continuar = false;
			}
		
			if ($continuar == false)
			{
				$objResponse->addAlert(utf8_encode('Error en el ingreso del rut'));
				$objResponse->addScript("document.getElementById('rut').focus()");
			}
		}	
	
	
		if ($continuar && $f["rut"]!="") {
			$funcionario = $funcionarios_modelo->getFuncionario($rut);
	
			if ($continuar && $funcionario['existe'] ){
				$continuar = false;
				$objResponse->addAlert("El rut ingresado ya est asociado a un Funcionario");
				$objResponse->addScript("document.getElementById('rut').focus()");
			}
		}		
	
	}
	
	if ($continuar && $f["nombres"]=="") $continuar = setError('nombres','Nombres');	
	if ($continuar && $f["apellidos"]=="") $continuar = setError('apellidos','Apellidos');		
	
	if ($f["email"]=="" && $continuar){
		$objResponse->addAlert("Falta ingresar el E-mail");
		$objResponse->addScript("document.getElementById('email').focus()");
		$continuar =false;
	}
	
	if ($continuar && !preg_match(
	'/^[^0-9][a-zA-Z0-9_]+([.][a-zA-Z0-9_]+)*[@][a-zA-Z0-9_]+([.][a-zA-Z0-9_]+)*[.][a-zA-Z]{2,4}$/',$f["email"])) {
	$objResponse->addAlert("Error en el ingreso del E-mail");
		$objResponse->addScript("document.getElementById('email').focus()");
		$continuar =false;
	}

	
	if($continuar && $f["action"]=="funcionarios_agregar"){

		$a_img = explode("/",$f["foto"]);
		$img_name = $a_img[count($a_img) - 1];
	
		if ($continuar && $img_name == "") {
			$continuar = false;
			$objResponse->addAlert("Seleccione una imagen para el perfil");
		}	
		
	}

	if (!$continuar) {
		$objResponse->addAssign("guardar","value","Guardar");
		$objResponse->addAssign("guardar","disabled",false);
		$objResponse->addScript("document.getElementById('nombre').focus()");		
	} else {
		$objResponse->addScript("document.funcionarios.submit();");
	}

	return $objResponse;
}


function setRevisarFormularioAsignarCargo($f) {
        global $objResponse;
        $continuar = true;
        if (!$continuar) {
                $objResponse->addAssign("guardar","value","Guardar");
                $objResponse->addAssign("guardar","disabled",false);
                $objResponse->addScript("document.getElementById('nombre').focus()");
        } else {
                $objResponse->addScript("document.funcionarios.submit();");
        }

        return $objResponse;
}

function setRevisarFormularioAsignarResolucion($f) {
        global $objResponse;
        $continuar = true;
        if (!$continuar) {
                $objResponse->addAssign("guardar","value","Guardar");
                $objResponse->addAssign("guardar","disabled",false);
                $objResponse->addScript("document.getElementById('nombre').focus()");
        } else {
                $objResponse->addScript("document.funcionarios.submit();");
        }

        return $objResponse;
}


$xajax = new xajax();
$objResponse = new xajaxResponse();
$xajax->registerFunction("setRevisarFormulario");
$xajax->registerFunction("setRevisarFormularioAsignarCargo");
$xajax->registerFunction("setRevisarFormularioAsignarResolucion");
$xajax->processRequests();
?>
