<?php
	class SolicitudAgregar_Action extends Action {
		function perform($actionMapping,$actionForm) {
			
			if (!is_object($actionForm)) {
				$actionForward = null;
				$index_vista = new Index_Vista();
				$oirs_modelo = new OIRS_Modelo();				
				
				if(isset($_REQUEST['id_ciudadano'])){
					$datos_usuario = $oirs_modelo->getUsuario($_REQUEST['id_ciudadano']);
					$index_vista->setSolicitud_agregar($datos_usuario);
				}else{						
					header("Location: index.php?action=oirs");				
				}
			} else {
				$oirs_modelo = new OIRS_Modelo();
				$feriados_modelo = new Feriado_Modelo();				
				$cmps = array();
						
				$cmps['id_ciudadano'] = $_POST['id_ciudadano'];
				$cmps['id_solicitante'] = $_POST['id_solicitante'];
				$cmps['id_tipo'] = 5;
				$cmps['id_organo_ciu'] = $_POST['dep_ciu'];
				$cmps['nombre_dep_ciu'] = $oirs_modelo->getDepsCiuNombre($_POST['dep_ciu']);
				$cmps['fecha'] = date('Y-m-d H:i:s');
				$cmps['mensaje'] = htmlentities($_POST['mensaje'],ENT_COMPAT,'ISO-8859-1');
				$cmps['observaciones'] = htmlentities($_POST['observaciones'],ENT_COMPAT,'ISO-8859-1') === "" ? NULL : htmlentities($_POST['observaciones'],ENT_COMPAT,'ISO-8859-1');
				$cmps['formato_entrega'] = $_POST['formatoentrega'];

				if($_POST["formatoentrega"] == 5 ){
					$cmps['otro_formato'] = htmlentities($_POST["otroformato"],ENT_COMPAT,'ISO-8859-1');
				}
				$cmps['tipo_respuesta'] = $_POST['formarespuesta'];									
				$cmps['tramitado'] = 0;
				$cmps['id_estado'] = 'EP';

				if($_POST['formarespuesta'] == 1){
					$cmps['email_oirs'] = $_POST['email'];
					$cmps['envio_email'] = 1;
				}

				if($_POST['formarespuesta'] == 2){
					$cmps['region_oirs'] = $_POST['region'];
					$cmps['comuna_oirs'] = $_POST['comuna'];
					$cmps['direccion_oirs'] = $_POST['direccion'];
					$cmps['localidad_oirs'] = $_POST['localidad'];
				}

				do{
					$a = uniqid();
					$code = substr($a, 9);
					//echo $a;

				}while($oirs_modelo->existeCodigo($code));

				$cmps['cod_solicitud'] = $code;

				$tipo = $oirs_modelo->getTiposOIRSxId($cmps['id_tipo']);
				$cmps["solicitud_informacion"] = $tipo["solicitud_informacion"];					
				$fecha = $feriados_modelo->fechaValida($cmps['fecha'], $tipo["plazo"]);	
				$cmps['fecha_maxima_respuesta'] = $fecha;
				$oirs_modelo = new OIRS_Modelo();	

				//$contacto_pasiva_modelo = new Contacto_Pasiva_Modelo();
				$oirs_modelo->Start();	
				$ok = true;
				
				if ($oirs_modelo->setAgregarOIRS($cmps)) {
					$id_oirs = $oirs_modelo->setInsertID();
					
					$cmp_historial['id_estado'] = 'EP';
					$cmp_historial['id_oirs'] = $id_oirs;
					$cmp_historial['id_organo'] = 1;
					$cmp_historial['fecha'] = date('Y-m-d H:i:s');
					
					if($ok){
						if(!$oirs_modelo->setAgregarHistorial($cmp_historial)){
							$oirs_modelo->FailTrans();
							$ok = false;
						}

						if (isset($_FILES['adjunto'])) {
						$tot = count($_FILES['adjunto']["name"]);
						$adjuntos = $_FILES['adjunto']["name"];
						
						$count = 0;
						foreach($adjuntos as $x){
						$adjuntos_visibles[$count] = 0;
						$count ++;
						}					
				for ($i = 0; $i < $tot; $i++){										
					$cmps_adjunto = array();
					$cmps_adjunto['id_oirs'] = $id_oirs;
					//$cmps['id_organo'] = $_POST['organos'];
					$cmps_adjunto['id_organo'] = 1;
					$cmps_adjunto['fecha_hora'] = date("Y-m-d H:m:s");
					$idhistorial = $oirs_modelo->getIDHistorial();
				    $cmps_adjunto['id_historial'] = $idhistorial;					
					$fp = fopen($_FILES['adjunto']['tmp_name'][$i], 'rb');
					$content = fread($fp, $_FILES['adjunto']['size'][$i]);
					fclose($fp);
																	
					$cmps_adjunto['adjunto'] = $content;
					$cmps_adjunto['nombre'] = $_FILES['adjunto']['name'][$i];
					$cmps_adjunto['tipo'] = $_FILES['adjunto']['type'][$i];
				
					foreach($_POST['publico'] as $y){
						$adjuntos_visibles[$y] = 1;
											
				
					if($adjuntos_visibles[$i] == "1"){ 
							$cmps_adjunto["publico"] = '1';	
						}else{
							$cmps_adjunto["publico"] = '0';	
						}
					}				
					
					$oirs_modelo->AgregarAdjunto($cmps_adjunto);

					}
				}											
					}
					
					$funcionario = $oirs_modelo->getFuncionario(1);

					$datos_ciudadano = $oirs_modelo->getUsuario($cmps["id_ciudadano"]);
					
					// if($cmps['envio_email'] == 1 && $cmps['email_oirs'] != ""){
					// 	$contacto_pasiva_modelo->setEnviarSolicitudPasiva($cmps,$id_oirs,$funcionario,$datos_ciudadano);
					// }

					$ok = true;
				} else {
					$ok = false;
					$oirs_modelo->FailTrans();								
				}
				
				$oirs_modelo->End();
					
				if($ok){	
					$actionForward = $actionMapping->get("mantenedor");										
				} else {
					$actionForward = $actionMapping->get("formulario");
				}
			}

			return $actionForward;
		}
	}
?>