<?php
class OIRS_Correccion_Action extends Action {
	function perform($actionMapping,$actionForm) {

		$oirs_vista = new OIRS_Vista();
		$oirs_modelo = new  OIRS_Modelo();
		$contacto_modelo = new Contacto_Modelo();
		$feriado_modelo = new Feriado_Modelo();

		if (!is_object($actionForm)) {
			$actionForward = null;
			$oirs = $oirs_modelo->getDatos_oirs($_REQUEST['id_oirs']);
			$ciudadano = $oirs_modelo->getCiudadano($_REQUEST['id_ciudadano']);

			if ($oirs["id_estado"] == "RE" || $oirs["id_estado"] == "EP") {
				$unidad_actual = "Oficina Central";
			}else{
				$unidad_actual = $oirs["derivado_de"][0]["nombre"];
			}

			$oirs_vista->setCorreccion($ciudadano,$oirs,$unidad_actual);
		} else {

				$cmps_oirs['id_oirs'] = $_POST['id_oirs'];
				$cmps_oirs['id_estado'] = 'EC';

				$cmps['id_oirs'] = $_POST['id_oirs'];
				$cmps['id_estado'] = 'EC';
				$cmps['id_organo'] = '1';
				$cmps['nota_al_ciudadano'] = htmlentities($_POST['nota_ciudadano'],ENT_COMPAT,'ISO-8859-1');
				$cmps['nota_interna'] = htmlentities($_POST['nota_interna'],ENT_COMPAT,'ISO-8859-1');
				$cmps['fecha'] = date('Y-m-d H:i:s');

				$datos = $oirs_modelo->getCiudadano($_POST['id_ciudadano']);
				$datos_oirs = $oirs_modelo->getDatos_oirs($_POST['id_oirs']);

				$cmps['tipo'] = $datos_oirs['id_tipo'];

				do {
					$b = uniqid();
					$subsanar = substr($b, 0);
				} while ($oirs_modelo->existeCodigoSubsanacion($subsanar));

				$cmps_oirs['subsanar_no_registro'] = $subsanar;

				if($datos_oirs['fecha_modificar'] == ""){
					$fecha = $feriado_modelo->fechaValida($cmps['fecha'],_DIAS_M);
					$cmps_oirs['fecha_modificar'] = $fecha;
				}else{
					$cmps_oirs['fecha_modificar'] = $datos_oirs["fecha_modificar"];
				}

				$cmps_oirs['cod_solicitud'] = $datos_oirs["cod_solicitud"];

				if ($oirs_modelo->setAgregar_Historial($cmps)){
					if (isset($_FILES['adjunto'])) {
						$tot = count($_FILES['adjunto']["name"]);
						$adjuntos = $_FILES['adjunto']["name"];

						$count = 0;
						foreach($adjuntos as $x){
						$adjuntos_visibles[$count] = 0;
						$count ++;
						}
				for ($i = 0; $i < $tot; $i++){
					$cmps_adjunto = array();
					$cmps_adjunto['id_oirs'] = $_POST['id_oirs'];
					//$cmps['id_organo'] = $_POST['organos'];
					$cmps_adjunto['id_organo'] = '1';
					$cmps_adjunto['fecha_hora'] = date("Y-m-d H:m:s");
					$idhistorial = $oirs_modelo->getIDHistorial();
				    $cmps_adjunto['id_historial'] = $idhistorial;
					$fp = fopen($_FILES['adjunto']['tmp_name'][$i], 'rb');
					$content = fread($fp, $_FILES['adjunto']['size'][$i]);
					fclose($fp);

					$cmps_adjunto['adjunto'] = $content;
					$cmps_adjunto['nombre'] = $_FILES['adjunto']['name'][$i];
					$cmps_adjunto['tipo'] = $_FILES['adjunto']['type'][$i];
					$cmps_adjunto["publico"] = $_POST['publico-'.($i+1)];

					$oirs_modelo->AgregarAdjunto($cmps_adjunto);

					}
				}
					if($oirs_modelo->setModificar_Oirs($cmps_oirs))
						if($datos_oirs['envio_email'] == "1"){
							$contacto_modelo->setCorreccion($cmps,$datos,$datos_oirs,$cmps_oirs);
						}
					$actionForward = $actionMapping->get('mantenedor');
				}else{
					$actionForward = $actionMapping->get('formulario');
					$actionForward->setAttribute('id_oirs',$_POST['id_oirs']);
					$actionForward->setAttribute('id_ciudadano',$_POST['id_ciudadano']);
				}
		}
		return $actionForward;
	}
}
?>
