<?php
/**
 * The ActionMapping class represents the information that the ActionController
 * knows about the ActionMapping of a particular request to an instance of a
 * particular Action class. The ActionMapping is passed to the perform() method
 * of the Action class itself, enabling access to this information directly.
 *
 * An ActionMapping has the following minimal set of properties. Additional
 * properties can be provided as needed by subclasses.
 * <ul>
 * <li><b>type</b> - Class name of the Action class used by this ActionMapping.
 * </li>
 * <li><b>name</b> - Name of the ActionForm class, if any, associated with this
 * Action.</li>
 * <li><b>input</b> - Path of the input form to which control should be
 * returned if a validation error is encountered.</li>
 * <li><b>validate</b> - Set to 1 if the validate() method of the ActionForm
 * class (if any) associated with this ActionMapping should be called. [0]</li>
 * </ul>
 *
 * @author	Arnold Cano
 * @version	$Id: ActionMapping.php,v 1.1.1.1 2002/11/19 16:46:54 arcano Exp $
 * @package	Phrame  
 */
class ActionMapping extends HashMap
{
	/**
	 * @var	string
	 */
	var $_type;
	/**
	 * @var	string
	 */
	var $_name;
	/**
	 * @var	string
	 */
	var $_input;
	/**
	 * @var	string
	 */
	var $_validate = 0;
	/**
	 * @var	string
	 */
	var $_unknown;
	/**
	 * @var	string
	 */
	var $_scope;
	/**
	 * @var array
	 */
	var $_roleNames;

	/**
	 * Create a ActionMapping with the specified values.
	 *
	 * @access	public
	 * @param	array	$mapping
	 */
	function ActionMapping(&$mapping)
	{
		$this->setType($mapping[_TYPE]);
		$this->setName($mapping[_NAME]);
		if (isset($mapping[_INPUT]))
			$this->setInput($mapping[_INPUT]);
		$this->setValidate(isset($mapping[_VALIDATE])?$mapping[_VALIDATE]:true);
		if (isset($mapping[_SCOPE]))
			$this->setScope($mapping[_SCOPE]);
		if (isset($mapping[_UNKNOWN]))
			$this->setUnknown($mapping[_UNKNOWN]);
		if (isset($mapping[_SECURITY_ROLES]))
			$this->setRoles($mapping[_SECURITY_ROLES]);
		if (isset($mapping[_FORWARD]))
			$this->setForward($mapping[_FORWARD]);
		if (is_array($mapping[_ACTION_FORWARDS])) {
			$this->_initActionForwards($mapping[_ACTION_FORWARDS]);
		}
	}
	/**
	 * Finds what to forward to
	 */
	function &findForward($name)
	{
		return $this->get($name);
	}
	/**
	 * Initialize the ActionForwards array associated with this
	 * ActionMapping.
	 *
	 * @access	private
	 * @param	array	$forwards
	 */
	function _initActionForwards(&$forwards)
	{
		foreach ($forwards as $name => $forward) {
			$actionForward = new ActionForward($name, $forward);
			$this->put($name, $actionForward);
		}
	}

	/**
	 * Set the role-names for this action. $role should be a comma
	 * separated list of rolenames.
	 * @access	public
	 * @param	string	$roles
	 */
	function setRoles($roles)
	{
		$roles = str_replace(" ", "", $roles); // stip spaces
		$this->_roleNames = explode(",", $roles);
	}

	/**
	 * Get the role-names for this action. Returns a comma
	 * separated list of rolenames.
	 * @access	public
	 * @return	string
	 */
	function getRoles()
	{
		if (isset($this->_roleNames))
			return join(",", $this->_roleNames);
		else
			return "";
	}

	/**
	 * Get the role-names for this action. Returns array with rolesnames.
	 * @access	public
	 * @return	array
	 */
	function getRoleNames()
	{
		return $this->_roleNames;
	}

	/**
	 * Get the type of the ActionForward.
	 *
	 * @access	public
	 * @return	string
	 */
	function getType()
	{
		return $this->_type;
	}
	/**
	 * Set the type of the ActionForward.
	 *
	 * @access	public
	 * @param	string	$type
	 */
	function setType($type)
	{
		$this->_type = $type;
	}
	/**
	 * Get the name of the ActionForward.
	 *
	 * @access	public
	 * @return	string
	 */
	function getName()
	{
		return $this->_name;
	}
	/**
	 * Set the name of the ActionForward.
	 *
	 * @access	public
	 * @param	string	$name
	 */
	function setName($name)
	{
		$this->_name = $name;
	}
	/**
	 * Get the input URI of the ActionForward.
	 *
	 * @access	public
	 * @return	string
	 */
	function getInput()
	{
		return $this->_input;
	}
	/**
	 * Set the input URI of the ActionForward.
	 *
	 * @access	public
	 * @param	string	$input
	 */
	function setInput($input)
	{
		$this->_input = $input;
	}
	/**
	 * Get the validate flag of the ActionForward.
	 *
	 * @access	public
	 * @return	integer
	 */
	function getValidate()
	{
		return $this->_validate;
	}
	/**
	 * Set the validate flag of the ActionForward.
	 *
	 * @access	public
	 * @param	string	$validate
	 */
	function setValidate($validate)
	{
		$this->_validate = $validate;
	}
	/**
	 * Get the validate flag of the ActionForward.
	 *
	 * @access	public
	 * @return	integer
	 */
	function getUnknown()
	{
		return $this->_unknown;
	}
	/**
	 * Set the validate flag of the ActionForward.
	 *
	 * @access	public
	 * @param	string	$unknown
	 */
	function setUnknown($unknown)
	{
		$this->_unknown = $unknown;
	}
	/**
	 * Get the scope flag of the ActionForward.
	 *
	 * @access	public
	 * @return	integer
	 */
	function getScope()
	{
		return $this->_scope;
	}
	/**
	 * Set the scope flag of the ActionForward.
	 *
	 * @access	public
	 * @param	string	$scope
	 */
	function setScope($scope)
	{
		$this->_scope = $scope;
	}
	/**
	 * Get the forward flag
	 *
	 * @access	public
	 * @return	string
	 */
	function getForward()
	{
		if (isset($this->_forward))
			return $this->_forward;
		else
			return "";
	}
	/**
	 * Set the forward flag.
	 *
	 * @access	public
	 * @param	string	$forward
	 */
	function setForward($forward)
	{
		$this->_forward = $forward;
	}

}
?>