<?php
include_once('MappingBuilder.php');
/**
 *	Wrapper class to create Phrame Mapping arrays
 *	Based on (and using) Jason's MappingManager
 *	@author		Alex Belgraver
 *	@package	Phrame
 */
class UserMappingBuilder extends MappingBuilder
{
	/**
	 *	constructor
	 *
	 *	@return void
	 */
	function UserMappingBuilder()
	{
	}

	/**
	 *      add a form to the mapping
	 *
	 *      "protected" function to be used by the constructor function of a derived class
	 *      @param  string  $psIdent        the identifer for the form
	 *      @param  string  $psType         the name of this form's class
	 *      @return boolean sucess
	 */
	function addForm($psIdent, $psType)
	{
		return $this->_AddForm($psIdent, $psType);
	}

	/**
	 * Add properties to forms.
	 * @param string $psIdent the identifier for the form
	 * @param string $psName the name of the property
	 * @param string $psInitial the initial value of the property
	 * @access protected
	 * @return void
	 */
	function addFormProperty($psIdent, $psName, $psInitial)
	{
		return $this->_AddFormProperty($psIdent, $psName, $psInitial);
	}

	/**
	 *	add a map to the mapping
	 *
	 *	"protected" function to be used by the constructor function of a derived class
	 *	@param string $psIdent Name (ID) of the mapping
	 *	@param string $psType Type (Action class name) to execute
	 *	@param string $psInput Input template to call back to if validating form fails [optional]
	 *	@param string $psForm Form associated with this mapping [optional]
	 *	@param bool $pbValidate Whether or not to validate the form [optional]
	 *	@param string $psScope Scope in which to store the form ("request" or "session") [optional]
	 *	@param bool $pbUnknown If this action is to be executed if no other action found. [optional]
	 *	@return	boolean sucess
	 */
	function addAction($psIdent, $psType, $psForm='_DEFAULT_', $pbValidate=false, $psInput='', $psScope='request', $pbUnknown=false, $psRoles='', $psForward=null)
	{
		return $this->_AddMapping($psIdent, $psType, $psInput, $psForm, $pbValidate, $psScope, $pbUnknown, $psRoles, $psForward);
	}

	/**
	 *	add a forward to an existing mapping
	 *
	 *	"protected" function to be used by the constructor function of a derived class
	 *	@param string $psMapIdent name (ID) of mapping
	 *	@param string $psFwdIdent name (ID) of forward
	 *	@param string $psPath path of forward
	 *	@param bool $pbRedir Redirect or normal forward. [optional]
	 *	@param bool $psEngine Which engine to use. [optional]
	 *	@return	boolean sucess
	 */
	function addForward($psMapIdent, $psFwdIdent, $psPath='_DEFAULT_', $pbRedir=false, $psEngine="")
	{
		return $this->_AddForward($psMapIdent, $psFwdIdent, $psPath, $pbRedir, $psEngine);
	}

	/**
	 * Add a welcome file.
	 * @param string $psPath Path to the welcome-file
	 * @return	boolean sucess
	 */
	function setWelcomeFile($psPath, $pbRedir=false, $psEngine=null)
	{
		return $this->_AddWelcomeFile($psPath, $pbRedir, $psEngine);
	}

	/**
	 *	add a forward to an existing mapping
	 *
	 *	"protected" function to be used by the constructor function of a derived class
	 *	@param string $psFwdIdent name (ID) of forward
	 *	@param string $psPath path of forward
	 *	@param bool $pbRedir Redirect or normal forward. [optional]
	 *	@param bool $psEngine Which engine to use. [optional]
	 *	@return	boolean sucess
	 */
	function addGlobalForward($psFwdIdent, $psPath='_DEFAULT_', $pbRedir=false, $psEngine)
	{
		return $this->_AddGlobalForward($psFwdIdent, $psPath, $pbRedir, $psEngine);
	}

	/**
	 * Add a new user.
	 *	@param string $psName Name of the user
	 *	@param string $psPassword Password of the user
	 *	@param string $psRoles Comma separated list of roles
	 *	@return	boolean sucess
	 */
	function addUser($psName, $psPassword, $psRoles)
	{
		return $this->_AddUser($psName, $psPassword, $psRoles);
	}

	/**
	 *
	 *	@return void
	 */
	function setOptions($psDefaultAction='ShowView'
					,$psErrorHandler='handle_error'
					,$piCache=0
					,$piErrorReporting=-1
					)
	{
		return $this->_SetOptions($psDefaultAction
					,$psErrorHandler
					,$piCache
					,$piErrorReporting
					);
	}

}

?>
