<?php
/**
 * Class for holding Request State. Light-version.
 * @author	Alex Belgraver
 * @version	$Id$
 * @package	Phrame
 */
class HttpServletRequest extends Object {

	/**
	 * Hashmap holding the named attributes
	 * @var	HashMap
	 */
	var $requestAttributes;
	/**
	 * Hashmap holding request parameters
	 * @var	HashMap
	 */
	var $requestParameters;
	/**
	 * Reference to ActionController
 	 * @var	ActionController
	 */
	var $controller;

	/**
	 * Constructor.
	 * @access public
	 */
	function HttpServletRequest() {
		$this->requestAttributes = new HashMap();
		$this->requestParameters = new HashMap();
		$this->mapRequest();
	}

	/**
	 * Method to set the controller.
	 * @access public
	 */
	function setController(&$refController){
		$this->controller =& $refController;
	}

	/**
	 * Get the controller.
	 * @access public
	 * @return ActionController
	 */
	function &getController(){
		return $this->controller;
	}

	/**
	 * map $_REQUEST to this object.
	 * @access protected
	 */
	function mapRequest(){
		while (list ($key, $val) = each ($_REQUEST)) {
			$this->setParameter($key, $val);
		}
		if (isset($_REQUEST[_ACTION]))
			$this->setAction($_REQUEST[_ACTION]);
	}

	/**
	 * Returns an array containing the names of the attributes available to this request.
	 * @access public
	 * @return array
	 */
	function &getAttributeNames(){
		return $this->requestAttributes->keySet();
	}

	/**
	 * Set a new request attribute
	 * @param $name string
	 * @param $obj object
	 * @access public
	 */
	function setAttribute($name, $obj){
		$this->requestAttributes->put($name, $obj);
	}

	/**
	 * Get a request attribute
	 * @access public
	 * @param $name string
	 * @return mixed
	 */
	function &getAttribute($name){
		return $this->requestAttributes->get($name);
	}

	/**
	 * Retrieve ALL attributes
	 * @return array
	 */
	function getAttributes(){
		return $this->requestAttributes->values();
	}

	/**
	 * Remove a request attribute
	 * @param $name string
	 * @access public
	 * @return mixed
	 */
	function removeAttribute($name){
		$this->requestAttributes->remove($name);
	}

	/**
	 * Returns the value of a request parameter as a String,
	 * or null if the parameter does not exist.
	 * @access public
	 * @param $name string  a String specifying the name of the parameter
	 */
	function &getParameter($name){
		return $this->requestParameters->get($name);
	}

	/**
	 * Returns an array containing the names of the attributes available to this request.
	 * @access public
	 * @return array
	 */
	function &getParameterNames(){
		return $this->requestParameters->keySet();
	}

	/**
	 * Retrieve ALL parameters
	 * @return array
	 */
	function getParameters(){
		return $this->requestParameters->values();
	}

	/**
	 * Set request Parameters.
	 * @access private
	 */
	function setParameter($name, $obj){
		$this->requestParameters->put($name, $obj);
	}

	/**
	 * Returns the session ID of this request.
	 * @access public
	 * @return string
	 */
	function getRequestedSessionId(){
		return $_COOKIE[session_name()];
	}

	/**
	 * Get the path of the request from the environment.
	 * @access public
	 * @return string
	 */
	function getContextPath()
	{
		return substr($_SERVER["SCRIPT_NAME"],0,strrpos($_SERVER["SCRIPT_NAME"],"/"));
	}

	/**
	 * Get path information from the environment.
	 * @access public
	 * @return string
	 */
	function getPathInfo()
	{
		$contextPath = $this->getContextPath();
		$pos=strpos($_SERVER["REQUEST_URI"],$contextPath);
		return substr($_SERVER["REQUEST_URI"],$pos+strlen($contextPath));
	}

	/**
	 * Retrieve action to be executed
	 * @return string
	 */
	function getAction() {
		return $this->requestAttributes->get(_ACTION);
	}

	/**
	 * Set action to be executed
	 * @param $action string
	 */
	function setAction($action) {
		return $this->requestAttributes->put(_ACTION, $action);
	}


	/**
	 * Returns whether or the controller is called with an action
	 * @return bool
	 */
	function isActionCall() {
		return $this->requestAttributes->containsKey(_ACTION);
	}

	/**
	 * Does the action exist in the mappings?
	 * @return boolean
	 */
	function actionExists()
	{
		return $this->requestAttributes->containsKey(_ACTION);
	}

	/**
	 * Make sure a string starts with a /
	 * @param string $str
	 * @access private
	 * @return string
	 */
	function _addSlash($str)
	{
		if (substr($str,0,1) != "/") {
			$str = "/$str";
		}
		return $str;
	}

}

?>
