<?php
/**
 * Class for managing the ActionMappings. This is including forms and views.
 * Mirrored somewhat from Struts.
 *
 * @author	Alex Belgraver
 * @version	$Id$
 * @package	Phrame
 */
class ActionMappings
{
	/**
	 * @var	array
	 */
	var $_mappings;

	/**
	 * Guess what, a constructor!
	 */
	function ActionMappings($mappings=null)
	{
		if (!isset($mappings))
			global $mappings;
		$this->_mappings =& $mappings;
	}

	/**
	 * Find an ActionMapping
	 * @access public
	 * @param string $path
	 * @return ActionMapping
	 */
	function findMapping($path)
	{
		if ($this->mappingExists($path))
		{
			// retrieve the mapping
			$mapping =& $this->_mappings[_ACTION_MAPPINGS][$path];
			// add global forwards
			if (array_key_exists(_ACTION_FORWARDS, $this->_mappings))
				while (list($key,$map) = each($this->_mappings[_ACTION_FORWARDS]))
				{
					if (!isset($mapping[_ACTION_FORWARDS][$key]))
						$mapping[_ACTION_FORWARDS][$key]=$map;
				}
			return new ActionMapping($mapping);
		} else return null;
	}

	/**
	 * Find a form
	 * @access public
	 * @param string $name
	 * @return array
	 */
	function findForm($name)
	{
		if (array_key_exists($name, $this->_mappings[_ACTION_FORMS]))
			return $this->_mappings[_ACTION_FORMS][$name];
		else
			return null;
	}

	/**
	 * Find properties for a form
	 * @return array
	 */
	function findFormProperties($name)
	{
		$form = $this->findForm($name);
	    if ( ($form != null) && (array_key_exists(_ACTION_FORMS_PROPERTY, $form)) )
			return $form[_ACTION_FORMS_PROPERTY];
		else
			return null;
	}

	/**
	 * Find a view
	 * @access public
	 * @param string $name
	 * @return string
	 */
	function findView($name)
	{
		if (array_key_exists($name, $this->_mappings))
			return $this->_mappings[$name];
		else
			return null;
	}

	/**
	 * Search for the name of an action Unknown="true"
	 * @access public
	 * @return string
	 */
	function findUnknownAction()
	{
		// iterate over all actionmappings to check.
		while (list($name,$actionMap) = each($this->_mappings[_ACTION_MAPPINGS]))
		{
			if ($actionMap[_UNKNOWN])
				return $name;
		}
		return null;
	}

	/**
	 * Get which users have access to this action
	 * @access public
	 * @return string
	 */
	function findUsers()
	{
		return $this->_mappings[_ACTION_USERS];
	}

	/**
	 * Check to see if a mapping (action) exists.
	 * @access public
	 * @param string $name
	 * @return boolean
	 */
	function mappingExists($name)
	{
		if (array_key_exists(_ACTION_MAPPINGS, $this->_mappings))
			return array_key_exists($name, $this->_mappings[_ACTION_MAPPINGS]);
		else
			return false;
	}

}

?>
