<?php
/**
 * The ActionForward class represents a destination to which the
 * ActionController might be directed to forward or redirect to, as a result of
 * the processing activities of an Action class. Instances of this class may be
 * created dynamically as necessary, or configured in association with an
 * ActionMapping instance for named lookup of potentially multiple destinations
 * for a particular ActionMapping instance.
 *
 * An ActionForward has the following minimal set of properties. Additional
 * properties can be provided as needed by subclasses.
 * <ul>
 * <li><b>name</b> - Logical name by which this instance may be looked up in
 * relationship to a particular ActionMapping.</li>
 * <li><b>path</b> - The absolute or relative URI to which control should be
 * forwarded or redirected.</li>
 * <li><b>redirect</b> - Set to 1 if the ActionController should kill the
 * session and redirect on the URI. [0]</li>
 * </ul>
 *
 * @author	Arnold Cano
 * @version	$Id: ActionForward.php,v 1.1.1.1 2002/11/19 16:46:54 arcano Exp $
 * @package	Phrame  
 */
class ActionForward extends Object
{
	/**
	 * @var	string
	 */
	var $_name;
	/**
	 * @var	string
	 */
	var $_path;
	/**
	 * @var	string
	 */
	var $_viewengine;
	/**
	 * @var	string
	 */
	var $_redirect;

	/**
	 * Create an ActionForward with the specified values.
	 *
	 * @access	public
	 * @param	string	$name
	 * @param	array	$forward
	 */
	function ActionForward($name, $forward)
	{
		$this->setName($name);
		$this->setPath($forward[_PATH]);
		$this->setRedirect(isset($forward[_REDIRECT]) ? $forward[_REDIRECT] : false);
		$this->setViewEngine(isset($forward[_VIEWENGINE]) ? $forward[_VIEWENGINE] : "");
	}
	/**
	 * Get the name of the ActionForward.
	 *
	 * @access	public
	 * @return	string
	 */
	function getName()
	{
		return $this->_name;
	}
	/**
	 * Set the name of the ActionForward.
	 *
	 * @access	public
	 * @param	string	$name
	 */
	function setName($name)
	{
		$this->_name = $name;
	}
	/**
	 * Get the path of the ActionForward.
	 *
	 * @access	public
	 * @return	string
	 */
	function getPath()
	{
		return $this->_path;
	}
	/**
	 * Set the path of the ActionForward.
	 *
	 * @access	public
	 * @param	string	$path
	 */
	function setPath($path)
	{
		$this->_path = $path;
	}
	/**
	 * Get the redirect flag of the ActionForward.
	 *
	 * @access	public
	 * @return	integer
	 */
	function getRedirect()
	{
		return $this->_redirect;
	}
	/**
	 * Set the redirect flag of the ActionForward.
	 *
	 * @access	public
	 * @param	integer	$redirect
	 */
	function setRedirect($redirect)
	{
		$this->_redirect = $redirect;
	}
	/**
	 * Get the validate flag of the ActionForward.
	 *
	 * @access	public
	 * @return	integer
	 */
	function getViewEngine()
	{
		return $this->_viewengine;
	}
	/**
	 * Set the validate flag of the ActionForward.
	 *
	 * @access	public
	 * @param	string	$viewengine
	 */
	function setViewEngine($viewengine)
	{
		$this->_viewengine = $viewengine;
	}
	/**
	 * Appends the add_path string to the forward-path.
	 * Does not url-encode the $add_path.
	 * @access	public
	 * @param	string	$add_path
	 */
	function appendPath($add_path)
	{
		// add the add_path
		$this->_path .= $add_path;
	}
	/**
	 * Add an attribute (key and value pair) to the forward-path.
	 * This urlencodes both key and value before appending to the forward-path.
	 * @access	public
	 * @param	string	$key
	 * @param	string	$value
	 */
	function setAttribute($key, $value)
	{
		// construct string, encoding both key and value
		$add_path =  htmlentities(urlencode($key));
		$add_path .= "=";
		$add_path .= htmlentities(urlencode($value));

		// check to see if $this->_path has an ? already
		if (strpos($this->_path, "?"))
			$add_path = "&".$add_path;
		else
			$add_path = "?".$add_path;

		// append it to the path
		$this->appendPath($add_path);
	}
}
?>
