<?php
class Funcionarios_Modelo extends Modelo {

	var $tb_cargos;
	var $tb_funcionarios;
	
	function Funcionarios_Modelo() {
		parent::Modelo();
		$this->tb_cargos = 'cargos';
		$this->tb_funcionarios = 'funcionarios';		
	}
	
	//transacciones
	function Start() {
		$this->setTransaccion('start');
	}
	function End() {
		$this->setTransaccion('end');
	}
	function FailTrans() {
		$this->setTransaccion('fail');
	}
	function setInsertID() {
		return $this->getInsertID();
	}
	
	
	// agregar funcionario
	function Agregar($_cmps,$adjunto) {
		$continuar = true;
		
		$sql = "select * from $this->tb_funcionarios where rut = -1";
		$continuar = $this->setGuardar($sql,$_cmps);
		

		if ($continuar) {
			$fp = fopen($adjunto['tmp_name'], 'rb');
			$content = fread($fp, $adjunto['size']);
			fclose($fp);
			$continuar = $this->db->UpdateBlob($this->tb_funcionarios,'foto',$content,"rut={$_cmps['rut']}");
			$continuar= true;
		}
		
		return $continuar;
	}

	// modificar funcionario
	function Modificar($_cmps,$adjunto) {
		$continuar = true;
		$sql = "select * from {$this->tb_funcionarios} where rut = {$_cmps['rut']}";
		$continuar = $this->setModificar($sql,$_cmps);
		
		if ($continuar && $_cmps['nombre_foto'] != "") {
			$fp = fopen($adjunto['tmp_name'], 'rb');
			$content = fread($fp, $adjunto['size']);
			fclose($fp);
			$continuar = $this->db->UpdateBlob($this->tb_funcionarios,'foto',$content,"rut={$_cmps['rut']}");
			$continuar= true;
		}
		
		return $continuar;
	}
	
	// eliminar funcionario
	function Eliminar($rut) {
		$sql = "delete from {$this->tb_funcionarios} where rut=$rut";
		$this->db->Execute($sql);
		
		return true;
	}

        // eliminar cargos
        function EliminarCargo($id_conservar,$rut_eliminar) {
		$conservar = " and (1=1 ";
		foreach ($id_conservar as $id_cargo){
			$conservar .= "and id_cargo <> '{$id_cargo}' ";
		}
		$conservar .=" )";
                $sql = "update {$this->tb_cargos} set rut = null, nombre_resolucion = null, tipo_resolucion = null, resolucion = null WHERE rut = '$rut_eliminar' $conservar";
                $this->db->Execute($sql);
                return true;
        }
	
	//listado funcionarios
	function getFuncionarios($_pagina_actual) {
				
		$sql = "select e.* from {$this->tb_funcionarios} e order by e.nombres asc ";
		$rs = $this->getConsulta($sql,true,$_pagina_actual);
		$funcionarios = array();

		while (!$rs->EOF) {
			$cargos = $this->getCargosFuncionarios($rs->fields['rut']);
			$rs->fields['cargos'] = $cargos;
			array_push($funcionarios,$rs->fields);
			$rs->MoveNext();
		}

		$datos['funcionarios'] = $funcionarios;
		$datos['paginacion'] = $this->getPaginado($rs->atfirstpage(),$rs->absolutepage(),$rs->atlastpage(),$rs->lastpageno());				
		$datos['paginacion']['paginar'] = ($rs->atfirstpage() && ($rs->lastpageno() == $rs->absolutepage())) ? "false" : "true";

		return $datos;
	}

	//datos funcionario
	function getFuncionario($rut) {
		$sql = "select e.* from {$this->tb_funcionarios} e where e.rut='{$rut}'";
		$rs = $this->getConsulta($sql);
		$rs->fields['existe'] = (!$rs->EOF) ? true : false;
		return $rs->fields;
	}

        //datos funcionario
        function getCargo($id_cargo) {
                $sql = "select * from {$this->tb_cargos} c where c.id_cargo='{$id_cargo}'";
                $rs = $this->getConsulta($sql);
                $rs->fields['existe'] = (!$rs->EOF) ? true : false;
                return $rs->fields;
        }
	
	//listado cargos x funcionarios
	function getCargosFuncionarios($rut) {
		$sql = "select c.* from {$this->tb_cargos} c where c.rut='{$rut}' order by c.nombre asc ";
		$rs = $this->getConsulta($sql);
		$cargos = array();
		while (!$rs->EOF) {
			array_push($cargos,$rs->fields);
			$rs->MoveNext();
		}
		return $cargos;
	}

        // asignar funcionario
        function AsignarCargo($_cmps,$adjunto) {
                $continuar = true;
		
		$cargo = $this->getCargosFuncionarios($_cmps['rut']);
			
                $sql = "select * from {$this->tb_cargos} where id_cargo = {$_cmps['id_cargo']} ";
                $continuar = $this->setModificar($sql,$_cmps);

                if ($continuar && $_cmps['nombre_resolucion'] != "") {
                        $fp = fopen($adjunto['tmp_name'], 'rb');
                        $content = fread($fp, $adjunto['size']);
                        fclose($fp);
                        $continuar = $this->db->UpdateBlob($this->tb_cargos,'resolucion',$content,"id_cargo={$_cmps['id_cargo']}");
                        $continuar= true;
                }

                return $continuar;
        }
        //listado cargos
        function getCargos() {
                $sql = "select c.* from {$this->tb_cargos} c order by c.id_padre asc ";
                $rs = $this->getConsulta($sql);
                $cargos = array();
                while (!$rs->EOF) {
                        array_push($cargos,$rs->fields);
                        $rs->MoveNext();
                }
                return $cargos;
        }
	//listado cargos con functionarios asignados
        function getCargoFuncionario($id_padre = 0,$nivel = 0) {
                $sql = "select c.rut,c.nombre,id_cargo,id_padre,f.nombres,f.apellidos from {$this->tb_cargos} c
			left join {$this->tb_funcionarios} f on c.rut = f.rut  
			where id_padre = '{$id_padre}'
			order by c.nombre_visual asc";
                $rs = $this->getConsulta($sql);
                $cargos = array();
                while (!$rs->EOF) {
                        $cargo = $rs->fields;
			$cargo['nivel'] = $nivel;
			$cargo['indent'] = str_repeat("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;", $nivel);
			$cargos_hijo = $this->getCargoFuncionario($cargo['id_cargo'], $nivel+1);
			$cargos[]=$cargo;
			$cargos=array_merge($cargos,$cargos_hijo);
                        $rs->MoveNext();
                }
                return $cargos;
        }
}
?>
